import { vsaAppServerModule } from 'common/js/modules';

var serverMod = vsaAppServerModule;

serverMod.directive('cvAutoscaleUpordownOptions', function() {
	return {
		restrict: 'E', //E = element
		templateUrl: appUtil.appRoot + 'modules/vmManagement/partials/lifeCyclePolicy/AutoscaleUpOrDownOptions.jsp',
		scope: {},
		bindToController: {
			policyDetails: '='
		},
		controllerAs: 'asUpOrDown',
		controller: 'autoScaleUpOrDownOptions'
	};
});

var controllers = {};

controllers.autoScaleUpOrDownOptions = [
	'cvLoc',
	'cvUtil',
	'$log',
	'serverService',
	function(cvLoc, cvUtil, $log, serverService) {
		var self = this;
		this.$onInit = function() {
			var modal = {};
			var serverDetailsInfo = {
				username: self.policyDetails
					? self.policyDetails.vmCredentials.userName
						? self.policyDetails.vmCredentials.userName
						: ''
					: '',
				password: self.policyDetails
					? self.policyDetails.vmCredentials.password
						? self.policyDetails.vmCredentials.password
						: ''
					: ''
			};

			self.minInstanceTypeChanged = function() {
				self.policyDetails.scaleOption.scaleUpParam.minVMType = self.minInstanceType;
			};

			self.maxInstanceTypeChanged = function() {
				self.policyDetails.scaleOption.scaleUpParam.maxVMType = self.maxInstanceType;
			};

			serverService
				.getInstanceTypes(self.policyDetails.destinationHyperV.clientId, serverDetailsInfo)
				.success(function(data) {
					self.instanceTypes = data;
					self.minInstanceType = self.policyDetails.scaleOption.scaleUpParam.minVMType
						? self.policyDetails.scaleOption.scaleUpParam.minVMType
						: self.instanceTypes[0];
					self.maxInstanceType = self.policyDetails.scaleOption.scaleUpParam.maxVMType
						? self.policyDetails.scaleOption.scaleUpParam.maxVMType
						: self.instanceTypes[1];
					self.policyDetails.scaleOption.scaleUpParam.minVMType = self.policyDetails.scaleOption.scaleUpParam.minVMType
						? self.policyDetails.scaleOption.scaleUpParam.minVMType
						: self.instanceTypes[0].name;
					self.policyDetails.scaleOption.scaleUpParam.maxVMType = self.policyDetails.scaleOption.scaleUpParam.maxVMType
						? self.policyDetails.scaleOption.scaleUpParam.maxVMType
						: self.instanceTypes[1].name;
				})
				.error(function(err) {
					console.log('error');
				});
		};
	}
];

serverMod.controller(controllers);
export default serverMod;
