import 'adminConsole/js/services/agents.svc.js';
import 'modules/vmManagement/js/directives/autoScalePolicy/cv-regions-directive.js';
import 'modules/vmManagement/js/factory/vmLifeCyclePolicy/lifeCyclePolicy.factory.js';

import { vsaAppServerModule } from 'common/js/modules';

var serverMod = vsaAppServerModule;

serverMod.directive('cvAutoscaleOutOptions', function() {
	return {
		restrict: 'E', //E = element
		templateUrl: appUtil.appRoot + 'modules/vmManagement/partials/lifeCyclePolicy/AutoScaleOutOptions.jsp',
		scope: {},
		require: ['^^cvSubmit', '^^form'],
		bindToController: {
			policyDetails: '=',
			kubernetesOptions: '=?'
		},
		controllerAs: 'asOut',
		controller: 'autoScaleOutOptions',
		link: function(scope, elem, attr, controllers) {
			scope.submitController = controllers[0];
			scope.formController = controllers[1];
		}
	};
});

var controllers = {};

controllers.autoScaleOutOptions = [
	'cvLoc',
	'cvUtil',
	'$log',
	'serverService',
	'vmLifeCyclePolicyFactory',
	'clientGroupService',
	'cvToaster',
	'AppTypes',
	'agentService',
	'VSA_VENDOR',
	function(
		cvLoc,
		cvUtil,
		$log,
		serverService,
		vmLifeCyclePolicyFactory,
		clientGroupService,
		cvToaster,
		AppTypes,
		agentService,
		VSA_VENDOR
	) {
		var self = this;
		this.$onInit = function() {
			const KUBERNETESVENDOR = 'KUBERNETES';
			self.model = {
				secGrp: 'cv-security-group',
				clientGroups: [], // contains all the client groups
				clientGroup: [], // contains the selected client group
				roles: [], // contains all the roles
				role: [], // contains the selected roles
				instanceTypes: [], // contains all the instance types
				intanceType: [], // contains the selected intance types,
				azureResourceGroupList: [], // contains all the resource groups
				azureResourceGroup: [] // contains  the selected resource groups
			};

			var loadingISteven = { id: 0, name: cvLoc('Loading'), displayName: cvLoc('Loading'), selected: true };

			var serverDetailsInfo = {
				username: '',
				password: ''
			};

			var scaleOutParams = {
				noOfVMs: 10,
				expirationTime: 1
			};

			var toggleStatus = {
				true: 'enabled-activity',
				false: 'disabled-activity'
			};

			self.serverId = self.policyDetails.destinationHyperV
				? self.policyDetails.destinationHyperV.clientId
				: self.policyDetails.serverId;

			self.isAzureRM = vmLifeCyclePolicyFactory.isAzureRM(
				vmLifeCyclePolicyFactory.getVendorByPolicyType(_.get(self.policyDetails, 'entity.policyType'))
			);

			if (_.get(self.policyDetails, 'entity.policyType') === KUBERNETESVENDOR) {
				self.advancedSettingsAccordion = false;
			}

			if (self.policyDetails && self.policyDetails.scaleOption && self.policyDetails.scaleOption.scaleOutParam) {
				self.isfirewallEnabled =
					self.policyDetails.scaleOption.scaleOutParam.isFirewallEnabled === true
						? 'enabled-activity'
						: 'disabled-activity';
			}

			function getClientGroups() {
				self.model.clientGroups.push(loadingISteven);
				clientGroupService
					.getClientGroups()
					.success(function(data) {
						if (data && data.length > 0) {
							self.model.clientGroups = data;
							self.model.clientGroups.sort(comparename);
							if (self.policyDetails.associatedClientGroup && self.policyDetails.associatedClientGroup.clientGroupId) {
								for (var i = 0; i < self.model.clientGroups.length; i++) {
									if (self.policyDetails.associatedClientGroup.clientGroupId === self.model.clientGroups[i].Id) {
										self.model.clientGroups[i].selected = true;
										break;
									}
								}
							} else {
								self.model.clientGroups[0].selected = true;
								self.policyDetails.associatedClientGroup = {};
								self.policyDetails.associatedClientGroup.clientGroupId = self.model.clientGroups[0].Id;
								self.policyDetails.associatedClientGroup.clientGroupName = self.model.clientGroups[0].name;
							}
						} else {
							self.model.clientGroups = [];
							showErrorMessage('No client groups available');
						}
					})
					.error(function(e) {
						self.model.clientGroups = [];
						showErrorMessage(e);
					});
			}
			self.resourceGroupLoaded = function() {
				self.errorMessage = null;
				self.azureResourceGroupLoaded = true;
				let resourceGroupName = _.get(self.policyDetails, 'esxServers[0].esxServerName');
				if (_.isArray(self.model.azureResourceGroupList)) {
					if (!!resourceGroupName) {
						for (var i = 0; i < self.model.azureResourceGroupList.length; i++) {
							if (resourceGroupName === self.model.azureResourceGroupList[i].displayName) {
								self.model.azureResourceGroupList[i].selected = true;
								break;
							}
						}
					} else {
						self.model.azureResourceGroupList[0].selected = true;
						if (!self.policyDetails.esxServers) {
							self.policyDetails.esxServers = [
								{
									esxServerName: self.model.azureResourceGroupList[0].displayName
								}
							];
						}
						self.policyDetails.esxServers[0].esxServerName = self.model.azureResourceGroupList[0].displayName;
					}
					getInstanceTypes();
				}
			};
			self.loadResourceGroup = function(serverId) {
				// Res data
				self.azureResourceGroupLoaded = false;
				self.errorMessage = null;
				let inventoryPath = '\\NONE:Resource Groups';
				if (angular.isDefined(serverId)) {
					self.model.azureResourceGroupList = [];
					self.model.azureResourceGroupList.push(loadingISteven);
					serverService
						.vsaInventoryBrowse(serverId, inventoryPath)
						.success(function(data) {
							self.model.azureResourceGroupList = data;
							self.resourceGroupLoaded();
						})
						.error(function(err) {
							self.errorMessage = cvUtil.errMsg(err ? err : cvLoc('error.resourceGroup'));
							self.azureResourceGroupLoaded = false;
							self.model.azureResourceGroupList = [];
						});
				}
			};

			function getInstanceTypes() {
				let hostname = self.isAzureRM ? _.get(self.policyDetails, 'esxServers[0].esxServerName') : undefined;
				self.model.instanceTypes.push(loadingISteven);
				serverService
					.getInstanceTypes(self.serverId, serverDetailsInfo, hostname)
					.success(function(data) {
						if (data && data.length > 0) {
							self.model.instanceTypes = data;
							self.model.instanceTypes.sort(comparename);

							if (self.policyDetails.amazonPolicy && self.policyDetails.amazonPolicy.instanceType) {
								if (
									self.policyDetails.amazonPolicy.instanceType[0] &&
									self.policyDetails.amazonPolicy.instanceType[0].instanceType
								) {
									let vmInstanceTypeName = _.get(
										self.policyDetails,
										'amazonPolicy.instanceType[0].instanceType.vmInstanceTypeName',
										''
									);
									for (var i = 0; i < self.model.instanceTypes.length; i++) {
										if (vmInstanceTypeName === self.model.instanceTypes[i].id) {
											self.model.instanceTypes[i].selected = true;
											break;
										}
									}
								}
							} else {
								self.model.autoSelectInstanceType = true;
								if (self.policyDetails.amazonPolicy) {
									self.policyDetails.amazonPolicy.instanceType = [];
								} else {
									self.policyDetails.amazonPolicy = {
										instanceType: []
									};
								}
							}
						} else {
							self.model.instanceTypes = [];
							showErrorMessage('No Instance types avaiable');
						}
					})
					.error(function(e) {
						self.model.instanceTypes = [];
						showErrorMessage(e);
					});
			}

			function getProxyClientEntity() {
				serverService.getProxyByClient(self.serverId, self.subclinetID).then(function(instance) {
					if (instance) {
						self.policyDetails.instanceId = instance.instance.instanceId;
					}

					if (!self.kubernetesOptions && !self.isAzureRM) {
						getAmazonIAMs();
					}
				});
			}

			function getAmazonIAMs() {
				self.model.roles.push(loadingISteven);
				serverService
					.getAmazonIAMs(self.policyDetails.instanceId)
					.success(function(data) {
						if (data && data.length > 0) {
							self.model.roles = data;
							if (self.policyDetails.roleInfo) {
								for (var i = 0; i < self.model.roles.length; i++) {
									if (self.policyDetails.roleInfo.name === self.model.roles[i].name) {
										self.model.roles[i].selected = true;
										break;
									}
								}
							} else {
								self.model.roles[0].selected = true;
								if (!self.policyDetails.roleInfo) {
									self.policyDetails.roleInfo = {
										name: self.model.roles[0].name
									};
								}
								self.policyDetails.roleInfo.name = self.model.roles[0].name;
							}
						} else {
							self.model.roles = [];
							showErrorMessage('No Amazon IAM roles available');
						}
					})
					.error(function(e) {
						self.model.roles = [];
						showErrorMessage(e);
					});
			}

			//Initialize the paramters
			self.init = function() {
				if (self.policyDetails) {
					if (
						!self.policyDetails.scaleOption ||
						!self.policyDetails.scaleOption.scaleOutParam ||
						!self.policyDetails.scaleOption.scaleOutParam.maxVMthreshold
					) {
						if (!self.policyDetails.scaleOption) {
							self.policyDetails.scaleOption = {
								scaleOutParam: {
									maxVMthreshold: scaleOutParams.noOfVMs
								}
							};
						} else {
							self.policyDetails.scaleOption.scaleOutParam.maxVMthreshold = scaleOutParams.noOfVMs;
						}
					}

					/*
					 * MR : 265944 AutoScale proxy changes from project feedback, expiraitonTime should be 1
					 * hour by default going forward. if(!self.policyDetails.minutesRetainUntil) {
					 * self.policyDetails.expirationTime = scaleOutParams.expirationTime; } else {
					 * self.policyDetails.expirationTime = self.policyDetails.minutesRetainUntil / 60; }
					 */
					self.policyDetails.expirationTime = scaleOutParams.expirationTime;
				}
			};

			// initial functions
			self.init();

			if (self.isAzureRM) {
				self.loadResourceGroup(self.serverId);
			}
			getClientGroups();
			if (!self.kubernetesOptions && !self.isAzureRM) {
				getInstanceTypes();
				self.policyDetails.instanceId ? getAmazonIAMs() : getProxyClientEntity();
			}

			//When user changes client group, we are caching the new value
			self.setClientGroup = function(data) {
				self.policyDetails.associatedClientGroup = {};
				self.policyDetails.associatedClientGroup.clientGroupId = data.Id;
				self.policyDetails.associatedClientGroup.clientGroupName = data.name;
			};

			//When user changes instance type, we are caching the new value
			self.setInstanceType = function(data) {
				self.policyDetails.amazonPolicy.instanceType[0] = _.assignIn(self.policyDetails.amazonPolicy.instanceType[0], {
					instanceType: {
						vmInstanceTypeName: data.id //for id suffix for azure/aws
					}
				});
			};

			//When user changes IAM role, we are chaching the new value
			self.setIAMRole = function(data) {
				self.policyDetails.roleInfo.name = data.name;
			};

			//When user changes resource group, we are chaching the new value
			self.setResourceGroup = function(data) {
				if (!self.policyDetails.esxServers) {
					self.policyDetails.esxServers = [
						{
							esxServerName: data.displayName
						}
					];
				}
				self.policyDetails.esxServers[0].esxServerName = data.displayName;
			};

			//This function manages the status of firewall toggle button
			self.manageFirewallStatus = function() {
				self.isfirewallEnabled = vmLifeCyclePolicyFactory.checkToggleStatus(self.isfirewallEnabled, toggleStatus);
				self.isfirewallEnabled === 'enabled-activity'
					? (self.policyDetails.scaleOption.scaleOutParam.isFirewallEnabled = true)
					: (self.policyDetails.scaleOption.scaleOutParam.isFirewallEnabled = false);
			};

			//This function manages the firewall connection type radio buttons
			self.manageFirewallConnectionType = function() {
				self.firewallConnectionType === 'csBehindFirewallEnabled'
					? (self.policyDetails.scaleOption.scaleOutParam.firewallSettings.firewallConnectionType = 1)
					: (self.policyDetails.scaleOption.scaleOutParam.firewallSettings.firewallConnectionType = 2);
			};

			self.autoSelectInstanceTypeClick = function() {
				self.model.autoSelectInstanceType = !self.model.autoSelectInstanceType;
				if (self.model.autoSelectInstanceType) {
					self.model.instanceType = [];
					self.policyDetails.amazonPolicy.instanceType = [];
				}
			};

			/* ================ HELPER FUNCTIONS ================= */

			function comparename(a, b) {
				return a.name.toLowerCase().localeCompare(b.name.toLowerCase());
			}

			function showErrorMessage(e) {
				cvToaster.showErrorMessage({
					ttl: '10000',
					message: e ? e : cvLoc('generic_error')
				});
			}
		};
	}
];

serverMod.controller(controllers);
export default serverMod;
