import 'modules/vmManagement/js/factory/virtualMachine.factory.js';

import { vmManagementAppModule } from 'common/js/modules';

var vmManagementMod = vmManagementAppModule;

vmManagementMod.controller('virtualMachinesListController', [
	'$state',
	'$stateParams',
	'$dialogs',
	'cvUtil',
	'cvLoc',
	'cvTableOptions',
	'virtualMachineFactory',
	function($state, $stateParams, $dialogs, cvUtil, cvLoc, cvTableOptions, virtualMachineFactory) {
		var self = this;
		self.virtualMachines = [];
		self.isDataLoading = true;
		self.serverMessage = cvUtil.infoMsgLoc('Loading');

		self.transistionTo = $stateParams.transistionTo;
		self.policyId = $stateParams.policyId;
		self.vmGUID = $stateParams.vmGUID;
		self.vmName = $stateParams.vmName;
		self.isLiveMount = $stateParams.isLiveMount;

		//test failover vms
		self.replicationId = $stateParams.replicationId;
		self.failoverGroupId = $stateParams.failoverGroupId;

		self.cvGridTitle = cvLoc('label.virtualMachines');
		self.cvOnGridEmpty = cvLoc('label.noVirtualMachines');

		if (self.isLiveMount) {
			self.cvGridTitle = cvLoc('label.activeMounts');
			self.cvOnGridEmpty = cvLoc('label.noLiveMounts');
		} else {
			self.cvGridTitle = cvLoc('label.virtualMachines');
			self.cvOnGridEmpty = cvLoc('label.noVirtualMachines');
		}

		if (!self.policyId) {
			self.policyId = -1;
		}

		virtualMachineFactory
			.getVirtualMachines(
				self.policyId,
				self.vmGUID,
				self.vmName,
				self.isLiveMount,
				self.replicationId,
				self.failoverGroupId
			)
			.then(function() {
				self.isDataLoading = false;
				self.virtualMachines = virtualMachineFactory.virtualMachines;
				self.serverMessage = cvUtil.emptyMsg();
			});

		self.renewVM = function(vmGUID, vmName, instanceId, policyId, isLiveMount, vmLocation) {
			//@todo: make sure backend set the system policy id for in place live mount in upcoming SP.
			if (isLiveMount && (!policyId || policyId <= 0)) {
				policyId = 1;
			}
			var vmOperationDetails = {
				vmGUID: vmGUID,
				vmName: vmName,
				instanceId: instanceId,
				policyId: policyId,
				operationType: 'RENEW_VM',
				isLiveMount: isLiveMount,
				vmLocation: vmLocation
			};
			virtualMachineFactory.vmOperationDialog(vmOperationDetails);
		};

		self.deleteVM = function(vmGUID, vmName, instanceId, vmLocation, policyId) {
			$dialogs.confirm(cvLoc('label.confirmDelete'), cvLoc('label.confirmDeleteVM'), {
				yesFunction: function() {
					virtualMachineFactory
						.performVMOperation(vmGUID, vmName, instanceId, 'DELETE_VM', vmLocation, policyId)
						.then(function(data) {
							$state.forceReload();
						});
				}
			});
		};

		var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);

		angular.extend(globalGridOptions, {
			data: 'virtualMachines',
			columnDefs: [
				{
					field: 'vmName',
					sort: {
						direction: 'asc',
						priority: 0
					},
					cellTooltip: true,
					enableHiding: false,
					displayName: cvLoc('label.name'),
					width: '20%'
				},
				{
					field: 'vmState',
					displayName: cvLoc('label.vmState'),
					width: '10%'
				},
				{
					field: 'ipAddress.address',
					displayName: cvLoc('label.ipAddress'),
					width: '10%'
				},
				{
					field: 'operatingSystem',
					displayName: cvLoc('label.operatingSystem'),
					width: '20%'
				},
				{
					field: 'creator.userName',
					displayName: cvLoc('label.creator'),
					width: '15%'
				},
				{
					field: 'formattedExpirationTime',
					displayName: cvLoc('label.expirationDate'),
					width: '15%'
				},
				{
					field: 'actions',
					enableFiltering: false,
					enableHiding: false,
					displayName: cvLoc('label.actions'),
					cellTemplate:
						'<div class="btn-group" uib-dropdown><a href class="uib-dropdown-toggle" uib-dropdown-toggle ng-disabled="disabled"><span class="grid-action-icon"></span></a>\
																		<ul uib-dropdown-menu class="dropdown-menu" role="menu">\
																			<li><a ng-click="grid.appScope.deleteVM(row.entity.vm.vmGUID, row.entity.vm.vmName, row.entity.entity.instanceId, row.entity.vmLocation, row.entity.vmAllocPolicyId)">' +
						cvLoc('action.delete') +
						'</a></li>\
																			<li ng-show="row.entity.enableRenew" ><a ng-click="grid.appScope.renewVM(row.entity.vm.vmGUID, row.entity.vm.vmName, row.entity.entity.instanceId, row.entity.vmAllocPolicyId, row.entity.liveMount,  row.entity.vmLocation)">' +
						cvLoc('action.renew') +
						'</a></li>\
																		</ul></div>',
					width: '10%'
				}
			]
		});

		self.breadCrombURL = function(transistionTo) {
			$state.transitionTo(transistionTo, $stateParams, {
				reload: true,
				inherit: false,
				notify: true
			});
		};
		self.cvPageLink = [];
		/*
		 * Todo later if(self.transistionTo){ self.cvPageLink = [ { label : cvLoc('label.addVirtualMachine'),
		 * onclick : self.breadCrombURL(self.transistionTo) } ] }
		 */
		self.gridOptions = {
			cvPageLinks: self.cvPageLink,
			cvGridTitle: self.cvGridTitle,
			cvIsPageTitle: true,
			cvTableName: 'virtualMachinesTable',
			cvSearchFields: ['vmName', 'vmState', 'ipAddress.address', 'operatingSystem', 'creator.userName'],
			cvOnGridEmpty: {
				message: self.cvOnGridEmpty,
				links: []
			},
			cvAppScope: self,
			gridOptions: globalGridOptions
		};
	}
]);

export default vmManagementMod;
