import { vsaAppServerModule } from 'common/js/modules';
import 'modules/vmManagement/js/directives/cv-advance-options-directive.js';
import 'modules/vmManagement/js/constants/vmLifeCyclePolicy.constants.js';

var serverMod = vsaAppServerModule;
var controllers = {};
serverMod.constant('RESTORE_OPTIONS_MODE_RED_HAT', {
	REPLICATION_TARGET: 'replicationTarget'
});

controllers.replicationControllerRedHat = [
	'$scope',
	'$stateParams',
	'replTargetFactory',
	'cvLoc',
	'cvUtil',
	'$uibModal',
	'serverService',
	'vmLifeCyclePolicyFactory',
	'restoreService',
	'cvToaster',
	'VM_POLICY_APP_TYPE',
	function(
		$scope,
		$stateParams,
		replTargetFactory,
		cvLoc,
		cvUtil,
		$modal,
		serverService,
		vmLifeCyclePolicyFactory,
		restoreService,
		cvToaster,
		VM_POLICY_APP_TYPE
	) {
		var self = this;
		self.vendor = 'REDHAT';
		self.editMode = $scope.editMode;
		self.advanceOptionsAccordion = false;
		$scope.$watch('model.vendor', function(vendor) {
			if (angular.isDefined(vendor)) {
				self.vendor = vendor;
				self.init();
			}
		});

		self.ctrl = {};
		self.model = {};
		self.browseOptions = {};
		self.ctrl.doRefresh = true;

		var nSettingsLoadingISteven = { id: 0, networkName: 'Loading...', selected: true };
		self.browseOptions.networkSettingsList = [];

		$scope.localLangDestinationNetwork = cvUtil.getIStevenLocLabels();
		$scope.localLangDestinationNetwork.nothingSelected = cvLoc('placeholder.selectDestinationNetwork');

		self.destinationHostPlaceHolder = cvLoc('placeholder.selectDestinationCluster');

		if ($stateParams.replicationTargetId) {
			self.replicationTargetId = $stateParams.replicationTargetId;
		}

		//Initializes the values during edit mode
		var setValues = function(restoreData) {
			self.model.selectedHypervisor = restoreData.selectedHypervisor ? restoreData.selectedHypervisor : null;
			self.restoreData.globalOptions.selectedProxy = [restoreData.proxyClientEntity];
			self.restoreData.globalOptions.server = self.model.selectedHypervisor;
			self.browseOptions.destinationHost = {
				displayName: self.restoreData.esxServers
			};
			if (self.restoreData.networkNames && self.restoreData.networkNames.length > 0) {
				self.browseOptions.savedNetwork = {
					networkName: self.restoreData.networkNames[0]
				};
			}
		};

		//Initializes the values during creation adn edit mode
		var initializeRestoreData = function(restoreData) {
			self.restoreData = angular.merge(
				{},
				{
					globalOptions: {}
				},
				self.restoreData
			);
			//during edit mode
			if (restoreData) {
				self.restoreData = angular.merge({}, restoreData, self.restoreData);
				setValues(self.restoreData);
			} else {
				//during creation
				self.restoreData = angular.merge(
					{},
					{
						prefixSuffixSelector: 'suffix',
						displayNamePrefixSuffix: replTargetFactory.getDefaultVMSuffixPrefixName()
					},
					self.restoreData
				);
			}
			// empty list for restore options directive
			self.vmList = [];
			self.vmList.push(self.restoreData);
			self.model.selectedVms = [];
			self.model.selectedVms.push(self.vmList[0]);
			self.mode = 'replicationTarget';
			self.displayNameOptions = true;

			replTargetFactory.collectUsersAndUserGroups(self.restoreData.securityAssociations, self.editMode).then(data => {
				self.usersAndUserGroups = data;
			});

			if (self.editMode) {
				self.changeDestination(self.browseOptions.destinationHost.displayName);
			}
		};

		self.init = function() {
			initializeRestoreData($scope.restoreData);
		};

		//flag to show/hide fields in override options and target
		self.displayOptionDetails = false;

		self.ctrl.refreshHypervisor = function() {
			var globalOptions = self.restoreData.globalOptions;
			var clearVmOptions = function(vmOpts) {
				vmOpts.selectedProxy = null;
			};

			if (self.model.selectedHypervisor && !self.model.selectedHypervisor.disabled) {
				var server = self.model.selectedHypervisor;
				if (globalOptions && globalOptions.server && globalOptions.server.serverId != server.clientId) {
					if (!self.editMode) {
						clearVmOptions(globalOptions);
					}
				}

				self.restoreData.globalOptions.server = angular.merge(
					{},
					{
						serverId: server.clientId,
						serverName: server.clientName
					},
					server
				);
			} else {
				self.restoreData.globalOptions.server = {};
			}

			if (self.ctrl.loadDestinationProxies) {
				self.ctrl.loadDestinationProxies(null, self.model.selectedHypervisor);
			}
		};

		self.getCurrentHostDisplayName = function() {
			if (!self.browseOptions || !self.browseOptions.destinationHost) {
				return;
			}

			return self.browseOptions.destinationHost.displayName;
		};

		var loadNetworkDetails = function(hostname) {
			self.isNetworkLoading = true;
			var destinationServer = self.restoreData.globalOptions.server;
			var serverDetailsInfo = {
				clientId: destinationServer.clientId,
				serverName: '',
				username: destinationServer.username,
				password: destinationServer.password
			};

			serverService
				.getNetworkInfo(serverDetailsInfo, hostname, self.vendor)
				.success(function(data) {
					self.browseOptions.networkSettingsListError = false;
					self.browseOptions.existingNetworkSettingsList = [];

					if (
						self.browseOptions.selectedNetwork.length === 0 ||
						(self.browseOptions.selectedNetwork.length > 0 &&
							self.browseOptions.selectedNetwork[0].networkName === 'Loading...')
					) {
						self.browseOptions.networkSettingsList = data;
					}
					if (self.browseOptions.networkSettingsList && self.browseOptions.networkSettingsList.length > 0) {
						if (self.browseOptions.savedNetwork && self.browseOptions.savedNetwork.networkName) {
							angular.forEach(self.browseOptions.networkSettingsList, function(networkSetting, key) {
								angular.forEach(self.browseOptions.savedNetwork, function(network, sKey) {
									if (self.browseOptions.savedNetwork.networkName === networkSetting.networkName) {
										self.browseOptions.networkSettingsList[key].selected = true;
										return;
									}
								});
							});
						}
					}
				})
				.error(function(err) {
					self.browseOptions.networkSettingsList = [];
					self.browseOptions.networkSettingsListError = true;
				});
		};

		self.changeDestination = function(hostName) {
			self.browseOptions.networkSettingsList.push(nSettingsLoadingISteven);
			loadNetworkDetails(hostName);
		};

		self.openSelectDestinationHostDialog = function() {
			self.serverMessageTop = cvUtil.emptyMsg();

			var modalInstance = $modal.open({
				templateUrl: appUtil.appRoot + 'vsa/partials/selectRestoreDestinationHostModal.jsp',
				backdrop: 'static',
				controller: [
					'$scope',
					'$rootScope',
					'$location',
					'$uibModalInstance',
					'$state',
					'cvLoc',
					'destinationHostData',
					'$log',
					'server',
					'cvToaster',
					function(
						$scope,
						$rootScope,
						$location,
						$modalInstance,
						$state,
						cvLoc,
						destinationHostData,
						$log,
						server,
						cvToaster
					) {
						$scope.server = server;
						$scope.cancel = function() {
							$modalInstance.dismiss('cancel');
						};

						$scope.select = function() {
							// Selections are stored at this point in destinationVmData.selection:
							var selected = null;
							if (destinationHostData.selection.length > 0) {
								selected = destinationHostData.selection[0];
							}
							$modalInstance.close(selected);
						};
					}
				],
				resolve: {
					server: function() {
						return {
							clientId:
								self.restoreData &&
								self.restoreData.globalOptions &&
								self.restoreData.globalOptions.server &&
								self.restoreData.globalOptions.server.clientId
									? self.restoreData.globalOptions.server.clientId
									: '',
							serverName: '',
							username: '',
							password: '',
							vendor: self.vendor,
							selectableType: self.vendor === 'REDHAT' ? 'CLUSTER' : 'SERVER'
						};
					}
				}
			});
			modalInstance.result.then(
				function(result) {
					self.browseOptions.dataStoreList = [];
					self.browseOptions.availabilityDomainList = [];
					self.browseOptions.networkSettingsList = [];
					self.browseOptions.existingNetworkSettingsList = [];
					self.browseOptions.restoreNetworkSettingsList = [];
					self.browseOptions.gatewayNetworkSettingsList = [];
					self.browseOptions.dataStoreForIsoPathList = [];
					self.browseOptions.isoInfo = {
						windows: null,
						unix: null
					};
					if (self.missingDestinationCluster && self.missingDestinationCluster.message) {
						self.missingDestinationCluster = {};
					}
					self.browseOptions.destinationHost = result;
					self.changeDestination(result.displayName);
				},
				function() {
					$log.info('Destination Host Selection cancelled.');
				}
			);
		};

		/** When user clicks on the cancel button in target* */
		self.saveRedHatCancelled = function() {
			$scope.$emit('replicationTargetAddCancelled');
		};

		/**
		 * This function takes care of the service call where the API is called during the creation of the
		 * target*
		 */
		self.addReplicationTarget = function(replicationTarget) {
			restoreService
				.addReplicationTarget(replicationTarget)
				.success(function(data) {
					$scope.$emit('replicationTargetAdded', data.entity);
					cvToaster.showInfoMessage({
						ttl: '10000', //10 sec
						message: cvLoc('label.createdReplicationTarget', data)
					});
				})
				.error(function(e) {
					self.redHatErrorMessage = cvUtil.errMsg(e ? e : cvLoc('error.saveReplicationTarget'));
				});
		};

		/** This function takes care of the service call where the API is called when the target is edited* */
		self.updateReplicationTarget = function(updatedReplicationTarget) {
			restoreService
				.updateReplicationTarget(updatedReplicationTarget)
				.success(function(data) {
					$scope.$emit('replicationTargetUpdated', data.entity);
					cvToaster.showInfoMessage({
						ttl: '10000', //10 sec
						message: cvLoc('label.updatedReplicationTarget', data)
					});
				})
				.error(function(e) {
					self.redHatErrorMessage = cvUtil.errMsg(e ? e : cvLoc('error.saveReplicationTarget'));
				});
		};

		self.validateTarget = function() {
			self.noErrorExisiting = true;
			if (
				!self.browseOptions.destinationHost ||
				(self.browseOptions.destinationHost && !self.browseOptions.destinationHost.displayName)
			) {
				self.missingDestinationCluster = cvUtil.errMsg(cvLoc('placeholder.selectDestinationCluster'));
				self.noErrorExisiting = false;
			}
		};

		self.save = function() {
			self.validateTarget();
			if (
				!self.noErrorExisiting ||
				!self.ctrl.validateCPUs() ||
				!self.ctrl.validateMaxMemory() ||
				!self.ctrl.validateNoOfVMs() ||
				!self.ctrl.validateExpirationTime()
			) {
				return;
			}

			var POLICY_TYPE = 9;
			var globalOptions = self.restoreData.globalOptions;
			var advanceOptions = self.restoreData.advanceOptions;
			var data = {
				entity: {
					vmAllocPolicyName: self.restoreData.replicationTargetName,
					policyType: POLICY_TYPE
				},
				destinationHyperV: {
					clientId: globalOptions.server.clientId,
					clientName: globalOptions.server.clientName
				},
				proxyClientEntity: {
					clientId: globalOptions.selectedProxy ? globalOptions.selectedProxy[0].clientId : null,
					clientName: globalOptions.selectedProxy ? globalOptions.selectedProxy[0].clientName : null
				},
				vmNameEditString: self.restoreData.displayNamePrefixSuffix,
				vmNameEditType: self.restoreData.prefixSuffixSelector.toUpperCase(),
				//destination default
				esxServers: [
					{
						esxServerName: vmLifeCyclePolicyFactory.getDestinationHostDisplayName(self.browseOptions.destinationHost)
					}
				],
				vmPolicyAppType: $scope.vmPolicyAppType ? $scope.vmPolicyAppType : VM_POLICY_APP_TYPE.REPLICATION.type
			};
			//destination cluster
			if (self.browseOptions.selectedNetwork.length > 0) {
				data.networkNames = [];
				angular.forEach(self.browseOptions.selectedNetwork, function(network) {
					data.networkNames.push(network.networkName);
				});
			}

			if (advanceOptions.isApplianceEnabledCS) {
				data.maxCores = advanceOptions.noOfCPUs;
				data.maxMemory = advanceOptions.maxMemory;
			}

			if (advanceOptions.showLiveMount) {
				data.isLiveMountEnabled = true;
				if (!!advanceOptions.minutesRetainUntil && !advanceOptions.enableVirtualLabs) {
					data.minutesRetainUntil = advanceOptions.minutesRetainUntil;
					data.daysRetainUntil = null;
				}

				if (advanceOptions.enableMediaAgent && advanceOptions.mediaAgent && advanceOptions.mediaAgent[0].displayName) {
					data.mediaAgent = {
						clientName: advanceOptions.mediaAgent[0].mediaAgentName,
						clientId: advanceOptions.mediaAgent[0].mediaAgentId
					};
				}
			}

			//user membership
			if (self.usersAndUserGroup && self.usersAndUserGroup.length > 0) {
				data.securityAssociations = replTargetFactory.setUsersAndUserGroups(self.usersAndUserGroup);
			}

			data.maxVMQuota = advanceOptions.noOfVms;

			if (self.editMode) {
				data.entity.vmAllocPolicyId = self.replicationTargetId;
				self.updateReplicationTarget(data);
			} else {
				self.addReplicationTarget(data);
			}
		};
	}
];

serverMod.controller(controllers);
export default serverMod;
