import 'modules/servers/js/services/servers.svc.js';
import 'vsa/js/services/restore.svc.js';
import 'vsa/js/directives/cv-select-hypervisors-directive.js';
import 'vsa/js/directives/cv-availability-zones-directive.js';
import 'vsa/js/factories/replicationTargetActions.factory.js';
import 'vsa/js/directives/cv-restore-options-openstack-directive.js';
import 'modules/vmManagement/js/constants/vmLifeCyclePolicy.constants.js';

import { vsaAppServerModule } from 'common/js/modules';

var serverMod = vsaAppServerModule;
var controllers = {};
controllers.replicationControllerOpenStack = [
	'$scope',
	'$stateParams',
	'$log',
	'restoreService',
	'serverService',
	'cvLoc',
	'cvUtil',
	'cvToaster',
	'$dialogs',
	'replTargetFactory',
	'VM_POLICY_APP_TYPE',
	function(
		$scope,
		$stateParams,
		$log,
		restoreService,
		serverService,
		cvLoc,
		cvUtil,
		cvToaster,
		$dialogs,
		replTargetFactory,
		VM_POLICY_APP_TYPE
	) {
		var self = this;
		self.editMode = $scope.editMode;
		$scope.vendor = 'OPENSTACK';
		$scope.$watch('model.vendor', function(vendor) {
			if (angular.isDefined(vendor)) {
				self.vendor = vendor;
				self.init();
			}
		});

		self.ctrl = {};
		self.model = {};

		self.ctrl.doRefresh = true;
		self.prefixSuffixSelector = 'SUFFIX'; //Select suffix by default
		self.displayNamePrefixSuffix = replTargetFactory.getDefaultVMSuffixPrefixName();
		$scope.disableEditing = false;
		if ($stateParams.policyId) {
			self.policyId = $stateParams.policyId;
		}
		// Initialize restoreData
		var initializeRestoreData = function(restoreData) {
			self.restoreData = angular.merge(
				{},
				{
					globalOptions: {
						overwrite: false,
						powerOn: false,
						selectedProxy: {},
						selectedHypervisor: {}
					}
				},
				self.restoreData
			);

			if (restoreData) {
				self.restoreData = angular.merge({}, restoreData, self.restoreData);
			} else {
				self.restoreData = angular.merge(
					{},
					{
						vmOptions: {
							displayName: null,
							createPublicIP: false,
							securityGroups: null,
							flavors: null,
							keyPairs: null,
							destinationHost: null,
							networkList: null,
							dataStores: null
						},
						minutesRetainUntil: 1
					},
					self.restoreData
				);
			}
			self.model.selectedHypervisor = $scope.model.selectedHypervisor ? $scope.model.selectedHypervisor : null;
			if (self.model.selectedHypervisor) {
				self.model.selectedHypervisor.type = 'OPENSTACK';
			}
			self.model.selectedProxy = $scope.model.selectedProxy ? $scope.model.selectedProxy : null;
			self.restoreData.globalOptions.showProxy = true;

			// empty list for restore options directive
			self.vmList = [];
			self.vmList.push(self.restoreData);

			replTargetFactory.collectUsersAndUserGroups(self.restoreData.securityAssociations).then(data => {
				self.usersAndUserGroups = data;
			});

			//For edit mode, get details from the restore data
			if (self.editMode) {
				self.displayNamePrefixSuffix = self.restoreData.displayNamePrefixSuffix;
				self.prefixSuffixSelector = self.restoreData.prefixSuffixSelector;
				self.additionalOptions = true;

				var server = self.model.selectedHypervisor;
				self.restoreData.globalOptions.server = angular.merge(
					{},
					{
						clientId: server.clientId,
						clientName: server.clientName
					},
					server
				);

				if (self.restoreData.vmOptions.flavors.length > 0) {
					if (!self.restoreData.vmOptions.flavors) {
						self.restoreData.vmOptions.flavors = {};
						self.restoreData.vmOptions.flavors.name = self.restoreData.vmOptions.flavors[0].vmInstanceTypeName;
					}
				}
				if (self.restoreData.vmOptions.securityGroups.length > 0) {
					if (!self.restoreData.vmOptions.securityGroups) {
						self.restoreData.vmOptions.securityGroups = {};
						self.restoreData.vmOptions.securityGroups.name = self.restoreData.vmOptions.securityGroups[0].name;
					}
				}
				if (self.restoreData.vmOptions.keyPairs.length > 0) {
					if (!self.restoreData.vmOptions.keyPairs) {
						self.restoreData.vmOptions.keyPairs = {};
						self.restoreData.vmOptions.keyPairs.keyName = self.restoreData.vmOptions.keyPairs[0].name;
					}
				}
				if (self.restoreData.vmOptions.networkLists.length > 0) {
					if (!self.restoreData.vmOptions.networkList) {
						self.restoreData.vmOptions.networkList = {};
						self.restoreData.vmOptions.networkList.networkDisplayName =
							self.restoreData.vmOptions.networkLists[0].networkDisplayName;
					}
				}

				if (self.restoreData.vmOptions.dataStoreList.length > 0) {
					if (!self.restoreData.vmOptions.dataStores) {
						self.restoreData.vmOptions.dataStores = {};
						self.restoreData.vmOptions.dataStores.dataStoreName =
							self.restoreData.vmOptions.dataStoreList[0].dataStoreName;
					}
				}
			}
		};

		// MARK: Initalize:
		self.init = function() {
			initializeRestoreData($scope.restoreData);
		};

		self.ctrl.refreshHypervisor = function() {
			var globalOptions = self.restoreData.globalOptions;

			var clearVmOptions = function(vmOpts) {
				vmOpts.securityGroups = null;
				vmOpts.flavors = null;
				vmOpts.keyPairs = null;
				vmOpts.networkList = null;
				vmOpts.dataStores = null;
				vmOpts.destinationHost = null;
			};

			if (self.model.selectedHypervisor && !self.model.selectedHypervisor.disabled) {
				var server = self.model.selectedHypervisor;
				if (globalOptions && globalOptions.server && globalOptions.server.serverId != server.clientId) {
					if (!self.editMode) {
						clearVmOptions(self.restoreData.vmOptions);
					}
				}

				self.restoreData.globalOptions.server = angular.merge(
					{},
					{
						clientId: server.clientId,
						clientName: server.clientName
					},
					server
				);

				//Load proxies again for selected hypervisor.
				if (self.ctrl.loadDestinationProxies) {
					self.ctrl.loadDestinationProxies(null, self.model.selectedHypervisor);
				}
			} else {
				self.restoreData.globalOptions.server = {};
			}

			self.mode = true;
		};

		self.addReplicationTarget = function(replicationTarget) {
			restoreService
				.addReplicationTarget(replicationTarget)
				.success(function(data) {
					$scope.$emit('replicationTargetAdded', data.entity);
					cvToaster.showSuccessMessage({
						ttl: '5000',
						message: cvLoc('label.createdReplicationTarget')
					});
				})
				.error(function(e) {
					self.openStackErrorMessage = cvUtil.errMsg(e ? e : cvLoc('error.saveReplicationTarget'));
				});
		};

		self.updateReplicationTarget = function(updatedReplicationTarget) {
			restoreService
				.updateReplicationTarget(updatedReplicationTarget)
				.success(function(data) {
					$scope.$emit('replicationTargetUpdated', data.entity);
					cvToaster.showSuccessMessage({
						ttl: '5000',
						message: cvLoc('label.updatedReplicationTarget')
					});
				})
				.error(function(e) {
					self.openStackErrorMessage = cvUtil.errMsg(e ? e : cvLoc('error.saveReplicationTarget'));
				});
		};

		var isSelectionValid = function() {
			self.openStackErrorMessage = cvUtil.emptyMsg();

			if (!self.restoreData.replicationTargetName) {
				self.openStackErrorMessage = cvUtil.errMsgLoc('error.name');
				return false;
			}
			if (!self.model.selectedHypervisor) {
				self.openStackErrorMessage = cvUtil.errMsgLoc('label.selectServer');
				return false;
			}

			if (!self.restoreData.vmOptions.destinationHost || self.restoreData.vmOptions.destinationHost === null) {
				$scope.$broadcast('validateEsxHost', self.restoreData.vmOptions.destinationHost);
				return false;
			}

			if (
				self.restoreData.vmOptions.networkInfo &&
				angular.isArray(self.restoreData.vmOptions.networkInfo) &&
				self.restoreData.vmOptions.networkInfo.length > 0 &&
				self.restoreData.vmOptions.networkInfo[0].networkDisplayName === 'loading'
			) {
				$scope.$broadcast('validateNetworkInfo', self.restoreData.vmOptions.networkInfo);
				return false;
			}

			if (
				self.restoreData.vmOptions.securityGroup &&
				angular.isArray(self.restoreData.vmOptions.securityGroup) &&
				self.restoreData.vmOptions.securityGroup.length > 0 &&
				self.restoreData.vmOptions.securityGroup[0].groupName === 'loading'
			) {
				$scope.$broadcast('validateSecurityGroup', self.restoreData.vmOptions.securityGroup);
				return false;
			}

			if (
				self.restoreData.vmOptions.dataStore &&
				angular.isArray(self.restoreData.vmOptions.dataStore) &&
				self.restoreData.vmOptions.dataStore.length > 0 &&
				self.restoreData.vmOptions.dataStore[0].dataStoreName === 'loading'
			) {
				$scope.$broadcast('validateDataStore', self.restoreData.vmOptions.dataStore);
				return false;
			}

			if (
				self.restoreData.vmOptions.flavor &&
				angular.isArray(self.restoreData.vmOptions.flavor) &&
				self.restoreData.vmOptions.flavor.length > 0 &&
				self.restoreData.vmOptions.flavor[0].name === 'loading'
			) {
				$scope.$broadcast('validateFlavor', self.restoreData.vmOptions.flavor);
				return false;
			}

			if (
				self.restoreData.vmOptions.keyPair &&
				angular.isArray(self.restoreData.vmOptions.keyPair) &&
				self.restoreData.vmOptions.keyPair.length > 0 &&
				self.restoreData.vmOptions.keyPair[0].keyName === 'loading'
			) {
				$scope.$broadcast('validateKeyPair', self.restoreData.vmOptions.keyPair);
				return false;
			}

			return true;
		};

		var getAmazonPolicy = function() {
			var amazonPolicy = {
				availabilityZones: [
					{
						availabilityZoneName: self.restoreData.vmOptions.destinationHost[0].displayName
					}
				]
			};
			amazonPolicy.vmInstanceTypes = [
				{
					vmInstanceTypeName: self.restoreData.vmOptions.flavor[0].name
				}
			];
			return amazonPolicy;
		};

		var getDestinationHostName = function(destinationHost) {
			if (destinationHost) {
				var host = destinationHost.replace(/%12/g, '/');
				return host;
			}
		};

		self.save = function() {
			if (!isSelectionValid()) {
				return;
			}

			var errorExisted = false;
			var vmOpt = self.restoreData.vmOptions;
			var globalOptions = self.restoreData.globalOptions;

			if (!vmOpt) {
				self.openStackErrorMessage = cvUtil.errMsg(cvLoc('error.saveReplicationTarget'));
				return false;
			}

			if (!globalOptions.server.clientId) {
				errorExisted = true;
				return;
			}

			var vmSize = angular.copy(vmOpt.openStackVmSize);
			var destinatioHostName = vmOpt.destinationHost[0].displayName;
			var securityGroup = angular.copy(vmOpt.securityGroup);
			var selectedProxy = globalOptions.selectedProxy ? globalOptions.selectedProxy[0] : null;
			var networkList = null;

			if (vmOpt.networkInfo) {
				networkList = [
					{
						networkName: vmOpt.networkInfo[0].networkName,
						name: vmOpt.networkInfo[0].name,
						subnetId: vmOpt.networkInfo[0].subNetId,
						networkDisplayName: vmOpt.networkInfo[0].networkDisplayName
					}
				];
			}

			if (!selectedProxy || !self.model.selectedHypervisor) {
				errorExisted = true;
			}

			if (errorExisted) {
				return;
			}

			var POLICY_TYPE = 10;
			var data = {
				entity: {
					vmAllocPolicyName: self.restoreData.replicationTargetName,
					policyType: POLICY_TYPE
				},
				destinationHyperV: {
					clientId: self.model.selectedHypervisor.clientId,
					clientName: self.model.selectedHypervisor.clientName
				},
				proxyClientEntity: {
					clientId: selectedProxy ? selectedProxy.clientId : null,
					clientName: selectedProxy ? selectedProxy.clientName : null
				},
				vmNameEditString: self.displayNamePrefixSuffix,
				vmNameEditType: self.prefixSuffixSelector.toUpperCase(),
				enableEditVMName: true,
				inPlaceRestore: true,
				networkList: networkList,
				keyPairs: [
					{
						name: self.restoreData.vmOptions.keyPair[0].keyName
					}
				],
				flavors: [
					{
						name: self.restoreData.vmOptions.flavor[0].name
					}
				],
				securityGroups: [
					{
						name: securityGroup[0] && securityGroup[0].groupName ? securityGroup[0].groupName : securityGroup[0].name,
						groupId: securityGroup[0] ? securityGroup[0].groupId : null
					}
				],
				destVendor: self.vendor,
				esxServers: [
					{
						esxServerName: destinatioHostName
					}
				],
				dataCenter: {
					instanceEntity: {
						instanceId: globalOptions.server.instanceId,
						instanceName: globalOptions.server.clientName
					}
				},
				dataStores: [
					{
						dataStoreName: self.restoreData.vmOptions.dataStore[0].dataStoreName
					}
				],
				vmPolicyAppType: $scope.vmPolicyAppType ? $scope.vmPolicyAppType : VM_POLICY_APP_TYPE.REPLICATION.type
			};

			if (self.usersAndUserGroup && self.usersAndUserGroup.length > 0) {
				data.securityAssociations = replTargetFactory.setUsersAndUserGroups(self.usersAndUserGroup);
			}
			data.amazonPolicy = getAmazonPolicy();

			if (selectedProxy && selectedProxy.clientId) {
				data.proxyClientEntity = {
					clientId: selectedProxy ? selectedProxy.clientId : null,
					clientName: selectedProxy ? selectedProxy.clientName : null
				};
				if (self.ctrl.displayProxyErrorMsg) {
					self.ctrl.displayProxyErrorMsg(cvUtil.emptyMsg());
				}
			} else {
				if (self.ctrl.displayProxyErrorMsg) {
					self.ctrl.displayProxyErrorMsg(cvUtil.errMsg(cvLoc('error.proxyClient')));
				}
				return;
			}

			if (self.editMode) {
				data.entity.vmAllocPolicyId = self.policyId;
				self.updateReplicationTarget(data);
			} else {
				self.addReplicationTarget(data);
			}
		};
	}
];
serverMod.controller(controllers);
export default serverMod;
