import { vsaAppServerModule } from 'common/js/modules';
import 'vsa/js/directives/cv-restore-options-googlecloud-directive.js';

var serverMod = vsaAppServerModule;
var controllers = {};

// serverMod.constant('RESTORE_OPTIONS_MODE_GOOGLECLOUD', {
// 	REPLICATION_TARGET: 'replicationTarget',
// 	RESTORE: 'restore'
// });

controllers.replicationControllerGoogleCloud = [
	'$scope',
	'$stateParams',
	'restoreService',
	'cvLoc',
	'cvUtil',
	'cvToaster',
	'replTargetFactory',
	'VM_POLICY_APP_TYPE',
	'VSA_VENDOR',
	function(
		$scope,
		$stateParams,
		restoreService,
		cvLoc,
		cvUtil,
		cvToaster,
		replTargetFactory,
		VM_POLICY_APP_TYPE,
		VSA_VENDOR
	) {
		var self = this;
		self.distributeWorkload = _.get(cvConfig, 'bEnableDistributeWorkload', false);
		self.vendor = VSA_VENDOR.GOOGLECLOUD;
		self.editMode = $scope.editMode;

		$scope.$watch('model.vendor', function(vendor) {
			if (angular.isDefined(vendor)) {
				self.vendor = vendor;
				self.init();
			}
		});
		self.ctrl = {};
		self.model = {};

		if ($stateParams.policyId) {
			self.policyId = $stateParams.policyId;
		}

		self.isRegularPolicy = function() {
			return $scope.vmPolicyAppType === VM_POLICY_APP_TYPE.REGULAR.type;
		};

		//Initializes the values during edit mode
		var setValues = function(restoreData) {
			self.model.selectedHypervisor = restoreData.selectedHypervisor ? restoreData.selectedHypervisor : null;
			self.restoreData.globalOptions.selectedProxy = restoreData.proxyClientEntity
				? [restoreData.proxyClientEntity]
				: restoreData.globalOptions.selectedProxy;
			self.restoreData.globalOptions.serverDetails = self.model.selectedHypervisor;
		};

		//Initializes the values during creation and edit mode
		var initializeRestoreData = function(restoreData) {
			self.restoreData = angular.merge(
				{},
				{
					globalOptions: {}
				},
				self.restoreData
			);

			//During target edit mode
			if (restoreData) {
				self.restoreData = angular.merge({}, restoreData, self.restoreData);
				self.restoreData.isAll = function() {
					return self.restoreData.vmOptions && !!self.restoreData.vmOptions.isAll;
				};
				setValues(self.restoreData);
			} else {
				//during target creation
				self.restoreData = angular.merge(
					{},
					{
						prefixSuffixSelector: 'suffix',
						displayNamePrefixSuffix: null,
						vmOptions: {},
						isAll: function() {
							return self.restoreData.vmOptions && !!self.restoreData.vmOptions.isAll;
						}
					},
					self.restoreData
				);
			}
			// empty list for restore options directive
			self.vmList = [];
			self.vmList.push(self.restoreData);

			replTargetFactory.collectUsersAndUserGroups(self.restoreData.securityAssociations, self.editMode).then(data => {
				self.usersAndUserGroups = data;
			});
		};

		self.init = function() {
			initializeRestoreData($scope.restoreData);
		};

		//flag to show/hide fields in override options and target
		self.displayOptionDetails = false;

		self.ctrl.refreshHypervisor = function() {
			var globalOptions = self.restoreData.globalOptions;
			var clearVmOptions = function(vmOpts) {
				vmOpts.selectedProxy = null;
			};

			if (self.model.selectedHypervisor && !self.model.selectedHypervisor.disabled) {
				var serverDetails = self.model.selectedHypervisor;
				if (
					globalOptions &&
					globalOptions.serverDetails &&
					globalOptions.serverDetails.serverId != serverDetails.clientId
				) {
					if (!self.editMode) {
						clearVmOptions(globalOptions);
					}
				}

				self.restoreData.globalOptions.serverDetails = angular.merge(
					{},
					{
						serverId: serverDetails.clientId,
						serverName: serverDetails.clientName
					},
					serverDetails
				);
			} else {
				self.restoreData.globalOptions.serverDetails = {};
			}

			if (self.ctrl.loadDestinationProxies) {
				self.ctrl.loadDestinationProxies(null, self.model.selectedHypervisor);
			}
		};

		var getCurrentHostDisplayName = function() {
			let destinationHost = self.restoreData.vmOptions.destinationHost;
			let displayName = destinationHost.displayName;
			if (destinationHost.project) {
				displayName = `${destinationHost.project.name}\\${displayName}`;
			} else {
				displayName = `${displayName}`;
			}
			return displayName;
		};

		//When user clicks on the cancel button in target
		self.saveGoogleCloudCancelled = function() {
			$scope.$emit('replicationTargetAddCancelled');
		};

		//This function takes care of the service call where the API is called during the creation of the target
		self.addReplicationTarget = function(replicationTarget) {
			restoreService
				.addReplicationTarget(replicationTarget)
				.success(function(data) {
					$scope.$emit('replicationTargetAdded', data.entity);
					cvToaster.showSuccessMessage({
						ttl: '5000',
						message: cvLoc('label.createdReplicationTarget')
					});
				})
				.error(function(e) {
					self.GoogleCloudErrorMessage = cvUtil.errMsg(e ? e : cvLoc('error.saveReplicationTarget'));
				});
		};

		//This function takes care of the service call where the API is called when the target is edited
		self.updateReplicationTarget = function(updatedReplicationTarget) {
			restoreService
				.updateReplicationTarget(updatedReplicationTarget)
				.success(function(data) {
					$scope.$emit('replicationTargetUpdated', data.entity);
					cvToaster.showSuccessMessage({
						ttl: '5000',
						message: cvLoc('label.updatedReplicationTarget')
					});
				})
				.error(function(e) {
					self.GoogleCloudErrorMessage = cvUtil.errMsg(e ? e : cvLoc('error.saveReplicationTarget'));
				});
		};

		//When the target is create/edited and then saved
		self.save = function() {
			if (!self.ctrl.validateVmOptions()) {
				return;
			}

			let POLICY_TYPE = 18;
			var globalOptions = self.restoreData.globalOptions;
			var networkList = null;

			if (_.get(self.restoreData, 'vmOptions.nics[0]', false)) {
				networkList = [
					{
						networkName: self.restoreData.vmOptions.nics[0].networkName
							? self.restoreData.vmOptions.nics[0].networkName
							: self.restoreData.vmOptions.nics[0].networkId,
						name: self.restoreData.vmOptions.nics[0].name,
						subnetId: self.restoreData.vmOptions.nics[0].subnetId,
						networkDisplayName: self.restoreData.vmOptions.nics[0].name
					}
				];
			}

			var data = {
				entity: {
					vmAllocPolicyName: self.restoreData.replicationTargetName,
					policyType: POLICY_TYPE
				},

				destinationHyperV: {
					clientId: globalOptions.serverDetails.clientId,
					clientName: globalOptions.serverDetails.clientName
				},

				vmNameEditString: self.restoreData.displayNamePrefixSuffix,

				vmNameEditType: self.restoreData.prefixSuffixSelector.toUpperCase(),
				destVendor: self.vendor,

				//Zone
				esxServers: [
					{
						esxServerName: self.restoreData.vmOptions.destinationHost.entity.name
					}
				],
				//availability zone for GoogleCloud VMProv cases
				zone: {
					primaryZoneName: getCurrentHostDisplayName(),
					secondaryZoneName: self.restoreData.vmOptions.destinationHost.secondaryZone[0].name
				},

				//Region
				dataStores: [
					{
						dataStoreName: self.restoreData.vmOptions.destinationHost.region.name
					}
				],

				machineType: {
					name: self.restoreData.vmOptions.vmSize[0].name,
					id: self.restoreData.vmOptions.vmSize[0].id
				},

				//Network settings
				networkList: networkList,

				//public IP is set to false for now
				//TODO: check for public ip flag
				isPublicIPSettingsAllowed: self.restoreData.vmOptions.createPublicIP
					? self.restoreData.vmOptions.createPublicIP
					: false,
				vmPolicyAppType: $scope.vmPolicyAppType ? $scope.vmPolicyAppType : VM_POLICY_APP_TYPE.REPLICATION.type
			};

			// Set proxyClientEntity only if proxy is not Distribute workload/Automatic
			if (
				globalOptions.selectedProxy &&
				globalOptions.selectedProxy.length > 0 &&
				!globalOptions.selectedProxy[0].autoProxy
			) {
				data.proxyClientEntity = {
					clientId: globalOptions.selectedProxy[0].clientId,
					clientName: globalOptions.selectedProxy[0].clientName
				};
			}

			//user membership
			if (self.usersAndUserGroup && self.usersAndUserGroup.length > 0) {
				data.securityAssociations = replTargetFactory.setUsersAndUserGroups(self.usersAndUserGroup);
			}

			if (self.editMode) {
				data.entity.vmAllocPolicyId = self.policyId;
				self.updateReplicationTarget(data);
			} else {
				self.addReplicationTarget(data);
			}
		};
	}
];

serverMod.controller(controllers);
export default serverMod;
