import 'modules/vmManagement/js/directives/cv-file-input.directive.js';
import 'modules/servers/js/services/servers.svc.js';
import 'vsa/js/directives/cv-vm-destinations-directive.js';
import 'users/js/services/users.svc.js';
import 'vsa/js/services/restore.svc.js';
import 'storage/js/services/storage.svc.js';
import 'modules/setup/js/directives/setup-steps.js';
import 'vsa/js/factories/vmActions.factory.js';
import 'modules/vmManagement/js/factory/vmLifeCyclePolicy/lifeCyclePolicy.factory.js';
import 'modules/vmManagement/js/services/vmLifeCyclePolicy/lifeCylePolicy.svc.js';

import { vmManagementAppModule } from 'common/js/modules';

var vmManagementMod = vmManagementAppModule;

/* Small controller used only by selectRestoreDestinationHostModal.jsp to store selections */
vmManagementMod.controller('selectRestoreDestinationHostController', [
	'$scope',
	'destinationHostData',
	function($scope, destinationVmData) {
		$scope.selectionStore = destinationVmData.selection;
	}
]);

vmManagementMod.controller('policyCreateController', [
	'$q',
	'$state',
	'$stateParams',
	'$uibModal',
	'$log',
	'$filter',
	'$dialogs',
	'cvToaster',
	'cvUtil',
	'cvLoc',
	'cvTableOptions',
	'cvPageActionsFactory',
	'cvBreadcrumbsTabsFactory',
	'serverService',
	'userService',
	'restoreService',
	'cvTreeFactory',
	'storageService',
	'vmLifeCyclePolicyFactory',
	'vmFactory',
	'vmLifeCylePolicyService',
	function(
		$q,
		$state,
		$stateParams,
		$modal,
		$log,
		$filter,
		$dialogs,
		cvToaster,
		cvUtil,
		cvLoc,
		cvTableOptions,
		cvPageActionsFactory,
		cvBreadcrumbsTabsFactory,
		serverService,
		userService,
		restoreService,
		cvTreeFactory,
		storageService,
		vmLifeCyclePolicyFactory,
		vmFactory,
		vmLifeCylePolicyService
	) {
		var self = this;
		var dummyHostName = 'dummy';
		var cvVLabGatewayPrefix = 'cv_vlab_gateway';

		self.policyCategory = $stateParams['policyCategory'];

		cvBreadcrumbsTabsFactory.addBreadCrumbs([
			{
				title: cvLoc('label.lifeCyclePolicies'),
				link: '#lifeCyclePolicies'
			}
		]);
		//cache loggedinUserId, so we can set the user in default membership selection panel
		self.loggedInUserId = 0;
		if (!!cv.loggedInUserId) {
			self.loggedInUserId = parseInt(cv.loggedInUserId);
		}

		self.browseOptions = {};

		self.model = {
			policyName: '',
			policyDescription: '',
			noOfVms: 5,
			deletionGracePeriodDays: 0,
			daysRetainUntil: 1,
			minutesRetainUntil: 1,
			noOfCPUs: 1,
			maxMemory: 1,
			noOfDisks: 1,
			maxDiskSize: 100,
			enableDecommission: false,
			displayNamePrefixSuffix: 'VM',
			prefixSuffixSelector: 'SUFFIX',
			datastore: '',
			showLiveMount: false,
			showVirtualizeMe: false,
			migrateVMs: false,
			expirationTime: 'Hours',
			sshKeyData: '',
			sshKeyFileName: '',
			enableMediaAgent: false,
			mediaAgent: '',
			waitBeforeMigrationInHours: 1,
			enableVirtualLabs: false,
			createIsolatedNetwork: false,
			configureExistingNetwork: false,
			showGatewayOptions: false,
			compartment: {},
			cloudAgents: [],
			isCSApplianceVM: false,
			retainEnableDecommission: false
		};

		self.model.isCSApplianceVM = !!(
			cv &&
			cv.additionalSettings &&
			cv.additionalSettings.AdminConsole &&
			cv.additionalSettings.AdminConsole.isCSApplianceVM
		);

		var policyCategory = {
			autoScale: 'Autoscale',
			vmLifeCyclePolicy: 'VMLifeCycle'
		};

		self.isAutoScalePolicy = function(category) {
			if (category === policyCategory.autoScale) {
				return true;
			}
			return false;
		};

		self.model.vendors = [
			{
				name: cvLoc('vendor.vmware'),
				value: 'VMW',
				type: {
					VMWARE: true,
					VMW_LIVEMOUNT: true,
					VMW_BACKUP_LABTEMPLATE: true
				},
				autoScale: false
			},
			{
				name: cvLoc('vendor.oracle_cloud_infrastructure'),
				value: 'ORACLE_CLOUD_INFRASTRUCTURE',
				type: 'ORACLE_CLOUD_INFRASTRUCTURE',
				autoScale: false
			}
		];

		if (
			cv &&
			cv.additionalSettings &&
			cv.additionalSettings.Console &&
			cv.additionalSettings.Console.bEnableRedHatLivemount
		) {
			self.model.vendors.push({
				name: cvLoc('vendor.redhat'),
				value: 'REDHAT',
				type: 'RHEV',
				autoScale: false
			});
		}
		self.model.vendors.push({
			name: cvLoc('vendor.amazon'),
			value: 'AMAZON',
			type: { AMAZON: true },
			autoScale: true
		});

		//To filter vendors based on the category of the policy(Regular or Auto scale)
		self.filterVendors = function(vendors) {
			return vendors.filter(function(vendor) {
				if (self.isAutoScalePolicy(self.policyCategory)) {
					if (vendor.autoScale == true) {
						return vendor;
					}
				} else {
					if (vendor.autoScale != true) {
						return vendor;
					}
				}
			});
		};

		self.vendors = self.filterVendors(self.model.vendors || []);

		self.usersAndUserGroups = [];
		self.sourceLocation = $stateParams.sourceLocation;
		self.policyId = $stateParams.policyId;
		self.editMode = false; //$scope.editMode;
		self.allowedSshKeyExtentios = '.ppk';
		self.sshKeyFileLabel = cvLoc('label.chooseSSHKey');
		var gotoSourceSelection = function() {
			if (self.sourceLocation && self.sourceLocation === 'lifeCyclePolicies') {
				$state.go('lifeCyclePolicy');
			} else if (self.sourceLocation && self.sourceLocation === 'policyDetails') {
				$state.go('lifeCyclePolicyDetails', {
					policyId: self.policyId
				});
			} else {
				$state.go('lifeCyclePolicy');
			}
		};

		self.initializePolicyBrowseOptions = function() {
			self.browseOptions = {};
		};

		self.localLangUsers = {
			selectAll: cvLoc('label.selectAll'),
			selectNone: cvLoc('label.selectNone'),
			reset: cvLoc('label.reset'),
			search: cvLoc('label.search'),
			nothingSelected: cvLoc('msg.selectUsersAndUserGroups')
		};
		/*
		 * { name: cvLoc('label.vendor.azure'), value: "AZURE", type: "AZURE" }, { name:
		 * cvLoc('label.vendor.azure_v2'), value: "AZURE_V2", type: "AZURE_RESOURCE_MANAGER" }, { name:
		 * cvLoc('vendor.amazon'), value: "AMAZON", type: "AMAZON" }
		 */

		self.isOracleCloudInfrastructure = function() {
			return vmLifeCyclePolicyFactory.isOracleCloudInfrastructure(self.model.vendor);
		};

		self.isAmazon = function() {
			return vmLifeCyclePolicyFactory.isAmazon(self.model.vendor);
		};

		self.isVMware = function() {
			return vmLifeCyclePolicyFactory.isVMware(self.model.vendor);
		};

		self.isRedHat = function() {
			return vmLifeCyclePolicyFactory.isRedHat(self.model.vendor);
		};

		self.isApplianceEnabledCS = function() {
			return self.isRedHat() && self.model.isCSApplianceVM && self.model.showLiveMount;
		};

		/*
		 * getAmazonPolicyNodeDetails -it cache the amazonPolicy message level details, to browseOptions for
		 * edit policy.
		 */
		var getAmazonPolicyNodeDetails = function(amazonDetails) {
			if (amazonDetails) {
				if (amazonDetails.amazonPolicy) {
					if (amazonDetails.amazonPolicy.availabilityZones && amazonDetails.amazonPolicy.availabilityZones.length > 0) {
						self.browseOptions.savedAvailabilityDomain = {
							name: amazonDetails.amazonPolicy.availabilityZones[0].availabilityZoneName
						};
					}
					if (amazonDetails.amazonPolicy.instanceType && amazonDetails.amazonPolicy.instanceType.length > 0) {
						var instanceTypes = [];
						angular.forEach(amazonDetails.amazonPolicy.instanceType, function(type) {
							instanceTypes.push({
								id: type.instanceType.vmInstanceTypeName,
								name: type.instanceType.vmInstanceTypeName,
								numOfCpu: type.cpuCores,
								memoryInMB: type.memory,
								ticked: true
							});
						});
						self.browseOptions.savedInstanceTypes = instanceTypes;
					}
				}
			}
		};

		/** Start of Auto Scale Code * */

		var toggleStatus = {
			true: 'enabled-activity',
			false: 'disabled-activity'
		};

		/*
		 * editPolicySettings - should be used to cache the already saved items.
		 */
		function editPolicySettings(policyData) {
			if (policyData) {
				// initialize values
				self.model.vendor = vmLifeCyclePolicyFactory.getVendorByPolicyType(policyData.entity.policyType);
				//converting policy type
				policyData.entity.policyType = vmLifeCyclePolicyFactory.getPolicyTypeEnumByPolicyType(
					policyData.entity.policyType
				);
				self.model.serverDetails = self.model.serverDetails || {};
				self.model.serverDetails.clientId = policyData.destinationHyperV.clientId;
				self.model.serverDetails.clientName = policyData.destinationHyperV.clientName;
				self.model.destinationHostName = policyData.esxServers ? policyData.esxServers[0].esxServerName : '';
				self.autoScaleUp = toggleStatus[!!policyData.scaleOption.autoScaleUp];
				self.autoScaleOut = policyData.scaleOption.autoScaleOut === true ? toggleStatus.enable : toggleStatus.disable;
				self.autoPowerManagement = toggleStatus[!!policyData.scaleOption.powerManagement];
				if (!!self.agentsList && self.isAutoScalePolicy(self.policyCategory)) {
					for (var i = 0; i < self.agentsList.length; i++) {
						var clientName = self.agentsList[i].clientName ? self.agentsList[i].clientName : self.agentsList[i].name;
						for (var j = 0; j < policyData.scaleOption.client.length; j++) {
							if (policyData.scaleOption.client && policyData.scaleOption.client[j].clientName === clientName) {
								self.agentsList[i].selected = true;
							}
						}
					}
				}

				self.model.cloudAgents = policyData.scaleOption.client;

				self.browseOptions.savedImagesList = [];
				var imagesList = [];
				if (policyData.templates && policyData.templates.length > 0) {
					angular.forEach(policyData.templates, function(template) {
						if (template.vmGUID) {
							var image = {
								strGUID: template.vmGUID,
								name: template.name,
								ticked: true
							};
							imagesList.push(image);
						}
					});
				}

				if (imagesList && imagesList.length) {
					self.browseOptions.savedImagesList = imagesList;
				}

				self.model.policyName = policyData.entity.vmAllocPolicyName;
				self.model.displayNamePrefixSuffix = policyData.vmNameEditString;
				self.model.prefixSuffixSelector = policyData.vmNameEditType;
				self.model.showVirtualizeMe = !!(policyData.isoInfo && policyData.isoInfo.length);

				if (policyData.esxServers && policyData.esxServers.length > 0) {
					self.browseOptions.destinationHost = policyData.esxServers.map(function(obj) {
						var esxName = obj.esxServerName;
						var esxSplitName = esxName.split('|');
						var esxGuid = '';
						if (esxSplitName.length > 1) {
							esxGuid = esxSplitName[0];
							esxName = esxSplitName[1];
						}
						return {
							entity: {
								name: esxName,
								guid: esxGuid
							},
							displayName: esxName,
							guid: esxGuid
						};
					});

					self.model.compartment = self.browseOptions.destinationHost[0];
					self.browseOptions.destinationHost = self.browseOptions.destinationHost[0];
				}

				self.model.dataCenter = {
					dataCenterName: policyData.dataCenter.dataCenterName,
					dataCenterId: policyData.dataCenter.dataCenterId
				};

				if (!!policyData.dataCenter.GUID) {
					self.model.dataCenter.strGUID = policyData.dataCenter.GUID;
				}
				if (self.model.dataCenter.dataCenterName && self.browseOptions.destinationHost) {
					self.browseOptions.destinationHost.parent = {
						entity: {
							name: self.model.dataCenter.dataCenterName,
							strGUID: self.model.dataCenter.strGUID,
							dataCenterId: self.model.dataCenter.dataCenterName
						},
						type: 'DATACENTER'
					};
				}
				if (policyData.dataStores && policyData.dataStores.length > 0) {
					self.model.datastore = policyData.dataStores[0].dataStoreName;
				}

				if (policyData.restoreNetworkName) {
					self.model.restoreNetwork = policyData.restoreNetworkName;
				}

				if (policyData.gatewayTemplate && policyData.gatewayTemplate.vmGUID) {
					self.model.showGatewayOptions = true;
					self.browseOptions.gatewayTemplate = policyData.gatewayTemplate;
					self.browseOptions.gatewayNetwork = policyData.primaryGatewayNetwork;
				}

				if (policyData.entity.policyType === vmLifeCyclePolicyFactory.policyTypes.VMW_BACKUP_LABTEMPLATE) {
					self.model.enableVirtualLabs = true;
					if (!!policyData.createIsolatedNetwork) {
						self.model.createIsolatedNetwork = true;
					} else {
						self.model.configureExistingNetwork = true;
					}
					self.model.showLiveMount = true;
				}

				if (policyData.daysRetainUntil && policyData.daysRetainUntil > 0) {
					self.model.daysRetainUntil = policyData.daysRetainUntil;

					if (policyData.entity.policyType === vmLifeCyclePolicyFactory.policyTypes.VMWARE_LIVEMOUNT) {
						self.model.enableDecommission = false;
						//self.model.retainEnableDecommission = true;
					} else {
						self.model.enableDecommission = true;
					}

					if (policyData.deletionGracePeriodDays) {
						self.model.deletionGracePeriodDays = policyData.deletionGracePeriodDays;
					}
				}

				if (policyData.minutesRetainUntil && policyData.minutesRetainUntil > 0) {
					self.model.minutesRetainUntil = policyData.minutesRetainUntil;
					self.model.showLiveMount = true;
					//self.model.expirationTime = 'Hours';
				}
				if (policyData.migrateVMs) {
					self.model.migrateVMs = policyData.migrateVMs;
					self.model.waitBeforeMigrationInHours = policyData.waitBeforeMigrationInHours
						? policyData.waitBeforeMigrationInHours
						: 1;
				}

				if (policyData.mediaAgent && policyData.mediaAgent.clientName) {
					self.model.mediaAgent = {
						mediaAgentName: policyData.mediaAgent.clientName
					};
				}

				if (policyData.maxVMQuota) {
					self.model.noOfVms = policyData.maxVMQuota;
				}

				if (policyData.isLiveMountEnabled) {
					self.model.showLiveMount = true;
				}

				if (self.model.showVirtualizeMe || self.isApplianceEnabledCS()) {
					self.model.noOfCPUs = !!policyData.maxCores ? policyData.maxCores : 1;
					self.model.maxMemory = !!policyData.maxMemory ? policyData.maxMemory : 1;
				}

				if (self.isOracleCloudInfrastructure()) {
					var networkInfo = {};
					getAmazonPolicyNodeDetails(policyData);
					if (policyData.networkInfo && policyData.networkInfo.length > 0) {
						var subnets = [];
						angular.forEach(policyData.networkInfo[0].subnetNames, function(subnet, key) {
							if (subnet.name) {
								subnets.push({
									name: subnet.name,
									label: subnet.name,
									subnetId: subnet.subnetId,
									subnetMask: subnet.subnetMask,
									networkAddress: subnet.networkAddress,
									ticked: true
								});
							}
						});
						self.browseOptions.savedSubnets = subnets;
						networkInfo = {
							networkId: policyData.networkInfo[0].networkName,
							networkName: policyData.networkInfo[0].label,
							subnets: subnets
						};
						self.browseOptions.savedNetwork = networkInfo;
					}

					if (policyData.maxDiscs) {
						self.model.noOfDisks = policyData.maxDiscs;
					}
					if (policyData.maxDiskSpace) {
						self.model.maxDiskSize = policyData.maxDiskSpace;
					}
					var keyPairs = policyData.keyPairs;
					if (keyPairs && keyPairs.length > 0) {
						if (keyPairs[0].path) {
							self.model.sshKeyFileName = keyPairs[0].name;
							self.model.sshKeyData = keyPairs[0].path;
							if (!!self.model.sshKeyFileName) {
								self.sshKeyFileLabel = self.model.sshKeyFileName;
							}
						}
					}
				} else {
					var savedNetwork = [];
					if (policyData.networkList && policyData.networkList.length > 0) {
						angular.forEach(policyData.networkList, function(network, key) {
							var networkInfo = {
								label: network.destinationNetwork,
								networkName: network.destinationNetwork
							};
							savedNetwork.push(networkInfo);
						});
						self.browseOptions.savedNetwork = savedNetwork;
					} else if (policyData.networkNames && policyData.networkNames.length > 0) {
						angular.forEach(policyData.networkNames, function(network) {
							var networkInfo = {
								label: network,
								networkName: network
							};
							savedNetwork.push(networkInfo);
						});
						self.browseOptions.savedNetwork = savedNetwork;
					}
				}

				//self.model.securityAssociations =  policyData.securityAssociations;
				self.browseOptions.isoInfo = {
					windows: null,
					unix: null
				};
				if (policyData.isoInfo && policyData.isoInfo.length) {
					policyData.isoInfo.forEach(function(isoInfoObj) {
						if (isoInfoObj.osType === 'WINDOWS') {
							self.browseOptions.isoInfo.windows = isoInfoObj;
						} else if (isoInfoObj.osType === 'UNIX') {
							self.browseOptions.isoInfo.unix = isoInfoObj;
						}
					});
				}
				self.init();
			}
		}

		if (self.policyId) {
			self.editMode = true;
			restoreService
				.getReplicationTarget(self.policyId)
				.success(function(details) {
					self.policyDetails = details;
					if (self.isAutoScalePolicy(self.policyCategory)) {
						vmLifeCyclePolicyFactory.groupCloudAgents(self.model.vendor).then(data => {
							self.agentsList = data;
							editPolicySettings(details);
						});
					} else {
						editPolicySettings(details);
					}

					self.isLoaded = true;
				})
				.error(function(e) {
					$log.error(e);
					cvToaster.showErrorMessage({
						message: e
					});
					self.isLoaded = true;
					gotoSourceSelection();
				});
		} else {
			self.isLoaded = true;
			if (self.isAutoScalePolicy(self.policyCategory)) {
				vmLifeCyclePolicyFactory.groupCloudAgents(self.model.vendor).then(data => {
					self.agentsList = data;
				});
			}
		}

		var getProxyByClient = function(clientId) {
			serverService.getProxyByClient(clientId).then(
				function(data) {
					self.showProxy = true;
					var memberServers = data.virtualServerInstance.associatedClients.memberServers;
					var proxyList = self.proxyList;
					if (memberServers && memberServers.length && proxyList) {
						for (var i = 0; i < proxyList.length; i++) {
							if (proxyList[i].clientId == memberServers[0].client.clientId) {
								self.model.proxy = memberServers[0].client;
								break;
							}
						}
					}
				},
				function(e) {
					self.policyErrorMessage = cvUtil.errMsg(e ? e : cvLoc('error.getServers'));
				}
			);
		};

		var getProxies = function() {
			//passing vendor info in proxy servers as we want only windows proxies for vm ware
			serverService
				.getProxyServers(self.model.vendor)
				.success(function(data) {
					if (data && data.length) {
						self.proxyList = data;
						angular.forEach(data, function(proxy) {
							if (self.model.proxy && self.model.proxy.clientId === proxy.clientId) {
								self.model.proxy = proxy;
							}
						});
						if (!self.model.proxy.clientId) {
							self.model.proxy = data[0];
						}
					}
				})
				.error(function(e) {
					$log.error(e);
					self.policyErrorMessage = cvUtil.errMsg(e ? e : cvLoc('error.getServers'));
				});
		};

		/*
		 * getServersData - get the hypervisor clients for the selected vendor.
		 */
		var getServersData = function() {
			serverService
				.getServersByVendor(self.model.vendor)
				.success(function(data) {
					if (data && data.length) {
						self.showVM = true;
						self.servers = data;
						self.policyErrorMessage = cvUtil.emptyMsg();
						angular.forEach(data, function(server) {
							if (self.model.serverDetails && self.model.serverDetails.clientId === server.clientId) {
								self.model.serverDetails = server;
							}
						});
						if (!self.model.serverDetails) {
							self.model.serverDetails = data[0];
						}
						self.destinationServerChanged(self.model.serverDetails);
					} else {
						self.model.serverDetails = undefined;
						self.servers = [];
					}
				})
				.error(function(e) {
					self.policyErrorMessage = cvUtil.errMsg(e ? e : cvLoc('error.getServers'));
					self.model.serverDetails = undefined;
					self.servers = [];
				});
		};

		/*
		 * mediaAgentDetails - get mediaAgent for the livemount 3dnfs server selection.
		 */
		self.mediaAgentDetails = function() {
			storageService
				.getMediaAgentList('NONE')
				.success(function(data) {
					self.mediaAgentList = cvUtil.sortAscending(data, 'displayName');
					var selectMediaAgent;
					if (self.model.mediaAgent && self.model.mediaAgent.mediaAgentName) {
						angular.forEach(self.mediaAgentList, function(mediaAgent) {
							if (mediaAgent.mediaAgentName === self.model.mediaAgent.mediaAgentName) {
								selectMediaAgent = mediaAgent;
								self.model.enableMediaAgent = true;
								self.model.mediaAgent = mediaAgent;
								return;
							}
						});
					}

					if (!selectMediaAgent || !selectMediaAgent.mediaAgentName) {
						self.model.mediaAgent = data[0];
					}
				})
				.error(function(data, status, headers, config) {
					self.serverMessage = cvUtil.errMsg(data);
					return false;
				});
		};

		/*
		 * changeLabelsByVendor - modify label based on the vendor.
		 */
		self.changeLabelsByVendor = function() {
			if (self.isOracleCloudInfrastructure()) {
				self.destinationHostLabel = cvLoc('label.compartment');
				self.availabilityDomainOrResourcePoolLabel = cvLoc('label.availabilityDomain');
				self.destinationNetworkLabel = cvLoc('label.virtualCloudNetwork');
			} else if (self.isVMware()) {
				self.destinationHostLabel = cvLoc('label.destinationHost');
				self.destinationHostPlaceHolder = cvLoc('placeholder.selectDestinationHost');
				self.availabilityDomainOrResourcePoolLabel = cvLoc('label.resourcePool');
				self.destinationNetworkLabel = cvLoc('label.destinationNetworkModal');
				self.dataStoreLabel = cvLoc('label.dataStore');
			} else if (self.isRedHat()) {
				self.destinationHostLabel = cvLoc('label.destinationCluster');
				self.destinationHostPlaceHolder = cvLoc('placeholder.selectDestinationCluster');
				self.destinationNetworkLabel = cvLoc('label.destinationNetworkModal');
				self.dataStoreLabel = cvLoc('label.storageDomain');
			}
		};
		// MARK: Initalize:
		self.init = function() {
			//initializeRestoreData(self);
			getServersData();
			//getProxies();
			self.changeLabelsByVendor();

			if (self.editMode) {
				if (!self.isAutoScalePolicy(self.policyCategory)) {
					self.collectUserAndUserGroupDetails();
				}
				self.mediaAgentDetails();
				var hostName = self.browseOptions.destinationHost ? self.browseOptions.destinationHost.displayName : '';
				var guid = self.browseOptions.destinationHost ? self.browseOptions.destinationHost.guid : '';

				if (self.isOracleCloudInfrastructure()) {
					self.changeCompartmentDetails(guid);
				} else if (self.isVMware() || self.isRedHat()) {
					self.changeDestination(hostName);
				}
			} else {
				//resetting the common settings, when vendor is change, as some of them are not applicable for all vendors.
				self.model.enableDecommission = false;
				self.model.showVirtualizeMe = false;
				self.model.migrateVMs = false;
				self.model.enableMediaAgent = false;

				/*
				 * TODO: For time being, VMware will have selected live mount option selected by default,
				 * once all the policy integrated with Adminconsole, we need to reevaluate.
				 */
				if (self.isRedHat() || self.isVMware()) {
					self.model.showLiveMount = true;
				} else {
					self.model.showLiveMount = false;
				}
			}
			//post property set, deciding on the option.
			self.changeLiveMountOptions();
		};

		/*
		 * changeStepsByVendor - need to make/clear settings when vendor is changed.
		 */
		self.changeStepsByVendor = function(vendor) {
			self.model.vendor = vendor;
			self.init();
		};

		self.changeLabelsByVendor();

		/*
		 * destinationServerChanged - reset settings when destination hypervisor modified.
		 */
		self.destinationServerChanged = function(server, userChanged) {
			if (server) {
				self.model.server = angular.merge(
					{},
					{
						serverId: server.clientId,
						serverName: server.name
					},
					server
				);

				//getProxyByClient(server.clientId);

				if (self.model.vendor == 'ORACLE_CLOUD_INFRASTRUCTURE') {
					if (self.model.serverDetails) {
						self.loadRootElements();
					}
				} else {
					/*
					 * when hypervisor is changed, we need to reset the configuration page component cache, it
					 * should be applicable for both creation/edit policy
					 */
					if (userChanged) {
						self.initializePolicyBrowseOptions();
					}
					/*
					 * hiding virtual lab settings for sp14 if(self.isVMware()){ loadVMwareTemplateDetails(); }
					 */
				}
			} else {
				self.model.server = {};
			}
		};

		/*
		 * collectUserAndUserGroupDetails - populate user/user group accessed to the policy creator.
		 */
		self.collectUserAndUserGroupDetails = function() {
			userService.getUsers().then(function(data) {
				var users = {};
				if (data && data.data && (users = data.data.usersList)) {
					var selectedUsers =
						self.policyDetails &&
						self.policyDetails.securityAssociations &&
						self.policyDetails.securityAssociations.users;
					users.forEach(function(user) {
						user.fullName = user.userEntity ? user.userEntity.userName : '';
						user.selected = false;
						if (user.userEntity.userId === self.loggedInUserId) {
							user.selected = true;
						}
						if (!user.selected) {
							selectedUsers &&
								selectedUsers.length > 0 &&
								selectedUsers.forEach(function(selectedUser) {
									if (user.userEntity.userId === selectedUser.userId) {
										user.selected = true;
										return;
									}
								});
						}
					});
					var header = {
						fullName: '<strong>' + cvLoc('label.users') + '</strong>',
						header: true
					};
					var end = {
						header: false
					};
					self.usersAndUserGroups = self.usersAndUserGroups.concat(header);
					self.usersAndUserGroups = self.usersAndUserGroups.concat(users);
					self.usersAndUserGroups = self.usersAndUserGroups.concat(end);
				}
			});

			userService.getUserGroups().then(function(data) {
				var userGroups = {};
				if (data && (userGroups = data.data)) {
					var selectedUserGroups =
						self.policyDetails &&
						self.policyDetails.securityAssociations &&
						self.policyDetails.securityAssociations.userGroups;
					userGroups.forEach(function(userGroup) {
						userGroup.fullName = userGroup.userGroupEntity.userGroupName;
						selectedUserGroups &&
							selectedUserGroups.length > 0 &&
							selectedUserGroups.forEach(function(selectedUserGroup) {
								if (!userGroup.selected) {
									userGroup.userGroupEntity.userGroupId === selectedUserGroup.userGroupId
										? (userGroup.selected = true)
										: (userGroup.selected = false);
								}
							});
					});

					var header = {
						fullName: '<strong>' + cvLoc('label.userGroups') + '</strong>',
						header: true
					};
					var end = {
						header: false
					};
					self.usersAndUserGroups = self.usersAndUserGroups.concat(header);
					self.usersAndUserGroups = self.usersAndUserGroups.concat(userGroups);
					self.usersAndUserGroups = self.usersAndUserGroups.concat(end);
				}
			});
		};
		if (!self.editMode) {
			if (!self.isAutoScalePolicy(self.policyCategory)) {
				self.collectUserAndUserGroupDetails();
			}
			self.mediaAgentDetails();
		}
		var generalPageValidate = function() {
			if (!self.model.policyName) {
				return cvLoc('error.policyName');
			}
			if (!self.model.vendor) {
				return cvLoc('error.vendor');
			}

			if (!self.model.serverDetails || (self.model.serverDetails && !self.model.serverDetails.clientId)) {
				return cvLoc('error.destinationHypervisor');
			}
		};

		var configPageValidate = function() {
			if (self.isOracleCloudInfrastructure()) {
				if (!self.model.compartment || !self.model.compartment.guid) {
					return cvLoc('error.compartment');
				}
				if (!self.browseOptions.availabilityDomain || !self.browseOptions.availabilityDomain.name) {
					return cvLoc('error.availabilityDomain');
				}
				if (!self.browseOptions.selectedInstanceTypes || !self.browseOptions.selectedInstanceTypes.length > 0) {
					return cvLoc('error.shapes');
				}
				if (!self.browseOptions.selectedImages || !self.browseOptions.selectedImages.length > 0) {
					return cvLoc('error.images');
				}

				if (!self.browseOptions.selectedNetwork || !self.browseOptions.selectedNetwork.networkName) {
					return cvLoc('error.virtualCloudNetwork');
				}
				if (!self.browseOptions.selectedSubnets || !self.browseOptions.selectedSubnets.length > 0) {
					return cvLoc('error.subnet');
				}

				if (!self.model.sshKeyFileName || !self.model.sshKeyData) {
					return cvLoc('error.sshKey');
				}
			} else if (self.isVMware()) {
				if (!self.browseOptions.destinationHost || !self.browseOptions.destinationHost.displayName) {
					return cvLoc('error.destinationServer');
				}
				/*
				 * if(!self.model.prefixSuffixSelector){ return cvLoc('error.prefixSuffixSelector'); }
				 */

				if (self.model.prefixSuffixSelector && !self.model.displayNamePrefixSuffix) {
					return cvLoc('error.displayName');
				}

				if (!self.model.prefixSuffixSelector && self.model.displayNamePrefixSuffix) {
					return cvLoc('error.prefixSuffixSelector');
				}
				if (!self.browseOptions.dataStore) {
					return cvLoc('error.dataStore');
				}

				/*
				 * if(!self.browseOptions.availabilityDomain || !self.browseOptions.availabilityDomain.name){
				 * return cvLoc('error.resourcePool'); }
				 *
				 * if(!self.model.enableVirtualLabs && !self.browseOptions.selectedNetwork ||
				 * (!self.browseOptions.selectedNetwork.length > 0)){ return
				 * cvLoc('error.networkSettings.destination'); }
				 */

				if (self.model.enableVirtualLabs) {
					if (
						self.model.configureExistingNetwork &&
						(!self.browseOptions.existingNetwork || !self.browseOptions.existingNetwork.networkName)
					) {
						return cvLoc('error.selectNetwork');
					} else if (self.model.createIsolatedNetwork) {
						if (self.model.showGatewayOptions) {
							if (!self.browseOptions.gatewayTemplate || !self.browseOptions.gatewayTemplate.vmName) {
								return cvLoc('error.selectGatewayTemplate');
							}
							if (!self.browseOptions.gatewayNetwork || !self.browseOptions.gatewayNetwork.networkName) {
								return cvLoc('error.selectGatewayNetwork');
							}
						}
					}
				}
			} else if (self.isRedHat()) {
				if (!self.browseOptions.destinationHost || !self.browseOptions.destinationHost.displayName) {
					return cvLoc('error.destinationCluster');
				}
				/*
				 * if(!self.model.prefixSuffixSelector){ return cvLoc('error.prefixSuffixSelector'); }
				 */

				if (self.model.prefixSuffixSelector && !self.model.displayNamePrefixSuffix) {
					return cvLoc('error.displayName');
				}

				if (!self.model.prefixSuffixSelector && self.model.displayNamePrefixSuffix) {
					return cvLoc('error.prefixSuffixSelector');
				}
				/*
				 * Bring it once support added. if(!self.browseOptions.dataStore){ return
				 * cvLoc('error.storageDomain'); }
				 *
				 */
			}
		};

		var settingsPageValidate = function() {
			var isUserOrUserGroupSelected = false;
			if (self.usersAndUserGroups.length > 0) {
				self.usersAndUserGroups.forEach(function(user) {
					if (user.selected) {
						isUserOrUserGroupSelected = true;
						return;
					}
				});
			}

			if (!isUserOrUserGroupSelected) {
				return cvLoc('error.userAndUserGroup');
			}

			if (self.isVMware()) {
				if (self.model.showVirtualizeMe) {
					if (!self.browseOptions.isoInfo.windows || !self.browseOptions.isoInfo.unix) {
						return cvLoc('error.selectIsoPath');
					}
				}
			}
		};

		var generalPage = {
			completed: false,
			template: appUtil.appRoot + 'modules/vmManagement/partials/lifeCyclePolicy/lifeCyclePolicyGeneralPage.jsp',
			name: cvLoc('label.policyGeneralPage'),
			skipStep: false,
			validateMethod: generalPageValidate
		};

		self.setConfigTemplateUrl = function() {
			return self.isAutoScalePolicy(self.policyCategory)
				? appUtil.appRoot + 'modules/vmManagement/partials/lifeCyclePolicy/vmAutoScalePolicyConfigPage.jsp'
				: appUtil.appRoot + 'modules/vmManagement/partials/lifeCyclePolicy/vmLifeCyclePolicyConfigPage.jsp';
		};

		var configPage = {
			completed: false,
			template: self.setConfigTemplateUrl(),
			name: cvLoc('label.policyConfigurationPage'),
			skipStep: false,
			validateMethod: configPageValidate
		};

		var settingsPage = {
			completed: false,
			template: appUtil.appRoot + 'modules/vmManagement/partials/lifeCyclePolicy/vmLifeCyclePolicySettingsPage.jsp',
			name: cvLoc('label.policySettingsPage'),
			skipStep: false,
			validateMethod: settingsPageValidate
		};

		var steps = [];
		steps.push(generalPage);
		steps.push(configPage);
		if (!self.isAutoScalePolicy(self.policyCategory)) {
			steps.push(settingsPage);
		}

		self.steps = steps;
		self.step = 0;

		self.setPageTitle = function() {
			self.isAutoScalePolicy(self.policyCategory)
				? (self.title = cvLoc('pageHeader.autoScalePolicy'))
				: (self.title = cvLoc('pageHeader.createPolicy'));
		};
		self.setPageTitle();

		if (self.editMode) {
			self.title = cvLoc('pageHeader.editPolicy');
		}

		/*
		 * self.wizardCancelMethod = function () { gotoSourceSelection(); };
		 */

		self.isDataStoreListAvailable = function() {
			// Data store list will be populated only if a destination host has been selected
			return !!self.browseOptions && !!self.browseOptions.dataStoreList;
		};

		self.getDataStoreDropdownLabel = function(ds) {
			return ds.dataStoreName + ' (' + $filter('capacity')(ds.freeSpaceInBytes) + ' free)';
		};

		self.getDataStoreDropdownText = function() {
			if (!self.isDataStoreListAvailable()) {
				// Data store list is not defined, indicating that no host has been selected - dropdown will be hidden in this case
				return '';
			}

			if (!!self.browseOptions.dataStoreListError) {
				// An error occurred loading the list
				return cvLoc('error.placeholder');
			}

			if (self.browseOptions.dataStoreList.length === 0) {
				// Data store list is empty, indicating that it is currently loading
				return cvLoc('Loading');
			}

			// Data store list is loaded
			return cvLoc('placeholder.selectDataStore');
		};

		self.getCurrentHostDisplayName = function() {
			if (!self.browseOptions || !self.browseOptions.destinationHost) {
				return;
			}
			return self.browseOptions.destinationHost.displayName;
		};

		self.isInstanceTypeListAvailable = function() {
			return (
				!!self.browseOptions && !!self.browseOptions.instanceTypeList && self.browseOptions.instanceTypeList.length > 0
			);
		};

		self.getInstanceTypeLabel = function(instanceType) {
			return instanceType.name === '' || !instanceType.memoryInMB
				? instanceType.name
				: instanceType.name +
						'(' +
						(instanceType.numOfCpu && instanceType.numOfCpu > 0 ? instanceType.numOfCpu + ' Core, ' : '') +
						Math.floor(instanceType.memoryInMB / 1024) +
						' GB)';
		};

		self.isImagesListAvailable = function() {
			return !!self.browseOptions && !!self.browseOptions.imagesList && self.browseOptions.imagesList.length > 0;
		};

		self.isAvailabilityDomainListAvailable = function() {
			return (
				!!self.browseOptions &&
				!!self.browseOptions.availabilityDomainList &&
				self.browseOptions.availabilityDomainList.length > 0
			);
		};

		self.getAvailabilityDomainOrResourePoolDisplayName = function(data) {
			if (self.isVMware()) {
				return data.resourcePoolPath;
			} else if (self.isOracleCloudInfrastructure()) {
				return data.name;
			}
		};

		self.getAvailabilityDomainDropdownText = function() {
			if (
				self.isAvailabilityDomainLoading &&
				!self.isAvailabilityDomainListAvailable() &&
				!self.browseOptions.availabilityDomainList
			) {
				// availabilityDomain type list is not defined, indicating that no host has been selected - dropdown will be hidden in this case
				return cvLoc('Loading');
			}

			if (!!self.browseOptions.availabilityDomainListError) {
				// An error occurred loading the list
				return cvLoc('error.placeholder');
			}

			var dropDownText = cvLoc('placeholder.selectAvailabilityDomain');
			if (self.model.vendor == 'VMW') {
				dropDownText = cvLoc('placeholder.selectResourcePool');
			}
			return dropDownText;
		};

		self.networkInfoChanged = function(selectedNetwork) {
			self.browseOptions.subnetsMultiSelectList = [];
			if (selectedNetwork.subnets && selectedNetwork.subnets.length > 0) {
				self.browseOptions.subnetsMultiSelectList = angular.copy(selectedNetwork.subnets);
			}
		};
		self.isNetworkListAvailable = function() {
			return (
				!!self.browseOptions &&
				!!self.browseOptions.networkSettingsList &&
				self.browseOptions.networkSettingsList.length > 0
			);
		};
		self.getNetworkDropdownText = function() {
			if (self.isNetworkLoading && !self.isNetworkListAvailable() && !self.browseOptions.networkSettingsList) {
				// instance type list is not defined, indicating that no host has been selected - dropdown will be hidden in this case
				return cvLoc('Loading');
			}

			if (!!self.browseOptions.networkSettingsListError) {
				// An error occurred loading the list
				return cvLoc('error.placeholder');
			}

			// instance type list is loaded
			return cvLoc('placeholder.selectNetworks');
		};

		self.isCompartmentAvailable = function() {
			return (
				!!self.browseOptions && !!self.browseOptions.compartmentList && self.browseOptions.compartmentList.length > 0
			);
		};
		self.getCompartmentDropdownText = function() {
			if (self.rootElementLoading && !self.isCompartmentAvailable() && !self.browseOptions.compartmentList) {
				// instance type list is not defined, indicating that no host has been selected - dropdown will be hidden in this case
				return cvLoc('Loading');
			}

			if (!!self.browseOptions.networkSettingsListError) {
				// An error occurred loading the list
				return cvLoc('error.placeholder');
			}

			// instance type list is loaded
			return cvLoc('placeholder.selectCompartment');
		};

		self.virtualLabetworkChanged = function(selectionType) {
			if (selectionType === 'createIsolatedNetwork' && self.model.createIsolatedNetwork) {
				self.model.configureExistingNetwork = false;
			}
			if (selectionType === 'configureExistingNetwork' && self.model.configureExistingNetwork) {
				self.model.createIsolatedNetwork = false;
			}
			if (self.model.createIsolatedNetwork || self.model.configureExistingNetwork) {
				self.model.enableVirtualLabs = true;
			} else {
				self.model.enableVirtualLabs = false;
			}
		};
		self.isGatewayTemplateListAvailable = function() {
			return (
				!!self.browseOptions &&
				!!self.browseOptions.gatewayTemplateList &&
				self.browseOptions.gatewayTemplateList.length > 0
			);
		};

		self.getGatewayTemplateDropdownText = function() {
			if (self.isTemplateLoading && !self.isGatewayTemplateListAvailable() && !self.browseOptions.gatewayTemplateList) {
				// template list is not defined, indicating that no host has been selected - dropdown will be hidden in this case
				return cvLoc('Loading');
			}

			if (!!self.browseOptions.gatewayTemplateListError) {
				// An error occurred loading the list
				return cvLoc('error.placeholder');
			}

			// template list is loaded
			return cvLoc('placeholder.template');
		};

		self.loadRootElements = function() {
			var serverId = self.model.serverDetails.clientId;

			var inventoryPath = '\\NONE:VMs';
			self.rootElementLoading = true;
			serverService
				.vsaInventoryBrowse(serverId, inventoryPath)
				.success(function(data) {
					self.browseOptions.compartmentList = data;
					if (data.length > 0) {
						var oldComparmentVal = self.model.compartment.guid;
						var newComparmentVal;
						for (var j = 0; j < data.length; j++) {
							if (data[j].guid === self.model.compartment.guid) {
								self.model.compartment = data[j];
								break;
							}
						}
					}

					self.rootElementLoading = false;
					if (oldComparmentVal && self.model.compartment.guid !== oldComparmentVal) {
						self.initializePolicyBrowseOptions();
					}
				})
				.error(function(err) {
					self.rootElementLoading = false;
					self.serverMessage = 'Compartments could not be loaded'; // !!! cvUtil.errMsgLoc('error.loading...');
				});
		};

		self.openSelectDestinationHostDialog = function() {
			self.serverMessageTop = cvUtil.emptyMsg();

			var modalInstance = $modal.open({
				templateUrl: appUtil.appRoot + 'vsa/partials/selectRestoreDestinationHostModal.jsp',
				backdrop: 'static',
				controller: [
					'$scope',
					'$rootScope',
					'$location',
					'$uibModalInstance',
					'$state',
					'cvLoc',
					'destinationHostData',
					'$log',
					'server',
					'cvToaster',
					function(
						$scope,
						$rootScope,
						$location,
						$modalInstance,
						$state,
						cvLoc,
						destinationHostData,
						$log,
						server,
						cvToaster
					) {
						$scope.server = server;
						$scope.cancel = function() {
							$modalInstance.dismiss('cancel');
						};

						$scope.select = function() {
							// Selections are stored at this point in destinationVmData.selection:
							var selected = null;
							if (destinationHostData.selection.length > 0) {
								selected = destinationHostData.selection[0];
							}
							$modalInstance.close(selected);
						};
					}
				],
				resolve: {
					server: function() {
						return {
							clientId: self.model.serverDetails.clientId,
							serverName: '',
							username: '',
							password: '',
							vendor: self.model.vendor,
							selectableType: self.model.vendor === 'REDHAT' ? 'CLUSTER' : 'SERVER'
						};
					}
				}
			});
			modalInstance.result.then(
				function(result) {
					// selection will be stored in $scope.selectionStore, which is destinationHostData.selection
					$log.debug('Destination Host: ' + (result ? result.displayName : result));
					// To trigger loading text in dropdown
					self.browseOptions.dataStoreList = [];
					self.browseOptions.availabilityDomainList = [];
					self.browseOptions.networkSettingsList = [];
					self.browseOptions.existingNetworkSettingsList = [];
					self.browseOptions.restoreNetworkSettingsList = [];
					self.browseOptions.gatewayNetworkSettingsList = [];
					self.browseOptions.dataStoreForIsoPathList = [];
					self.browseOptions.isoInfo = {
						windows: null,
						unix: null
					};
					self.browseOptions.destinationHost = result;
					self.changeDestination(result.displayName);
				},
				function() {
					$log.info('Destination Host Selection cancelled.');
				}
			);
		};

		var loadDataStores = function(hostname) {
			self.isDataStoreLoading = true;

			var destinationServer = self.model.serverDetails;
			var serverId = destinationServer.clientId;

			// Load data store list:
			serverService.getDataStores(serverId, hostname, destinationServer, self.model.vendor).then(
				function(data) {
					self.browseOptions.dataStoreListError = false;
					self.browseOptions.dataStoreList = data.data;
					self.browseOptions.dataStoreForIsoPathList = angular.copy(self.browseOptions.dataStoreList);
					if (self.browseOptions.dataStoreList.length > 0) {
						//Set the first one in the list selected
						self.browseOptions.dataStore = self.browseOptions.dataStoreList[0];
						//Check if the default datastore value is in the list.If so, set the default value selected.
						if (self.model.datastore) {
							for (var i in self.browseOptions.dataStoreList) {
								if (self.browseOptions.dataStoreList[i].dataStoreName == self.model.datastore) {
									self.browseOptions.dataStore = self.browseOptions.dataStoreList[i];
									break;
								}
							}
						}
						self.browseOptions.dataStoreForIsoPath = self.browseOptions.dataStoreForIsoPathList[0];
					}
				},
				function(e) {
					$log.error(e);
					self.browseOptions.dataStoreList = [];
					self.browseOptions.dataStoreForIsoPathList = [];
					self.browseOptions.dataStoreListError = true;
				}
			);
		};

		var loadAvailabilityDomainDetails = function(hostname) {
			self.isAvailabilityDomainLoading = true;

			var destinationServer = self.model.serverDetails;
			var serverId = destinationServer.clientId;

			//load availabilityDomains
			serverService
				.getResourcePools(serverId, hostname)
				.success(function(data) {
					self.browseOptions.availabilityDomainListError = false;
					self.browseOptions.availabilityDomainList = [];
					self.browseOptions.availabilityDomainList = self.browseOptions.availabilityDomainList.concat(data);
					self.isAvailabilityDomainLoading = false;

					if (self.browseOptions.availabilityDomainList.length > 0) {
						self.browseOptions.availabilityDomain = self.browseOptions.availabilityDomainList[0];
						if (self.browseOptions.savedAvailabilityDomain && self.browseOptions.savedAvailabilityDomain.name) {
							for (var i in self.browseOptions.availabilityDomainList) {
								if (
									self.browseOptions.availabilityDomainList[i].name == self.browseOptions.savedAvailabilityDomain.name
								) {
									self.browseOptions.availabilityDomain = self.browseOptions.availabilityDomainList[i];
									break;
								}
							}
						}
						if (self.isOracleCloudInfrastructure()) {
							self.changeAvailabilityDomain(hostname, self.browseOptions.availabilityDomain);
						}
					}
				})
				.error(function(err) {
					$log.error(err);
					self.isAvailabilityDomainLoading = false;
					self.browseOptions.availabilityDomainList = [];
					self.browseOptions.availabilityDomainListError = true;
				});
		};

		var loadShapesDetails = function(hostname) {
			var destinationServer = self.model.serverDetails;
			var serverId = destinationServer.clientId;
			var serverDetailsInfo = {
				serverName: '',
				username: destinationServer.username,
				password: destinationServer.password
			};
			self.isInstanceTypeLoading = true;
			//load instance types
			serverService
				.getInstanceTypes(serverId, serverDetailsInfo, hostname)
				.success(function(data) {
					self.browseOptions.instanceTypeListError = false;
					self.browseOptions.instanceTypeList = [];
					self.browseOptions.instanceTypeMultiSelectList = [];
					self.browseOptions.instanceTypeMultiSelectList = self.browseOptions.instanceTypeMultiSelectList.concat(data);
					self.browseOptions.instanceTypeList = self.browseOptions.instanceTypeMultiSelectList;
					self.isInstanceTypeLoading = false;

					var isDefaultInstanceTypeRequire = true;
					if (self.browseOptions.savedInstanceTypes && self.browseOptions.savedInstanceTypes.length > 0) {
						isDefaultInstanceTypeRequire = false;
						angular.forEach(self.browseOptions.instanceTypeList, function(instanceType, key) {
							angular.forEach(self.browseOptions.savedInstanceTypes, function(savedInstanceType, sKey) {
								if (instanceType.id === savedInstanceType.id) {
									self.browseOptions.instanceTypeMultiSelectList[key].ticked = true;
									return;
								}
							});
						});
					}

					if (
						isDefaultInstanceTypeRequire &&
						self.browseOptions.instanceTypeMultiSelectList &&
						self.browseOptions.instanceTypeMultiSelectList.length > 0
					) {
						self.browseOptions.instanceTypeMultiSelectList[0].ticked = true;
					}
				})
				.error(function(err) {
					$log.error(err);
					self.browseOptions.instanceTypeList = [];
					self.browseOptions.instanceTypeListError = true;
					self.browseOptions.instanceTypeMultiSelectList = [];
					self.isInstanceTypeLoading = false;
				});
		};

		var loadImagesDetails = function(hostname) {
			self.isImagesLoading = true;

			var destinationServer = self.model.serverDetails;
			var serverDetailsInfo = {
				serverName: '',
				username: destinationServer.username,
				password: destinationServer.password
			};
			//load images info
			serverService
				.getOCIImages(destinationServer.clientId, serverDetailsInfo, hostname)
				.success(function(data) {
					self.browseOptions.imagesListError = false;
					self.browseOptions.imagesSettingsList = [];
					self.browseOptions.imagesMultiSelectList = [];
					self.browseOptions.imagesMultiSelectList = self.browseOptions.imagesMultiSelectList.concat(data);
					self.browseOptions.imagesList = self.browseOptions.imagesMultiSelectList;
					self.isImagesLoading = false;

					var isDefaultImageRequire = true;
					if (self.browseOptions.savedImagesList && self.browseOptions.savedImagesList.length > 0) {
						isDefaultImageRequire = false;
						angular.forEach(self.browseOptions.imagesList, function(image, key) {
							angular.forEach(self.browseOptions.savedImagesList, function(savedImage, sKey) {
								if (image.strGUID === savedImage.strGUID) {
									self.browseOptions.imagesMultiSelectList[key].ticked = true;
									return;
								}
							});
						});
					}

					if (
						isDefaultImageRequire &&
						self.browseOptions.imagesMultiSelectList &&
						self.browseOptions.imagesMultiSelectList.length > 0
					) {
						self.browseOptions.imagesMultiSelectList[0].ticked = true;
					}
				})
				.error(function(err) {
					$log.error(err);
					self.browseOptions.imagesMultiSelectList = [];
					self.browseOptions.imagesList = [];
					self.browseOptions.imagesListError = true;
					self.isImagesLoading = false;
				});
		};

		var loadNetworkDetails = function(hostname) {
			self.isNetworkLoading = true;

			var destinationServer = self.model.serverDetails;
			var serverDetailsInfo = {
				clientId: destinationServer.clientId,
				serverName: '',
				username: destinationServer.username,
				password: destinationServer.password
			};
			//load network info
			serverService
				.getNetworkInfo(serverDetailsInfo, hostname, self.model.vendor)
				.success(function(data) {
					self.browseOptions.networkSettingsListError = false;
					self.browseOptions.networkSettingsList = [];
					self.browseOptions.existingNetworkSettingsList = [];
					self.browseOptions.restoreNetworkSettingsList = [];
					self.browseOptions.gatewayNetworkSettingsList = [];
					self.browseOptions.subnetsMultiSelectList = [];
					self.browseOptions.selectedSubnets = []; //clearing out the cache for selected subnets

					self.browseOptions.networkSettingsList = self.browseOptions.networkSettingsList.concat(data);
					self.browseOptions.existingNetworkSettingsList = self.browseOptions.existingNetworkSettingsList.concat(data);
					self.browseOptions.restoreNetworkSettingsList = self.browseOptions.restoreNetworkSettingsList.concat(data);
					self.browseOptions.gatewayNetworkSettingsList = self.browseOptions.gatewayNetworkSettingsList.concat(data);
					self.isNetworkLoading = false;
					var isDefaultSubnetRequired = true;
					if (self.browseOptions.networkSettingsList && self.browseOptions.networkSettingsList.length > 0) {
						if (
							self.browseOptions.savedNetwork &&
							(self.browseOptions.savedNetwork.networkId || self.browseOptions.savedNetwork.networkName)
						) {
							isDefaultSubnetRequired = false;
							angular.forEach(self.browseOptions.networkSettingsList, function(network) {
								var networkId = network.networkId ? network.networkId : network.networkName;
								var savedNetworkId = self.browseOptions.savedNetwork.networkId
									? self.browseOptions.savedNetwork.networkId
									: self.browseOptions.savedNetwork.networkName;
								if (networkId === savedNetworkId) {
									self.browseOptions.selectedNetwork = network;
									var subnets = network.subnets;
									var savedSubnets = self.browseOptions.savedSubnets;
									if (savedSubnets && savedSubnets.length > 0 && subnets && subnets.length > 0) {
										angular.forEach(subnets, function(subnet, key) {
											angular.forEach(savedSubnets, function(savedSubnet, sKey) {
												if (subnet.subnetId === savedSubnet.subnetId) {
													subnets[key].ticked = true;
													return;
												}
											});
										});
									}
									if (!!subnets) {
										self.browseOptions.subnetsMultiSelectList = subnets;
									}
									return;
								}
							});
						} else if (self.browseOptions.savedNetwork && self.browseOptions.savedNetwork.length > 0) {
							angular.forEach(self.browseOptions.networkSettingsList, function(networkSetting, key) {
								angular.forEach(self.browseOptions.savedNetwork, function(network, sKey) {
									if (network.networkName === networkSetting.networkName) {
										if (
											!!self.policyDetails &&
											self.policyDetails.entity.policyType ===
												vmLifeCyclePolicyFactory.policyTypes.VMW_BACKUP_LABTEMPLATE
										) {
											self.browseOptions.existingNetwork = self.browseOptions.networkSettingsList[key];
										} else {
											self.browseOptions.networkSettingsList[key].ticked = true;
										}
										return;
									}
								});
							});
						}

						angular.forEach(self.browseOptions.networkSettingsList, function(networkSetting, key) {
							//caching gateway/restore networks.
							if (self.model.restoreNetwork === networkSetting.networkName) {
								self.model.restoreNetwork = self.browseOptions.restoreNetworkSettingsList[key];
							}
							if (self.browseOptions.gatewayNetwork === networkSetting.networkName) {
								self.browseOptions.gatewayNetwork = self.browseOptions.gatewayNetworkSettingsList[key];
							}
						});

						if (isDefaultSubnetRequired) {
							if (!!self.browseOptions.networkSettingsList && self.browseOptions.networkSettingsList.length > 0) {
								self.browseOptions.selectedNetwork = self.browseOptions.networkSettingsList[0];
								if (!!self.browseOptions.networkSettingsList[0].subnets) {
									self.browseOptions.subnetsMultiSelectList = angular.copy(
										self.browseOptions.networkSettingsList[0].subnets
									);
								}
								if (self.browseOptions.subnetsMultiSelectList && self.browseOptions.subnetsMultiSelectList.length > 0) {
									self.browseOptions.subnetsMultiSelectList[0].ticked = true;
								}
							}
						}
					}
				})
				.error(function(err) {
					$log.error(err);
					self.browseOptions.networkSettingsList = [];
					self.browseOptions.networkSettingsListError = true;
					self.isNetworkLoading = false;
				});
		};

		var isValidTemplate = function(template, esxHosts) {
			if (template && esxHosts && esxHosts.includes(template.esxServer)) {
				return true;
			}
			return false;
		};
		var isValidGatewayTemplate = function(gateway, esxHosts) {
			if (
				isValidTemplate(gateway, esxHosts) &&
				!!gateway.vmName &&
				gateway.vmName.toLowerCase().startsWith(cvVLabGatewayPrefix)
			) {
				return true;
			}
			return false;
		};

		var filterTemplates = function() {
			var host = self.browseOptions.destinationHost;
			var esxHosts = [];
			esxHosts.push(vmFactory.getDestinationHostName(host));
			self.browseOptions.gatewayTemplateList = [];
			angular.forEach(self.browseOptions.templateList, function(template) {
				if (isValidGatewayTemplate(template, esxHosts)) {
					if (self.browseOptions.gatewayTemplate && self.browseOptions.gatewayTemplate.vmGUID === template.vmGUID) {
						self.browseOptions.gatewayTemplate = template;
					}
					self.browseOptions.gatewayTemplateList.push(template);
				}
			});

			if (!self.browseOptions.gatewayTemplate && self.browseOptions.gatewayTemplateList.length > 0) {
				self.browseOptions.gatewayTemplate = self.browseOptions.gatewayTemplateList[0];
			}
		};

		var loadVMwareTemplateDetails = function() {
			var destinationServer = self.model.serverDetails;
			var clientId = destinationServer.clientId;
			self.browseOptions.templateList = [];
			self.isTemplateLoading = true;

			vmLifeCylePolicyService
				.getGatewayTemplates(
					clientId,
					typeof destinationServer.instanceId != 'undefined' ? destinationServer.instanceId : 0
				)
				.then(
					function(data) {
						if (data.data && data.data.scList && data.data.scList.length) {
							data.data.scList.map(function(template) {
								var templateEntity = {
									vmName: template.name,
									vmGUID: template.guid,
									esxServer: template.esxServer
								};

								//if(isValidTemplate(template, esxHosts)){
								self.browseOptions.templateList.push(templateEntity);
								//}
							});
							//call filterTemplates post collecting templates
							filterTemplates();
						}
						self.isTemplateLoading = false;
					},
					function(e) {
						$log.error(e);
						self.browseOptions.gatewayTemplateList = [];
						self.browseOptions.templateList = [];
						self.browseOptions.gatewayTemplateListError = true;
						self.browseOptions.templateListError = true;
						self.isTemplateLoading = false;
					}
				);
		};

		self.selectedIsoPathWindows = [];
		self.selectedIsoPathUnix = [];

		self.openBrowseDataStoresModal = function(destinationHosts, osType) {
			// load the root level data (data stores based on destination hosts)
			if (!destinationHosts || !destinationHosts.entity.name) {
				return;
			}

			var destinationServer = self.model.serverDetails;
			var serverId = destinationServer.clientId;
			var vendor = 'VMW';

			var cvTreeModalParams = {
				dialogTitle: cvLoc('label.isoPath'),
				treeRoot: {
					label: destinationHosts.entity.name,
					type: 'esxServer',
					iconClass: 'vsaIconSERVER'
				},
				//multiSelect : true,
				selectedItems: osType === 'unix' ? self.selectedIsoPathUnix : self.selectedIsoPathWindows,
				selectableTypes: ['iso'],
				loadChildren: function(entity) {
					if (entity.type === 'esxServer') {
						var destinationHostname = entity.label;

						// Load data store list
						return serverService.getDataStores(serverId, destinationHostname, destinationServer, vendor);
					} else if (entity.type === 'datastore') {
						var dataStoreName = entity.label;
						var destinationHostname = entity.destinationHostname;

						return serverService.getIsoPaths(serverId, dataStoreName, destinationServer, vendor, destinationHostname);
					} else {
						// error.. type not supported
					}
				},
				processChildren: function(entity, data) {
					if (entity.type === 'esxServer') {
						if (data.data && data.data.length) {
							return data.data.map(function(ds) {
								return {
									label: ds.dataStoreName,
									destinationHostname: entity.label,
									type: 'datastore',
									iconClass: 'vsaIconDATASTORE'
								};
							});
						}
					} else if (entity.type === 'datastore') {
						if (
							data.data &&
							data.data.hostInfo &&
							data.data.hostInfo.length > 0 &&
							data.data.hostInfo[0].dataStore &&
							data.data.hostInfo[0].dataStore.length > 0 &&
							data.data.hostInfo[0].dataStore[0].filepath &&
							data.data.hostInfo[0].dataStore[0].filepath.length > 0
						) {
							return data.data.hostInfo[0].dataStore[0].filepath.map(function(filePath) {
								return {
									label: filePath,
									iconClass: 'vsaIconLocalDisk',
									isLeaf: true,
									type: 'iso'
								};
							});
						}
					}
				}
			};

			// Saving the value
			cvTreeFactory.openCvTreeWrapperModal(cvTreeModalParams).result.then(function(result) {
				// ok clicked

				if (osType === 'unix') {
					// unix
					if (result.length) {
						self.browseOptions.isoInfo.unix = {
							isoPath: result[0].label,
							osType: 0
						};
					} else {
						self.browseOptions.isoInfo.unix = null;
					}
				} else if (osType === 'windows') {
					// windows
					if (result.length) {
						self.browseOptions.isoInfo.windows = {
							isoPath: result[0].label,
							osType: 1
						};
					} else {
						self.browseOptions.isoInfo.windows = null;
					}
				}
			});
		};

		self.fileLoaded = function(e) {
			self.sshKeyFileLabel = self.model.sshKeyFileName;
			self.model.sshKeyData = e.target.result;
		};

		self.fileUpload = function() {
			var reader = new FileReader();
			var file = self.file; //caching the file object input passed in the cvFileInput directive
			if (file) {
				if (file.name.endsWith(self.allowedSshKeyExtentios)) {
					self.model.sshKeyFileName = file.name;
					reader.onload = self.fileLoaded;
					reader.filename = file.name;
					reader.readAsText(file);
				} else {
					$dialogs.error(
						cvLoc('label.error'),
						cvLoc('msg.allowedSSHKeyExtenstion', file.name, self.allowedSshKeyExtentios)
					);
				}
			} else {
				console.error('SSH key error: Please select valid file');
			}
		};

		self.addPolicy = function(policyData) {
			restoreService
				.addReplicationTarget(policyData)
				.success(function(data) {
					cvToaster.showSuccessMessage({
						ttl: '15000',
						message: cvLoc('msg.policyCreationSuccessful')
					});
					gotoSourceSelection();
				})
				.error(function(e) {
					cvToaster.showErrorMessage({
						message: e
					});
				});
		};

		self.updatePolicy = function(policyData) {
			restoreService
				.updateReplicationTarget(policyData)
				.success(function(data) {
					cvToaster.showSuccessMessage({
						ttl: '15000',
						message: cvLoc('msg.policyUpdated')
					});
					gotoSourceSelection();
				})
				.error(function(e) {
					cvToaster.showErrorMessage({
						message: e
					});
				});
		};

		self.changeDestination = function(hostName) {
			if (self.isVMware()) {
				loadDataStores(hostName); // datastores available vary with host selection; reload them
				//hiding virtual lab settings for sp14
				//filterTemplates();
			}
			//loadAvailabilityDomainDetails(hostName); // resource pools available vary with host selection; reload them
			///network settings destination networks vary with destination host
			loadNetworkDetails(hostName);
		};
		self.changeCompartmentDetails = function(compartmentName) {
			loadAvailabilityDomainDetails(compartmentName);
			loadShapesDetails(compartmentName);
			loadImagesDetails(compartmentName);
			//loadNetworkDetails(compartmentName);
		};

		self.changeAvailabilityDomain = function(compartmentName, availabilityDomain) {
			loadNetworkDetails(
				vmLifeCyclePolicyFactory.getCompartmentGuidAndAvailabilityDomain(compartmentName, availabilityDomain)
			);
		};
		self.changeLiveMountOptions = function() {
			if (self.model.showLiveMount) {
				self.userMemberShipAndDecommisionLabel = cvLoc('label.userMemberShipAndDecommission');
			} else {
				self.userMemberShipAndDecommisionLabel = cvLoc('label.userMemberShip');
			}
		};

		self.expirationTimeClick = function(source) {
			if (source === 'Hours') {
				$('#expirationTimeInHours').focus();
				self.model.migrateVMs = false;
			} else if (source === 'Days') {
				$('#expirationTimeInDays').focus();
			} else if (source.target && source.target.id === 'expirationTimeInHours') {
				self.model.expirationTime = 'Hours';
				self.model.migrateVMs = false;
			} else if (
				(source.target && source.target.id === 'expirationTimeInDays') ||
				source.target.id === 'gracePeriodInDays'
			) {
				self.model.expirationTime = 'Days';
			}
		};

		self.createIsolateNetworkChanged = function(isSelected) {
			if (!isSelected) {
				self.model.showGatewayOptions = false;
			}
		};

		//To manage autoPowerManagement toggle button
		self.manageAutoPowerManagement = function() {
			self.autoPowerManagement = vmLifeCyclePolicyFactory.checkToggleStatus(self.autoPowerManagement, toggleStatus);
		};

		//To manage autoScaleUp toggle button
		self.manageAutoScaleUp = function() {
			self.autoScaleUp = vmLifeCyclePolicyFactory.checkToggleStatus(self.autoScaleUp, toggleStatus);
		};

		//To Manage autoScaleOut button
		self.manageAutoScaleOut = function() {
			self.autoScaleOut = vmLifeCyclePolicyFactory.checkToggleStatus(self.autoScaleOut, toggleStatus);
		};

		/** End of Auto Scale Code * */

		self.savePolicy = function() {
			var data = vmLifeCyclePolicyFactory.savePolicy(self.model, self.browseOptions, self.model.vendor);
			//Set the entities of the config page in AutoScale policy, start of AutoScale policy
			if (self.isAutoScalePolicy(self.policyCategory)) {
				var client = [];

				for (var i = 0; i < self.model.cloudAgents.length; i++) {
					client.push({
						clientId: self.model.cloudAgents[i].clientId,
						clientName: self.model.cloudAgents[i].clientName,
						hostName: self.model.cloudAgents[i].hostName
					});
				}

				data.scaleOption = {
					powerManagement: self.autoPowerManagement === 'enabled-activity' ? true : false,
					autoScaleUp: self.autoScaleUp === 'enabled-activity' ? true : false,
					autoScaleOut: self.autoScaleOut === 'enabled-activity' ? true : false,
					client: client,
					useForAutoDeployment: true
				};
			}
			/** End of Autoscale Code* */

			if (
				!self.isAutoScalePolicy(self.policyCategory) &&
				self.usersAndUserGroups &&
				self.usersAndUserGroups.length > 0
			) {
				data.securityAssociations = {};
				data.securityAssociations.users = [];
				data.securityAssociations.userGroups = [];
				self.usersAndUserGroups.forEach(function(user) {
					var userToAdd = {};
					var userGroupToAdd = {};
					var selectedUser = {};
					if (user.selected && (selectedUser = user.userEntity)) {
						// denotes user entity;
						userToAdd.userId = selectedUser.userId;
						userToAdd.userGUID = selectedUser.userGUID;
						userToAdd.userName = selectedUser.userName;
						data.securityAssociations.users.push(userToAdd);
					} else if (user.selected && (selectedUser = user.userGroupEntity)) {
						// denotes user group entity
						userGroupToAdd.userGroupId = selectedUser.userGroupId;
						userGroupToAdd.userGroupName = selectedUser.userGroupName;
						data.securityAssociations.userGroups.push(userGroupToAdd);
					}
				});
			}
			if (self.editMode) {
				data.entity.vmAllocPolicyId = self.policyId;
				self.updatePolicy(data);
			} else {
				self.addPolicy(data);
			}
		};
	}
]);

export default vmManagementMod;
