import 'vsa/js/constants/lifeCyclePolicyCategories.constants.js';
import 'vsa/js/factories/replication.factory.js';
import 'vsa/js/services/restore.svc.js';
import 'modules/vmManagement/js/factory/vmLifeCyclePolicy/lifeCyclePolicy.factory.js';
import 'modules/vmManagement/js/factory/vmLifeCyclePolicy/recoveryTargetActions.factory.js';
import 'vsa/js/controllers/configureReplicationGroup.ctrl.js';
import * as lifeCyclePolicyColumnsTemplate from './lifeCyclePolicy.column.template.js';
import { vmManagementAppModule } from 'common/js/modules';

class LifeCyclePolicyController {
	constructor(
		$scope,
		cvLoc,
		cvUtil,
		$state,
		$dialogs,
		$modal,
		$stateParams,
		$compile,
		cvToaster,
		restoreService,
		replicationFactory,
		VSA_LIFECYCLEPOLICYCATEGORY,
		VM_POLICY_APP_TYPE,
		vmLifeCyclePolicyFactory,
		recoveryTargetActionsFactory,
		VENDORS,
		ENTITY_TYPES
	) {
		this.$scope = $scope;
		this.cvLoc = cvLoc;
		this.cvUtil = cvUtil;
		this.$state = $state;
		this.$dialogs = $dialogs;
		this.$modal = $modal;
		this.$stateParams = $stateParams;
		this.$compile = $compile;
		this.cvToaster = cvToaster;
		this.restoreService = restoreService;
		this.VSA_LIFECYCLEPOLICYCATEGORY = VSA_LIFECYCLEPOLICYCATEGORY;
		this.replicationFactory = replicationFactory;
		this.VM_POLICY_APP_TYPE = VM_POLICY_APP_TYPE;
		this.vmLifeCyclePolicyFactory = vmLifeCyclePolicyFactory;
		this.recoveryTargetActionsFactory = recoveryTargetActionsFactory;
		this.VENDORS = VENDORS;
		this.ENTITY_TYPES = ENTITY_TYPES;
		this._init();
	}

	_init() {
		this._setupGridOptions();
	}

	onActionsClick(event) {
		event.preventDefault();
	}

	_initColumnDefs() {
		return lifeCyclePolicyColumnsTemplate.getColumns(this.onActionsClick.bind(this), {
			cvLoc: this.cvLoc,
			cvUtil: this.cvUtil
		});
	}

	getPolicies(options) {
		let vmPolicyAppType = null; // regular + replication policies
		let cvUtil = this.cvUtil;
		let self = this;
		this.restoreService
			.getLifeCyclePolicies(vmPolicyAppType)
			.success(function(data) {
				self.serverMessage = cvUtil.emptyMsg();
				self.lifeCyclePolicies = data;
				self.lifeCyclePolicies.forEach(function(policy) {
					var entity;
					var policyType;
					if (angular.isDefined((entity = policy.entity)) && angular.isDefined((policyType = entity.policyType))) {
						if (
							policyType == 'VMW_LIVEMOUNT' ||
							policyType == 'VMW_BACKUP_LABTEMPLATE' ||
							policyType == 'VMW_LABTEMPLATE'
						) {
							policyType = 'VMWARE';
						}

						policy.entity.policyTypeText = cvUtil.lookupEnumConstant(policyType);

						if (self.VENDORS['AZURE_V2'].policyTypes.includes(policyType)) {
							policy.entity.policyTypeText = self.VENDORS['AZURE_V2'].text;
						}
					}
					if (!policy.vmPolicyAppType) {
						policy.vmPolicyAppType = '';
					} else {
						policy.vmPolicyAppTypeText =
							policy.vmPolicyAppType === self.VM_POLICY_APP_TYPE.REPLICATION.type
								? self.VM_POLICY_APP_TYPE.REPLICATION.name
								: self.VM_POLICY_APP_TYPE.REGULAR.name;
						policy.vmPolicyAppTypeHelpTextSet = false;

						if (self.VM_POLICY_APP_TYPE.REGULAR.type === policy.vmPolicyAppType) {
							let vendorType = self.vmLifeCyclePolicyFactory.getVendorByPolicyType(policyType);
							if (self.vmLifeCyclePolicyFactory.isVMware(vendorType)) {
								policy.vmPolicyAppTypeHelpTextSet = true;
								policy.vmPolicyAppTypeHelpText = self.cvLoc('msg.appTypeRegularVMware');
							}

							if (self.vmLifeCyclePolicyFactory.isHyperv(vendorType)) {
								policy.vmPolicyAppTypeHelpTextSet = true;
								policy.vmPolicyAppTypeHelpText = self.cvLoc('msg.appTypeRegularHyperV');
							}

							if (
								self.vmLifeCyclePolicyFactory.isAzureRM(vendorType) ||
								self.vmLifeCyclePolicyFactory.isOracleCloudInfrastructure(vendorType)
							) {
								policy.vmPolicyAppTypeHelpTextSet = true;
								policy.vmPolicyAppTypeHelpText = self.cvLoc('msg.appTypeRegularMigrateToCloud');
							}
						} else {
							if (
								cvConfig.showDistributedStorages &&
								_.get(policy, 'HedvigDatastore[0].distributedStorage.distributedStorageName')
							) {
								policy.hedvigDataStore = _.get(policy, 'dataStores[0].dataStoreName', '');
							} else {
								policy.hedvigDataStore = '';
							}
						}
					}

					policy.permittedOptions = self._getPermittedOptions(policy);
				});
				options.success(self.lifeCyclePolicies);
			})
			.error(function(e) {
				self.serverMessage = cvUtil.errMsg(e);
				options.error(self.serverMessage);
			});
	}

	_setupGridOptions() {
		const self = this;
		this.gridOptions = {};
		this.$scope.gridOptions = this.gridOptions;
		this.gridOptions.height = $(window).height - 150;
		this.gridOptions.columns = this._initColumnDefs();
		this.gridOptions.pageSize = 20;
		this.gridOptions.gridTitle = this.cvLoc('label.lifeCyclePolicies');
		this.gridOptions.tableName = 'lifeCyclePoliciesTable';
		this.gridOptions.idField = 'entity.vmAllocPolicyName';
		this.gridOptions.beforeGridInitialize = ({ grid }) => {
			self.grid = grid;
		};
		this.gridOptions.url = this.getPolicies.bind(this);
		this.gridOptions.usePageToolbar = true;
		this.gridOptions.gridToolbarMenu = [
			{
				id: 'AddReplicationTargetButton',
				label: this.cvLoc('label.add'),
				onSelect: this.showAddReplicationTarget.bind(this)
			}
		];
		this.gridOptions.actionMenu = [];
		this.gridOptions.onGridDataBound = this._onGridDataBound.bind(this);
		this.gridOptions.rowDetailTemplateId = 'target-details-grid-template';
	}

	_onGridDataBound(dataItem, row) {
		const permittedOptions = dataItem.permittedOptions;
		const id = permittedOptions.entityId;
		const template = `<cv-permitted-actions cv-permitted-options="permittedOptions${id}"></cv-permitted-actions>`;
		this.$scope[`permittedOptions${id}`] = permittedOptions;
		row.find('.permittedActions').html(this.$compile(template)(this.$scope));

		if (!dataItem.hedvigDataStore) {
			row.find('.k-icon.k-i-expand').hide();
		}
	}

	_getPermittedOptions(policy) {
		return {
			entityType: this.ENTITY_TYPES.VM_ALLOCATION_POLICY_ENTITY,
			entity: angular.copy(policy),
			entityId: policy.entity.vmAllocPolicyId,
			entityName: policy.entity.vmAllocPolicyName,
			appendToBody: true,
			permittedActionList: this.recoveryTargetActionsFactory.computePermittedActions(policy)
		};
	}

	createLifeCyclePolicy() {
		this.$state.go('policyCreate', { policyCategory: 'VMLifeCycle' });
	}

	showAddReplicationTarget() {
		let $state = this.$state;
		return this.replicationFactory.showAddReplicationTarget().result.then(function() {
			$state.forceReload();
		});
	}
}

LifeCyclePolicyController.$inject = [
	'$scope',
	'cvLoc',
	'cvUtil',
	'$state',
	'$dialogs',
	'$uibModal',
	'$stateParams',
	'$compile',
	'cvToaster',
	'restoreService',
	'replicationFactory',
	'VSA_LIFECYCLEPOLICYCATEGORY',
	'VM_POLICY_APP_TYPE',
	'vmLifeCyclePolicyFactory',
	'recoveryTargetActionsFactory',
	'VENDORS',
	'ENTITY_TYPES'
];
vmManagementAppModule.controller('lifeCyclePolicyController', LifeCyclePolicyController);

export default vmManagementAppModule;
