export const getColumns = function(onActionsClick, angularLibs) {
	const columnList = [
		getPolicyNameColumn(angularLibs.cvLoc),
		getTypeColumn(angularLibs.cvLoc),
		getPolicyAppType(angularLibs.cvLoc)
	];
	if (!cv.isTenantAdmin) {
		columnList.push(getDestinationColumn(angularLibs.cvLoc));
	}
	columnList.push(getActionsColumn(angularLibs.cvLoc));
	const columns = {};
	columnList.forEach(column => {
		const field = Object.keys(column)[0];
		columns[field] = column[field];
	});
	return columns;
};

export const getPolicyNameColumn = function(cvLoc) {
	return {
		'entity.vmAllocPolicyName': {
			title: cvLoc('label.name'),
			type: 'string',
			template: cv.isTenantAdmin
				? '<span data-uib-tooltip="#:entity.toolTipMSG#"><a class="#:entity.disabled#" href="\\#lifeCyclePolicyDetails/#:entity.vmAllocPolicyId#">#:entity.vmAllocPolicyName#</a></span>'
				: '<a class="crop" cv-toggle="tooltip" cv-toggle-content="#:entity.vmAllocPolicyName#" href="\\#lifeCyclePolicyDetails/#:entity.vmAllocPolicyId#">#:entity.vmAllocPolicyName#</a>',
			disableViewFiltering: false,
			width: '30%'
		}
	};
};
export const getTypeColumn = function(cvLoc) {
	return {
		'entity.policyTypeText': {
			title: cvLoc('label.vendor'),
			template:
				'<span class="crop" cv-toggle="tooltip" cv-toggle-content="#:entity.policyTypeText#" >#:entity.policyTypeText#</span>',
			width: '20%'
		}
	};
};
export const getDestinationColumn = function(cvLoc) {
	return {
		'destinationHyperV.clientName': {
			title: cvLoc('label.destinationServer'),
			template:
				'<a class="icon-with-text" cv-toggle="tooltip" cv-toggle-content="#:entity.vmAllocPolicyName#" href="\\#servers/#:destinationHyperV.clientId#">#:destinationHyperV.clientName#</a>',
			width: '20%'
		}
	};
};
export const getPolicyAppType = function(cvLoc) {
	return {
		vmPolicyAppType: {
			title: cvLoc('label.PolicyType'),
			template: getVMPolicyAppTypeTemplate(),
			width: '20%'
		}
	};
};

export const getActionsColumn = function(cvLoc) {
	return {
		actions: {
			title: cvLoc('header.actions'),
			type: 'string',
			template: `<div class="permittedActions"></div>`,
			attributes: {
				class: 'permitted-actions'
			},
			width: '10%',
			allowHiding: false,
			disableViewFiltering: true,
			disableColumnFilter: true,
			excludeFromExport: true,
			searchable: false,
			sortable: false
		}
	};
};

const getVMPolicyAppTypeTemplate = cvLoc =>
	`#if (vmPolicyAppTypeHelpTextSet) {#
	<span class="crop" cv-toggle="tooltip" cv-toggle-content="#:vmPolicyAppTypeHelpText#">#:vmPolicyAppTypeText#</span>
#}
else {#
	<span class="crop" cv-toggle="tooltip" cv-toggle-content="#:vmPolicyAppTypeText#">#:vmPolicyAppTypeText#</span>
#}#`;
