<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.tags"></cv:cvMessages>
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>

<h1 class="page-title">
	<span data-ng-bind="tagsetDetailsCtrl.tagset.name"></span>
</h1>

<div class="row">
	<%-- Configuration --%>
	<div class="col-md-6">
		<cv-tile-component title='<cv:msg key="label.configuration" bundle="ediscovery"/>'>
			<div class="page-details-box-links">
				<a href="" data-ng-if="!tagsetDetailsCtrl.tagset.isSystem && tagsetDetailsCtrl.allowEdit && tagsetDetailsCtrl.tagManagementPermission" data-ng-click="tagsetDetailsCtrl.editTagset()">
					<cv:msg key="label.edit" bundle="ediscovery" />
				</a>
			</div>
			<ul class="list-style-secondary">
				<li class="group">
					<span class="pageDetailColumn">
						<cv:msg key="label.name" bundle="ediscovery" />
					</span>
					<span class="pageDetailColumn" data-ng-bind="tagsetDetailsCtrl.tagset.name"></span>
				</li>
				<li class="group">
					<span class="pageDetailColumn">
						<cv:msg key="label.description" bundle="ediscovery" />
					</span>
					<span class="pageDetailColumn" data-ng-bind="tagsetDetailsCtrl.tagset.description"></span>
				</li>
				<li class="group">
					<span class="pageDetailColumn">
						<cv:msg key="label.owner" bundle="ediscovery" />
					</span>
					<span class="pageDetailColumn" data-ng-bind="tagsetDetailsCtrl.tagset.ownerAlias"></span>
				</li>
				<li class="group">
					<span class="pageDetailColumn">
						<cv:msg key="label.type" bundle="ediscovery" />
					</span>
					<span class="pageDetailColumn" data-ng-bind="tagsetDetailsCtrl.tagset.type"></span>
				</li>
			</ul>
		</cv-tile-component>
	</div>
	<%-- Security --%>
	<div class="col-md-6">
		<cv-ds-security-component
			entity-type="tagsetDetailsCtrl.entityType"
			generic-entity="tagsetDetailsCtrl.genericEntity"
			associations="tagsetDetailsCtrl.securityAssociations"
			associations-loaded="tagsetDetailsCtrl.associationsLoaded"
			hide-inherited-associations="true"
		></cv-ds-security-component>
	</div>
</div>

<cv-kendo-grid
	data-ng-if="tagsetDetailsCtrl.tagsGridOptions"
	data-cv-grid-options="tagsetDetailsCtrl.tagsGridOptions"
></cv-kendo-grid>
