import { ediscoveryAppModule } from 'common/js/modules';

class TagManagerService {
	constructor($http) {
		this.$http = $http;
	}

	getTagsets() {
		return this.$http.get(`${appUtil.appRoot}api/EDiscovery/TagSets`);
	}

	getTags() {
		return this.$http.get(`${appUtil.appRoot}api/EDiscovery/Tags`);
	}

	getTagset(tagsetId) {
		return this.$http.get(`${appUtil.appRoot}api/EDiscovery/TagSets?tagSetId=${tagsetId}`);
	}

	getTagsForTagset(tagsetId) {
		return this.$http.get(`${appUtil.appRoot}api/EDiscovery/Tags?tagSetId=${tagsetId}`);
	}

	performTagsetOperation(obj) {
		return this.$http.post('performContainerOperation.do', { containerOperationReq: JSON.stringify(obj) });
	}

	createTag(obj) {
		return this.$http.post(`${appUtil.appRoot}api/EDiscovery/Tags`, JSON.stringify(obj), {
			headers: { 'Content-Type': 'application/json' }
		});
	}

	updateTag(obj) {
		return this.$http.put(`${appUtil.appRoot}api/EDiscovery/Tags`, JSON.stringify(obj), {
			headers: { 'Content-Type': 'application/json' }
		});
	}

	deleteTagset(obj) {
		return this.$http.post(`${appUtil.appRoot}api/Containers/Action/Delete`, JSON.stringify(obj), {
			headers: { 'Content-Type': 'application/json' }
		});
	}
}

TagManagerService.$inject = ['$http'];

ediscoveryAppModule.service('tagManagerService', TagManagerService);
export default ediscoveryAppModule;
