import { ediscoveryAppModule } from 'common/js/modules';
import { DM2EntityType, OperationType, DM2OwnerType, SiteMode } from 'modules/tags/js/tags.constants.js';
import 'modules/tags/js/services/tagManager.svc.js';

class AddTagsetController {
	constructor(isEdit, tagset, $uibModalInstance, cvLoc, cvToaster, tagManagerService) {
		this.isEdit = isEdit;
		this.tagset = tagset;
		this.$uibModalInstance = $uibModalInstance;
		this.cvLoc = cvLoc;
		this.cvToaster = cvToaster;
		this.tagManagerService = tagManagerService;

		this.init();
	}

	init() {
		if (this.isEdit) {
			this.tagsetName = this.tagset.name;
			this.tagsetDescription = this.tagset.description;
		}
	}

	save(isValid) {
		this.serverMessage = undefined;
		if (!isValid) {
			return;
		}
		if (this.isEdit) {
			this.updateTagset();
		} else {
			this.createTagset();
		}
	}

	createTagset() {
		const req = this.createTagsetReqObj(this.tagsetName, this.tagsetDescription);
		this.tagManagerService
			.performTagsetOperation(req)
			.then(
				resp => {
					if (!_.isUndefined(_.get(resp, 'data.errList[0].errLogMessage'))) {
						this.showErrorNotification(this.tagsetName, resp.data.errList[0].errLogMessage);
					} else {
						this.$uibModalInstance.close(resp.data);
						this.cvToaster.showSuccessMessage({
							ttl: '5000',
							message: this.cvLoc('info.tagset.added', this.tagsetName)
						});
					}
				},
				err => {
					this.showErrorNotification(this.tagsetName);
				}
			)
			.catch(err => {
				console.error(err);
				this.showErrorNotification(this.tagsetName);
				this.$uibModalInstance.dismiss(err);
			});
	}

	updateTagset() {
		const req = this.createTagsetReqObj(this.tagsetName, this.tagsetDescription, this.isEdit, this.tagset.containerId);
		this.tagManagerService
			.performTagsetOperation(req)
			.then(
				resp => {
					if (!_.isUndefined(_.get(resp, 'data.errList[0].errLogMessage'))) {
						this.showErrorNotification(this.tagsetName, resp.data.errList[0].errLogMessage);
					} else {
						this.$uibModalInstance.close(resp.data);
						this.cvToaster.showSuccessMessage({
							ttl: '5000',
							message: this.cvLoc('info.tagset.edited', this.tagsetName)
						});
					}
				},
				err => {
					this.showErrorNotification(this.tagsetName);
				}
			)
			.catch(err => {
				console.error(err);
				this.showErrorNotification(this.tagsetName);
				this.$uibModalInstance.dismiss(err);
			});
	}

	createTagsetReqObj(name, description, isEdit, tagsetId) {
		const container = {
			containerType: DM2EntityType.Tags,
			containerName: name,
			comment: description,
			conatinerOwnerType: DM2OwnerType.Owner,
			containerId: tagsetId
		};
		const reqObj = {
			entityType: DM2EntityType.Tags,
			operationType: isEdit ? OperationType.Modify : OperationType.Add,
			fromSite: SiteMode.WebConsole,
			container
		};
		return reqObj;
	}

	showErrorNotification(tagsetName, errorMessage) {
		this.serverMessage = errorMessage;
		this.cvToaster.showErrorMessage({
			ttl: '10000',
			message: this.isEdit ? this.cvLoc('error.tagset.edit', tagsetName) : this.cvLoc('error.tagset.add', tagsetName)
		});
	}
}

AddTagsetController.$inject = ['isEdit', 'tagset', '$uibModalInstance', 'cvLoc', 'cvToaster', 'tagManagerService'];

ediscoveryAppModule.controller('addTagsetController', AddTagsetController);
export default ediscoveryAppModule;
