const getTags = cvLoc => ({
	name: {
		title: cvLoc('label.tag'),
		width: '90%',
		type: 'string'
	}
});

const getActionTemplate = () =>
	`<span class="action-btn grid-action-icon">
		<svg xmlns="http://www.w3.org/2000/svg" version="1.1" x="0" y="0" viewBox="0 0 20 20" xml:space="preserve"><path d="M10.1 0C4.6-0.1 0.1 4.4 0 9.9s4.4 10 9.9 10.1 10-4.4 10.1-9.9c0-0.1 0-0.1 0-0.2C19.9 4.5 15.5 0.1 10.1 0zM10.1 18.9c-5 0-9-4-9-9s4-9 9-9 9 4 9 9S15.1 18.9 10.1 18.9L10.1 18.9z"/><rect x="6.1" y="8.8" width="2" height="2"/><rect x="9.1" y="8.8" width="2" height="2"/><rect x="12.1" y="8.8" width="2" height="2"/></svg>
	</span>`;

const getActions = cvLoc => ({
	actions: {
		title: cvLoc('label.actions'),
		template: getActionTemplate(),
		width: '10%',
		filterType: false,
		searchable: false,
		sortable: false
	}
});

export default cvLoc => ({
	...getTags(cvLoc),
	...getActions(cvLoc)
});
