<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
  <cv:cvMessages bundle="localization.storage"></cv:cvMessages>
  <cv:cvMessages bundle="localization.snapArray"></cv:cvMessages>
  <cv:cvMessages bundle="localization.vmManagement"></cv:cvMessages>
  <cv:cvMessages bundle="localization.collections"></cv:cvMessages>
  <cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
</script>
<div class="row">
    <div class="col-xs-12  flex-detail-header">
        <h1 class="float-left" data-ng-bind="vaultName"></h1>       
        <span class="flex-page-actions">
            <span class="uib-dropdown" uib-dropdown>
                <a href="" class="uib-dropdown-toggle" data-uib-dropdown-toggle>
                    <span><cv:msg key="Actions" bundle="storage" /></span>
                    <span class="k-icon k-i-arrow-60-down"></span>
                </a>
                <ul uib-dropdown-menu class="dropdown-menu cv-dropdown-style-2 margin-top-0">
                    <li class="no-padding"><a href ng-click="runNowVaultTracker()"><cv:msg key="action.runNow" bundle="storage" /></a></li>
                    <li class="no-padding"><a href='#/vaultTrackerPolicyListMedia?input.LibraryId={{libraryId}}&input.PolicyId={{vaultId}}&libraryId={{libraryId}}&vaultId={{vaultId}}&libraryName={{libraryName}}&vaultName={{vaultName}}&model={{model}}'>
                            <cv:msg key="action.listMedia" bundle="storage" />
                        </a></li>
                    <li class="no-padding"> <a href='#/vaultTrackerPolicyActions?input.LibraryId={{libraryId}}&input.PolicyId={{vaultId}}&input.model={{model}}&libraryId={{libraryId}}&vaultId={{vaultId}}&libraryName={{libraryName}}&vaultName={{vaultName}}&model={{model}}'>
                            <cv:msg key="label.pendingActions" bundle="storage" />
                    </a></li>
                    <li class="no-padding"><a href ng-click="deleteVault()">
                        <cv:msg key="action.delete" bundle="storage" />
                    </a></li>
                </ul>
            </span>
        </span>
    </div><div ng-repeat="(colRenderIndex, col) in colContainer.renderedColumns track by col.uid" ui-grid-one-bind-id-grid="rowRenderIndex + '-' + col.uid + '-cell'" class="ui-grid-cell ng-scope ui-grid-coluiGrid-000L" ng-class="{ 'ui-grid-row-header-cell': col.isRowHeader }" role="gridcell" ui-grid-cell="" id="1545336697180-4-uiGrid-000L-cell"><!-- ngIf: row.entity.enable --><span data-ng-if="row.entity.enable" class="ng-scope"> Enabled </span><!-- end ngIf: row.entity.enable --> <!-- ngIf: !row.entity.enable --></div>
</div>
<div class="row">
    <div class="col-md-6">
        <cv-tile-component data-title='<cv:msg key="label.general" bundle="snapArray"/>'>
        <span class="page-details-box-links">
                <a ng-if="!forms.general.editing" ng-click="onEdit('general')">
                    <cv:msg key="action.edit" bundle="storage" />
                </a>
                <a ng-if="forms.general.editing" ng-click="onGeneralSave()">
                    <cv:msg key="action.save" bundle="storage" />
                </a>
            </span>
            <ul class="list-style-secondary">
                <li class="group">
                    <span class="pageDetailColumn">
                        <cv:msg key="label.policyName" bundle="vmManagement" />
                    </span>
                    <span class="pageDetailColumn">
                        <span ng-if="!forms.general.editing">{{forms.general.values.policyName}}</span>
                        <input
                                ng-if="forms.general.editing"
                                class="max-width-200"
                                name="PolicyName"
                                type="text"
                                data-ng-model="forms.general.values.policyName"
                                ng-change="changeValue('general','policyName', forms.general.values.policyName)"
                        />
                    </span>
                </li>
                <li class="group">
                    <span class="pageDetailColumn">
                        <cv:msg key="label.description" bundle="storage" />
                    </span>
                    <span class="pageDetailColumn">
                        <span ng-if="!forms.general.editing">{{forms.general.values.description}}</span>
                        <input
                                ng-if="forms.general.editing"
                                class="max-width-200"
                                name="Description"
                                type="text"
                                data-ng-model="forms.general.values.description"
                                ng-change="changeValue('general','description', forms.general.values.description)"
                        />
                    </span>
                </li>
                <li class="group">
                    <span class="pageDetailColumn">
                        <cv:msg key="label.enable" bundle="storage" />
                    </span>
                    <toggle-control data-ng-class="{'enabled-activity': forms.general.values.enable, 'disabled-activity disabled': !forms.general.values.enable, 'noToggle': !forms.general.editing}"
                                    status="forms.general.values.enable? 'enabled-activity' : 'disabled-activity'" data-ng-click="changeSelective('general_enable')"
                    ></toggle-control>
                </li>
                <li class="group">
                    <span class="pageDetailColumn">
                        <cv:msg key="label.autoAcknowledge" bundle="storage" />
                    </span>
                    <toggle-control data-ng-class="{'enabled-activity': forms.general.values.autoAcknowledge, 'disabled-activity disabled': !forms.general.values.autoAcknowledge, 'noToggle': !forms.general.editing}"
                                    status="forms.general.values.autoAcknowledge? 'enabled-activity' : 'disabled-activity'" data-ng-click="changeSelective('autoAcknowledge')"
                    ></toggle-control>
                </li>
            </ul>
        </cv-tile-component>
        <cv-security-component show-edit='showEdit' entity-type='entityType' generic-entity='genericEntity' associations='formattedSecurityAssociations'
                               associations-loaded='associationsLoaded'>
        </cv-security-component>
        <cv-tile-component data-title='<cv:msg key="title.schedule" bundle="storage"/>'>
            <span class="page-details-box-links">
                <a ng-click="addSchedule()">
                    <cv:msg key="label.addSchedule" bundle="schedule" />
                </a>
            </span>
            <div class="margin-left-right">
                <%--<cv-derivable-input>--%>
                <div class="schedule-list margin-top-15">
                    <ul class="add-schedule__List group">
                        <li class="ellipsis-parent ellipsis-content margin-bottom-5 padding-bottom-10" data-ng-repeat="schedule in scheduleObjectTaskInfoList track by $index">
                            <a class="always-enabled" data-ng-click="editSchedule(schedule)">{{schedule.subTasks[0].subTask.subTaskName}} </a>
                        </li>
                        <li data-ng-if="scheduleObjectTaskInfoList == undefined || scheduleObjectTaskInfoList.length == 0" class="ellipsis-parent ellipsis-content "><cv:msg key="info.noVtPoliciesScheduled" bundle="storage"/> </li>
                    </ul>
                </div>
                <%--</cv-derivable-input>--%>
            </div>
        </cv-tile-component>
    </div>
    <div class="col-md-6">
        <cv-tile-component data-title='<cv:msg key="title.mediaStatus" bundle="storage"/>'>
            <span class="page-details-box-links">
                <a ng-if="!forms.media.editing" ng-click="onEdit('media')">
                    <cv:msg key="action.edit" bundle="storage" />
                </a>
                <a ng-if="forms.media.editing" ng-click="onMediaSave()">
                    <cv:msg key="action.save" bundle="storage" />
                </a>
            </span>
            <ul class="list-style-secondary">
                <li class="group">
                    <span class="pageDetailColumn">
                        <cv:msg key="label.fullTapes" bundle="storage" />
                    </span>
                    <toggle-control data-ng-class="{'enabled-activity': forms.media.values.fullTape , 'disabled-activity': !forms.media.values.fullTape, 'noToggle': !forms.media.editing}"
                                    status="forms.media.values.fullTape ? 'enabled-activity' : 'disabled-activity'" data-ng-click="changeSelective('full_tape')">
                    </toggle-control>
                </li>
                <li class="group">
                    <span class="pageDetailColumn">
                        <cv:msg key="label.includeTapes" bundle="storage" />
                    </span>
                    <toggle-control data-ng-class="{'enabled-activity': forms.media.values.includeTape , 'disabled-activity': !forms.media.values.includeTape, 'noToggle': !forms.media.editing}"
                                    status="forms.media.values.includeTape ? 'enabled-activity' : 'disabled-activity'" data-ng-click="changeSelective('include_tape')">
                    </toggle-control>
                </li>
                <li class="group">
                    <span class="pageDetailColumn" ng-class="{'padding-top-10': forms.media.editing}">
                        <cv:msg key="label.tapeLast" bundle="storage" />
                    </span>
                    <span class="pageDetailColumn">
                        <span ng-if="!forms.media.editing && 0 !== forms.media.values.lastTape.value">{{forms.media.values.lastTape.value}}</span>
                        <span ng-if="!forms.media.editing && 0 === forms.media.values.lastTape.value"><cv:msg key="label.notSelected" bundle="settingsJs"/></span>
                        <input ng-if="forms.media.editing" class="max-width-200" type="number" min="1" max="9999" name="TapeLast" data-ng-model="forms.media.values.lastTape.value" ng-change="changeValue('media','lastTape', forms.media.values.lastTape.value)" />
                        <span data-ng-if="forms.media.values.lastTape.value">
                            {{forms.media.values.lastTape.value > 1
                                ? '<cv:msg key="label.days" bundle="storage" />'
                                : '<cv:msg key="label.day" bundle="storage" />'
                            }}
                        </span>
                        <div class="error help-block ng-scope full-width margin-0" data-ng-if="forms.media.editing && forms.media.values.lastTape.hasError">
                            <cv:msg key="error.lastTape" bundle="schedule" />
                        </div>
                    </span>
                </li>
                <li class="group">
                    <span class="pageDetailColumn">
                        <cv:msg key="label.excludeMedia" bundle="storage" />
                    </span>
                    <toggle-control data-ng-class="{'enabled-activity': forms.media.values.excludeMedia , 'disabled-activity': !forms.media.values.excludeMedia, 'noToggle': !forms.media.editing}"
                                    status="forms.media.values.excludeMedia ? 'enabled-activity' : 'disabled-activity'" data-ng-click="changeSelective('exclude_media')">
                    </toggle-control>
                </li>
                <li class="group">
                    <span class="pageDetailColumn" ng-class="{'padding-top-10': forms.media.editing}">
                        <cv:msg key="label.limitMedia" bundle="storage" />
                    </span>
                    <span class="pageDetailColumn">
                        <span ng-if="!forms.media.editing && 0 !== forms.media.values.limitMedia.value">{{forms.media.values.limitMedia.value}}</span>
                        <span ng-if="!forms.media.editing && 0 === forms.media.values.limitMedia.value"><cv:msg key="label.notSelected" bundle="settingsJs"/></span>
                        <input ng-if="forms.media.editing" class="max-width-200" type="number" min="1" max="1000" name="limitMedia" data-ng-model="forms.media.values.limitMedia.value"
                               ng-change="changeValue('media','limitMedia', forms.media.values.limitMedia.value)" />
                        <div ng-if="forms.media.editing && forms.media.values.limitMedia.hasError" class="error help-block ng-scope full-width margin-0">
                            <cv:msg key="error.limitMedia" bundle="schedule" />
                        </div>
                    </span>
                </li>
            </ul>
        </cv-tile-component>
        <cv-tile-component data-title='<cv:msg key="label.destination" bundle="storage"/>'>
            <span class="page-details-box-links">
                <a ng-if="!forms.destination.editing" ng-click="onEdit('destination')">
                    <cv:msg key="action.edit" bundle="storage" />
                </a>
                <a ng-if="forms.destination.editing" ng-click="onDestinationSave()">
                    <cv:msg key="action.save" bundle="storage" />
                </a>
            </span>
            <ul class="list-style-secondary">
                <li class="group">
                    <span class="pageDetailColumn padding-top-10">
                        <cv:msg key="label.trackTransitLocation" bundle="storage" />
                    </span>
                    <span class="pageDetailColumn">
                        <div ng-if="!forms.destination.editing" class="padding-top-10">{{forms.destination.values.trackTransit[0].locationName}}</div>
                        <span ng-if="forms.destination.editing" class="col-md-6 full-width backup-window-list">
                            <select-and-create
                                available-options="availableTransit"
                                select-id="'toTrackTransit'"
                                selected-option="forms.destination.values.trackTransit[0]"
                                on-item-click="destinationTouched"
                                ng-if="isLoadedLocations">
                            </select-and-create>
                        </span>
                    </span>
                </li>
                <li class="group">
                    <span class="pageDetailColumn padding-top-10">
                        <cv:msg key="label.exportDestination" bundle="storage" />
                    </span>
                    <span class="pageDetailColumn">
                        <div ng-if="!forms.destination.editing" class="padding-top-10">{{getDestinationName()}}</div>
                        <span ng-if="forms.destination.editing"  class="col-md-6 full-width backup-window-list">
                            <select-and-create
                                available-options="availableDestinations"
                                select-id="'toExportDestination'"
                                selected-option="forms.destination.values.destination[0]"
                                on-item-click="destinationTouched"
                                ng-if="isLoadedLocations">
                            </select-and-create>
                        </span>
                    </span>
                </li>
            </ul>
        </cv-tile-component>
    </div>
</div>
