<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
  <cv:cvMessages bundle="localization.storage"></cv:cvMessages>
</script>
<h1 class="page-title">{{mediaAgentName}}</h1>
<div class="group row">
    <div class="col-md-6">
        <cv-tile-component  data-title='<cv:msg key="title.diskInformation" bundle="storage"/>'>
            <ul class="list-style-secondary">
                <li class="group">
                    <span class="pageDetailColumn"><cv:msg key="label.vendor" bundle="storage"/></span>
                    <span class="pageDetailColumn">{{scaleOutStorageDiskInfoList[0].vendor}}</span>
                </li>
                <li class="group">
                    <span class="pageDetailColumn"><cv:msg key="label.product" bundle="storage"/></span>
                    <span class="pageDetailColumn">{{scaleOutStorageDiskInfoList[0].product}}</span>
                </li>
                <li class="group">
                    <span class="pageDetailColumn"><cv:msg key="label.fileSystem" bundle="storage"/></span>
                    <span class="pageDetailColumn">{{scaleOutStorageDiskInfoList[0].fileSystem}}</span>
                <li class="group">
                    <span class="pageDetailColumn"><cv:msg key="label.status" bundle="storage"/></span>
                    <span class="pageDetailColumn" data-ng-class="{notProtected: (successStatus ==0 ), protected:(successStatus ==1)}">{{statusString}}	</span>
                </li>
            </ul>
        </cv-tile-component>
    </div>
    <div class="col-md-6">
        <cv-tile-component data-title='<cv:msg key="title.serverInformation" bundle="storage"/>'>
        	<div class="page-details-box-links" data-ng-show="isHwCollectionSupported==true">
	   			<a data-ng-href="{{hwInfo.detailsLink}}"><cv:msg key="label.viewDetails" bundle="storage"/></a>
	   		</div>
            <ul class="list-style-secondary">
            	<li class="group" data-ng-show="isHwCollectionSupported==true" >
                    <span class="pageDetailColumn"><cv:msg key="label.cpu" bundle="storage"/></span>
                    <span class="pageDetailColumn">{{hwInfo.cpuInfo}}	</span>
                </li>
                <li class="group" data-ng-show="isHwCollectionSupported==true" >
                    <span class="pageDetailColumn"><cv:msg key="label.fan" bundle="storage"/></span>
                    <span class="pageDetailColumn" data-ng-class="{notProtected: (hwInfo.fanStatus ==0 ), protected:(hwInfo.fanStatus ==1)}">{{hwInfo.fanStatusString}}
                    	<a class="hwDetailsLink" data-ng-if="hwInfo.fanStatusLink" data-ng-href="{{hwInfo.fanStatusLink}}"><cv:msg key="label.viewDetails" bundle="storage"/></a>
                    </span>
                </li>
                <li class="group" data-ng-show="isHwCollectionSupported==true" >
                    <span class="pageDetailColumn"><cv:msg key="label.powerSupply" bundle="storage"/></span>
                    <span class="pageDetailColumn" data-ng-class="{notProtected: (hwInfo.powerStatus ==0 ), protected:(hwInfo.powerStatus ==1)}">{{hwInfo.powerStatuString}}
                    	<a class="hwDetailsLink" data-ng-if="hwInfo.powerStatusLink" data-ng-href="{{hwInfo.powerStatusLink}}"><cv:msg key="label.viewDetails" bundle="storage"/></a>
                    </span>
                <li class="group" data-ng-show="isHwCollectionSupported==true" >
                    <span class="pageDetailColumn"><cv:msg key="label.cacheDrive" bundle="storage"/></span>
                    <span class="pageDetailColumn" data-ng-class="{notProtected: (hwInfo.flashDriveStatus ==0 ), protected:(hwInfo.flashDriveStatus ==1)}">{{hwInfo.flashDriveStatusString}}
                    	<a class="hwDetailsLink" data-ng-if="hwInfo.flashStatusLink" data-ng-href="{{hwInfo.flashStatusLink}}"><cv:msg key="label.viewDetails" bundle="storage"/></a>
                    </span>
                </li>
		  		<li class="group" data-ng-show="isHwCollectionSupported==true" >
					<span class="pageDetailColumn"><cv:msg key="label.nicStatus" bundle="storage"/></span>
					<span class="pageDetailColumn" data-ng-class="{notProtected: (hwInfo.nicStatus ==0 ), protected:(hwInfo.nicStatus ==1)}">{{hwInfo.nicStatusString}}
						<a class="hwDetailsLink" data-ng-if="hwInfo.nicStatusLink" data-ng-href="{{hwInfo.nicStatusLink}}"><cv:msg key="label.viewDetails" bundle="storage"/></a>
					</span>
		  		</li>
		  		<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.system.cpu" bundle="storage"/></span>
					<div class="pageDetailColumn hw-status" >
						<span class="hw-status-icon"><img data-ng-if="cpuUsage.statusIcon" data-ng-src="{{cpuUsage.statusIcon}}"/></span>
						<span class="hw-status-val">{{cpuUsage.usageStr}}</span>
					</div>
		  		</li>
		  		<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.system.memory" bundle="storage"/></span>
					<div class="pageDetailColumn hw-status" >
						<span class="hw-status-icon"><img data-ng-if="memoryUsage.statusIcon" data-ng-src="{{memoryUsage.statusIcon}}"/></span>
						<span class="hw-status-val">{{memoryUsage.usageStr}}</span>
					</div>
		  		</li>
            </ul>
        </cv-tile-component>
    </div>
</div>
<cv-kendo-grid data-cv-grid-options="kendoGridOptions"></cv-kendo-grid>
<div id="reportArea" data-ng-if="bEnableScaleoutPerformanceCharts && 'SCALE_OUT' === storagePoolType">
    <div id="reportAreaScaleoutNode">
        <div data-ng-controller="reportsCtrl " data-ng-init="init( null, 'Storage Pool ScaleOut Node')">
            <div id="pageDiv" data-ng-controller="pageController" class="maskLayer" data-ng-class="{'isMasked':masked}" >
                <div data-ng-include="'${pageContext.request.contextPath}/reportsplus/templates/reportComponents/viewerPage.jsp'">
                </div>
            </div>
        </div>
    </div>
</div>
