<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>
<div>
    <script nonce="${sessionScope.cspNonce}">
        <cv:cvMessages bundle="localization.storage"></cv:cvMessages>
    </script>
    <ul class="group list-style-secondary">
        <li class="group">
            <span class="pageDetailColumn">
                <cv:msg key="label.encrypt" bundle="storage" /></span>
            <span class="pageDetailColumn">
                <toggle-control class="enabled-activity"
                    status="vm.encryption.encrypt ? 'enabled-activity' : 'disabled-activity'"
                    data-ng-click="vm.onToggleEncrypt()">
                </toggle-control>
            </span>
        </li>
        <li class="group" ng-if="vm.test.selectedCipher.length > 0">
            <span class="pageDetailColumn">
                <cv:msg key="label.cipher" bundle="storage" /></span>
            <div data-ng-if="!vm.isEditingEncrypt" class="pageDetailColumn">
                <span data-ng-if="vm.encryption.cipher.keyName !== 'UNKNOWN'">
                    {{vm.encryption.cipher.keyName}} - {{vm.encryption.cipher.keyLength}}
                    <a class="horizontal-link-button" data-ng-click="vm.editEncrypt()">
                        <i class="glyphicon glyphicon-pencil"></i>
                    </a>
                </span>
            </div>
            <div data-ng-if="vm.isEditingEncrypt && vm.test.selectedCipher.length > 0" class="pageDetailColumn">
                <div class="encrypt-key-lengths inline-block width-50-percentage">
                    <isteven-multi-select id="cvEncryptionComponentTemplate_isteven-multi-select_#7501" input-model="vm.cipherList" output-model="vm.test.selectedCipher" 
                        button-label="name" item-label="name" helper-elements="none" hide-search-button="true"
                        tick-property="selected" on-close="vm.getkeyLengths()"
                        class="isteven-multi-select user-group-select" selection-mode="single">
                    </isteven-multi-select>
                </div>
            </div>
        </li>
        <li class="group" data-ng-if="vm.isEditingEncrypt && vm.test.selectedCipher.length > 0"> 
            <span class="pageDetailColumn">
                <cv:msg key="label.keyLength" bundle="storage" /></span>
            <div class="pageDetailColumn">
                <div class="encrypt-key-lengths inline-block width-50-percentage">
                    <isteven-multi-select id="cvEncryptionComponentTemplate_isteven-multi-select_#5652" input-model="vm.keyLengths" output-model="vm.test.selectedKeyLength" 
                        button-label="length" item-label="length" helper-elements="none" hide-search-button="true"
                        tick-property="selected" class="isteven-multi-select user-group-select" selection-mode="single">
                    </isteven-multi-select>
                </div>
                <a class="inline-editor-button" data-ng-click="vm.updateEncryption('encryption')"><i class="k-icon k-i-check"></i></a>
                <a class="inline-editor-button" data-ng-click="vm.editEncrypt()"><i class="k-icon k-i-close"></i></a>
            </div>
        </li>
        <li class="group">
            <span class="pageDetailColumn">
                <cv:msg key="label.keyManagement" bundle="storage" /></span>
            <span class="pageDetailColumn" data-ng-if="!vm.isEditingKeyManagement">
                {{vm.encryption.managementServer}}
                <a class="horizontal-link-button" data-ng-if="vm.keyManagementList.length > 0"
                    data-ng-click="vm.onToggleEditKeyManagement()">
                    <i class="glyphicon glyphicon-pencil"></i>
                </a>
                <span class="horizontal-link-button second-item font-size-16 padding-left-0">
                    <cv-actions-dropdown btn-icon-classname="'glyphicon glyphicon-plus'"
                        permitted-options="vm.KeyManagementServerActions.permittedOptions"></cv-actions-dropdown>
                </span>
            </span>
            <div class="pageDetailColumn" data-ng-if="vm.isEditingKeyManagement">
                <div class="inline-block width-50-percentage">
                    <isteven-multi-select id="cvEncryptionComponentTemplate_isteven-multi-select_#3543" input-model="vm.keyManagementList" output-model="vm.test.selectedKeyManagement" 
                        button-label="keyProviderName" item-label="keyProviderName" helper-elements="none"
                        hide-search-button="true" tick-property="selected" class="isteven-multi-select user-group-select"
                        selection-mode="single">
                    </isteven-multi-select>
                </div>
                <a class="inline-editor-button" data-ng-click="vm.updateEncryption('keyManagement')"><i
                        class="k-icon k-i-check"></i></a>
                <a class="inline-editor-button" data-ng-click="vm.onToggleEditKeyManagement()"><i class="k-icon k-i-close"></i></a>
            </div>
        </li>
    </ul>
</div>