<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
</script>
<h1 class="page-title">
	<span>
		<cv:msg key="title.addCloudLibrary" bundle="storage"/>
	</span>
</h1>
<div class="set-up-page">
	<div class="setup-content medium-width">
		<div class="bootstrap-wrapper form-horizontal padding-bottom-0">
			<div class="panel-default setup-panel">
				<div class="panel-body">
					<div class="col-xs-12">
						<form class="cloudStorageForm" name="otherCloudStorageForm" novalidate data-cv-submit="addEditShareLibrary()" autocomplete="off">
							<div class="group row">
								<cv-tile-component data-ac-id="other_cloud-type" data-title='<cv:msg key="label.configureCloud" bundle="storage"/>'>
									<div class="form-group">
										<label class="col-xs-5 col-sm-5" for="libraryName"><cv:msg key="Name" bundle="storage"/></label>
							    		<div id="libraryName" class="col-xs-7 col-sm-7 text-align-left">
							        		<input data-ng-class="{'has-error': cv.otherCloudStorageForm.needsAttention(otherCloudStorageForm.libraryName)}" type="text" name="libraryName" data-ng-model="libraryInfo.libraryEntity.libraryName" maxlength="128" data-ng-change="inputRequired.name = false"/>
							        		<span class="help-block" data-ng-show="inputRequired.name"><cv:msg key="error.libraryName.required" bundle="storage"/></span>
							        	</div>
							        </div>
								</cv-tile-component>
								<cv-tile-component  data-ac-id="other_cloud-type" data-title='<cv:msg key="label.storage" bundle="storage"/>'>
									<div class="form-group">
										<label for="cloudType" class="col-xs-5 col-sm-5"><cv:msg key="label.cloudType" bundle="storage"/></label>
						                <div class="col-xs-7 col-sm-7 text-align-left">
											<isteven-multi-select
												input-model="cloudTypeList"
												output-model="cloud.cloudType"
												button-label="name"
												item-label="name"
												helper-elements="filter"
												hide-search-button="false"
												directive-id="cloudServerType"
												id="cloudType"
												name="cloudType"
												tick-property="selected"
												class="isteven-multi-select user-group-select "
												selection-mode="single"
												on-item-click="refreshCloudInputs()"
											>
											</isteven-multi-select>
							                <span class="help-block" data-ng-show="cv.addCollectionForm.needsAttention(addCollectionForm.cloudType)"><cv:msg key="error.cloudType" bundle="storage"/></span>
						                </div>
									</div>
									<div class="form-group">
								        <label for="mediaAgent" class="col-xs-5 col-sm-5"><cv:msg key="label.mediaAgent" bundle="storage"/></label>
								        <div class="col-xs-7 col-sm-7 text-align-left" id="mediaAgent">
							                <select-with-create-button
							                    select-id="mediaAgent"
							                    select-name="mediaAgent"
							                    key-label="displayName"
							                    key-id="mediaAgentId"
							                    option-list="agentList"
							                    selected-option="selectedMediaAgent"
							                    select-only-option="true"
							                    on-change-option="setClientType"
							                    on-click-create-button="openCreateMediaAgentModal"
							                    is-required="true"
							                    has-error="mediaAgentError"
							                    select-disabled="false"
							                    placeholder='<cv:msg key="placeholder.mediaAgent" bundle="storage"/>'
							                    is-credential="false">
							                </select-with-create-button>
							                <span class="help-block" data-ng-show="mediaAgentError"><cv:msg key="error.mediaAgent" bundle="storage"/></span>
										</div>
									</div>
								    <div class="hpe-catalyst-storage-container"
								        data-ng-if="libraryInfo.serverType.id === HPE_CATALYST_STORAGE">
									    <div class="form-group">
									        <label for="serviceHost" class="col-xs-5 col-sm-5">
									        	<cv:msg key="label.StoreOnceHost" bundle="storage"/>
									        </label>
									        <div class="col-xs-7 col-sm-7">
									            <input id="serviceHost" type="text" name="ServiceHost" data-ng-model="libraryInfo.serviceHost" required maxlength="128"/>
									            <span class="help-block" data-ng-show="otherCloudStorageForm.ServiceHost.$error.required && cv.otherCloudStorageForm.needsAttention(otherCloudStorageForm.ServiceHost)"><cv:msg key="error.ServiceHost.required" bundle="storage"/></span>
									        </div>
									    </div>
								        <div class="form-group">
								            <label for="bucket" class="col-xs-5 col-sm-5">{{cloudTypeLables[libraryInfo.serverType.id].label_Bucket | cvLoc}}</label>
								            <div class="col-xs-7 col-sm-7">
								                <input id="bucket" type="text" name="Bucket" data-ng-model="libraryInfo.mountPath.name" required maxlength="128"/>
								                <span class="help-block" data-ng-show="otherCloudStorageForm.Bucket.$error.required && cv.otherCloudStorageForm.needsAttention(otherCloudStorageForm.Bucket)">{{cloudTypeLables[libraryInfo.serverType.id].error_Bucket | cvLoc}}</span>
								            </div>
								        </div>
								        <div class="form-group" >
								            <label class="col-xs-5 col-sm-5">{{cloudTypeLables[libraryInfo.serverType.id].label_UserName | cvLoc}}</label>
								            <div class="col-xs-7 col-sm-7">
								                <input type="text" name="HPEUserName" data-ng-model="libraryInfo.loginName" maxlength="128"/>
								                <span class="help-block" data-ng-show="otherCloudStorageForm.HPEUserName.$error.required && cv.otherCloudStorageForm.needsAttention(otherCloudStorageForm.HPEUserName)"><cv:msg key="error.UserName.required" bundle="storage"/></span>
								            </div>
								        </div>
								        <div class="form-group margin-bottom-15">
								        	<label class="col-xs-5 col-sm-5">{{cloudTypeLables[libraryInfo.serverType.id].label_Password | cvLoc}}</label>
								            <div class="col-xs-7 col-sm-7">
								                <input type="password" name="HPEPassword" data-ng-model="libraryInfo.password" maxlength="128"/>
								                <span class="help-block" data-ng-show="otherCloudStorageForm.HPEPassword.$error.required && cv.otherCloudStorageForm.needsAttention(otherCloudStorageForm.HPEPassword)"><cv:msg key="error.Password.required" bundle="storage"/></span>
								            </div>
								        </div>
								    </div>
							    	<div class="full-width flex-column" data-ng-if="libraryInfo.serverType.id !== HPE_CATALYST_STORAGE
								        && libraryInfo.serverType.id != ORACLE_CLOUD_INFRASTRUCTURE_OBJECT_STORAGE
								        && libraryInfo.serverType.id != ORACLE_CLOUD_INFRASTRUCTURE_ARCHIVE_STORAGE">
								        <div class="form-group">
								            <label for="serviceHost" class="col-xs-5 col-sm-5">
								                <cv:msg key="label.serviceHost" bundle="storage"/>
								            </label>
								            <div class="col-xs-7 col-sm-7">
								                <input id="serviceHost" type="text" name="ServiceHost" data-ng-model="libraryInfo.serviceHost" required maxlength="128"/>
								                <span class="help-block" data-ng-show="otherCloudStorageForm.ServiceHost.$error.required && cv.otherCloudStorageForm.needsAttention(otherCloudStorageForm.ServiceHost)"><cv:msg key="error.ServiceHost.required" bundle="storage"/></span>
								            </div>
								        </div>
								        <div class="form-group" data-ng-if="showAuthenticationType">
								            <label for="authenticationType" class="col-xs-5 col-sm-5"><cv:msg key="label.authentication" bundle="storage" /></label>
								            <div class="col-xs-7 col-sm-7">
								                <select id="authenticationType" name="authenticationType" data-ng-model="configureAuthCloud.storageAuthenticationType"
								                        data-ng-change="authenticationChanged()"
								                        data-ng-options="authenticationType as authenticationType.displayName | cvLoc for authenticationType in storageAuthenticationTypeList | orderBy:'id' track by authenticationType.id" required
								                        data-ng-class="{'has-error': cv.addCollectionForm.needsAttention(addCollectionForm.authenticationType)}">
								                    <option value=""><cv:msg key="placeholder.authenticationType" bundle="storage" /></option>
								                </select>
								                <span class="help-block" data-ng-show="cv.addCollectionForm.needsAttention(addCollectionForm.authenticationType)"><cv:msg key="error.authenticationType" bundle="storage"/></span>
								            </div>
								        </div>
								        <div class="form-group" ng-if="showAuthenticationType && configureAuthCloud.storageAuthenticationType.showIAMRole">
								            <label for="iamRole" class="col-xs-5 col-sm-5">
								                <cv:msg key="label.iamRole" bundle="storage"/>
								            </label>
								            <div class="col-xs-7 col-sm-7">
								                <input id="iamRole" type="text" name="iamRole" data-ng-model="configureAuthCloud.iamRole" required maxlength="128"/>
								                <span class="help-block" data-ng-show="otherCloudStorageForm.iamRole.$error.required && cv.otherCloudStorageForm.needsAttention(otherCloudStorageForm.iamRole)"><cv:msg key="error.iamRole.required" bundle="storage"/></span>
								            </div>
								        </div>
								        <div class="form-group" ng-if="showAuthenticationType && configureAuthCloud.storageAuthenticationType.showARNRole">
								            <label for="arnRole" class="col-xs-5 col-sm-5">
								                <cv:msg key="label.arnRole" bundle="storage"/>
								            </label>
								            <div class="col-xs-7 col-sm-7">
								                <input id="arnRole" type="text" name="arnRole" data-ng-model="configureAuthCloud.arnRole" required maxlength="128"/>
								                <span class="help-block" data-ng-show="otherCloudStorageForm.arnRole.$error.required && cv.otherCloudStorageForm.needsAttention(otherCloudStorageForm.arnRole)"><cv:msg key="error.arnRole.required" bundle="storage"/></span>
								            </div>
								        </div>
								        <div class="form-group" data-ng-if="configureAuthCloud.showIAMVMLabels || configureAuthCloud.showIAMADCMLabels ">
								            <label for="accountName" class="col-xs-5 col-sm-5">
								                <cv:msg key="label.accountName" bundle="storage"/>
								            </label>
								            <div class="col-xs-7 col-sm-7">
								                <input id="accountName" type="text" name="accountName" data-ng-model="configureAuthCloud.accountName" required maxlength="128"/>
								                <span class="help-block" data-ng-show="otherCloudStorageForm.accountName.$error.required && cv.otherCloudStorageForm.needsAttention(otherCloudStorageForm.accountName)"><cv:msg key="error.AccountName.required" bundle="storage"/></span>
								            </div>
								        </div>
						        		<div data-ng-class="{'panel-body no-padding' : showSwitchToCM}" data-ng-if="showSwitchToCM">
								            <div data-ng-if="!showCredentialDropDown">
								                <div class="form-group">
								                    <label for="userName" class="col-xs-5 col-sm-5">{{cloudTypeLables[libraryInfo.serverType.id].label_UserName | cvLoc}}</label>
								                    <div class="col-xs-7 col-sm-7">
								                        <input id="userName" type="text" name="UserName" data-ng-model="libraryInfo.loginName" maxlength="128"	data-ng-required="!showCredentialDropDown">
								                        <span class="help-block" data-ng-show="otherCloudStorageForm.UserName.$error.required && cv.otherCloudStorageForm.needsAttention(otherCloudStorageForm.UserName)"><cv:msg key="error.UserName.required" bundle="storage"/></span>
								                    </div>
								                </div>
								                <div class="form-group">
								                    <label for="password" class="col-xs-5 col-sm-5">{{cloudTypeLables[libraryInfo.serverType.id].label_Password | cvLoc}}</label>
								                    <div class="col-xs-7 col-sm-7">
								                        <input id="password" type="password" name="Password" data-ng-model="libraryInfo.password" maxlength="128" data-ng-required="!showCredentialDropDown"/>
								                        <span class="help-block" data-ng-show="otherCloudStorageForm.Password.$error.required && cv.otherCloudStorageForm.needsAttention(otherCloudStorageForm.Password)"><cv:msg key="error.Password.required" bundle="storage"/></span>
								                    </div>
								                </div>
								            </div>
						            		<div data-ng-if="showCredentialDropDown">
						                		<div class="form-group margin-bottom-10">
						                   			<label for="credential" class="col-xs-5 col-sm-5"> <cv:msg key="label.credentialName" bundle="storage"/></label>
							                    	<div class="col-xs-7 col-sm-7">
								                        <select-with-create-button
								                            select-id="credential"
								                            select-name="credential"
								                            key-label="credentialName"
								                            key-id="credentialId"
								                            option-list="savedCredentials"
								                            on-change-option="onChangeCredential"
								                            selected-option="libraryInfo.selectedCredential"
								                            on-click-create-button="openCreateCredentialModal"
								                            has-error="cv.otherCloudStorageForm.needsAttention(otherCloudStorageForm.credential)"
								                            class="no-float-auto tile-large-width"
								                            placeholder='<cv:msg key="placeholder.credential" bundle="storage"/>'
								                            edit-disabled="libraryInfo.selectedCredential.length === 0"
								                            on-click-edit-button="openEditCredentialModal"
								                            is-credential="true">
								                        </select-with-create-button>
								                        <span class="help-block" data-ng-show="credentialNotSelectedError">
								                            <cv:msg key="error.credential.required" bundle="storage"/>
								                        </span>
							                    	</div>
						                		</div>
						            		</div>
						        		</div>
								        <div class="form-group">
								            <label for="bucket" class="col-xs-5 col-sm-5">{{cloudTypeLables[libraryInfo.serverType.id].label_Bucket | cvLoc}}</label>
								            <div class="col-xs-7 col-sm-7">
								                <input id="bucket" type="text" name="Bucket" data-ng-model="libraryInfo.mountPath.name" required maxlength="128"/>
								                <span class="help-block" data-ng-show="otherCloudStorageForm.Bucket.$error.required && cv.otherCloudStorageForm.needsAttention(otherCloudStorageForm.Bucket)">{{cloudTypeLables[libraryInfo.serverType.id].error_Bucket | cvLoc}}</span>
								            </div>
								        </div>
								        <div class="form-group" data-ng-if="showStorageClass">
								            <label for="storageClass" class="col-xs-5 col-sm-5"><cv:msg key="label.storageClass" bundle="storage" /></label>
								            <div class="col-xs-7 col-sm-7">
								                <select id="storageClass" name="storageClass" data-ng-model="libraryInfo.storageClass"
								                        data-ng-options="storageClass as storageClass.displayName | cvLoc for storageClass in storageClassList | orderBy:'id' track by storageClass.id" required
								                        data-ng-class="{'has-error': cv.addCollectionForm.needsAttention(addCollectionForm.cloudType)}">
								                    <option value=""><cv:msg key="placeholder.storageClass" bundle="storage" /></option>
								                </select>
								                <span class="help-block" data-ng-show="cv.addCollectionForm.needsAttention(addCollectionForm.cloudType)"><cv:msg key="error.cloudType" bundle="storage"/></span>
								            </div>
								        </div>
							    	</div>
							    	<div class="full-width flex-column" data-ng-if="libraryInfo.serverType.id == ORACLE_CLOUD_INFRASTRUCTURE_OBJECT_STORAGE
						    	|| libraryInfo.serverType.id == ORACLE_CLOUD_INFRASTRUCTURE_ARCHIVE_STORAGE">
								        <div class="form-group">
								            <label for="serviceHost" class="col-xs-5 col-sm-5">
								                <cv:msg key="label.serviceHost" bundle="storage"/>
								            </label>
								            <div class="col-xs-7 col-sm-7">
								                <input id="serviceHost" type="text" name="ServiceHost" data-ng-model="libraryInfo.serviceHost" required maxlength="128"/>
								                <span class="help-block" data-ng-show="otherCloudStorageForm.ServiceHost.$error.required && cv.otherCloudStorageForm.needsAttention(otherCloudStorageForm.ServiceHost)"><cv:msg key="error.ServiceHost.required" bundle="storage"/></span>
								            </div>
								        </div>
								        <div class="form-group">
								            <label class="col-xs-5 col-sm-5">{{cloudTypeLables[libraryInfo.serverType.id].label6 | cvLoc}}</label>
								            <div class="col-xs-7 col-sm-7">
								                <input data-ng-class="{'has-error': cv.otherCloudStorageForm.needsAttention(otherCloudStorageForm.TenancyOCID)}" type="text" name="TenancyOCID" data-ng-model="configureCloudLibrary.TenancyOCID" required maxlength="128"/>
								                <span class="help-block" data-ng-show="otherCloudStorageForm.TenancyOCID.$error.required && cv.otherCloudStorageForm.needsAttention(otherCloudStorageForm.TenancyOCID)"><cv:msg key="error.TenancyOCID.required" bundle="storage"/></span>
								            </div>
								        </div>
								        <div class="form-group">
								            <label class="col-xs-5 col-sm-5">{{cloudTypeLables[libraryInfo.serverType.id].label7 | cvLoc}}</label>
								            <div class="col-xs-7 col-sm-7">
								                <input data-ng-class="{'has-error': cv.otherCloudStorageForm.needsAttention(otherCloudStorageForm.UserOCID)}" type="text" name="UserOCID" data-ng-model="configureCloudLibrary.UserOCID" required maxlength="128"/>
								                <span class="help-block" data-ng-show="otherCloudStorageForm.UserOCID.$error.required && cv.otherCloudStorageForm.needsAttention(otherCloudStorageForm.UserOCID)"><cv:msg key="error.UserOCID.required" bundle="storage"/></span>
								            </div>
								        </div>
								        <div class="form-group">
								            <label class="col-xs-5 col-sm-5">{{cloudTypeLables[libraryInfo.serverType.id].label8 | cvLoc}}</label>
								            <div class="col-xs-7 col-sm-7">
								                <input data-ng-class="{'has-error': cv.otherCloudStorageForm.needsAttention(otherCloudStorageForm.KeysFingerprint)}" type="text" name="KeysFingerprint" data-ng-model="configureCloudLibrary.KeysFingerprint" required maxlength="128"/>
								                <span class="help-block" data-ng-show="otherCloudStorageForm.KeysFingerprint.$error.required && cv.otherCloudStorageForm.needsAttention(otherCloudStorageForm.KeysFingerprint)"><cv:msg key="error.KeysFingerprint.required" bundle="storage"/></span>
								            </div>
								        </div>
								        <div class="form-group">
								            <label class="col-xs-5 col-sm-5">{{cloudTypeLables[libraryInfo.serverType.id].label9 | cvLoc}}</label>
								            <div class="col-xs-7 col-sm-7">
								                <input type="text" name="CompartmentName" data-ng-model="configureCloudLibrary.CompartmentName" maxlength="128"/>
								            </div>
								        </div>
								        <div class="form-group">
								            <label class="col-xs-5 col-sm-5">{{cloudTypeLables[libraryInfo.serverType.id].label10 | cvLoc}}</label>
								            <div class="col-xs-7 col-sm-7">
								                <input data-ng-class="{'has-error': cv.otherCloudStorageForm.needsAttention(otherCloudStorageForm.PemKeyFilename)}" type="text" name="PemKeyFilename" data-ng-model="configureCloudLibrary.PemKeyFilename" required maxlength="128"/>
								                <span class="help-block" data-ng-show="otherCloudStorageForm.PemKeyFilename.$error.required && cv.otherCloudStorageForm.needsAttention(otherCloudStorageForm.PemKeyFilename)"><cv:msg key="error.PemKeyFilename.required" bundle="storage"/></span>
								            </div>
								        </div>
								        <div class="form-group">
								            <label class="col-xs-5 col-sm-5">{{cloudTypeLables[libraryInfo.serverType.id].label11 | cvLoc}}</label>
								            <div class="col-xs-7 col-sm-7">
								                <input data-ng-class="{'has-error': cv.otherCloudStorageForm.needsAttention(otherCloudStorageForm.Password)}" type="password" name="Password" data-ng-model="libraryInfo.password" required maxlength="128"/>
								                <span class="help-block" data-ng-show="otherCloudStorageForm.Password.$error.required && cv.otherCloudStorageForm.needsAttention(otherCloudStorageForm.Password)"><cv:msg key="error.PrivateKeysPassword.required" bundle="storage"/></span>
								            </div>
								        </div>
								        <div class="form-group">
								            <label class="col-xs-5 col-sm-5">{{cloudTypeLables[libraryInfo.serverType.id].label12 | cvLoc}}</label>
								            <div class="col-xs-7 col-sm-7">
								                <input data-ng-class="{'has-error': cv.otherCloudStorageForm.needsAttention(otherCloudStorageForm.Bucket)}" type="text" name="Bucket" data-ng-model="libraryInfo.mountPath.name" required maxlength="128"/>
								                <span class="help-block" data-ng-show="otherCloudStorageForm.Bucket.$error.required && cv.otherCloudStorageForm.needsAttention(otherCloudStorageForm.Bucket)"><cv:msg key="error.bucket.required" bundle="storage"/></span>
								            </div>
								        </div>
						    		</div>

								    <!-- // DDB location start// -->
								    <div data-ng-if="libraryInfo.serverType.id !== HPE_CATALYST_STORAGE">
								        <div class="form-group text-align-left margin-top-20" data-ng-class="{'margin-bottom-20' : !showDDBInput}">
								            <toggle-control
								            class="margin-right-5 margin-left-15"
								                status="showDDBInput ? 'enabled-activity' : 'disabled-activity'"
								                data-ng-click="onToggleUseDDBOtherCloud()"> </toggle-control>
								            <span for="partitionPath"><cv:msg key="label.useDeduplication"  bundle="storage" /></span>
								        </div>
								        <div data-ng-if="showDDBInput" class="margin-bottom-20">
											<cv-kendo-grid data-cv-grid-options="addCloudDDBGridOptions"></cv-kendo-grid>
											<span class="margin-right-5 margin-left-15 help-block" data-ng-show="inputRequired.DDB"><cv:msg key="error.partitionPathAdd" bundle="storage"/></span>
										</div>
									</div>
								    <!-- // DDB location end// -->
								</cv-tile-component>

								<div class="button-container">
									<button id="addCloudStorage_button_#5532" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="cancel()">
										<cv:msg key="Cancel" bundle="messages"/>
									</button>
									<%-- <button id="addCloudStorage_button_#4276" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-hide="action=='addMP' ||action=='addCloudLib' action=='newCloudLib'" data-ng-click="deleteMountPath()">
										<cv:msg key="Delete" bundle="messages"/>
									</button> --%>
									<button id="addCloudStorage_button_#3208"  data-ng-if="!isSetup" class="btn margin-right-0 btn-primary cvBusyOnAjax" type="submit" data-ng-disabled ="disableSaveButton()">
										<div data-ng-if="action=='editMP'">
											<cv:msg key="action.save" bundle="storage"/>
										</div>
										<div data-ng-if="action=='addCloudLib' || action=='newCloudLib' || action=='addCloudMP'" >
											<cv:msg key="action.save" bundle="storage"/>
										</div>
									</button>
									<button id="addCloudStorage_button_#6118" type="button" class="btn btn-default cvBusyOnAjax skip-btn--hidden" data-ng-if="isCurrentStepCompleted()" data-ng-click="skip()"><cv:msg key="Skip" /></button>
									<button id="addCloudStorage_button_#0236" data-ng-if="isSetup" type="submit" data-ng-click="saveButtonClick()" class="btn margin-right-0 btn-primary cvBusyOnAjax" data-ng-disabled="disableSaveButton()">
										<div >
						                	<cv:msg key="action.save" bundle="storage" />
						                </div>
									</button>
								</div>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>