<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
</script>

<div class="row setup-content padding-0 bootstrap-wrapper medium-width">
	<div class="setup-section padding-top-0">
		<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
        <p data-ng-show="formStorage.hide" class="{{storagePresentMessage.type}} serverMessage" data-ng-class="{'storage-top-margin' : isTenantAdmin || isTenantOperator}">{{storagePresentMessage.message}}</p>
        <p class="text-center" data-ng-show="formStorage.hide && !mspModeOn"><a data-ng-click="changeStorage()"><cv:msg key="label.addAnotherStorage" bundle="storage"/></a></p>
        <div data-ng-hide="formStorage.hide">
			<form class="storageForm" name="metallicStorageForm" novalidate autocomplete="off">
				<div class="panel panel-body margin-top-20">
					<div class="form-group">
						<label class="col-xs-5 col-sm-5" for="libraryName"><cv:msg key="Name" bundle="storage"/></label>
			    		<div id="libraryName" class="col-xs-7 col-sm-7 text-align-left">
			        		<input data-ng-class="{'has-error': cv.storageForm.needsAttention(storageForm.libraryName)}" type="text" name="libraryName" data-ng-model="libraryInfo.libraryEntity.libraryName" maxlength="128" data-ng-change="inputRequired.name = false" />
			        		<span class="help-block" data-ng-show="inputRequired.name"><cv:msg key="error.libraryName.required" bundle="storage"/></span>
			        	</div>
			        </div>
					<div class="form-group">
				        <label for="mediaAgent" class="col-xs-5 col-sm-5"><cv:msg key="label.mediaAgent" bundle="storage"/></label>
				        <div class="col-xs-7 col-sm-7" id="mediaAgent">
			                <select-with-create-button
			                    select-id="mediaAgent"
			                    select-name="mediaAgent"
			                    key-label="displayName"
			                    key-id="mediaAgentId"
			                    option-list="agentList"
			                    selected-option="libraryInfo.mediaAgent"
			                    select-only-option="true"
			                    on-change-option="setMediaAgent"
			                    on-click-create-button="openCreateMediaAgentModal"
			                    is-required="true"
			                    has-error="mediaAgentError || cv.addCollectionForm.needsAttention(addCollectionForm.mediaAgent)"
			                    select-disabled="false"
			                    placeholder='<cv:msg key="placeholder.mediaAgent" bundle="storage"/>'
			                    is-credential="false">
			                </select-with-create-button>
			                <span class="help-block" data-ng-show="inputRequired.mediaAgent"><cv:msg key="error.mediaAgent" bundle="storage"/></span>
						</div>
					</div>
					<div class="form-group" data-ng-if="licenseTypeList.length > 1">
						<label class="col-xs-5 col-sm-5" for="licenseType"><cv:msg key="label.license" bundle="storage"/></label>
				        <div class="col-xs-7 col-sm-7">
							<isteven-multi-select
								directive-id="licenseTypeList"
								input-model="licenseTypeList"
								output-model="metallicStorageInfo.licenseType"
								button-label="label"
								item-label="label"
								id="licenseType"
								tick-property="selected"
								class="grid-filter-isteven-multi-select isteven-multi-select user-group-select grid-column-filter"
								helper-elements="none"
								selection-mode="single"
								on-item-click="setMetallicLicenseType(data)">
							</isteven-multi-select>
							<span class="help-block" data-ng-show="inputRequired.license"><cv:msg key="error.license" bundle="storage"/></span>
			        	</div>
			        </div>
					<div class="form-group">
						<label for="region" class="col-xs-5 col-sm-5"><cv:msg key="label.location" bundle="storage"/></label>
				        <div class="col-xs-7 col-sm-7">
							<isteven-multi-select
								directive-id="regionList"
								input-model="regionList"
								output-model="metallicStorageInfo.region"
								button-label="label"
								item-label="label"
								id="region"
								tick-property="selected"
								class="grid-filter-isteven-multi-select isteven-multi-select user-group-select grid-column-filter"
								helper-elements="none"
								selection-mode="single"
								on-item-click="setMetallicRegion(data)">
							</isteven-multi-select>
							<span class="help-block" data-ng-show="inputRequired.region"><cv:msg key="error.region" bundle="storage"/></span>
			        	</div>
					</div>
					<div class="form-group" data-ng-if="showMetallicInputs.storageClass">
						<label for="storageClass" class="col-xs-5 col-sm-5"><cv:msg key="label.storageClass" bundle="storage"/></label>
				        <div class="col-xs-7 col-sm-7">
							<isteven-multi-select
								directive-id="storageClassList"
								input-model="storageClassList"
								output-model="metallicStorageInfo.storageClass"
								button-label="label"
								item-label="label"
								id="storageClass"
								tick-property="selected"
								class="grid-filter-isteven-multi-select isteven-multi-select user-group-select grid-column-filter"
								helper-elements="none"
								selection-mode="single"
								on-item-click="setMetallicStorageClass(data)">
							</isteven-multi-select>
							<span class="help-block" data-ng-show="inputRequired.storageClass"><cv:msg key="error.storageClass" bundle="storage"/></span>
			        	</div>
					</div>
					<div class="form-group" data-ng-if="showMetallicInputs.replication">
						<label for="replication" class="col-xs-5 col-sm-5"><cv:msg key="label.replication" bundle="storage"/></label>
				        <div class="col-xs-7 col-sm-7">
							<isteven-multi-select
								directive-id="replicationList"
								input-model="replicationList"
								output-model="metallicStorageInfo.replication"
								button-label="label"
								item-label="label"
								id="replication"
								tick-property="selected"
								class="grid-filter-isteven-multi-select isteven-multi-select user-group-select grid-column-filter"
								helper-elements="none"
								selection-mode="single"
								on-item-click="setMetallicReplication(data)">
							</isteven-multi-select>
							<span class="help-block" data-ng-show="inputRequired.replication"><cv:msg key="error.replication" bundle="storage"/></span>
			        	</div>
					</div>
				    <!-- // DDB location start// -->
					<div class="margin-top-5 margin-bottom-15">
						<div class="form-group">
							<div class="col-xs-12 col-sm-12 margin-top-10 margin-bottom-20">
								<toggle-control
									status="showDDBInput ? 'enabled-activity' : 'disabled-activity'"
									data-ng-click="onToggleUseDDBMetallic()">
								</toggle-control>
								<span for="partitionPath"><cv:msg key="label.useDeduplication"  bundle="storage" /></span>
							</div>
						</div>
						<div class="form-group margin-top-5" data-ng-if="showDDBInput">
							<label class="col-xs-5 col-sm-5" for="partitionPath">
								<cv-help-text help-label="<cv:msg key="label.deduplicationDBLocation"  bundle="storage" />" help-text="'<cv:msg key='label.ddbPartitionPathHelpText' bundle='storage' />'"/>
							</label>
							<div class="col-xs-7 col-sm-7 text-align-left">
								<div class="input-group">
									<input type="text" class="indexServerPath" name="ddbPartitionPath" id="partitionPath"
									data-ng-model="libraryInfo.ddbPartitionPath"
									data-ng-pattern='pathPattern.pattern' />
									<span class="input-group-btn">
										<button id="storagePoolGeneralTemplate_button_#7929" class="icon-style cv-material-button browse" data-ng-click="browseForPartitionPath({isDDBLocation: true})">
											<div class="cv-material-button-icon cursor-pointer">
												<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M0 0h24v24H0z" fill="none"/><path d="M19 4H5c-1.11 0-2 .9-2 2v12c0 1.1.89 2 2 2h4v-2H5V8h14v10h-4v2h4c1.1 0 2-.9 2-2V6c0-1.1-.89-2-2-2zm-7 6l-4 4h3v6h2v-6h3l-4-4z"/></svg>
											</div><div class="cv-material-button-tooltip"><cv:msg key="Browse" bundle="storage" /></div>
										</button>
									</span>
								</div>
								<span class="help-block" data-ng-show="inputRequired.DDB"><cv:msg key="error.partitionPathAdd" bundle="storage"/></span>
								<span class="help-block" data-ng-show="metallicStorageForm.ddbPartitionPath.$error.pattern"><cv:msg key="error.partitionPath.invalid" bundle="storage"/></span>
							</div>
						</div>
					</div>
				    <!-- // DDB location end// -->
				</div>
				<div class="button-container">
					<button id="metallicStorageForm_button_#3026" type="button" class="btn btn-default cvBusyOnAjax skip-btn--hidden" data-ng-if="isCurrentStepCompleted()" data-ng-click="skip()"><cv:msg key="Skip" /></button>
					<button id="metallicStorageForm_button_#2004" data-ng-if="isSetup" type="submit" class="btn margin-right-0 btn-primary cvBusyOnAjax" data-ng-click="addMetallicSP()" data-ng-disabled="metallicStorageForm.ddbPartitionPath.$error.pattern"><cv:msg key="action.save" bundle="storage"/></button>
				</div>
			</form>
		</div>
	</div>
</div>