<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
</script>
<h1 class="page-title">
	<span>
		<cv:msg key="title.addMetallicStorage" bundle="storage"/>
	</span>
</h1>
<div class="set-up-page">
	<div class="setup-content medium-width">
		<div class="bootstrap-wrapper form-horizontal padding-bottom-0">
			<div class="panel-default setup-panel">
				<div class="panel-body">
					<div class="col-xs-12">
						<form class="cloudStorageForm" name="metallicStorageForm" novalidate data-cv-submit="addMetallicSP()" autocomplete="off">
							<div class="group row">
								<cv-tile-component  data-ac-id="metallic_cloud-type" data-title='<cv:msg key="label.configureMetallic" bundle="storage"/>'>
									<div class="form-group">
										<label class="col-xs-5 col-sm-5" for="libraryName"><cv:msg key="Name" bundle="storage"/></label>
							    		<div id="libraryName" class="col-xs-7 col-sm-7 text-align-left">
							        		<input data-ng-class="{'has-error': cv.storageForm.needsAttention(storageForm.libraryName)}" type="text" name="libraryName" data-ng-model="libraryInfo.libraryEntity.libraryName" maxlength="128" data-ng-change="inputRequired.name = false" />
							        		<span class="help-block" data-ng-show="inputRequired.name"><cv:msg key="error.libraryName.required" bundle="storage"/></span>
							        	</div>
							        </div>
								</cv-tile-component>
								<cv-tile-component  data-ac-id="metallic_cloud-type" data-title='<cv:msg key="label.storage" bundle="storage"/>'>
									<div class="form-group">
								        <label for="mediaAgent" class="col-xs-5 col-sm-5"><cv:msg key="label.mediaAgent" bundle="storage"/></label>
								        <div class="col-xs-7 col-sm-7" id="mediaAgent">
							                <select-with-create-button
							                    select-id="mediaAgent"
							                    select-name="mediaAgent"
							                    key-label="displayName"
							                    key-id="mediaAgentId"
							                    option-list="agentList"
							                    selected-option="libraryInfo.mediaAgent"
							                    select-only-option="true"
							                    on-change-option="setMediaAgent"
							                    on-click-create-button="openCreateMediaAgentModal"
							                    is-required="true"
							                    has-error="inputRequired.mediaAgent"
							                    select-disabled="false"
							                    placeholder='<cv:msg key="placeholder.mediaAgent" bundle="storage"/>'
							                    is-credential="false">
							                </select-with-create-button>
							                <span class="help-block" data-ng-show="inputRequired.mediaAgent"><cv:msg key="error.mediaAgent" bundle="storage"/></span>
										</div>
									</div>
									<div class="form-group" data-ng-if="licenseTypeList.length > 1">
										<label class="col-xs-5 col-sm-5" for="licenseType"><cv:msg key="label.license" bundle="storage"/></label>
								        <div class="col-xs-7 col-sm-7">
											<isteven-multi-select
												directive-id="licenseTypeList"
												input-model="licenseTypeList"
												output-model="metallicStorageInfo.licenseType"
												button-label="label"
												item-label="label"
												id="licenseType"
												tick-property="selected"
												class="grid-filter-isteven-multi-select isteven-multi-select user-group-select grid-column-filter"
												helper-elements="none"
												selection-mode="single"
												on-item-click="setMetallicLicenseType(data)">
											</isteven-multi-select>
											<span class="help-block" data-ng-show="inputRequired.license"><cv:msg key="error.license" bundle="storage"/></span>
							        	</div>
							        </div>
									<div class="form-group">
										<label for="region" class="col-xs-5 col-sm-5"><cv:msg key="label.location" bundle="storage"/></label>
								        <div class="col-xs-7 col-sm-7">
											<isteven-multi-select
												directive-id="regionList"
												input-model="regionList"
												output-model="metallicStorageInfo.region"
												button-label="label"
												item-label="label"
												id="region"
												tick-property="selected"
												class="grid-filter-isteven-multi-select isteven-multi-select user-group-select grid-column-filter"
												helper-elements="none"
												selection-mode="single"
												on-item-click="setMetallicRegion(data)">
											</isteven-multi-select>
											<span class="help-block" data-ng-show="inputRequired.region"><cv:msg key="error.region" bundle="storage"/></span>
							        	</div>
									</div>
									<div class="form-group" data-ng-if="showMetallicInputs.storageClass">
										<label for="storageClass" class="col-xs-5 col-sm-5"><cv:msg key="label.storageClass" bundle="storage"/></label>
								        <div class="col-xs-7 col-sm-7">
											<isteven-multi-select
												directive-id="storageClassList"
												input-model="storageClassList"
												output-model="metallicStorageInfo.storageClass"
												button-label="label"
												item-label="label"
												id="storageClass"
												tick-property="selected"
												class="grid-filter-isteven-multi-select isteven-multi-select user-group-select grid-column-filter"
												helper-elements="none"
												selection-mode="single"
												on-item-click="setMetallicStorageClass(data)">
											</isteven-multi-select>
											<span class="help-block" data-ng-show="inputRequired.storageClass"><cv:msg key="error.storageClass" bundle="storage"/></span>
							        	</div>
									</div>
									<div class="form-group" data-ng-if="showMetallicInputs.replication">
										<label for="replication" class="col-xs-5 col-sm-5"><cv:msg key="label.replication" bundle="storage"/></label>
								        <div class="col-xs-7 col-sm-7">
											<isteven-multi-select
												directive-id="replicationList"
												input-model="replicationList"
												output-model="metallicStorageInfo.replication"
												button-label="label"
												item-label="label"
												id="replication"
												tick-property="selected"
												class="grid-filter-isteven-multi-select isteven-multi-select user-group-select grid-column-filter"
												helper-elements="none"
												selection-mode="single"
												on-item-click="setMetallicReplication(data)">
											</isteven-multi-select>
											<span class="help-block" data-ng-show="inputRequired.replication"><cv:msg key="error.replication" bundle="storage"/></span>
							        	</div>
									</div>
								    <!-- // DDB location start// -->
							        <div class="form-group text-align-left margin-top-20" data-ng-class="{'margin-bottom-20' : !showDDBInput}">
							            <toggle-control
							            class="margin-right-5 margin-left-15"
							                status="showDDBInput ? 'enabled-activity' : 'disabled-activity'"
							                data-ng-click="onToggleUseDDBMetallic()"> </toggle-control>
							            <span for="partitionPath"><cv:msg key="label.useDeduplication"  bundle="storage" /></span>
							        </div>
							        <div data-ng-if="showDDBInput" class="margin-bottom-20">
										<cv-kendo-grid data-cv-grid-options="addMetallicDDBGridOptions"></cv-kendo-grid>
										<span class="margin-right-5 margin-left-15 help-block" data-ng-show="inputRequired.DDB"><cv:msg key="error.partitionPathAdd" bundle="storage"/></span>
									</div>
								    <!-- // DDB location end// -->
								</cv-tile-component>

								<div class="button-container">
									<button id="addCloudStorage_button_#5532" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="cancel()">
										<cv:msg key="Cancel" bundle="messages"/>
									</button>
									<button id="addCloudStorage_button_#3208"  class="btn margin-right-0 btn-primary cvBusyOnAjax" type="submit">
										<cv:msg key="action.save" bundle="storage"/>
									</button>
								</div>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>