<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1>
		<cv:msg key="title.exportMediaListBased" bundle="storage" />
	</h1>
</div>
<div class="setup-content">
<div class="{{generalSetupMessage.type}} serverMessage">{{generalSetupMessage.message}}</div>
	<form name="exportMediaForm" novalidate data-cv-submit="exportMedia()"
		autocomplete="off" class="edit-users-grid-form">		
		<div class="margin-left-right">
			<h4>
				<cv:msg key="title.selectMediatoExport" bundle="storage" />
			</h4>
		</div>		
		<div class="margin-left-right more-height-overflow-scroll">
			<cv-grid cv-grid-options="gridOptions"></cv-grid>
		</div>
		<div class="panel-body margin-top-30">
			<div class="row padding-left-20 padding-top-15">
				<span class="col-md-6 col-xs-6 padding-top-10 backup-window-list">
					<cv:msg key="label.exportDestination" bundle="storage" />
				</span>
				<span class="col-md-6 col-xs-6 backup-window-list">
					<select-and-create
						available-options="availableDestinations"
						select-id="'toExportDestination'"
						selected-option="data.exportDestination.value"
						on-item-click="arrayControllerSelection()"
						ng-if="isLoadedLocations">
					</select-and-create>
					<div class="error float-left margin-0 padding-top-10" data-ng-if="data.exportDestination.hasError">
						<cv:msg key="error.exportDestination" bundle="schedule"/>
					</div>
				</span>
			</div>
			<div class="row padding-left-20 padding-top-15" ng-if="bShowVaultTrackerChanges">
				<span class="col-md-6 col-xs-6 padding-top-10 backup-window-list">
					<cv:msg key="label.trackTransit" bundle="storage" />
				</span>
				<div class="error text-left float-left margin-0 padding-top-10">
					<toggle-control data-ng-class="{'enabled-activity': data.trackTransit.isShow , 'disabled-activity': !data.trackTransit.isShow}"
									status="data.trackTransit.isShow ? 'enabled-activity' : 'disabled-activity'" data-ng-click="changeValue('trackTransit')">
					</toggle-control>
				</div>
			</div>
			<div class="row padding-left-20 padding-top-15" data-ng-if="data.trackTransit.isShow">
				<span class="col-md-6 col-xs-6 padding-top-10 backup-window-list">
					<cv:msg key="label.trackTransitLocation" bundle="storage" />
				</span>
				<span class="col-md-6 col-xs-6 backup-window-list">
					<select-and-create
						available-options="availableTransit"
						select-id="'toTrackTransit'"
						selected-option="data.trackTransit.value"
						on-item-click="arrayControllerSelection()"
						ng-if="isLoadedLocations">
					</select-and-create>
					<div class="error margin-0 ng-scope help-block" data-ng-if="data.trackTransit.hasError">
						<cv:msg key="error.trackTransit" bundle="schedule"/>
					</div>
				</span>
			</div>
		</div>
		
		<div class="button-container">
			<fmt:bundle basename="localization.messages">
				<button id="ExportMedia_button_#9005" type="button" 
					class="btn btn-default cvBusyOnAjax setup-btn--hidden"
					data-ng-click="cancel()">
					<cv:msg key="Cancel" bundle="messages" />
				</button>
				<button id="ExportMedia_button_#5366" type="submit" class="btn btn-primary cvBusyOnAjax"> 
					<cv:msg key="action.save" bundle="storage" />
				</button>
			</fmt:bundle>
	</form>
</div>
