export const getMountPathName = ({ cvLoc, isRPStore, stateName, storagePool }) => ({
	//#storagePoolMountPath?storagePoolName=disk333333&storagePoolId=27&storagePoolType=DEDUPLICATION&libraryId=26&libraryName=121&model=Disk&mountPathId=20
	mountPathName: {
		title: cvLoc('Name'),
		searchField: 'mountPathName',
		width: '45%',
		template: `
            <span class="crop" cv-toggle="tooltip" cv-toggle-content="#:mountPathName#">
                #if (${!!isRPStore}) {#
                    #:mountPathName#
                #} else if ((${!isRPStore}) && (${stateName === 'diskLibraryDetails'})) {#
                    <a uib-tooltip="#:mountPathName#" tooltip-append-to-body="true" tooltip-placement="bottom" href="\\#mountPath?libraryId=#:mountPathSummary.libraryId#&libraryName=#:mountPathSummary.libraryName#&model=#:model#&storagePoolType=${
											storagePool.type
										}&mountPathId=#:mountPathId#">#:mountPathName#</a>
                #} else if ((${!isRPStore}) && (${stateName === 'cloudStoragePoolDetails'})) {#
                    <a uib-tooltip="#:mountPathName#" tooltip-append-to-body="true" tooltip-placement="bottom" href="\\#cloudMountPath?storagePoolName=${
											storagePool.name
										}&storagePoolId=${storagePool.id}&storagePoolType=${
			storagePool.type
		}&libraryId=#:mountPathSummary.libraryId#&libraryName=#:mountPathSummary.libraryName#&model=#:model#&mountPathId=#:mountPathId#&libraryVendorId=${
			storagePool.libraryVendorId
		}">#:mountPathName#</a>
                #} else if (${!isRPStore}) {#
                    <a uib-tooltip="#:mountPathName#" tooltip-append-to-body="true" tooltip-placement="bottom" href="\\#diskMountPath?storagePoolName=${
											storagePool.name
										}&storagePoolId=${storagePool.id}&storagePoolType=${
			storagePool.type
		}&libraryId=#:mountPathSummary.libraryId#&libraryName=#:mountPathSummary.libraryName#&model=#:model#&mountPathId=#:mountPathId#">#:mountPathName#</a>
                #}#
            </span>`
		/*
		 * <a
		 * href="\\#/storagePoolMountPath?storagePoolName=disk333333&storagePoolId=27&storagePoolType=DEDUPLICATION&libraryId=26&libraryName=121&model=Disk&mountPathId=20"></a>
		 */
		// </span>`
		// template: `#if (${!!isRPStore}) {#
		// <span class="CROP" title="#:mountPathName#">#:mountPathName#</span>
		// #} else if ((${!isRPStore}) && (${stateName === 'diskLibraryDetails'})) {#
		// template:  '<span class="CROP" title="#:mountPathName#"><a uib-tooltip="#:mountPathName#" tooltip-append-to-body="true" tooltip-placement="bottom" href="#mountPath?libraryId=#:mountPathSummary.libraryId#&libraryName=#:mountPathSummary.libraryName#&model=#:model#&storagePoolType=#:storagePoolType#&mountPathId=#:mountPathId#">#:mountPathName#</a></span>'
		// #} else if (${!isRPStore}) {#
		//     <a uib-tooltip="#:mountPathName#" tooltip-append-to-body="true" tooltip-placement="bottom" href="#storagePoolMountPath?storagePoolName=#:storagePoolName#&storagePoolId=#:storagePoolId#&storagePoolType=#:storagePoolType#&libraryId=#:mountPathSummary.libraryId#&libraryName=#:mountPathSummary.libraryName#&model=#:model#&mountPathId=#:mountPathId#">#:mountPathName#</a>
		// #}#`

		//       cellTemplate: '<span class="CROP" title="{{row.entity.mountPathName}}" data-ng-if="grid.appScope.isRPStore">{{row.entity.mountPathName}}</span>
		// <a  uib-tooltip="{{row.entity.mountPathName}}" tooltip-append-to-body="true" tooltip-placement="bottom" data-ng-if="((!grid.appScope.isRPStore) && (grid.appScope.stateName === \'diskLibraryDetails\'))" href="#mountPath?libraryId={{row.entity.mountPathSummary.libraryId}}&libraryName={{row.entity.mountPathSummary.libraryName | encodeParam}}&model={{grid.appScope.model}}&storagePoolType={{grid.appScope.libDetails.storagePoolType}}&mountPathId={{row.entity.mountPathId}}">{{row.entity.mountPathName}}</a>'
		// + '<a uib-tooltip="{{row.entity.mountPathName}}" tooltip-append-to-body="true" tooltip-placement="bottom" data-ng-if="((!grid.appScope.isRPStore) && (grid.appScope.stateName === \'diskStoragePoolDetails\'))" href="#storagePoolMountPath?storagePoolName={{grid.appScope.storagePoolName | encodeParam}}&storagePoolId={{grid.appScope.storagePoolId}}&storagePoolType={{grid.appScope.storagePoolType}}&libraryId={{row.entity.mountPathSummary.libraryId}}&libraryName={{row.entity.mountPathSummary.libraryName | encodeParam}}&model={{grid.appScope.model}}&mountPathId={{row.entity.mountPathId}}">{{row.entity.mountPathName}}</a>',

		// template: '<span class="CROP" title="#:mountPathName#">#:mountPathName#</span>
		// + '<a uib-tooltip="#:mountPathName#" tooltip-append-to-body="true" tooltip-placement="bottom" href="#storagePoolMountPath?storagePoolName=#:storagePoolName:&storagePoolId=#:storagePoolId#&storagePoolType=#:storagePoolType#&libraryId=#:mountPathSummary.libraryId#&libraryName=#:mountPathSummary.libraryName#&model=#:model#&mountPathId=#:mountPathId#">#:mountPathName#</a>',
	}
	// storagePoolType=#:libDetails.storagePoolType#/
	// data-ng-if="grid.appScope.isRPStore"
	// data-ng-if="((!grid.appScope.isRPStore) && (grid.appScope.stateName === \'diskLibraryDetails\'))"
	// data-ng-if="((!grid.appScope.isRPStore) && (grid.appScope.stateName === \'diskStoragePoolDetails\'))"
	// storagePoolName | encodeParam
	// storagePoolId, storagePoolType, libraryName | encodeParam
});

export const getDeviceNmae = cvLoc => ({
	deviceName: {
		searchField: 'deviceInfo.name',
		title: cvLoc('label.deviceName'),
		cellClass: 'crop',
		cvUserPref: 'deviceName',
		enableHiding: !$scope.isRPStore,
		visible: !$scope.isRPStore
	}
});

export const getStatusColumn = cvLoc => ({
	status: {
		searchField: 'status',
		title: cvLoc('label.status'),
		template:
			'<div class="ellipsis-parent"><span class="ellipsis-content" uib-tooltip="#:status#" tooltip-append-to-body="true" tooltip-placement="left">#:status#</span></div>',
		width: '35%',
		type: 'string'
	}
});

export const getModelColumn = cvLoc => ({
	model: {
		searchField: 'model',
		title: cvLoc('label.model'),
		template:
			'<div class="ellipsis-parent"><span class="ellipsis-content" uib-tooltip="#:model#" tooltip-append-to-body="true" tooltip-placement="left">#:model#</span></div>',
		width: '10%',
		type: 'string'
	}
});

export const getStatusColumn1 = cvLoc => ({
	status: {
		type: 'string',
		width: '20%',
		searchField: 'status',
		title: cvLoc('label.status'),
		template:
			'<div class="ellipsis-parent"><span class="ellipsis-content" uib-tooltip="#:status#}}" tooltip-append-to-body="true" tooltip-placement="left" >#:status#</span></div>'
	}
});

export const getStoragePoolTypeColumn = cvLoc => ({
	storagePoolType: {
		type: 'string',
		searchField: 'storagePoolType',
		width: '20%',
		title: cvLoc('label.Type'),
		template:
			'<span class="crop" title="#:storagePoolType# | storagePoolTypeName">#:storagePoolType# | storagePoolTypeName</span>'
	}
});

export const getTotalCapacity = cvLoc => ({
	totalCapacity: {
		title: cvLoc('label.capacity'),
		searchField: 'totalCapacity',
		type: 'string',
		width: '10%',
		template:
			'<span class="crop" title="{{#:totalCapacity*1024*1024# | dataSizeString}}">#:totalCapacity*1024*1024#  | dataSizeString</span>'
	}
});
export const getTotalFreeSpace = cvLoc => ({
	totalFreeSpace: {
		title: cvLoc('label.freeSpace'),
		searchField: 'totalFreeSpace',
		template:
			'<span class="crop" title="#:totalFreeSpace*1024*1024# | dataSizeString">#:totalFreeSpace*1024*1024#  | dataSizeString</span>',
		//         enableFiltering: false
		type: 'string',
		width: '10%'
	}
});

export const getActionsColumn = function(cvLoc) {
	return {
		action: {
			title: cvLoc('label.actions'),
			type: 'string',
			template: `<div class="permittedActions"></div>`,
			disableViewFiltering: true,
			sortable: false,
			disableColumnFilter: true,
			width: '15%',
			attributes: {
				class: 'permitted-actions'
			}
		}
	};
};

export const getStoragePoolColumnTemplate = angularLibs => ({
	// ...getStoragePoolName(angularLibs.cvLoc),
	...getStatusColumn1(angularLibs.cvLoc),
	...getStoragePoolTypeColumn(angularLibs.cvLoc),
	...getTotalCapacity(angularLibs.cvLoc),
	...getTotalFreeSpace(angularLibs.cvLoc)
});

export const getMountPathColumnTemplate = angularLibs => ({
	...getMountPathName(angularLibs),
	...getStatusColumn(angularLibs.cvLoc),
	...getActionsColumn(angularLibs.cvLoc)
});

// angular.extend(mountpathGridOptions, {
//     data: 'mountPaths',
//     showGridFooter: true,
//     columnDefs : [{
//       field: "mountPathName",
//       sort: {
//         direction: 'asc',
//         priority: 0
//       },
//       displayName: cvLoc("Name"),
//       cellClass: "crop",
//       cellTemplate: '<span class="CROP" title="{{row.entity.mountPathName}}" data-ng-if="grid.appScope.isRPStore">{{row.entity.mountPathName}}</span><a  uib-tooltip="{{row.entity.mountPathName}}" tooltip-append-to-body="true" tooltip-placement="bottom" data-ng-if="((!grid.appScope.isRPStore) && (grid.appScope.stateName === \'diskLibraryDetails\'))" href="#mountPath?libraryId={{row.entity.mountPathSummary.libraryId}}&libraryName={{row.entity.mountPathSummary.libraryName | encodeParam}}&model={{grid.appScope.model}}&storagePoolType={{grid.appScope.libDetails.storagePoolType}}&mountPathId={{row.entity.mountPathId}}">{{row.entity.mountPathName}}</a>' + '<a uib-tooltip="{{row.entity.mountPathName}}" tooltip-append-to-body="true" tooltip-placement="bottom" data-ng-if="((!grid.appScope.isRPStore) && (grid.appScope.stateName === \'diskStoragePoolDetails\'))" href="#storagePoolMountPath?storagePoolName={{grid.appScope.storagePoolName | encodeParam}}&storagePoolId={{grid.appScope.storagePoolId}}&storagePoolType={{grid.appScope.storagePoolType}}&libraryId={{row.entity.mountPathSummary.libraryId}}&libraryName={{row.entity.mountPathSummary.libraryName | encodeParam}}&model={{grid.appScope.model}}&mountPathId={{row.entity.mountPathId}}">{{row.entity.mountPathName}}</a>',
//       enableHiding: false
//     }, {
//       field: "deviceInfo.name",
//       displayName: cvLoc("label.deviceName"),
//       cellClass: "crop",
//       cvUserPref: "deviceName",
//       enableHiding: !$scope.isRPStore,
//       visible: !$scope.isRPStore
//     }, {
//       field: "status",
//       displayName: cvLoc("label.status"),
//       cellTemplate: '<div class="ellipsis-parent"><span class="ellipsis-content" uib-tooltip="{{row.entity.status}}" tooltip-append-to-body="true" tooltip-placement="left" >{{row.entity.status}}</span></div>',
//       cvUserPref: "status"
//     }, {
//       field: "jobIds",
//       displayName: cvLoc("label.jobID"),
//       cellTemplate: '<div class="ellipsis-parent"><span class="ellipsis-content" uib-tooltip="{{row.entity.jobIds}}" tooltip-append-to-body="true" tooltip-placement="left" >{{row.entity.jobIds}}</span></div>',
//       cvUserPref: "jobIds",
//       enableHiding: !$scope.isRPStore,
//       visible: !$scope.isRPStore
//     }, {
//       field: "mediaAgents",
//       displayName: cvLoc("label.mediaAgentName"),
//       cvUserPref: "mediaAgentName",
//       enableHiding: !$scope.isRPStore,
//       visible: !$scope.isRPStore
//     }, {
//       name: cvLoc('Actions'),
//       cellTooltip: true,
//       cellTemplate: '<div class="btn-group" uib-dropdown><a href class="uib-dropdown-toggle" uib-dropdown-toggle data-ng-disabled="disabled"><span class="grid-action-icon">
//</span></a><ul uib-dropdown-menu class="dropdown-menu" role="menu">' + '<li data-ng-if="!grid.appScope.isRPStore">
//<a class="crop" data-ng-click="grid.appScope.deleteMountPath(row.entity.mountPathId, row.entity.mountPathName, row.entity.mountPathSummary.libraryId, row.entity.mountPathSummary.libraryName);">'
// + cvLoc('action.delete') + '</a></li>' + '<li><a data-ng-if="grid.appScope.libDetails.storagePoolType!=\'SCALE_OUT\'" href="" data-ng-click="grid.appScope.openWizard(row.entity.mountPathId, row.entity.mountPathName, row.entity.deviceInfo.id, row.entity.dataServerType);">' + cvLoc('action.share') + '</a></li></ul></div>',
//       width: '10%',
//       enableFiltering: false,
//       enableSorting: false,
//       enableHiding: false
//     }]
//   });

//   $scope.addMountPath = function () {
//     $scope.addMountPath($scope.libraryId, $scope.libraryName, $scope.model);
//   };
//   $scope.gridOptions = {
//     cvPageLinks: [{
//       label: $scope.title,
//       show: "showAddOption",
//       onclick: $scope.addMountPath
//     }],
//     cvGridTitle: $scope.fromStoragePool ? cvLoc("label.storage") : cvLoc("label.mountPaths"),
//     cvIsPageTitle: false,
//     cvTableName: $scope.isRPStore ? "rpStoreDetailTable":"diskLibraryDetailsTable",
//     cvSearchFields:$scope.isRPStore ?['mountPathName']: ['mountPathName', 'deviceInfo.name', 'mediaAgents'],
//     cvServerMessage: "storagePoolMessage",
//     gridOptions: mountpathGridOptions
//   };
