import { commonStorageModule } from 'common/js/modules';

commonStorageModule.service('VaultTrackerService', [
	'$http',
	function($http) {
		this.getVaultTrackerDetails = function(policyId) {
			const request = $http.get(`proxy/VaultTrackerPolicy/${policyId}`, httpHeader['jsonDefaultHeader']);
			return request;
		};

		this.putVaultTrackerDetails = function(body, policyId) {
			const request = $http.put(`proxy/VaultTrackerPolicy/${policyId}`, body, httpHeader['jsonDefaultHeader']);
			return request;
		};

		this.postVaultTracker = function(body) {
			const request = $http.post(`proxy/VaultTrackerPolicy`, body, httpHeader['jsonDefaultHeader']);
			return request;
		};

		this.getLocations = function() {
			const request = $http.get(`proxy/Locations`, httpHeader['jsonDefaultHeader']);
			return request;
		};

		this.deleteVaultTracker = function(policyId, body, force) {
			const request = $http.delete(
				`proxy/VaultTrackerPolicy/${policyId}?force=${force}`,
				body,
				httpHeader['jsonDefaultHeader']
			);
			return request;
		};

		this.getVTSchedule = function(policyId) {
			const request = $http.get(`proxy/Schedules?trackingPolicyId=${policyId}`, httpHeader['jsonDefaultHeader']);
			return request;
		};

		this.getVTScheduleDetails = function(schedule) {
			return $http.get(
				'GetScheduleDetails.do?taskId=' + schedule.taskId + '&subtaskId=' + schedule.subtaskId + '&isSchedule=true'
			);
		};

		this.runNowVaultTracker = function(policyId, body) {
			return $http.post(`proxy/CreateTask`, body, httpHeader['jsonDefaultHeader']);
		};
	}
]);

export default commonStorageModule;
