import 'modules/storage/js/controllers/storage.ctrl.js';
import 'adminConsole/js/controllers/cloudLibConstants.js';

import { acAppStorageModule } from 'common/js/modules';

var storageMod = acAppStorageModule;

storageMod.filter('accessType', [
	'cvLoc',
	'StorageConstants',
	function(cvLoc, StorageConstants) {
		var getStringForAccessType = function(val) {
			var ret = '';
			if ((val & StorageConstants.READ_DEVICEACCESS) != 0 && (val & StorageConstants.WRITE_DEVICEACCESS) == 0) {
				ret = cvLoc('label.read');
			} else if ((val & StorageConstants.READWRITE_DEVICEACCESS) != 0) {
				ret = cvLoc('label.readWrite');
			}

			return ret;
		};

		return function(accessType) {
			return getStringForAccessType(accessType);
		};
	}
]);

storageMod.filter('accessTypeValue', [
	'cvLoc',
	'StorageConstants',
	function(cvLoc, StorageConstants) {
		var getAccessType = function(val) {
			var ret = 0;
			if ((val & StorageConstants.READ_DEVICEACCESS) != 0 && (val & StorageConstants.WRITE_DEVICEACCESS) == 0) {
				ret = StorageConstants.READ_DEVICEACCESS;
			} else if ((val & StorageConstants.READWRITE_DEVICEACCESS) != 0) {
				ret = StorageConstants.READWRITE_DEVICEACCESS;
			}

			return ret;
		};

		return function(accessType) {
			return getAccessType(accessType);
		};
	}
]);

storageMod.filter('TransportTypeString', [
	'cvLoc',
	'StorageConstants',
	function(cvLoc, StorageConstants) {
		var getStringForTransportType = function(val) {
			var ret = '';
			if ((val & StorageConstants.DATASERVER_FC_DEVICEACCESS) != 0) {
				ret = cvLoc('label.dataServerFC');
			} else if ((val & StorageConstants.DATASERVER_iSCSI_DEVICEACCESS) != 0) {
				ret = cvLoc('label.dataServeriSCSI');
			} else if ((val & StorageConstants.DATASERVER_IP_DEVICEACCESS) != 0) {
				ret = cvLoc('label.dataServerIP');
			}

			return ret;
		};

		return function(transportType) {
			return getStringForTransportType(transportType);
		};
	}
]);

storageMod.filter('TransportType', [
	'cvLoc',
	'StorageConstants',
	function(cvLoc, StorageConstants) {
		var getValueForTransportType = function(val) {
			var ret = 0;
			if ((val & StorageConstants.DATASERVER_FC_DEVICEACCESS) != 0) {
				ret = StorageConstants.DATASERVER_FC_DEVICEACCESS;
			} else if ((val & StorageConstants.DATASERVER_iSCSI_DEVICEACCESS) != 0) {
				ret = StorageConstants.DATASERVER_iSCSI_DEVICEACCESS;
			} else if ((val & StorageConstants.DATASERVER_IP_DEVICEACCESS) != 0) {
				ret = StorageConstants.DATASERVER_IP_DEVICEACCESS;
			}

			return ret;
		};

		return function(accessType) {
			return getValueForTransportType(accessType);
		};
	}
]);

storageMod.filter('numWriters', [
	'cvLoc',
	function(cvLoc) {
		var getStringForWriters = function(val) {
			var ret = '';
			if (val == -1) {
				ret = cvLoc('label.max');
			} else if (val == 0) {
				ret = cvLoc('label.N_SLASH_A');
			} else {
				ret = '' + val;
			}
			return ret;
		};

		return function(numWriters) {
			return getStringForWriters(numWriters);
		};
	}
]);

storageMod.filter('yesNo', [
	'cvLoc',
	function(cvLoc) {
		var getAccessibleString = function(val) {
			return val === 1 || val == true ? cvLoc('label.yes') : cvLoc('label.no');
		};

		return function(enabled) {
			return getAccessibleString(enabled);
		};
	}
]);

storageMod.filter('cloudVendorNames', [
	'cvLoc',
	'CLOUD_TYPE_LIST',
	function(cvLoc, CLOUD_TYPE_LIST) {
		var getCloudVendorNames = function(val) {
			var ret = '';
			for (var i = 0; i < CLOUD_TYPE_LIST.CloudType.length; i++) {
				if (CLOUD_TYPE_LIST.CloudType[i].id === val) {
					ret = CLOUD_TYPE_LIST.CloudType[i].name;
					break;
				}
			}
			if (ret === '') {
				ret = cvLoc('label.cloud');
			}
			return ret;
		};

		return function(cloudVendorNames) {
			return getCloudVendorNames(cloudVendorNames);
		};
	}
]);

export default storageMod;
