import { commonStorageModule } from 'common/js/modules';

class SupportMultipleDDBLocationHelper {
	constructor(cvLoc, cvUtil, $dialogs) {
		this.cvLoc = cvLoc;
		this.cvUtil = cvUtil;
		this.$dialogs = $dialogs;
	}

	getController(isDiskStorageForMultipleDDBs) {
		return isDiskStorageForMultipleDDBs ? 'createStoragePoolController' : 'addStorageController';
	}

	getTemplateController(isDiskStorageForMultipleDDBs) {
		return isDiskStorageForMultipleDDBs
			? 'webScale/partials/storagePoolGeneralTemplate.jsp'
			: 'adminConsole/partials/addCloudStorage.jsp';
	}

	getGridColumns(isDiskStorageForMultipleDDBs) {
		return {
			'storageInfo.mediaAgent.displayName': {
				title: this.cvLoc('label.mediaAgentName'),
				type: 'string',
				width: '20%',
				attributes: {},
				template: `<a> #:storageInfo.mediaAgent.displayName# </a>`
			},
			'storageInfo.mountPath': {
				title: isDiskStorageForMultipleDDBs ? this.cvLoc('label.backupLocation') : this.cvLoc('label.Bucket'),
				type: 'string',
				width: '29%',
				attributes: {},
				template: `
          #if(storageInfo.mountPath) {#
          <span> #:storageInfo.mountPath# </span>
          #}else {#
              <span> ${this.cvLoc('label.N_SLASH_A')} </span>
          #};#
        `
			},
			'storageInfo.ddbPartitionPath': {
				title: this.cvLoc('label.ddbLocation'),
				type: 'string',
				width: '29%',
				attributes: {},
				template: `
          #if(storageInfo.ddbPartitionPath) {#
              <span> #:storageInfo.ddbPartitionPath# </span>
              #}else {#
              <span> ${this.cvLoc('label.N_SLASH_A')} </span>
          #};#
        `
			},
			'storageInfo.mediaAgent.mediaAgentId': {
				title: '',
				filterable: false,
				searchable: false,
				type: 'string',
				width: '10%',
				disableViewFiltering: true,
				disableColumnFilter: true,
				sortable: false,
				attributes: {
					class: 'permitted-actions'
				},
				template: `<a class="k-icon k-i-delete k-i-trash k-grid-delete-copy"></a>`
			}
		};
	}

	shouldShowAddButtonFromGrid({
		isCloudStorageForMultipleDDBs,
		multipleDDBsListForNewDiskOrCloud,
		partitionList,
		grid
	}) {
		const [primary] = multipleDDBsListForNewDiskOrCloud;
		const isFirstMADeduplication = primary.storageInfo.isDeduplication;

		// double !! is only because in other controller isCloudStorageForMultipleDDBs is not defined
		if (!!isCloudStorageForMultipleDDBs) {
			if (
				partitionList.length === 4 ||
				(!isFirstMADeduplication && partitionList.length === 0) ||
				primary.storageInfo.cloudLibInfo.serverType === 59
			) {
				grid.gridToolbarMenu.hide('AddMediAgentForDiskorCloud');
			} else if (
				multipleDDBsListForNewDiskOrCloud.length > 0 &&
				(isFirstMADeduplication || (!isFirstMADeduplication && partitionList.length > 0))
			) {
				grid.gridToolbarMenu.show('AddMediAgentForDiskorCloud');
			}
		} else {
			grid.gridToolbarMenu.show('AddMediAgentForDiskorCloud');
		}
	}

	getConfigDiskObject(storageInfo, name, primary) {
		return {
			storageId: storageInfo.storageId,
			isFirstMA: storageInfo.isFirstMA,
			name: name,
			configureStorage: {
				createNew: true,
				library: {
					id: 0,
					name: null
				},
				mediaAgent: {
					mediaAgentId: storageInfo.mediaAgent.mediaAgentId,
					mediaAgentName: storageInfo.mediaAgent.mediaAgentName,
					displayName: storageInfo.mediaAgent.displayName
				},
				distributedStorage: angular.copy(storageInfo.distributedStorage),
				mountPath: storageInfo.mountPath,
				scaleoutAgentList: {
					mediaAgentId: 0,
					mediaAgentName: null
				},
				storagepoolType: '0',
				userName: storageInfo.userName,
				password: storageInfo.password,

				scaleoutconfigType: 'Good',
				credential: storageInfo.credential
			},
			ddbPartitionPath: storageInfo.ddbPartitionPath,
			isDeduplication: storageInfo.isDeduplication
		};
	}

	getConfigCloudObject(storageInfo, name, primary, serverType) {
		return {
			storageId: storageInfo.storageId,
			isFirstMA: storageInfo.isFirstMA,
			libraryEntity: {
				libraryName: name
			},
			mountPath: {
				id: '',
				name: storageInfo.isFirstMA ? primary.storageInfo.mountPath : ''
			},
			loginName: primary.storageInfo.cloudLibInfo.loginName,
			password: primary.storageInfo.cloudLibInfo.password,
			serverType: serverType,
			serviceHost: primary.storageInfo.serviceHost,
			selectedCredential:
				primary.storageInfo.selectedCredential !== null
					? {
							credentialId: primary.storageInfo.selectedCredential.credentialId,
							credentialName: primary.storageInfo.selectedCredential.credentialName
					  }
					: null,
			controller: { ...storageInfo.mediaAgent, storageClassId: primary.storageInfo.storageClass.id },
			ddbPartitionPath: storageInfo.ddbPartitionPath,
			isDeduplsication: storageInfo.isDeduplication,
			storageClass: { ...primary.storageInfo.storageClass }
		};
	}

	getIndexByStorageId(mpList, config) {
		const item = mpList.find(mp => mp.storageInfo.storageId === config.storageId);
		return mpList.indexOf(item);
	}

	tranformNewDiskConfig({ multipleDDBsListForNewDiskOrCloud }) {
		const getUserNameAndPassword = disk => {
			if (!disk.storageInfo.userName && !disk.storageInfo.password) {
				return {};
			} else {
				return disk.storageInfo.userName && disk.storageInfo.password
					? {
							credentials: {
								userName: disk.storageInfo.userName,
								password: cvUtil.toUTF8Array(disk.storageInfo.password)
							}
					  }
					: {
							credentials: {
								userName: disk.storageInfo.userName
							}
					  };
			}
			// return disk.storageInfo.userName && disk.storageInfo.password
			// 	? {
			// 			credentials: {
			// 				userName: disk.storageInfo.userName,
			// 				password: cvUtil.toUTF8Array(disk.storageInfo.password)
			// 			}
			// 	  }
			// 	: {};
		};

		const getSavedCredentials = disk => {
			return disk.storageInfo.credential && disk.storageInfo.credential.length > 0
				? {
						savedCredential: {
							credentialId: disk.storageInfo.credential[0].credentialId,
							credentialName: disk.storageInfo.credential[0].credentialName
						}
				  }
				: {};
		};

		const getNetworkCredentials = disk => {
			return {
				...getSavedCredentials(disk),
				...getUserNameAndPassword(disk)
			};
		};

		return multipleDDBsListForNewDiskOrCloud
			.filter(_disk => {
				return _disk.storageInfo.mountPath && _disk.storageInfo.mountPath !== '';
			})
			.map(disk => ({
				mediaAgent: {
					...disk.storageInfo.mediaAgent
				},
				distributedStorage:
					disk.storageInfo.distributedStorage && disk.storageInfo.distributedStorage[0]
						? angular.copy(disk.storageInfo.distributedStorage[0])
						: angular.copy(disk.storageInfo.distributedStorage),
				path: disk.storageInfo.mountPath,
				...getNetworkCredentials(disk)
			}));
	}

	onInitialCloudToGrid(
		storageInfo,
		{ multipleDDBsListForNewDiskOrCloud, getLoginName, getPassword, configureAuthCloud }
	) {
		return {
			storageId: this.cvUtil.generateUUID(),
			isFirstMA: storageInfo.isFirstMA,
			name: storageInfo.libraryEntity.libraryName,
			configureStorage: {
				mediaAgent: { ...storageInfo.controller },
				mountPath: storageInfo.mountPath.name
			},
			ddbPartitionPath: storageInfo.ddbPartitionPath,
			isDeduplication: storageInfo.isDeduplication,
			// This condition is only to prevent add data that you only need for 1st data item of grid
			cloudLibInfo: {
				...(multipleDDBsListForNewDiskOrCloud.length === 0
					? {
							serverType: storageInfo.serverType.id,
							loginName: getLoginName(storageInfo),
							authType: configureAuthCloud.storageAuthenticationType.id,
							password: getPassword(storageInfo),
							serverName: storageInfo.serviceHost,
							serverHost: storageInfo.storageClass
								? `${storageInfo.serviceHost}@${storageInfo.storageClass.id}`
								: storageInfo.serviceHost
					  }
					: {})
			},
			selectedCredential: storageInfo.selectedCredential,
			storageClass: storageInfo.storageClass,
			serviceHost: storageInfo.serviceHost
		};
	}

	onEditCloudToGrid(storageInfo, { getLoginName, getPassword, configureAuthCloud }) {
		return {
			storageId: storageInfo.storageId,
			isFirstMA: storageInfo.isFirstMA,
			name: storageInfo.libraryEntity.libraryName,
			configureStorage: {
				mediaAgent: { ...storageInfo.controller },
				mountPath: storageInfo.mountPath.name
			},
			ddbPartitionPath: storageInfo.ddbPartitionPath,
			isDeduplication: storageInfo.isDeduplication,
			// This condition is only to prevent add data that you only need for 1st data item of grid
			cloudLibInfo: {
				...(storageInfo.isFirstMA
					? {
							serverType: storageInfo.serverType.id,
							loginName: getLoginName(storageInfo),
							authType: configureAuthCloud.storageAuthenticationType.id,
							password: getPassword(storageInfo),
							serverName: storageInfo.serviceHost,
							serverHost: storageInfo.storageClass
								? `${storageInfo.serviceHost}@${storageInfo.storageClass.id}`
								: storageInfo.serviceHost
					  }
					: {})
			},
			selectedCredential: storageInfo.selectedCredential,
			storageClass: storageInfo.storageClass,
			serviceHost: storageInfo.serviceHost
		};
	}

	buildStorageInfo(globalTemplate, $scope) {
		const { multipleDDBsListForNewDiskOrCloud, isDiskStorageForMultipleDDBs, isCloudStorageForMultipleDDBs } = $scope;
		const returnedStorage = {
			storageInfo: {
				storageId: globalTemplate.storageId || cvUtil.generateUUID(),
				isFirstMA: multipleDDBsListForNewDiskOrCloud.length === 0 || !!globalTemplate.isFirstMA,
				mediaAgent: { ...globalTemplate.configureStorage.mediaAgent },
				distributedStorage: { ...globalTemplate.configureStorage.distributedStorage },
				ddbPartitionPath: globalTemplate.ddbPartitionPath,
				isDeduplication: globalTemplate.isDeduplication,
				mountPath: globalTemplate.configureStorage.mountPath,
				// Avoid not useful info for each storage
				...(isDiskStorageForMultipleDDBs // if it's emptied or already filled and it's the first data source
					? {
							credential: globalTemplate.configureStorage.credential
					  }
					: {}),
				...(globalTemplate.configureStorage.userName
					? {
							userName: globalTemplate.configureStorage.userName,
							password: globalTemplate.configureStorage.password
					  }
					: {}),
				...(isCloudStorageForMultipleDDBs &&
				(multipleDDBsListForNewDiskOrCloud.length === 0 || globalTemplate.isFirstMA)
					? {
							cloudLibInfo: { ...(globalTemplate.cloudLibInfo || {}) },
							storageClass: globalTemplate.storageClass ? { ...globalTemplate.storageClass } : {},
							serviceHost: globalTemplate.serviceHost || '',
							selectedCredential:
								globalTemplate.selectedCredential !== null ? { ...globalTemplate.selectedCredential } : null
					  }
					: {})
			}
		};

		returnedStorage.permittedOptions = {
			entity: {
				storageId: returnedStorage.storageInfo.storageId
			},
			appendToBody: true
		};

		return returnedStorage;
	}

	onDeleteStorage(storageId, $scope) {
		const { multipleDDBsListForNewDiskOrCloud, grid } = $scope;
		const removedItem = multipleDDBsListForNewDiskOrCloud.find(
			mpathElto => storageId === mpathElto.storageInfo.storageId
		); // ddb locations
		const callBackFunctions = {
			noFunction: () => {
				$scope.deleteButtonClicked = false;
			},
			yesFunction: () => {
				const removedIndex = multipleDDBsListForNewDiskOrCloud.indexOf(removedItem); // we need to mutate existing list which we pass to kendo grid
				multipleDDBsListForNewDiskOrCloud.splice(removedIndex, 1); // backup location
				$scope.deleteButtonClicked = false; //
				/// recalculate partitionlist from data source vector
				$scope.partitionList = [];
				multipleDDBsListForNewDiskOrCloud.forEach(mp => {
					if (mp.storageInfo.ddbPartitionPath !== null && mp.storageInfo.ddbPartitionPath !== '') {
						$scope.partitionList.push({
							mediaAgentName: mp.storageInfo.mediaAgent.mediaAgentName,
							mediaAgentId: mp.storageInfo.mediaAgent.mediaAgentId,
							path: mp.storageInfo.ddbPartitionPath, //"c:\\testddb_rahul",
							displayName: `${mp.storageInfo.mediaAgent.mediaAgentName} and ${mp.storageInfo.ddbPartitionPath}` //"ABC and c:\\testddb_rahul"
						});
					}
				});
				$scope.deleteButtonClicked = false;
				this.shouldShowAddButtonFromGrid($scope);
				grid.refreshData();
			}
		};

		this.$dialogs.confirm(
			this.cvLoc('label.confirmDelete'),
			this.cvLoc(
				'label.confirmationDeleteMountpath',
				'<b>' + removedItem.storageInfo.mediaAgent.mediaAgentName + '</b>'
			),
			callBackFunctions
		);
	}

	shouldBeDeleted(dataItem, $scope) {
		const { multipleDDBsListForNewDiskOrCloud, isDiskStorageForMultipleDDBs } = $scope;

		if (isDiskStorageForMultipleDDBs) {
			return multipleDDBsListForNewDiskOrCloud.length > 1;
		}

		return !dataItem.storageInfo.isFirstMA;
	}
}

SupportMultipleDDBLocationHelper.$inject = ['cvLoc', 'cvUtil', '$dialogs'];

commonStorageModule.service('SupportMultipleDDBLocationHelper', SupportMultipleDDBLocationHelper);

export default commonStorageModule;
