import 'modules/storage/js/factories/supportMultipleDDBLocationHelper.factory.js';
import { acAppStorageModule } from 'common/js/modules';

var storageMod = acAppStorageModule;

storageMod.factory('storageFactory', [
	'cvToaster',
	'cvLoc',
	'cvUtil',
	'storageService',
	'$compile',
	'$uibModal',
	'TapeConstants',
	'credentialManagerFactory',
	'CREDENTIAL_TYPE',
	'SupportMultipleDDBLocationHelper',
	'$location',
	'$state',
	'MetallicStorageClass',
	'MetallicReplication',
	'MetallicLicense',
	'mbService',
	function storageFactory(
		cvToaster,
		cvLoc,
		cvUtil,
		storageService,
		$compile,
		$modal,
		TapeConstants,
		credentialManagerFactory,
		CREDENTIAL_TYPE,
		supportMultipleDDBLocationHelper,
		$location,
		$state,
		MetallicStorageClass,
		MetallicReplication,
		MetallicLicense,
		mbService
	) {
		var storageFactory = {};
		storageFactory.libraryInfo = {};

		storageFactory.openCreateCredentialModal = (
			requiredAccountType = CREDENTIAL_TYPE.WINDOWSACCOUNT,
			accountTypes = null
		) => {
			const cancelReloadApp = true;
			return credentialManagerFactory
				.openCreateNewUser({
					cancelReloadApp: cancelReloadApp,
					AccountTypeId: requiredAccountType,
					showInputs: true,
					accountTypes: accountTypes
				})
				.result.then(
					function() {},
					data => {
						if (data && data.msg === 'createSucessful') {
							return storageService.getCredentials(requiredAccountType, data.name);
						}
						return null;
					}
				);
		};

		storageFactory.addCloudStorage = function(
			$scope,
			$http,
			storageService,
			$rootScope,
			$modal,
			$stateParams,
			cvTableOptions,
			cvLoc,
			action,
			title,
			entity
		) {
			$state.templateUrl = 'modules/storage/partials/addCloudLanding.jsp';
			$state.current.name = 'addCloudLanding';
			$state.pageTitle = 'label.nav.cloudType';
		};

		storageFactory.addOrEditStorage = function(
			$scope,
			$http,
			storageService,
			$rootScope,
			$modal,
			$stateParams,
			cvTableOptions,
			cvLoc,
			action,
			title,
			$state,
			entity
		) {
			$scope.action = action;
			$scope.entity = entity;
			$scope.title = title;
			if (!entity) {
				entity = {
					libraryEntity: {
						libraryName: ''
					},
					mountPath: {
						id: '',
						name: ''
					},
					loginName: '',
					serverType: {
						id: 0,
						name: ''
					},
					serverHost: '',
					selectedCredential: null
				};
			}
			if (!('selectedCredential' in entity)) {
				entity.selectedCredential = null;
			}
			var template = 'adminConsole/partials/addDiskStorage.jsp';
			var setCloudController = false;
			if (action == 'newTapeLib') {
				template = 'adminConsole/partials/addTapeStorage.jsp';
			} else if (action == 'newCloudLib' || action == 'addCloudMP' || action == 'addCloudLib') {
				template = 'adminConsole/partials/addCloudStorage.jsp';
				setCloudController = true;
			}
			var callLockUnlock = true;

			$modal
				.open({
					templateUrl: appUtil.appRoot + template,
					windowClass: 'addServerModal',
					backdrop: 'static',
					controller: [
						'$scope',
						'$uibModalInstance',
						'$log',
						'libraryInfo',
						'action',
						'$state',
						'cvLoc',
						'cvUtil',
						'fromStoragePool',
						'$dialogs',
						'$controller',
						function(
							$scope,
							$modalInstance,
							$log,
							libraryInfo,
							action,
							$state,
							cvLoc,
							cvUtil,
							fromStoragePool,
							$dialogs,
							$controller
						) {
							$scope.serverMessage = cvUtil.emptyMsg();
							$scope.action = action;
							$scope.title = title;
							$scope.oldLibraryInfo = libraryInfo;
							$scope.libraryInfo = angular.copy(libraryInfo);
							$scope.distributedStorage = libraryInfo.distributedStorage;
							if ($scope.action === 'newTapeLib') {
								$scope.lckUnlkConfig = 1;
								storageService
									.lockUnlockConfig($scope.lckUnlkConfig)
									.success(function(data) {
										$log.debug('Lock Configration success');
									})
									.error(function(e) {
										var callBackFunctions = {
											noFunction: function() {
												callLockUnlock = false; //do not send unlock request if the user says no for force unlock.
												$modalInstance.dismiss();
											},
											yesFunction: function() {
												$scope.lckUnlkConfig = 3;
												storageService
													.lockUnlockConfig($scope.lckUnlkConfig)
													.success(function(data) {
														$log.debug('Force Lock Configration success');
													})
													.error(function(e) {
														$log.error('Force Lock Configration failed');
														$scope.serverMessage = cvUtil.errMsg(e);
													});
											}
										};

										$dialogs.confirm(cvLoc('label.confirm'), e, callBackFunctions);
									});
							}
							$scope.fromStoragePool = fromStoragePool;
							$rootScope.$on('storageAdded', function() {
								$log.debug('storageAdded....');
								$modalInstance.dismiss();
								$state.forceReload();
							});
							$rootScope.$on('storageAddCancelled', function() {
								$log.debug('storageAddCancelled....');
								$modalInstance.dismiss();
							});
							$rootScope.$on('editLibrary', function() {
								$log.debug('editLibrary success received');
								$modalInstance.dismiss();
								$state.forceReload();
							});
							$rootScope.$on('editLibraryFailed', function() {
								$log.debug('editLibraryFailed....');
							});
							$rootScope.$on('tapeStorageAdded', function() {
								$log.debug('tapeStorageAdded....');
								$modalInstance.dismiss();
								$state.forceReload();
							});
							$rootScope.$on('TapeStorageCancelled', function() {
								$modalInstance.dismiss();
							});
							setCloudController && angular.extend(this, $controller('addStorageController', { $scope: $scope }));
						}
					],
					resolve: {
						libraryInfo: function() {
							return entity;
						},
						action: function() {
							return $scope.action;
						},
						fromStoragePool: function() {
							return $scope.fromStoragePool;
						}
					}
				})
				.result.then(
					function() {},
					function() {
						if ($scope.action === 'newTapeLib') {
							if (callLockUnlock) {
								$scope.lckUnlkConfig = 0;
								storageService
									.lockUnlockConfig($scope.lckUnlkConfig)
									.success(function(data) {})
									.error(function(e) {
										$scope.serverMessage = cvUtil.errMsg(e);
									});
								//					$state.forceReload();
							}
						}
					}
				);
		};

		storageFactory.exportLibrary = function(libraryId, libraryName, model) {
			return storageService
				.getExportLibrary(libraryId)
				.success(function(libraryOperationResponse) {
					var exportOptions = libraryOperationResponse ? libraryOperationResponse.exportOptions : 'null';
					if (!libraryOperationResponse || libraryOperationResponse == 'null') {
						cvToaster.showErrorMessage({
							ttl: '10000',
							message: cvLoc('popup.errorFetchingMedia')
						});
						return;
					} else if (exportOptions.mediaDetails == 'null' || !exportOptions.mediaDetails) {
						cvToaster.showErrorMessage({
							ttl: '10000',
							message: cvLoc('popup.errorNoMedia')
						});
						return;
					} else {
						storageFactory.openExportMediaDialog(libraryId, libraryName, model, exportOptions);
					}
				})
				.error(function(e) {
					cvToaster.showErrorMessage({
						ttl: '10000',
						message: e ? e : cvLoc('popup.errorFetchingMedia')
					});
				});
		};

		storageFactory.editEncryption = (encryption, cipher, storagePoolDetails) => {
			const modal = $modal.open({
				templateUrl: appUtil.appRoot + 'adminConsole/partials/addStorageEncryptModal.jsp',
				backdrop: 'static',
				controller: [
					'$scope',
					'$uibModalInstance',
					'encryption',
					'cipher',
					'storageService',
					'poolDetails',
					'storagePolicyService',
					'$log',
					'$state',
					'$stateParams',
					(
						$scope,
						$uibModalInstance,
						encryption,
						cipher,
						storageService,
						poolDetails,
						storagePolicyService,
						$log,
						$state,
						$stateParams
					) => {
						$scope.modalEncyption = Object.assign({}, encryption);
						$scope.encryption = encryption;
						$scope.poolDetails = poolDetails;
						$scope.cipher = cipher;
						$scope.selectedCipher = null;
						$scope.serverMessage = null;
						$scope.selectedKeyLength = null;
						$scope.keyLengths = null;
						$scope.keyManagement = null;
						$scope.selectedKeyManagement = null;
						$scope.storagePoolType = $stateParams['storagePoolType'];

						storageService.getAllKeyManagementServers(null).success(data => {
							if (data && data.keyProviders) {
								$scope.keyManagement = data.keyProviders.map(elem => {
									if (elem.provider.keyProviderName === $scope.modalEncyption.managementServer) {
										const obj = {
											keyProviderType: elem.keyProviderType,
											...elem.provider,
											selected: true
										};
										$scope.selectedKeyManagement = obj;
										return obj;
									}
									return {
										keyProviderType: elem.keyProviderType,
										...elem.provider,
										selected: false
									};
								});
							}
						});
						$scope.getkeyLengths = () => {
							$scope.keyLengths = $scope.selectedCipher[0].keyLength.map(elem => {
								return $scope.selectedKeyLength && elem === $scope.selectedKeyLength[0].length
									? { length: elem, selected: true }
									: { length: elem, selected: false };
							});
							if ($scope.keyLengths.length === 1) {
								$scope.keyLengths[0].selected = true;
							}
						};
						$scope.cipherList = $scope.cipher.map(elem => {
							if (elem.name.toLowerCase().includes($scope.modalEncyption.cipher.keyName.toLowerCase())) {
								$scope.selectedCipher = [{ ...elem, selected: true }];
								$scope.selectedKeyLength = [{ length: $scope.modalEncyption.cipher.keyLength, selected: true }];
								$scope.getkeyLengths();
								return { ...elem, selected: true };
							}
							return { ...elem, selected: false };
						});

						$scope.isChanged = false;
						$scope.changedValue = () => {
							if ($scope.encryption.managementServer !== $scope.selectedKeyManagement[0].keyProviderName) {
								$scope.isChanged = true;
							} else {
								$scope.isChanged = false;
							}
						};

						$scope.close = () => {
							$uibModalInstance.close();
						};
						$scope.addPolicy = () => {
							$scope.serverMessage = null;
							if (
								$scope.selectedKeyManagement !== null &&
								($scope.selectedCipher !== null || $scope.modalEncyption.encrypt)
							) {
								const copyInfo = $scope.poolDetails.copyInfo;
								let data = {
									storagePolicyCopyInfo: {
										StoragePolicyCopy: copyInfo.StoragePolicyCopy,
										copyFlags: {
											auxCopyReencryptData: $scope.modalEncyption.encrypt === true ? 1 : 0,
											preserveEncryptionModeAsInSource: $scope.modalEncyption.encrypt === false ? 1 : 0,
											storeKeyOnMedia: $scope.modalEncyption.storeOnMedia === true ? 1 : 0
										},
										extendedFlags: {
											encryptOnDependentPrimary: $scope.modalEncyption.encrypt === true ? 1 : 0
										},
										dataEncryption: {}
									}
								};

								if ($scope.modalEncyption.encrypt) {
									data.storagePolicyCopyInfo.dataEncryption.encryptionKeyLength = $scope.selectedKeyLength[0].length;
									data.storagePolicyCopyInfo.dataEncryption.encryptionType = $scope.selectedCipher[0].name;
								} else {
									data.storagePolicyCopyInfo.dataEncryption.encryptionType = 0;
									data.storagePolicyCopyInfo.dataEncryption.encryptionKeyLength = 0;
								}

								if ($scope.isChanged) {
									data.storagePolicyCopyInfo.dataEncryption.keyProvider = {
										keyProviderId: $scope.selectedKeyManagement[0].keyProviderId,
										keyProviderName: $scope.selectedKeyManagement[0].keyProviderName
									};
									data.storagePolicyCopyInfo.dataEncryption.keyProviderName =
										$scope.selectedKeyManagement[0].keyProviderName;
									data.storagePolicyCopyInfo.dataEncryption.rotateMasterKey = true;
								}

								storagePolicyService
									.updateStoragePolicyCopy(
										copyInfo.StoragePolicyCopy.storagePolicyId,
										copyInfo.StoragePolicyCopy.copyId,
										data
									)
									.success(function(data) {
										if (data.errorCode === 0) {
											$log.debug(cvLoc('log.succesUpdatePolicy'));
											$uibModalInstance.close();
											$state.forceReload();
										} else {
											$log.error(cvLoc('log.errorUpdatePolicy'));
											$scope.serverMessage = data.error.errorMessage;
										}
									})
									.error(function(data) {
										$log.error(cvLoc('log.errorUpdatePolicy'));
										$scope.serverMessage = data.errorMessage;
									});
							}
						};
					}
				],
				resolve: {
					encryption: () => {
						return encryption;
					},
					cipher: () => {
						return cipher;
					},
					poolDetails: () => {
						return storagePoolDetails;
					}
				}
			});
			return modal;
		};

		storageFactory.exportLibraryCriteria = function(libraryId) {
			storageFactory.openExportMediaCriteriaDialog(libraryId);
		};

		storageFactory.isFormValidate = function($scope, formData, isEditing) {
			let flag = true;
			let dataKeys = Object.keys(formData);

			dataKeys.forEach(item => {
				const element = formData[item];
				if ((element.validateOnCreate && !isEditing) || (element.validateOnEdit && isEditing)) {
					element.validate();
				}
			});

			dataKeys.forEach(item => {
				const element = formData[item];
				if (element.hasError) {
					flag = false;
				}
			});

			return flag;
		};

		storageFactory.openExportMediaDialog = function(libraryId, libraryName, model, exportOptions) {
			var template = 'modules/storage/partials/ExportMedia.jsp';
			$modal.open({
				templateUrl: appUtil.appRoot + template,
				backdrop: 'static',
				controller: [
					'VaultTrackerService',
					'$scope',
					'$uibModalInstance',
					'$log',
					'$state',
					'cvLoc',
					'cvUtil',
					'cvTableOptions',
					function(VaultTrackerService, $scope, $modalInstance, $log, $state, cvLoc, cvUtil, cvTableOptions) {
						$scope.libraryId = libraryId;
						$scope.libraryName = libraryName;
						$scope.model = model;
						$scope.exportOptionsOrig = {};
						$scope.locationModel = {};
						$scope.exportOptions = {};
						$scope.availableDestinations = [];
						$scope.availableTransit = [];

						$scope.bShowVaultTrackerChanges = !(
							(cv &&
								cv.additionalSettings &&
								cv.additionalSettings.AdminConsole &&
								cv.additionalSettings.AdminConsole.bHideVaultTrackerChanges) ||
							false
						);

						$scope.availableControllers =
							exportOptions.exportLocations &&
							exportOptions.exportLocations.map(opt => {
								return {
									...opt,
									ticked: false
								};
							});

						$scope.validateSelector = function() {
							if (this.isShow) {
								let flag = this.value ? true : false;
								this.hasError = !flag;
								return flag;
							}
						};

						$scope.changeValue = type => {
							if (type === 'trackTransit') {
								$scope.data.trackTransit.isShow = !$scope.data.trackTransit.isShow;
								if (!$scope.data.trackTransit.isShow) {
									$scope.data.trackTransit.value = null;
									delete $scope.data.trackTransit.hasError;
								}
							}
						};
						$scope.arrayControllerSelection = type => {
							switch (type) {
								case 'destination':
									// $scope.exportOptions
									break;
								case 'trackTransit':
									if ($scope.data.trackTransit.isShow && $scope.data.trackTransit.value) {
										$scope.data.trackTransit.hasError = false;
									}
									break;
							}
						};

						$scope.data = {
							trackTransit: {
								value: null,
								isShow: false,
								validateOnCreate: true,
								validate: $scope.validateSelector
							},
							exportDestination: {
								value: null,
								validate: $scope.validateSelector,
								validateOnEdit: true,
								validateOnCreate: true,
								isShow: true
							}
						};

						$scope.exportOptions = exportOptions;
						angular.copy($scope.exportOptions, $scope.exportOptionsOrig);
						$scope.isLoadedLocations = false;
						VaultTrackerService.getLocations()
							.success(function(response) {
								$scope.availableTransit = response.locations.map(opt => {
									if (opt.isTransit) {
										return {
											...opt.location,
											ticked: false
										};
									}
								});
								$scope.availableTransit = $scope.availableTransit.filter(item => item != undefined);

								$scope.availableDestinations = response.locations.map(opt => {
									if (!opt.isTransit && typeof opt.location !== undefined && opt.location.locationId !== 0) {
										return {
											...opt.location,
											ticked: !opt.location.locationId
										};
									}
								});
								$scope.availableDestinations = $scope.availableDestinations.filter(item => item != undefined);
								$scope.isLoadedLocations = true;
							})
							.error(function(e) {
								$dialogs.error(cvLoc('label.error'), e.errorMessage);
								$log.error('Getting Locations failed');
							});

						var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);
						angular.extend(globalGridOptions, {
							data: 'exportOptions.mediaDetails',
							enablePaginationControls: false,
							enableRowSelection: true,
							enableSelectAll: true,
							multiSelect: true,
							paginationPageSize: exportOptions.mediaDetails.length,

							columnDefs: [
								{
									field: 'barCode',
									sort: {
										direction: 'asc',
										priority: 0
									},
									displayName: cvLoc('label.barcode'),
									cellClass: 'crop',
									cellTooltip: true,
									enableHiding: false
								},
								{
									field: 'status',
									displayName: cvLoc('label.status'),
									cellClass: 'crop',
									cellTooltip: true,
									enableHiding: false
								},
								{
									field: 'container',
									displayName: cvLoc('label.container'),
									cellClass: 'crop',
									cellTooltip: true,
									cvUserPref: 'container',
									enableHiding: true,
									visible: false
								},
								{
									field: 'lastWriteTime',
									displayName: cvLoc('label.lastWriteTime'),
									cellClass: 'crop',
									enableHiding: true,
									cellTooltip: true,
									cellTemplate: '<div class="time crop" val="{{row.entity.lastWriteTime}}"></div> ',
									visible: false
								},
								{
									field: 'Location',
									displayName: cvLoc('label.location'),
									cellTooltip: true,
									cellClass: 'crop'
								},
								{
									field: 'retainDataUntil',
									displayName: cvLoc('label.retainDataUntil'),
									cellTooltip: true,
									cellClass: 'crop',
									type: 'date',
									enableHiding: true,
									cellTemplate: '<div class="time crop" val="{{row.entity.retainDataUntil}}"></div> ',
									visible: false
								},
								{
									field: 'mediaGroup.name',
									displayName: cvLoc('label.mediaGroupName'),
									cellClass: 'crop',
									cellTooltip: true,
									enableHiding: true,
									visible: false
								},
								{
									field: 'sizeOfStoredData',
									displayName: cvLoc('label.sizeOfStoredData'),
									cellClass: 'crop',
									enableHiding: true,
									cellTooltip: true,
									cellTemplate: '<span class="crop">{{row.entity.sizeOfStoredData | capacity}}</span>',
									visible: false
								}
							],
							onRegisterApi: function(gridApi) {
								gridApi.selection.enableVerticalScrollbar = 0;
								gridApi.selection.on.rowSelectionChangedBatch($scope, function(rows) {
									gridApi.grid.rows.forEach(function(row) {
										row.entity.selected = row.isSelected;
									});
								});
								gridApi.grid.rows.forEach(function(row) {
									if (row.entity.selected) {
										row.isSelected = true;
									}
								});
								gridApi.selection.on.rowSelectionChanged($scope, function(row) {
									row.entity.selected = row.isSelected;
								});
								gridApi.grid.registerRowsProcessor(function(renderableRows) {
									renderableRows.forEach(function(row) {
										if (row.entity.selected) {
											row.isSelected = true;
										}
									});
									return renderableRows;
								}, 200);
							}
						});
						$scope.gridOptions = {
							cvHasTitle: false,
							cvTableName: cvLoc('title.exportMedia'),
							cvIsSearchable: true,
							cvHasViews: false,
							cvSearchFields: ['barCode', 'StoragePolicy.name', 'Location', 'retainDataUntil'],
							cvGridDirectives: {
								uiGridPagination: false,
								uiGridSelection: true
							},
							cvGridCssClass: {
								'bottom-border-last-child': true,
								'top-bottom-border': true,
								'modal-grid': true
							},
							cvShowSelectedOption: true,
							gridOptions: globalGridOptions
						};
						$scope.cancel = function() {
							$modalInstance.dismiss();
						};

						$scope.closeModal = function(result) {
							$modalInstance.dismiss();
						};

						$scope.exportMedia = function() {
							if (storageFactory.isFormValidate($scope, $scope.data, false)) {
								var mediaList = [];

								$scope.exportOptionsOrig.mediaDetails = [];
								$scope.exportOptionsOrig.exportLocations = [];

								if (
									!$scope.locationModel.name ||
									!$scope.locationModel.checked ||
									$scope.locationModel.checked == 'false'
								) {
									$scope.locationModel.name = null;
								}

								if ($scope.exportOptions.mediaDetails) {
									$scope.exportOptions.mediaDetails.map(function(mediaDetail) {
										if (mediaDetail.selected) {
											mediaDetail = {
												mediaId: mediaDetail.mediaId
											};
											mediaList.push(mediaDetail);
										}
									});
								}
								if (mediaList.length == 0) {
									$scope.generalSetupMessage = {
										message: cvLoc('error.selectMediatoExport'),
										type: 'error'
									};
									return;
								}
								$scope.exportOptionsOrig.mediaDetails = mediaList;
								if ($scope.locationModel) {
									$scope.exportOptionsOrig.exportLocations.push($scope.locationModel);
								}

								$scope.exportOptionsOrig.exportLocation = $scope.data.exportDestination.value;
								$scope.exportOptionsOrig.exportLocation.paginationPageSize = mediaList.length;

								$scope.exportOptionsOrig.exportLocation &&
									$scope.exportOptionsOrig.exportLocation.locationId === -1 &&
									delete $scope.exportOptionsOrig.exportLocation.locationId;

								if ($scope.data.trackTransit.value && $scope.data.trackTransit.isShow) {
									const assignable =
										$scope.data.trackTransit.value.locationId === -1
											? { locationName: $scope.data.trackTransit.value.locationName }
											: {
													locationId: $scope.data.trackTransit.value.locationId,
													_type_: $scope.data.trackTransit.value._type_
											  };
									$scope.exportOptionsOrig.transitLocation = Object.assign({}, assignable);
								} else if (!$scope.data.trackTransit.value && $scope.data.trackTransit.isShow) {
									$scope.data.trackTransit.hasError = true;
									return;
								} else {
									$scope.exportOptionsOrig.transitLocation = null;
								}
								if (!$scope.isAPICall) {
									$modalInstance.close();
								}
								storageService
									.exportLibrary($scope.exportOptionsOrig, $scope.libraryId)
									.success(function(libDetails) {
										if (libDetails == null) {
											cvToaster.showErrorMessage({
												ttl: '10000',
												message: cvLoc('popup.errorExportingMedia')
											});
											return;
										}
										if (libDetails.errorMessage != '' && libDetails.errorMessage && libDetails.errorMessage != null) {
											cvToaster.showErrorMessage({
												ttl: '10000',
												message: libDetails.errorMessage
											});
											return;
										} else {
											const actionLink =
												'#/vaultTrackerActions?input.LibraryId=' +
												$scope.libraryId +
												'&input.model=' +
												$scope.model +
												'&libraryId=' +
												$scope.libraryId +
												'&libraryName=' +
												encodeURIComponent($scope.libraryName) +
												'&model=' +
												$scope.model;
											const message =
												cvLoc('popup.successExportMedia') +
												'. <a href="' +
												actionLink +
												'">' +
												cvLoc('popup.viewActions') +
												'</a>';
											cvToaster.showSuccessMessage({
												ttl: '10000',
												message: message
											});
										}
									})
									.error(function(e) {
										cvToaster.showErrorMessage({
											ttl: '10000',
											message: cvLoc('popup.errorExportingMedia')
										});
										return;
									});
							}
						};
					}
				]
			});
		};

		storageFactory.openExportMediaCriteriaDialog = function(libraryId) {
			var template = 'modules/storage/partials/ExportMediaCriteria.jsp';
			$modal.open({
				templateUrl: appUtil.appRoot + template,
				backdrop: 'static',
				controller: [
					'sharedData',
					'VaultTrackerService',
					'$stateParams',
					'$scope',
					'$rootScope',
					'$uibModalInstance',
					'$log',
					'$state',
					'cvLoc',
					'cvUtil',
					'cvTableOptions',
					'scheduleUIFactory',
					function(
						sharedData,
						VaultTrackerService,
						$stateParams,
						$scope,
						$rootScope,
						$modalInstance,
						$log,
						$state,
						cvLoc,
						cvUtil,
						cvTableOptions,
						scheduleUIFactory
					) {
						$scope.libraryId = libraryId;
						$scope.exportOptionsOrig = {};
						$scope.locationModel = {};
						$scope.exportOptions = {};
						$scope.availableTransit = [];
						$scope.availableDestinations = [];
						$scope.selectedSnapControllers = 'Option';
						$scope.addedSchedules = [];
						$scope.planSubType = 'vaultTracker';
						$scope.libId = $stateParams['libraryId'] || libraryId;
						$scope.serverErrorMessage = null;

						$scope.validateValue = function() {
							let flag = this.value ? true : false;
							this.hasError = !flag;
							return flag;
						};

						$scope.validateSelector = function() {
							if (this.isShow) {
								let flag = this.value ? true : false;
								this.hasError = !flag;
								return flag;
							}
						};

						$scope.validateSchedule = function() {
							let flag = $scope.scheduleObject.taskInfo.subTasks.length > 0 ? true : false;
							this.hasError = !flag;
							return flag;
						};

						// set
						$scope.data = {
							policyName: {
								value: null,
								validate: $scope.validateValue,
								validateOnEdit: true,
								validateOnCreate: true
							},
							description: {
								value: null
							},
							fullTape: {
								value: true
							},
							includeTape: {
								value: false
							},
							lastTape: {
								value: null
							},
							excludeMedia: {
								value: false
							},
							limitMedia: {
								value: null
							},
							trackTransit: {
								value: null,
								isShow: false,
								validateOnCreate: true,
								validate: $scope.validateSelector
							},
							exportDestination: {
								value: null,
								validate: $scope.validateSelector,
								validateOnEdit: true,
								validateOnCreate: true,
								isShow: true
							},
							schedule: {
								value: []
							}
						};

						// Default Values:
						$scope.data.limitMedia.value = 10;
						$scope.data.lastTape.value = 7;

						$scope.arrayControllerSelection = type => {
							switch (type) {
								case 'destination':
									// $scope.exportOptions
									break;
								case 'trackTransit':
									if ($scope.data.trackTransit.isShow && $scope.data.trackTransit.value) {
										$scope.data.trackTransit.hasError = false;
									}
									break;
							}
						};
						$scope.$watch('inputModel', function(data) {});
						$scope.isLoadedLocations = false;

						VaultTrackerService.getLocations()
							.success(function(response) {
								$scope.availableTransit = response.locations.map(opt => {
									if (opt.isTransit) {
										return {
											...opt.location,
											ticked: false
										};
									}
								});
								$scope.availableTransit = $scope.availableTransit.filter(item => item != undefined);

								$scope.availableDestinations = response.locations.map(opt => {
									if (!opt.isTransit && typeof opt.location !== undefined && opt.location.locationId !== 0) {
										return {
											...opt.location,
											ticked: false
										};
									}
								});
								$scope.availableDestinations = $scope.availableDestinations.filter(item => item != undefined);
								$scope.isLoadedLocations = true;
							})
							.error(function(e) {
								$dialogs.error(cvLoc('label.error'), e.errorMessage);
								$log.error('Getting Locations failed');
							});

						/**
						 *
						 * @param {*}
						 *            type Vaiable's names
						 * @param {*}
						 *            value The value to modify
						 */
						$scope.changeValue = type => {
							if (type === 'trackTransit') {
								$scope.data.trackTransit.isShow = !$scope.data.trackTransit.isShow;
								if (!$scope.data.trackTransit.isShow) {
									$scope.data.trackTransit.value = null;
									delete $scope.data.trackTransit.hasError;
								}
							}
						};

						$scope.changeSelective = type => {
							switch (type) {
								case 'full_tape':
									$scope.data.fullTape.value = !$scope.data.fullTape.value;
									break;
								case 'include_tape':
									$scope.data.includeTape.value = !$scope.data.includeTape.value;
									break;
								case 'exclude_media':
									$scope.data.excludeMedia.value = !$scope.data.excludeMedia.value;
									break;
								default:
									break;
							}
						};

						$scope.scheduleObject = {
							associations: [
								{
									trackingPolicyName: null,
									_type_: 21
								}
							],
							task: {
								ownerId: 1,
								taskType: 2,
								ownerName: 'admin',
								sequenceNumber: 0,
								initiatedFrom: 1,
								policyType: 1,
								taskFlags: {
									isEdgeDrive: false,
									isEZOperation: false,
									disabled: false
								}
							},
							subTasks: []
						};

						$scope.returnScheduleObject = function(addedSchedule) {
							return {
								subTask: {
									subTaskName: addedSchedule.name,
									subTaskType: 1,
									operationType: TapeConstants.DEFAULT_OPERATION_TYPE
								},
								pattern: {
									...addedSchedule
								}
							};
						};

						$scope.addSchedule = function() {
							$scope.oneTime = false;
							scheduleUIFactory.addNewSchedule(null, $scope.planSubType);
						};

						const scheduleAddedListener = $rootScope.$on('scheduleAdded', function(evt, addedSchedule) {
							//this event will be called twice when plan has secondary schedule, for secondary schedule, don't do anything
							if (!$scope.oneTime) {
								$scope.scheduleObject.subTasks.push(addedSchedule);
								$scope.oneTime = true;
							}
						});

						const scheduleEditedListener = $rootScope.$on('scheduleEdited', function(evt, addedSchedule) {
							var idToEdit = addedSchedule.id;
							for (var i = 0; i < $scope.scheduleObject.subTasks.length; i++) {
								if ($scope.scheduleObject.subTasks[i].id == idToEdit) {
									$scope.scheduleObject.subTasks[i] = addedSchedule;
									return;
								}
							}
						});

						const scheduleDeletedListener = $rootScope.$on('scheduleDeleted', function(evt, addedSchedule) {
							var idToEdit = addedSchedule.id;
							for (var i = 0; i < $scope.scheduleObject.subTasks.length; i++) {
								if ($scope.scheduleObject.subTasks[i].id == idToEdit) {
									$scope.scheduleObject.subTasks.splice(i, 1);
									return;
								}
							}
						});

						$scope.$on('$destroy', scheduleAddedListener, scheduleEditedListener, scheduleDeletedListener);

						$scope.editSchedule = function(obj) {
							var showEdit = true;
							obj.planSubType = 'vaultTracker';
							obj.backupLevel = 'vaultTracker';
							scheduleUIFactory.addSchedule(
								{
									source: 'createProfile',
									model: { ...obj }
								},
								showEdit,
								$scope.planSubType,
								false,
								'',
								'',
								'',
								undefined,
								undefined,
								undefined,
								true
							);
						};

						$scope.isDataProtectionSelected = function() {
							return $scope.model.associationsTree && $scope.model.task.policyType === 'DATA_PROTECTION';
						};

						$scope.formatSelectedAgentNodes = agentsList => {
							var agentIds = {
								appGroups: [],
								appTypes: []
							};
							if (agentsList && agentsList.length > 0) {
								agentsList.forEach(function(agent) {
									if (agent.isAppGroup) {
										agentIds.appGroups.push({
											appGroupId: agent.value,
											appGroupName: agent.label
										});
									} else {
										agentIds.appTypes.push({
											appTypeId: agent.value,
											appTypeName: agent.labelf
										});
									}
								});
							}
							return agentIds;
						};

						$scope.arrayControllerSelection = data => {};

						$scope.cancel = function() {
							$modalInstance.dismiss();
						};
						$scope.changeInput = function(type) {
							switch (type) {
								case 'lastTape':
									if ($scope.data.lastTape.value > 0 && $scope.data.lastTape.value <= 9999) {
										$scope.data.lastTape.hasError = false;
									} else {
										$scope.data.lastTape.hasError = true;
									}
									break;
								case 'limitMedia':
									if ($scope.data.limitMedia.value > 0 && $scope.data.limitMedia.value <= 1000) {
										$scope.data.limitMedia.hasError = false;
									} else {
										$scope.data.limitMedia.hasError = true;
									}
									break;
							}
						};
						$scope.closeModal = function(result) {
							$modalInstance.dismiss();
						};

						// OK button
						$scope.exportMedia = function() {
							if (storageFactory.isFormValidate($scope, $scope.data, false)) {
								let payload = {
									vaultTrackerPolicy: {
										vaultTrackerPolicyType: 1,
										enable: true,
										destinationLocation: {
											destinationType: 2,
											location: {
												locationId: $scope.data.exportDestination.value.locationId
											}
										},
										sourceLocation: {
											exportCriteria: {
												tapeWrittenToLastDay: $scope.data.lastTape.value,
												excludeMediaNotCopied: $scope.data.excludeMedia.value,
												partiallyWrittenTapes: $scope.data.includeTape.value,
												mediaState: 1,
												limitMediaCountForExport: {
													limitMediaCount: 1,
													value: $scope.data.limitMedia.value
												},
												mediaGroups: {
													all: true
												},
												mediaStatus: {
													appendableAssignedMedia: $scope.data.includeTape.value,
													activeAssignedMedia: $scope.data.includeTape.value,
													fullAssignedMedia: $scope.data.fullTape.value
												}
											},
											libraryList: [
												{
													libraryName: ' ',
													libraryId: Number($scope.libId)
												}
											]
										},
										trackingPolicy: {
											trackingPolicyName: $scope.data.policyName.value
										}
									}
								};

								if (payload.vaultTrackerPolicy.destinationLocation.location.locationId === -1) {
									delete payload.vaultTrackerPolicy.destinationLocation.location.locationId;
									const locationName = $scope.data.exportDestination.value.locationName;
									payload.vaultTrackerPolicy.destinationLocation.location.locationName = locationName;
								}

								if ($scope.data.trackTransit.value && $scope.data.trackTransit.isShow) {
									const assignable =
										$scope.data.trackTransit.value.locationId === -1
											? { locationName: $scope.data.trackTransit.value.locationName }
											: {
													locationId: $scope.data.trackTransit.value.locationId,
													_type_: $scope.data.trackTransit.value._type_
											  };
									payload.vaultTrackerPolicy.trasitLocation = Object.assign({}, assignable);
								} else if (!$scope.data.trackTransit.value && $scope.data.trackTransit.isShow) {
									$scope.data.trackTransit.hasError = true;
									return;
								}

								payload.vaultTrackerPolicy.trasitLocation &&
									payload.vaultTrackerPolicy.trasitLocation.locationId &&
									payload.vaultTrackerPolicy.trasitLocation.locationId;

								if ($scope.scheduleObject.subTasks.length > 0) {
									$scope.scheduleObject.associations[0].trackingPolicyName = $scope.data.policyName.value;

									$scope.scheduleObject.subTasks = $scope.scheduleObject.subTasks.map(item => {
										let scheduleItem = scheduleUIFactory.convertScheduleToSubTaskInfo(item);
										delete scheduleItem.options;
										scheduleItem.subTask = {
											subTaskName: scheduleItem.pattern.name,
											subTaskType: 1,
											operationType: TapeConstants.DEFAULT_OPERATION_TYPE
										};
										scheduleItem.options = {
											backupOpts: {
												backupLevel: 2,
												dataOpt: {
													dataOpt: {
														autoCopy: false
													}
												}
											},
											adminOpts: {
												runvtPolicyOption: {
													vTPolicy: {
														trackingPolicyName: $scope.data.policyName.value
													}
												}
											}
										};

										switch (scheduleItem.pattern.freq_type) {
											case 'Weekly':
												scheduleItem.pattern.freq_type = 8;
												scheduleItem.pattern.active_end_occurence = 0;
												scheduleItem.pattern.active_end_time = 0;
												scheduleItem.pattern.active_start_date = 1541376000; // need to change ?
												scheduleItem.pattern.calendar = { calendarId: 1, calendarName: 'Standard' };
												scheduleItem.pattern.calendarId = 1;
												scheduleItem.pattern.description = 'Every week on Friday at 8:00 AM starting November 5, 2018 '; // need to change ?
												scheduleItem.pattern.freq_recurrence_factor = 1;
												scheduleItem.pattern.freq_relative_interval = 0;
												scheduleItem.pattern.freq_type = 8;
												scheduleItem.pattern.skipDayNumber = 0;
												scheduleItem.pattern.skipOccurence = 0;
												scheduleItem.pattern.timeZone = TapeConstants.DEFAULT_CS_TIME_ZONE;
												delete scheduleItem.pattern.daysToRun.Saturday;
												break;
											case 'One_Time':
												scheduleItem.pattern.freq_type = 1;
												scheduleItem.pattern.active_start_time = item.activeStartTime;
												scheduleItem.freq_recurrence_factor = 1;
												scheduleItem.pattern.freq_subday_interval = 0;
												scheduleItem.pattern.timeZone = TapeConstants.DEFAULT_CS_TIME_ZONE;
												break;
											case 'Daily':
												scheduleItem.pattern.timeZone = TapeConstants.DEFAULT_CS_TIME_ZONE;
												scheduleItem.pattern.freq_type = 4;
												scheduleItem.pattern.active_end_occurence = 0;
												scheduleItem.pattern.active_end_time = 0;
												scheduleItem.pattern.active_start_date = 1541376000; // need to change ?
												scheduleItem.pattern.description = 'Every day at 8:00 AM starting November 14, 2018 '; // need to change ?
												scheduleItem.pattern.freq_recurrence_factor = 1;
												delete scheduleItem.pattern.daysToRun;
												break;
											case 'Monthly':
												scheduleItem.pattern.freq_type = 16;
												scheduleItem.pattern.timeZone = TapeConstants.DEFAULT_CS_TIME_ZONE;
												scheduleItem.pattern.freq_recurrence_factor = 1;
												scheduleItem.pattern.active_start_date = 1542326400; // need to change ?
												scheduleItem.pattern.active_start_time = item.activeStartTime;
												scheduleItem.pattern.active_end_occurence = 0;
												scheduleItem.pattern.active_end_time = 0;
												scheduleItem.pattern.calendar = { calendarId: 1, calendarName: 'Standard' };
												scheduleItem.pattern.calendarId = 1;
												scheduleItem.pattern.description =
													'Every month on day 10  at 9:00 AM starting November 16, 2018 '; // need to change ?
												break;
											case 'Monthly_Relative':
												scheduleItem.pattern.freq_type = 32;
												scheduleItem.pattern.timeZone = TapeConstants.DEFAULT_CS_TIME_ZONE;
												scheduleItem.pattern.freq_recurrence_factor = 1;
												scheduleItem.pattern.active_end_occurence = 0;
												scheduleItem.pattern.active_end_time = 0;
												scheduleItem.pattern.calendar = { calendarId: 1, calendarName: 'Standard' };
												scheduleItem.pattern.calendarId = 1;
											default:
												break;
										}

										return scheduleItem;
									});

									payload.vaultTrackerPolicy.schedule = $scope.scheduleObject;
								}

								if ($scope.data.description.value && $scope.data.description.value !== '') {
									payload.vaultTrackerPolicy.description = $scope.data.description.value;
								}

								$scope.serverErrorMessage = null;
								VaultTrackerService.postVaultTracker(JSON.stringify(payload))
									.success(function(response) {
										$log.debug('Created VaulTracker');
										$modalInstance.dismiss();

										if ($state.current.name !== 'storage/tape') {
											if ($state.current.name === 'tapeLibraryMediaDetails') {
												sharedData.data.libId = 0; // set 0 to libId in order to reset values to default
											}

											$state.forceReload();
										}
									})
									.error(function(e) {
										$scope.serverErrorMessage = e.errorMessage;
										$log.error('Creation of VaulTracker failed');
										$scope.generalSetupMessage = {
											message: e.errorMessage,
											type: 'error'
										};
									});
							} else {
								if (!$scope.data.limitMedia.value) {
									$scope.data.limitMedia.hasError = true;
									return;
								}

								if (!$scope.data.lastTape.value) {
									$scope.data.lastTape.hasError = true;
									return;
								}
							}
						};
					}
				]
			});
		};

		storageFactory.openEditCredentialModal = function(credentialEntity) {
			return credentialManagerFactory
				.openEditCredential({ credentialEntity: credentialEntity, cancelReloadApp: true, showInputs: true })
				.result.then(
					function() {},
					data => {
						if (data && data.msg === 'editSucessful') {
							return data.name;
						}
						return null;
					}
				);
		};

		// This method returns options for runing a kendo grid
		// which will be displayed when user creates a new disk/cloud storage
		storageFactory.configMultipleDDBsGrid = $scope => {
			const controller = supportMultipleDDBLocationHelper.getController($scope.isDiskStorageForMultipleDDBs);
			const template = supportMultipleDDBLocationHelper.getTemplateController($scope.isDiskStorageForMultipleDDBs);
			const LABEL = $scope.isDiskStorageForMultipleDDBs ? cvLoc('label.disk') : cvLoc('label.cloud');
			$scope.multipleDDBsListForNewDiskOrCloud = [];
			$scope.libraryInfoTemplate = angular.copy($scope.libraryInfo);
			$scope.partitionList = $scope.partitionList || [];

			$scope.mode = {
				submitMode: false,
				editMode: false,
				initialMode: false
			};

			const runModal = () => {
				const {
					savedCredentials,
					multipleDDBsListForNewDiskOrCloud,
					partitionList,
					action,
					libraryInfo,
					libraryInfoTemplate,
					isCloudStorageForMultipleDDBs,
					mode,
					globalTemplate
				} = $scope;

				$modal
					.open({
						templateUrl: appUtil.appRoot + template,
						backdrop: 'static',
						controller: [
							'$scope',
							'$uibModalInstance',
							'$controller',
							function($scope, $modalInstance, $controller) {
								$scope.partitionList = partitionList;
								$scope.multipleDDBsListForNewDiskOrCloud = multipleDDBsListForNewDiskOrCloud;
								$scope.isModalFromMultipleDDBGrid = true;
								$scope.showInputs = multipleDDBsListForNewDiskOrCloud.length === 0; // adding new data source item
								$scope.isCloudStorageForMultipleDDBs = isCloudStorageForMultipleDDBs;
								$scope.shouldShowDDBLocationInputField = true; // we use this flag in  order to hide/show ddb location field
								$scope.shouldShowDDBLocationSection = true;
								$scope.sliderDefaultValue = true;

								$scope.mode = { ...mode, submitMode: false };
								if (controller === 'createStoragePoolController' || controller === 'addStorageController') {
									$scope.isReadyForAPICall = false; // hide api button
								}

								if ($scope.mode.editMode) {
									// ON EDIT MODE
									if (!!isCloudStorageForMultipleDDBs) {
										// CLOUD CREATION
										$scope.shouldShowDDBLocationInputField =
											!!libraryInfo.ddbPartitionPath || libraryInfo.isDeduplication;
										$scope.libraryInfo = angular.copy(libraryInfo);
										$scope.showInputs = libraryInfo.isFirstMA;
										// here we asking if we need to display toggle button which switch visibility of ddb location field
										$scope.shouldShowDDBLocationSection = libraryInfo.isFirstMA
											? $scope.shouldShowDDBLocationInputField || partitionList.length < 4
											: true;
									} else {
										// DISK CREATION
										$scope.globalTemplate = angular.copy(globalTemplate);
										// LESSS THAN OR EQUAL  TO 4 ddb locations,
										//you can only show ddb location component in those disk config where user has filled it in a previous state.
										$scope.shouldShowDDBLocationSection =
											partitionList.length !== 4 || !!globalTemplate.ddbPartitionPath;
										$scope.sliderDefaultValue = globalTemplate.ddbPartitionPath ? true : false;
									}
								} else {
									// ON INIT MODE
									$scope.libraryInfo = angular.copy(libraryInfoTemplate);
									if (!isCloudStorageForMultipleDDBs) {
										// if it is  only disk we can keep adding new disk with only backup location when you get max ddb location
										$scope.shouldShowDDBLocationSection = partitionList.length < 4;
									}
								}

								if ($scope.isCloudStorageForMultipleDDBs) {
									$scope.action = action;
								}

								$scope.addCloudToGrid = function(storageInfo) {
									$modalInstance.close({
										params: { cancelOp: false },
										globalTemplate: $scope.mode.initialMode
											? supportMultipleDDBLocationHelper.onInitialCloudToGrid(storageInfo, $scope)
											: supportMultipleDDBLocationHelper.onEditCloudToGrid(storageInfo, $scope)
									});
								};

								$scope.cancelAdd = function() {
									$modalInstance.close({ params: { cancelOp: true } });
								};

								$scope.closeModalFromMultipleDDBGrid = function(params = { cancelOp: false }) {
									const { globalTemplate } = $scope;
									$modalInstance.close({ params, globalTemplate });
								};

								angular.extend(this, $controller(controller, { $scope: $scope }));
							}
						]
					})
					.result.then(function({ params: { cancelOp }, globalTemplate }) {
						if (!cancelOp) {
							// if it is not performing cancel action
							if ($scope.isCloudStorageForMultipleDDBs && globalTemplate.isFirstMA) {
								globalTemplate.ddbPartitionPath = globalTemplate.isDeduplication
									? globalTemplate.ddbPartitionPath || ''
									: null;
							}

							if ($scope.mode.editMode) {
								$scope.partitionList = [];
								const indexItem = supportMultipleDDBLocationHelper.getIndexByStorageId(
									$scope.multipleDDBsListForNewDiskOrCloud,
									globalTemplate
								);
								$scope.multipleDDBsListForNewDiskOrCloud[indexItem] = null;
								$scope.multipleDDBsListForNewDiskOrCloud[indexItem] = supportMultipleDDBLocationHelper.buildStorageInfo(
									globalTemplate,
									$scope
								);

								$scope.multipleDDBsListForNewDiskOrCloud.forEach(mp => {
									if (mp.storageInfo.ddbPartitionPath !== null && mp.storageInfo.ddbPartitionPath !== '') {
										const ddbpath = {
											mediaAgentName: mp.storageInfo.mediaAgent.mediaAgentName,
											mediaAgentId: mp.storageInfo.mediaAgent.mediaAgentId,
											path: mp.storageInfo.ddbPartitionPath,
											displayName: `${mp.storageInfo.mediaAgent.mediaAgentName} and ${mp.storageInfo.ddbPartitionPath}`
										};
										$scope.partitionList.push(ddbpath);
									}
								});
							}

							if ($scope.mode.initialMode) {
								$scope.multipleDDBsListForNewDiskOrCloud.push(
									supportMultipleDDBLocationHelper.buildStorageInfo(globalTemplate, $scope)
								);
								if (globalTemplate.ddbPartitionPath !== null && globalTemplate.ddbPartitionPath !== '') {
									$scope.partitionList.push({
										mediaAgentName: globalTemplate.configureStorage.mediaAgent.mediaAgentName,
										mediaAgentId: globalTemplate.configureStorage.mediaAgent.mediaAgentId,
										path: globalTemplate.ddbPartitionPath, //"c:\\testddb_rahul",
										displayName: `${globalTemplate.configureStorage.mediaAgent.mediaAgentName} and ${globalTemplate.ddbPartitionPath}` //"ABC and c:\\testddb_rahul"
									});
								}
							}

							if (globalTemplate.isFirstMA && $scope.isCloudStorageForMultipleDDBs) {
								const isOracle =
									globalTemplate.cloudLibInfo.serverType === $scope.ORACLE_CLOUD_INFRASTRUCTURE_OBJECT_STORAGE ||
									globalTemplate.cloudLibInfo.serverType === $scope.ORACLE_CLOUD_INFRASTRUCTURE_ARCHIVE_STORAGE;
								const bucket = $scope.cloudTypeLables[globalTemplate.cloudLibInfo.serverType];
								let label = '';
								if (isOracle) {
									label = bucket.label12;
								} else {
									label = bucket.label_Bucket;
								}
								angular
									.element('#mediaAgentTable thead [data-field="storageInfo.mountPath"] .k-link span:first-child')
									.html(cvLoc(label));
							}

							/// main rule for handle ddb backup locations
							supportMultipleDDBLocationHelper.shouldShowAddButtonFromGrid($scope);
							$scope.grid.refreshData();
						}
						$scope.mode.editMode = false;
						$scope.mode.initialMode = false;
						$scope.mode.submitMode = true;
					});
			};

			const gridEmptyPlaceholderForDisk = `<svg class="add-new-placeholder placeholder-medium-size" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 160 200" xml:space="preserve"><path d="M121,167a5,5,0,0,0,5-5V38a5,5,0,0,0-5-5H39a5,5,0,0,0-5,5V162a5,5,0,0,0,5,5h82ZM44.8,53.3h70.4v3H44.8v-3Zm0,12h70.4v3H44.8v-3Zm0,12h70.4v3H44.8v-3Zm0,12h70.4v3H44.8v-3ZM72,134.8a8,8,0,1,1,8,8A8,8,0,0,1,72,134.8Z"/></svg>`;

			const gridEmptyPlaceholderForCloud =
				'<svg class="add-new-placeholder" xmlns="http://www.w3.org/2000/svg" width="200" height="200" viewBox="0 0 24 24"><path d="M22,9a4,4,0,0,0-.11-.5,3.54,3.54,0,0,0-.62-1.22l-.19-.22-.2-.21A3.55,3.55,0,0,0,17.51,6a3.66,3.66,0,0,0-1.37.71,4,4,0,0,0-.44.41l-.25,0a4.9,4.9,0,0,0-3.51-1.5h-.09A5.09,5.09,0,0,0,7.92,7.52,4,4,0,0,0,6,7H6a3.88,3.88,0,0,0-3.83,3.38A4,4,0,0,0,3.95,18H15.13a4,4,0,0,0,3.4-2h1.82A3.72,3.72,0,0,0,24,12.28,3.71,3.71,0,0,0,22,9Zm-4.15,6a3,3,0,0,1-2.77,2H4a3,3,0,0,1-3-3,3,3,0,0,1,1.9-2.81.38.38,0,0,0,.21-.34A2.86,2.86,0,0,1,6,8H6a3,3,0,0,1,1.85.64.35.35,0,0,0,.22.08h.06a.35.35,0,0,0,.24-.16,4,4,0,0,1,3.46-1.94h.1a3.93,3.93,0,0,1,3.93,3.85c0,.11,0,.21,0,.31a.33.33,0,0,0,.23.34A3,3,0,0,1,17.89,15Zm4.55-1.08A2.68,2.68,0,0,1,20.34,15H18.92a4,4,0,0,0-2.06-4.61s0-.07,0-.1A4.9,4.9,0,0,0,16.13,8a.32.32,0,0,0,.18-.1,2.88,2.88,0,0,1,1.46-1h0a2.54,2.54,0,0,1,.69-.1,2.58,2.58,0,0,1,1.78.72l.13.14.14.17a2.69,2.69,0,0,1,.55,1.55.33.33,0,0,0,.21.31A2.73,2.73,0,0,1,23,12.29,2.67,2.67,0,0,1,22.44,13.93Z"/></svg>';

			return {
				data: $scope.multipleDDBsListForNewDiskOrCloud,
				enableCheckBoxColumn: false,
				idField: 'storageInfo.mediaAgent.mediaAgentId',
				hasViews: false,
				tableName: 'mediaAgentTable',
				gridTitle: cvLoc('label.storage'),
				pageSize: 5,
				sortDirection: {
					field: 'storageInfo.mediaAgent.displayName',
					dir: 'asc'
				},
				columns: supportMultipleDDBLocationHelper.getGridColumns($scope.isDiskStorageForMultipleDDBs),
				gridToolbarMenu: [
					{
						id: 'AddMediAgentForDiskorCloud',
						disableOnDeselect: false,
						label: $scope.isDiskStorageForMultipleDDBs ? cvLoc('action.add') : cvLoc('action.addPartition'),
						onSelect: () => {
							$scope.mode.initialMode = true;
							runModal();
						}
					}
				],
				onGridDataBound: (dataItem, row) => {
					supportMultipleDDBLocationHelper.shouldShowAddButtonFromGrid($scope);
					const deleteLink = row.find('.k-grid-delete-copy');

					if (supportMultipleDDBLocationHelper.shouldBeDeleted(dataItem, $scope)) {
						deleteLink.click(() => {
							$scope.deleteButtonClicked = true;
							const permittedOptions = dataItem.permittedOptions;
							supportMultipleDDBLocationHelper.onDeleteStorage(permittedOptions.entity.storageId, $scope);
						});
					} else {
						deleteLink.hide();
					}

					row.addClass('cursor-pointer');
					row.click(() => {
						if ($scope.deleteButtonClicked) {
							return;
						}
						$scope.mode.editMode = true;
						const [primary] = $scope.multipleDDBsListForNewDiskOrCloud;
						if ($scope.isDiskStorageForMultipleDDBs) {
							$scope.globalTemplate = supportMultipleDDBLocationHelper.getConfigDiskObject(
								dataItem.storageInfo,
								$scope.globalTemplate.name,
								primary
							);
						} else {
							let serverType = {};
							if (primary.storageInfo.cloudLibInfo) {
								serverType = $scope.cloudTypeList.find(
									ctype => ctype.id === primary.storageInfo.cloudLibInfo.serverType
								);
							}
							$scope.libraryInfo = supportMultipleDDBLocationHelper.getConfigCloudObject(
								dataItem.storageInfo,
								$scope.libraryInfo.libraryEntity.libraryName,
								primary,
								serverType
							);
						}

						runModal();
					});
				},
				beforeGridInitialize: ({ grid }) => {
					$scope.grid = grid;
				},
				afterGridInitialize: () => {
					$scope.grid.gridToolbarMenu.hide('AddMediAgentForDiskorCloud');
				},
				enableFiltering: false,
				enableColumnMenu: false,
				pageSize: 10,
				gridEmptyMenu: [
					{
						id: 'gridEmptyMenuForDiskorCloud',
						label: cvLoc('action.add'),
						onSelect: () => {
							$scope.mode.initialMode = true;
							runModal();
						}
					}
				],
				gridEmptyMessage: '<div class="text-align-center">' + cvLoc('label.noDiskOrCloudAvailable', LABEL) + '</div>',
				gridEmptySvg: $scope.isCloudStorageForMultipleDDBs ? gridEmptyPlaceholderForCloud : gridEmptyPlaceholderForDisk
			};
		};

		storageFactory.tranformNewDiskConfig = config => {
			return supportMultipleDDBLocationHelper.tranformNewDiskConfig(config);
		};

		storageFactory.addCloudDDBGridOptions = $scope => {
			$scope.partitionList = $scope.partitionList || [];
			$scope.agentList = $scope.agentList;
			$scope.numDDBLimit = $scope.numDDBLimit;
			$scope.inputRequired = $scope.inputRequired;

			$scope.addDDBGridOptions = {
				gridTitle: cvLoc('label.partitionPath'),
				data: $scope.partitionList,
				tableName: 'cloudDDBsTable',
				enableColumnMenu: false,
				hideGridContextMenu: true,
				enableCheckBoxColumn: false,
				enableFiltering: false,
				columns: {
					displayName: {
						title: cvLoc('label.mediaAgent'),
						template: '#if(displayName){#<span>#=displayName#</span>#}#',
						searchField: 'displayName',
						width: '30%'
					},
					ddbPartitionPath: {
						title: cvLoc('label.ddbLocation'),
						template: `<a class="k-grid-trigger-edit-mode"> #:path# </a>`,
						searchField: 'path',
						width: '60%'
					},
					mediaAgentId: {
						title: '',
						template: `<a class="k-icon k-i-delete k-i-trash k-grid-delete-copy"></a>`,
						width: '10%',
						sortable: false,
						filterable: false,
						searchable: false
					}
				},
				beforeGridInitialize: ({ grid }) => {
					$scope.addDDBGridOptions = grid;
				},
				gridEmptyMessage: '<div>&nbsp;</div>',
				gridToolbarMenu: [
					{
						id: 'addddb',
						label: cvLoc('action.add'),
						onSelect: () => {
							processAddDDB({
								partitionList: $scope.partitionList,
								storageInfo: {
									mediaAgent: {
										mediaAgentId: 0,
										mediaAgentName: '',
										displayName: ''
									},
									ddbPartitionPath: ''
								},
								mediaAgentList: $scope.agentList.map(ma => ({ ...ma })),
								editIndex: -1,
								inputRequired: $scope.inputRequired
							});
						},
						hidden: $scope.partitionList.length === $scope.numDDBLimit
					}
				],
				onGridDataBound: (dataItem, row) => {
					$scope.shouldntAppearAPIButton = false; // API button should appear
					const deleteLink = row.find('.k-grid-delete-copy');
					const detailLink = row.find('.k-grid-trigger-edit-mode');
					deleteLink.click(() => {
						deleteDDBPath(dataItem);
					});
					detailLink.click(() => {
						let editIndex = 0;
						for (let i = 0; i < $scope.partitionList.length; i++) {
							if (
								$scope.partitionList[i].path === dataItem.path &&
								$scope.partitionList[i].mediaAgentId === dataItem.mediaAgentId
							) {
								editIndex = i;
								break;
							}
						}
						processAddDDB({
							partitionList: $scope.partitionList,
							storageInfo: {
								mediaAgent: {
									mediaAgentId: dataItem.mediaAgentId,
									mediaAgentName: dataItem.mediaAgentName,
									displayName: dataItem.displayName
								},
								ddbPartitionPath: dataItem.path
							},
							mediaAgentList: $scope.agentList.map(ma => ({ ...ma })),
							editIndex: editIndex,
							inputRequired: $scope.inputRequired
						});
					});
				}
			};
			$scope.addDDBGridOptions.pageSize = $scope.numDDBLimit + 1;

			const deleteDDBPath = dataItem => {
				let indexToRemove = 0;
				for (let i = 0; i < $scope.partitionList.length; i++) {
					if (
						$scope.partitionList[i].path === dataItem.path &&
						$scope.partitionList[i].mediaAgentId === dataItem.mediaAgentId
					) {
						indexToRemove = i;
						break;
					}
				}
				$scope.partitionList.splice(indexToRemove, 1);
				$scope.addDDBGridOptions.refreshData();
			};

			const processAddDDB = params => {
				let template = 'modules/storage/partials/addDDBCloudWindowModal.jsp';
				$modal
					.open({
						templateUrl: appUtil.appRoot + template,
						backdrop: 'static',
						windowClass: 'small-size',
						controller: [
							'$scope',
							'$uibModalInstance',
							'$controller',
							'partitionList',
							'storageInfo',
							'mediaAgentList',
							'editIndex',
							'inputRequired',
							'cvUtil',
							function(
								$scope,
								$modalInstance,
								$controller,
								partitionList,
								storageInfo,
								mediaAgentList,
								editIndex,
								inputRequired,
								cvUtil
							) {
								$scope.mediaAgentList = mediaAgentList;
								$scope.partitionList = partitionList;
								$scope.storageInfo = storageInfo;
								$scope.editIndex = editIndex;
								$scope.inputReuired = inputRequired;
								$scope.localLang = cvUtil.getIStevenLocLabels();

								$scope.localDDBPathPattern = /^([a-zA-Z]:){1}(\\[^<>:"/\\|?*]+)*\\?$/;
								$scope.linuxDDBPathPattern = /^(\/[^<>:"/\\|?*]+)+\/?$/;
								$scope.pathPattern = {
									pattern: ''
								};

								$scope.setMediaAgent = function(data) {
									$scope.mediaAgentError = false;
									if (data) {
										mbService.getOSType(data.mediaAgentId).then(function successCallBack(response) {
											$scope.separator = response.data.toLowerCase() == 'unix' ? '/' : '\\';
											$scope.pathPattern.pattern =
												response.data.toLowerCase() === 'unix'
													? $scope.linuxDDBPathPattern
													: $scope.localDDBPathPattern;
										});
									}
								};

								if ($scope.mediaAgentList.length === 1) {
									$scope.mediaAgentList[0].selected = true;
									$scope.setMediaAgent($scope.mediaAgentList[0]);
								}

								if ($scope.editIndex !== -1) {
									$scope.setMediaAgent({
										mediaAgentId: $scope.partitionList[$scope.editIndex].mediaAgentId,
										mediaAgentName: $scope.partitionList[$scope.editIndex].mediaAgentName,
										displayName: $scope.partitionList[$scope.editIndex].displayName
									});
								}

								$scope.addCloudDDBToGrid = function() {
									if ($scope.storageInfo.mediaAgent.length === 0) {
										$scope.mediaAgentError = true;
										return;
									}
									$modalInstance.close($scope.storageInfo);
								};

								$scope.cancel = function() {
									$modalInstance.dismiss();
								};

								$scope.browseForPartitionPath = function(browseParamFlags) {
									if ($scope.storageInfo.mediaAgent.length === 0) {
										$scope.mediaAgentError = true;
										return;
									} else {
										$scope.mediaAgentError = false;
									}

									var modalInstance = $modal.open({
										templateUrl: appUtil.appRoot + 'machineBrowse/partials/machineBrowse.jsp',
										controller: 'mbController',
										windowClass: 'small-size',
										resolve: {
											browseParams: function() {
												return {
													foldersOnly: true,
													clientId: $scope.storageInfo.mediaAgent[0].mediaAgentId,
													isBackupLocation: angular.isDefined(browseParamFlags)
														? !browseParamFlags.isDDBLocation
														: false,
													isDDBackupLocation: angular.isDefined(browseParamFlags)
														? browseParamFlags.isDDBLocation
														: false
												};
											}
										}
									});
									modalInstance.result.then(
										function(result) {
											$scope.storageInfo.ddbPartitionPath = result.path;
										},
										function() {}
									);
								};
							}
						],
						resolve: {
							partitionList: function() {
								return params.partitionList;
							},
							storageInfo: function() {
								return params.storageInfo;
							},
							mediaAgentList: function() {
								return params.mediaAgentList;
							},
							editIndex: function() {
								return params.editIndex;
							},
							inputRequired: function() {
								return params.inputRequired;
							}
						}
					})
					.result.then(
						function(storageInfo) {
							if (params.editIndex === -1) {
								$scope.partitionList.push({
									mediaAgentName: storageInfo.mediaAgent[0].mediaAgentName,
									mediaAgentId: storageInfo.mediaAgent[0].mediaAgentId,
									path: storageInfo.ddbPartitionPath,
									displayName: storageInfo.mediaAgent[0].displayName
								});
							} else {
								$scope.partitionList[params.editIndex].mediaAgentName = storageInfo.mediaAgent[0].mediaAgentName;
								$scope.partitionList[params.editIndex].mediaAgentId = storageInfo.mediaAgent[0].mediaAgentId;
								$scope.partitionList[params.editIndex].path = storageInfo.ddbPartitionPath;
								$scope.partitionList[params.editIndex].displayName = storageInfo.mediaAgent[0].displayName;
							}
							$scope.inputRequired.DDB = false;

							if ($scope.partitionList.length === $scope.numDDBLimit) {
								$scope.addDDBGridOptions.gridToolbarMenu.hide('addddb');
							}

							$scope.addDDBGridOptions.refreshData();
						},
						function() {}
					);
			};

			return $scope.addDDBGridOptions;
		};

		const getMetallicReplication = function(replication) {
			let replicationObjArray = [];

			for (let i = 0; i < replication.length; i++) {
				for (const key in MetallicReplication) {
					if (MetallicReplication[key].value === replication[i]) {
						replicationObjArray.push(MetallicReplication[key]);
					}
				}
			}
			replicationObjArray.sort(itemComparator);
			replicationObjArray[0].selected = true;

			return replicationObjArray;
		};

		const itemComparator = function(itemA, itemB) {
			if (itemA.label < itemB.label) {
				return -1;
			} else if (itemA.label > itemB.label) {
				return 1;
			} else {
				return 0;
			}
		};

		const getMetallicRegion = function(region) {
			let regionArray = [];

			for (let i = 0; i < region.length; i++) {
				let regionEntity = {
					label: region[i].displayName,
					value: region[i].regionId,
					name: region[i].regionName
				};

				regionArray.push(regionEntity);
			}
			regionArray.sort(itemComparator);
			return regionArray;
		};

		const getMetallicStorageClass = function(storageClass) {
			let storageClassObjArray = [];

			for (let i = 0; i < storageClass.length; i++) {
				for (const key in MetallicStorageClass) {
					if (MetallicStorageClass[key].value === storageClass[i]) {
						storageClassObjArray.push(MetallicStorageClass[key]);
					}
				}
			}
			storageClassObjArray.sort(itemComparator);
			storageClassObjArray[0].selected = true;

			return storageClassObjArray;
		};

		storageFactory.isInputRequired = function(input, opParams, checkName, checkDDB) {
			if (checkName) {
				if (input.libraryName === '') {
					opParams.inputRequired.name = true;
				} else {
					opParams.inputRequired.name = false;
				}
			}

			if (!input.mediaAgent || input.mediaAgent.mediaAgentId === 0) {
				opParams.inputRequired.mediaAgent = true;
			} else {
				opParams.inputRequired.mediaAgent = false;
			}

			if (input.licenseType.length === 0) {
				opParams.inputRequired.license = true;
			} else {
				opParams.inputRequired.license = false;
			}

			if (input.storageClass.length === 0) {
				opParams.inputRequired.storageClass = true;
			} else {
				opParams.inputRequired.storageClass = false;
			}

			if (input.region.length === 0) {
				opParams.inputRequired.region = true;
			} else {
				opParams.inputRequired.region = false;
			}

			if (input.replication.length === 0) {
				opParams.inputRequired.replication = true;
			} else {
				opParams.inputRequired.replication = false;
			}

			if (checkDDB) {
				if (input.partitionList.length === 0) {
					opParams.inputRequired.DDB = true;
				} else {
					opParams.inputRequired.DDB = false;
				}
			}

			return (
				(checkName ? opParams.inputRequired.name : false) ||
				opParams.inputRequired.license ||
				opParams.inputRequired.storageClass ||
				opParams.inputRequired.region ||
				opParams.inputRequired.replication ||
				(checkDDB ? opParams.inputRequired.DDB : false)
			);
		};

		storageFactory.setMetallicLicenseType = function(data, params) {
			params.metallicStorageInfo.licenseType = [data];
			angular.copy(params.licenseTypeToData[data.label].regionList, params.regionList);
			angular.copy(params.licenseTypeToData[data.label].storageClassList, params.storageClassList);
			angular.copy(params.licenseTypeToData[data.label].replicationList, params.replicationList);

			params.inputRequired.licenseType = false;
			for (let i = 0; i < params.storageClassList.length; i++) {
				params.storageClassList[i].selected = false;
			}
			for (let i = 0; i < params.replicationList.length; i++) {
				params.replicationList[i].selected = false;
			}
			params.storageClassList[0].selected = true;
			params.replicationList[0].selected = true;
		};

		storageFactory.setMetallicRegion = function(data, params) {
			params.metallicStorageInfo.region = [data];
			params.inputRequired.region = false;
		};

		storageFactory.setMetallicStorageClass = function(data, params) {
			params.metallicStorageInfo.storageClass = [data];
			params.inputRequired.storageClass = false;
		};

		storageFactory.setMetallicReplication = function(data, params) {
			params.metallicStorageInfo.replication = [data];
			params.inputRequired.replication = false;
		};

		storageFactory.processGetMetallicStorageInfo = function(data, params) {
			for (let respIndex = 0; respIndex < data.storageInformation.length; respIndex++) {
				for (const key in MetallicLicense) {
					if (MetallicLicense[key].value === data.storageInformation[respIndex].licenseType) {
						params.licenseTypeList.push(MetallicLicense[key]);
						let dataObj = {};
						dataObj['regionList'] = getMetallicRegion(data.storageInformation[respIndex].region);
						dataObj['storageClassList'] = getMetallicStorageClass(data.storageInformation[respIndex].storageClass);
						dataObj['replicationList'] = getMetallicReplication(data.storageInformation[respIndex].replication);
						params.licenseTypeToData[MetallicLicense[key].label] = dataObj;
						if (respIndex === 0) {
							params.licenseTypeList[0].selected = true;
							this.setMetallicLicenseType(params.licenseTypeList[0], params);
							this.setMetallicStorageClass(dataObj['storageClassList'][0], params);
							this.setMetallicReplication(dataObj['replicationList'][0], params);
						}
						break;
					}
				}
			}

			if (data.storageInformation.length > 1) {
				params.showMetallicInputs.storageClass = true;
				params.showMetallicInputs.replication = true;
			} else {
				if (data.storageInformation.length == 1) {
					if (data.storageInformation[0].storageClass.length > 1) {
						params.showMetallicInputs.showStorageClass = true;
					} else {
						let entry = getMetallicStorageClass(data.storageInformation[0].storageClass);
						this.setMetallicStorageClass(entry[0], params);
					}

					if (data.storageInformation[0].replication.length > 1) {
						params.showMetallicInputs.showReplication = true;
					} else {
						let entry = getMetallicReplication(data.storageInformation[0].replication);
						this.setMetallicReplication(entry[0], params);
					}
				}
			}
		};

		return storageFactory;
	}
]);

export default storageMod;
