import { acAppStorageModule } from 'common/js/modules';

// acAppStorageModule.directive('storageActionsCell', [function () {
//   return {
//     restrict: 'E',
//     templateUrl: appUtil.appRoot + 'modules/storage/partials/storageActionsCell.jsp',
//     scope: {
//       'row': '=',
//       'isStandAloneLibrary': '=',
//       'deleteLibrary': '=',
//       'resetLibrary': '=',
//       'exportLibrary': '=',
//       'exportLibraryCriteria': '='
//     },
//     replace: true,
//     controller: ['$scope', function ($scope) {}]
//   };
// }]);

acAppStorageModule.directive('credentialSelect', function() {
	return {
		restrict: 'E',
		templateUrl: appUtil.appRoot + 'modules/storage/partials/credentialSelect.jsp',
		scope: {
			selectedCredential: '=',
			credentialList: '=',
			isRequired: '=',
			hasError: '='
		},
		replace: true,
		controller: [
			'$scope',
			'credentialManagerFactory',
			'CREDENTIAL_TYPE',
			'storageService',
			function($scope, credentialManagerFactory, CREDENTIAL_TYPE, storageService) {
				$scope.$watch('credentialList', () => {
					if ($scope.credentialList && $scope.credentialList instanceof Array) {
						if (!$scope.credentialList.find(credential => credential.credentialId === -1))
							$scope.credentialList.unshift({ credentialName: 'Create Credential', credentialId: -1 });
					} else $scope.credentialList = [{ credentialName: 'Create Credential', credentialId: -1 }];
				});

				$scope.handlerChangeCredential = () => {
					if ($scope.selectedCredential && $scope.selectedCredential.credentialId === -1) {
						$scope.selectedCredential = { credentialId: 0, credentialName: '' };
						const cancelReloadApp = true;
						credentialManagerFactory.openCreateNewUser(cancelReloadApp).result.then(
							function() {},
							data => {
								if (data && data.msg === 'createSucessful') {
									$scope.credentialList = [];
									const requiredAccountType = CREDENTIAL_TYPE.WINDOWSACCOUNT;
									storageService
										.getCredentials(requiredAccountType)
										.then(
											credentialsList =>
												($scope.savedCredentials = credentialsList ? credentialsList.list : $scope.savedCredentials)
										);
								}
							}
						);
					}
				};
			}
		]
	};
});

acAppStorageModule.directive('selectAndCreate', function() {
	return {
		restrict: 'E',
		templateUrl: appUtil.appRoot + 'modules/storage/partials/selectAndCreate.jsp',
		scope: {
			availableOptions: '=',
			type: '=',
			selectedOption: '=',
			onItemClick: '=',
			selectId: '='
		},
		replace: true,
		controller: [
			'$scope',
			'cvLoc',
			function($scope, cvLoc) {
				setTimeout(() => {
					initializeSelect();
					$scope.selectedOption && $scope.select2.val($scope.selectedOption.locationId).trigger('change');
				}, 1);

				const initializeSelect = function() {
					const formattedOptions = $scope.availableOptions.map(option => ({
						...option,
						text: option.locationName,
						id: option.locationId
					}));

					$scope.select2 = $(`#${$scope.selectId}`)
						.select2({
							data: formattedOptions,
							placeholder: cvLoc('label.noneSelected'),
							width: '100%',
							createSearchChoice: function(term, data) {
								if (data.filter(data => data.text.localeCompare(term) === 0).length === 0) {
									return {
										id: -1,
										text: term,
										locationId: -1,
										locationName: term
									};
								}
							}
						})
						.on('select2-selecting', function(e) {
							const { locationName, locationId } = e.object;
							$scope.selectedOption = { locationName, locationId };

							$scope.onItemClick && $scope.onItemClick();
						});
				};
			}
		]
	};
});

/*
 * when you have onChangeOption you should pass as argument to your callback the selectedOption same model
 * that you use outside of this directive
 */
acAppStorageModule.directive('selectWithCreateButton', function() {
	return {
		restrict: 'E',
		templateUrl: appUtil.appRoot + 'modules/storage/partials/selectWithCreateButton.jsp',
		scope: {
			selectedOption: '=',
			optionList: '=',
			isRequired: '=',
			hasError: '=',
			onChangeOption: '=',
			onClickCreateButton: '=',
			keyLabel: '@',
			keyId: '@',
			placeholder: '@',
			selectId: '@',
			selectName: '@',
			selectDisabled: '=',
			selectOnlyOption: '=',
			editDisabled: '=',
			onClickEditButton: '=',
			isCredential: '=',
			showSaveDiscardButton: '=',
			onUpdateCredentials: '=',
			onDiscardChanges: '=',
			createButtonDisabled: '=?'
		},
		replace: true,
		controller: [
			'$scope',
			'cvUtil',
			function($scope, cvUtil) {
				$scope.keyLabel = $scope.keyLabel || 'label';
				$scope.keyId = $scope.keyId || 'id';
				$scope.localLang = cvUtil.getIStevenLocLabels();

				$scope.handlerOnChange = function() {
					$scope.onChangeOption && $scope.onChangeOption($scope.selectedOption[0]);
				};
				$scope.handlerOpenCreateModal = () => {
					$scope.onClickCreateButton && $scope.onClickCreateButton();
				};
				$scope.handlerUpdateCredential = () => {
					$scope.onUpdateCredentials();
				};

				$scope.handlerDiscardChanges = () => {
					$scope.onDiscardChanges();
				};

				$scope.handlerOpenEditModal = () => {
					$scope.onClickEditButton && $scope.onClickEditButton($scope.selectedOption[0]);
				};
			}
		]
	};
});

/**
 * Directive: cvActionsDropdown Scope: permittedOptions { entityId // node id related to dataItem entityName: //
 * node name related to dataItem, entity // config object related to a dataItem permittedActionList: [ { show: //
 * property to define visibility according to a condition label: // label for action onClick: // handler for
 * action - here you recieve as
 *
 * @params {entity} = self.permittedOptions } ] } // onClick(entity) we recommend to bind the function and
 *         pass the params that you need // instead of using default params for onClick
 */

acAppStorageModule.directive('cvActionsDropdown', function() {
	function cvActionsDropdownController($scope, $timeout, cvUtil) {
		const self = this;
		this.$onInit = function() {
			const dropdownIdSelector = `dropdown-${self.permittedOptions.entityId || $scope.$id}`;
			const dropdownMenuIdSelector = `dropdown-menu-${self.permittedOptions.entityId || $scope.$id}`;

			self.getDropdownIdSelector = () => dropdownIdSelector;
			self.getDropdownMenuIdSelector = () => dropdownMenuIdSelector;
			self.hasChildren = hasChildren;
			self.trigger = trigger;
			self.visibility = visibility;
			self.toggledOpen = false;

			self.isOpen = {
				_value: false,
				get value() {
					return self.isOpen._value;
				},
				set value(val) {
					if (self.isOpen._value !== val) {
						self.isOpen._value = val;
						// Calculate the dropdown offset in a requestAnimationFrame
						// so that uib-dropdon can initialize the dropdon position:

						cancelAnimationFrame(self.calcOffsetRafId);
						self.calcOffsetRafId = requestAnimationFrame(() => {
							self.toggledOpen = self.isOpen._value;
							self.stylesheet = { visibility: 'hidden' };
							$timeout(() => {
								if (self.isOpen._value) {
									self.dropdownMenuOffset = self.calculateDropdownOffset();
								} else {
									self.dropdownMenuOffset = null;
									self.stylesheet = null;
								}

								if (self.dropdownMenuOffset) {
									self.stylesheet = {
										visibility: 'visible',
										...self.dropdownMenuOffset
									};
								} else {
									self.stylesheet = {
										visibility: 'visible'
									};
								}
							}, 100);
						});
					}
				}
			};

			self.calculateDropdownOffset = function() {
				self.repositionQueued = false;
				const body = angular.element('body');
				const dropdown = angular.element(`#${dropdownIdSelector}`);
				const rulerMenu = angular.element(`#${dropdownMenuIdSelector}`);
				// Read height/width/position of body and dropdown:
				const bodyHeight = body.height();
				const bodyWidth = body.width();
				let dropdownMenuHeight = rulerMenu.outerHeight(true) + 1;
				let dropdownMenuWidth = rulerMenu.outerWidth(true) + 1;

				// Cap dropdown dimensions at body dimensions so that we will
				// at most move the dropdown to the top left corner:
				dropdownMenuWidth = bodyWidth < dropdownMenuWidth ? bodyWidth : dropdownMenuWidth;
				dropdownMenuHeight = bodyHeight < dropdownMenuHeight ? bodyHeight : dropdownMenuHeight;

				// Add one to height/width as a hacky fix because the ruler menu is sometimes 1px shorter than the actual dropdown menu
				const dropdownOffset = dropdown.offset();
				const dropdownHeight = dropdown.outerHeight();
				const feedbackLabelWidth = angular.element('#feedback-wrapper').outerWidth() || 0;

				//added this check because actions were not loading on grids.
				if (
					cvUtil.objectContainsNestedProperty('dropdownOffset.top', dropdownOffset) &&
					cvUtil.objectContainsNestedProperty('dropdownOffset.left', dropdownOffset) &&
					angular.isDefined(dropdownHeight)
				) {
					const dropdownMenuOffset = {
						top: dropdownOffset.top + dropdownHeight,
						left: dropdownOffset.left
					};

					// Move dropdown if it extends past the body:
					const dropdownMenuRight = dropdownMenuOffset.left + dropdownMenuWidth;
					const dropdownMenuBottom = dropdownMenuOffset.top + dropdownMenuHeight;
					const moveLeft = bodyWidth < dropdownMenuRight ? dropdownMenuRight - bodyWidth + feedbackLabelWidth : 0;
					const moveUp = bodyHeight < dropdownMenuBottom ? dropdownMenuBottom - bodyHeight : 0;
					if (moveLeft > 0 || moveUp > 0) {
						return {
							top: dropdownMenuOffset.top - moveUp,
							left: dropdownMenuOffset.left - moveLeft
						};
					} else {
						return null;
					}
				}

				return null;
			};

			function hasChildren(action) {
				return action.children && action.children.length > 0;
			}

			function trigger(action) {
				if (action.onClick) {
					action.onClick(self.permittedOptions.entity);
				}

				return;
			}

			function visibility(action) {
				return action.show === undefined ? true : action.show;
			}
			// this is by a UI-grid bug, when using server side pagination or filtering, directives will not be rendered again after applying any filtering.
			$scope.$watch('actionDropdownCtrl.permittedOptions', function(newValue, oldValue) {
				self.permittedOptions = newValue;
				//entity info of selected entity
				self.entity = self.permittedOptions.entity;
				//entity type of selected entity
				self.entityType = self.permittedOptions.entityType;
				//entity id of selected entity
				self.entityId = self.permittedOptions.entityId;
				//entityName for selected entity
				self.entityName = self.permittedOptions.entityName;
			});

			if (document.documentMode) {
				// There is an issue in Internet Explorer only where the dropdown
				// is sometimes not closed and removed if appendedToBody is true
				// and the page changes when the user clicks a dropdown option.
				// If the browser is IE then when this directive is destroyed,
				// wait for the next digest cycle, and if the menu is still
				// present then remove it
				$scope.$on('$destroy', () => {
					$scope.$applyAsync(() => {
						const dropdownMenu = angular.element(`#${self.dropdownMenuId}`);
						if (dropdownMenu.length) {
							dropdownMenu.remove();
						}
					});
				});
			}
		};
	}

	return {
		restrict: 'E',
		template: `
      <div class="btn-group cv-permitted-actions" 
        uib-dropdown data-ng-attr-id="{{actionDropdownCtrl.getDropdownIdSelector()}}" 
        is-open="actionDropdownCtrl.isOpen.value"
        dropdown-append-to-body>
        <a href class="uib-dropdown-toggle" uib-dropdown-toggle role="button">
					<span data-ng-if="actionDropdownCtrl.btnLabel" ng-bind="actionDropdownCtrl.btnLabel"></span>
					<span data-ng-if="!actionDropdownCtrl.btnLabel && actionDropdownCtrl.btnIconClassname" ng-class="actionDropdownCtrl.btnIconClassname"></span>
					<span data-ng-if="!actionDropdownCtrl.btnLabel && !actionDropdownCtrl.btnIconClassname" class="grid-action-icon"></span>
        </a>
        <ul uib-dropdown-menu 
          data-ng-attr-id="{{actionDropdownCtrl.getDropdownMenuIdSelector()}}" 
          class="dropdown-menu cv-dropdown-style-2 cv-permitted-actions-append-to-body" 
          data-ng-class="{hidden: !actionDropdownCtrl.toggledOpen}"
          role="menu" data-ng-style="actionDropdownCtrl.stylesheet">
            <li data-ng-repeat="action in actionDropdownCtrl.permittedOptions.permittedActionList" 
                data-ng-if="actionDropdownCtrl.visibility(action)"
                data-ng-class="{'dropdown-submenu dropdown-submenu-left': actionDropdownCtrl.hasChildren(action)}">
                
                <a data-ng-click="actionDropdownCtrl.trigger(action)" data-ng-bind="action.label"></a>

              <ul class="dropdown-menu cv-dropdown-style-2 margin-top-10" data-ng-if="actionDropdownCtrl.hasChildren(action)">
                <li data-ng-repeat="child in action.children">
                  <a href data-ng-click="child.onClick()" data-ng-bind="child.label"></a>
                </li>
              </ul>
            </li>
        </ul>
      </div>    
    `,
		scope: {
			permittedOptions: '=',
			btnLabel: '=',
			btnIconClassname: '='
		},
		replace: true,
		controllerAs: 'actionDropdownCtrl',
		bindToController: true,
		controller: ['$scope', '$timeout', 'cvUtil', cvActionsDropdownController]
	};
});

export default acAppStorageModule;
