import { acAppStorageModule } from 'common/js/modules';
import 'modules/storage/js/factories/addEncryptionDialog.factory.js';

acAppStorageModule.directive('cvEncryptionComponent', function() {
	return {
		restrict: 'E',
		scope: {
			encryption: '=',
			storagePolicyCopy: '=',
			keyManagement: '=',
			keyProviders: '='
		},
		replace: true,
		controllerAs: 'vm',
		bindToController: true,
		controller: [
			'$scope',
			'$state',
			'$rootScope',
			'$uibModal',
			'cvLoc',
			'encryptService',
			'keyManagementFactory',
			'addEncryptionDialogFactory',
			EncryptionControllerWrapper()
		],
		templateUrl: appUtil.appRoot + 'modules/storage/partials/cvEncryptionComponentTemplate.jsp'
	};
});

function EncryptionControllerWrapper() {
	return class EncryptionController {
		constructor(
			$scope,
			$state,
			$rootScope,
			$modal,
			cvLoc,
			encryptService,
			keyManagementFactory,
			addEncryptionDialogFactory
		) {
			this.$scope = $scope;
			this.$state = $state;
			this.$rootScope = $rootScope;
			this.$modal = $modal;
			this.cvLoc = cvLoc;
			this.encryptService = encryptService;
			this.keyManagementFactory = keyManagementFactory;
			this.addEncryptionDialogFactory = addEncryptionDialogFactory;
		}

		$onInit() {
			this.serverMessage = null;
			this.initEditingEncryptionTile();
			this.configEncryptionType();
			this.handleKeyManagementServers();
			this.encryptService.isChangedkeyManagement = false;
			this.isEditingEncrypt = false;
			this.KeyManagementServerActions = {
				label: 'Add',
				permittedOptions: {
					entityId: 'KeyManagementServerActions',
					permittedActionList: [
						{
							show: true,
							label: this.cvLoc('label.awsKmsp'),
							onClick: () =>
								this.keyManagementFactory.addAWS(this.$scope, this.$rootScope, this.$modal, this.cvLoc, null)
						},
						{
							show: true,
							label: this.cvLoc('label.kmip'),
							onClick: () =>
								this.keyManagementFactory.addKMIP(this.$scope, this.$rootScope, this.$modal, this.cvLoc, null)
						},
						{
							show: true,
							label: this.cvLoc('label.passphrase'),
							onClick: () =>
								this.keyManagementFactory.addPassphrase(this.$scope, this.$rootScope, this.$modal, this.cvLoc, {
									typeToShow: 'all'
								})
						}
					]
				}
			};
		}

		handleKeyManagementServers() {
			this.keyManagementList = (this.keyProviders || []).map(elem => {
				return {
					keyProviderType: elem.keyProviderType,
					...elem.provider,
					selected: false
				};
			});

			const selectedKeyProvider = this.keyManagementList.find(
				keyProvider => keyProvider.keyProviderName === this.encryption.managementServer
			);
			if (selectedKeyProvider) {
				selectedKeyProvider.selected = true;
				this.test.selectedKeyManagement.push(selectedKeyProvider);
			}
		}

		configEncryptionType() {
			this.cipherList = [
				{ id: 2, name: 'BlowFish', keyLength: [128, 256], selected: false },
				{ id: 3, name: 'AES', keyLength: [128, 256], selected: false },
				{ id: 4, name: 'Serpent', keyLength: [128, 256], selected: false },
				{ id: 5, name: 'TwoFish', keyLength: [128, 256], selected: false },
				{ id: 6, name: 'DES3', keyLength: [192], selected: false },
				{ id: 8, name: 'GOST', keyLength: [256], selected: false }
			];

			const selectedCipher = this.cipherList.find(
				cipher => cipher.name.toLowerCase() === this.encryption.cipher.keyName.toLowerCase()
			);

			if (selectedCipher) {
				selectedCipher.selected = true;
				this.test.selectedCipher.push(selectedCipher);
				this.test.selectedKeyLength.push({ length: this.encryption.cipher.keyLength, selected: true });
				this.getkeyLengths();
			}
		}

		initEditingEncryptionTile() {
			this.test = {
				selectedCipher: [],
				selectedKeyLength: [],
				selectedKeyManagement: []
			};
		}

		getkeyLengths() {
			// in some cases, it could be only one option. So we set the selection by default
			if (this.test.selectedCipher[0].keyLength.length === 1) {
				this.keyLengths = [
					{
						length: this.test.selectedCipher[0].keyLength[0],
						selected: true
					}
				];
				return;
			}

			this.keyLengths = this.test.selectedCipher[0].keyLength.map(elem => {
				return {
					length: elem,
					selected: this.test.selectedKeyLength.length > 0 && elem === this.test.selectedKeyLength[0].length
				};
			});
		}

		putEncryption() {
			this.encryptService
				.updateEncryption(this.encryption, this.storagePolicyCopy, this.test)
				.then(data => {
					if (data.error || data.errorMessage) {
						this.encryption.encrypt = this.backupEncryptValue;
					}
				})
				.finally(() => {
					this.initEditingEncryptionTile();
					this.configEncryptionType();
					this.handleKeyManagementServers();
				});
		}

		updateEncryption(toChange) {
			let isChanged = false;
			this.serverMessage = null;
			switch (toChange) {
				case 'encryption':
					const validateKeyNameAndLength =
						this.encryption.cipher.keyName !== this.test.selectedCipher[0].name ||
						this.test.selectedKeyLength[0].length !== this.encryption.cipher.keyLength;
					isChanged = !this.encryption.encrypt || (this.test.selectedCipher && validateKeyNameAndLength);
					if (!isChanged) {
						this.isEditingEncrypt = false;
					}
					break;
				case 'storeOnMedia':
					this.encryption.storeOnMedia = !this.encryption.storeOnMedia;
					isChanged = true;
					break;
				case 'keyManagement':
					isChanged =
						this.test.selectedKeyManagement &&
						this.test.selectedKeyManagement[0].keyProviderName !== this.encryption.managementServer;
					this.encryptService.isChangedkeyManagement = isChanged;
					this.isEditingKeyManagement = false;
					break;
			}
			isChanged && this.putEncryption();
		}

		onToggleEncrypt() {
			this.backupEncryptValue = this.encryption.encrypt;
			this.encryption.encrypt = !this.encryption.encrypt;
			if (this.encryption.encrypt) {
				this.addEncryptionDialogFactory.showAddEncryptionDialog({
					encryption: this.encryption,
					storagePolicyCopy: this.storagePolicyCopy,
					cipherList: this.cipherList,
					opts: this.test,
					keyLengths: this.keyLengths,
					getkeyLengths: this.getkeyLengths
				});
			} else {
				this.putEncryption();
			}
		}

		editEncrypt() {
			this.isEditingEncrypt = this.encryption.encrypt && !this.isEditingEncrypt;
		}

		onToggleEditKeyManagement() {
			this.isEditingKeyManagement = !this.isEditingKeyManagement;
		}
	};
}

export default acAppStorageModule;
