import 'adminConsole/js/directives/cv-detect-tape-library.js';
import 'browse/js/controllers/browse.ctrl.js';
import 'machineBrowse/js/controllers/machineBrowse.ctrl.js';
import 'machineBrowse/js/services/machineBrowse.svc.js';
import 'storage/js/services/storage.svc.js';
import 'webScale/js/controllers/storagePool.ctrl.js';
import 'adminConsole/js/controllers/cloudLibConstants.js';
import 'dlo/js/controllers/profile.ctrl.js';
import 'adminConsole/js/factories/rpstore.factory.js';
import 'adminConsole/js/controllers/rpstore.ctrl.js';
import { acAppStorageModule } from 'common/js/modules';
import 'ediscovery/common/js/controllers/dataSourceSecurity.ctrl.js';
import 'ediscovery/common/js/directives/dataSourceSecurity.js';
import 'modules/storage/js/constants/storage.constants.js';
//service
import 'modules/storage/js/services/vaultTracker.svc.js';
import 'adminConsole/js/controllers/security.ctrl.js';
import 'modules/schedule/js/factory/schedule.factory.js';
import 'vsa/js/services/schedules.svc.js';

var storageMod = acAppStorageModule;

var vaultTrackerController = {};

vaultTrackerController.vaultController = [
	'$scope',
	'$http',
	'storageService',
	'$rootScope',
	'$uibModal',
	'cvBreadcrumbsTabsFactory',
	'$stateParams',
	'cvTableOptions',
	'cvLoc',
	'$state',
	'$dialogs',
	'LibraryConstants',
	'DriveConstants',
	'ReportConstants',
	'rpStoreFactory',
	'storageFactory',
	'dsSecurityFactory',
	'VaultTrackerService',
	'$log',
	'$location',
	'securityFactory',
	'scheduleUIFactory',
	'cvUtil',
	'scheduleService',
	'VaultTrackerConstants',
	'cvToaster',
	function(
		$scope,
		$http,
		storageService,
		$rootScope,
		$modal,
		cvBreadcrumbsTabsFactory,
		$stateParams,
		cvTableOptions,
		cvLoc,
		$state,
		$dialogs,
		LibraryConstants,
		DriveConstants,
		ReportConstants,
		rpStoreFactory,
		storageFactory,
		dsSecurityFactory,
		VaultTrackerService,
		$log,
		$location,
		securityFactory,
		scheduleUIFactory,
		cvUtil,
		scheduleService,
		VaultTrackerConstants,
		cvToaster
	) {
		// getting arguments
		$scope.vaultId = $stateParams['vaultId'];
		$scope.vaultName = $stateParams['vaultName'];
		$scope.libraryId = $stateParams['libraryId'];
		$scope.libraryName = $stateParams['libraryName'];
		$scope.model = $stateParams['model'];
		$scope.controlId = '48'; // WAIT
		$scope.availableTransit = [];
		$scope.availableDestinations = [];
		$scope.VTScheduleArray = [];

		$scope.forms = {
			general: {
				values: {
					policyName: null,
					description: null,
					enable: false,
					autoAcknowledge: false
				}
			},
			media: {
				editing: false,
				isDirty: false,
				values: {
					fullTape: false,
					includeTape: false,
					lastTape: {
						value: null,
						hasError: false
					},
					excludeMedia: false,
					limitMedia: {
						value: null,
						hasError: false
					}
				},
				isEditing: {
					fullTape: false,
					includeTape: false,
					lastTape: false,
					excludeMedia: false,
					limitMedia: false
				}
			},
			destination: {
				isDirty: false,
				values: {
					trackTransit: null,
					destination: null
				},
				isEditing: {
					trackTransit: false,
					destination: false
				}
			}
		};

		$scope.payloadData = {};

		// Get Services
		VaultTrackerService.getVaultTrackerDetails($scope.vaultId)
			.success(function(vaultDetails) {
				if (vaultDetails.vaultTrackerPolicies.length > 0) {
					$scope.vaultDetails = vaultDetails.vaultTrackerPolicies[0];
					$scope.payloadData = $scope.vaultDetails;

					// set values:
					// Title:
					$scope.vaultName = $scope.vaultDetails.trackingPolicy.trackingPolicyName;
					// General
					$scope.forms.general.values.policyName = $scope.vaultDetails.trackingPolicy.trackingPolicyName;
					$scope.forms.general.values.description = $scope.vaultDetails.description;
					$scope.forms.general.values.enable = $scope.vaultDetails.enable;
					$scope.forms.general.values.autoAcknowledge = $scope.vaultDetails.autoAcknowledge;
					$scope.controlId = $scope.vaultDetails.trackingPolicy.trackingPolicyId; // WAIT

					// Media Status
					// ASK all media variable from the server
					let exportCriteria = $scope.vaultDetails.sourceLocation.exportCriteria;
					if (exportCriteria) {
						if (exportCriteria.mediaStatus) {
							$scope.forms.media.values.fullTape = exportCriteria.mediaStatus.fullAssignedMedia;
							$scope.forms.media.values.includeTape = exportCriteria.mediaStatus.appendableAssignedMedia;
						}
						$scope.forms.media.values.excludeMedia = exportCriteria.excludeMediaNotCopied || false;
						$scope.forms.media.values.limitMedia.value = exportCriteria.limitMediaCountForExport
							? exportCriteria.limitMediaCountForExport.value
							: 0; //exportCriteria.limitMediaCountForExport.limitMediaCount;
						$scope.forms.media.values.lastTape.value = exportCriteria.tapeWrittenToLastDay
							? exportCriteria.tapeWrittenToLastDay
							: 0; // exportCriteria.limitMediaCountForExport.value;
					}

					// Destination
					$scope.initializeDestinationTile();
				}
			})
			.error(function(e) {
				console.log('ERROR: ', e);
			});

		$scope.getDestinationName = function() {
			if (!$scope.vaultDetails) return '';
			const destinationLocation = $scope.vaultDetails.destinationLocation;
			return (
				(destinationLocation.location && destinationLocation.location.locationName) ||
				(destinationLocation.library && destinationLocation.library.libraryName) ||
				(destinationLocation.shelf && destinationLocation.shelf.shelfName) ||
				''
			);
		};

		$scope.initializeDestinationTile = () => {
			$scope.forms.destination.values.trackTransit = [];
			$scope.forms.destination.values.destination = [];

			$scope.isLoadedLocations = false;
			VaultTrackerService.getLocations()
				.success(function(response) {
					let transitLocName = $scope.vaultDetails.trasitLocation
						? $scope.vaultDetails.trasitLocation.locationName
						: '';
					$scope.availableTransit = response.locations.map(opt => {
						if (opt.isTransit) {
							if (opt.location.locationName == transitLocName) {
								$scope.forms.destination.values.trackTransit.push(opt.location);
								return {
									...opt.location,
									ticked: true
								};
							} else {
								return {
									...opt.location,
									ticked: false
								};
							}
						}
					});
					$scope.availableTransit = $scope.availableTransit.filter(item => item != undefined);

					let destinationLocName = $scope.getDestinationName();
					$scope.availableDestinations = response.locations.map(opt => {
						if (!opt.isTransit && (typeof opt.location === undefined || opt.location.locationId !== 0)) {
							if (typeof opt.location !== undefined && opt.location.locationName == destinationLocName) {
								$scope.forms.destination.values.destination.push(opt.location);
								return {
									...opt.location,
									ticked: true
								};
							} else {
								return {
									...opt.location,
									ticked: false
								};
							}
						}
					});
					$scope.availableDestinations = $scope.availableDestinations.filter(item => item != undefined);
					$scope.isLoadedLocations = true;
				})
				.error(function(e) {
					$dialogs.error(cvLoc('label.error'), e.errorMessage);
					$log.error('Getting Locations failed');
				});
		};

		$scope.scheduleObjectTaskInfoList = [];

		// Get Schedule
		function getAllSchedule() {
			VaultTrackerService.getVTSchedule($scope.vaultId)
				.success(function(VTSchedule) {
					$scope.scheduleObjectTaskInfoList = VTSchedule.taskDetail;
				})
				.error(function(e) {
					console.log('ERROR: ', e);
				});
		}

		getAllSchedule();

		// Security in VT
		$scope.entityType = 'TRACKING_POLICY_ENTITY';
		$scope.entityType = $scope.entityType;

		$scope.genericEntity = {
			trackingPolicyId: parseInt($scope.vaultId) || null
		};
		$scope.genericEntity = $scope.genericEntity;

		$scope.formattedSecurityAssociations = securityFactory.createSecurityAssociationsObject();
		$scope.associationsLoaded = false;

		securityFactory.getSecurityAssociation($scope.entityType, parseInt($scope.vaultId)).success(function(data) {
			$scope.formattedSecurityAssociations = securityFactory.formatSecurityAssociationsObject(
				data.securityAssociations
			);
			$scope.associationsLoaded = true;
		});

		$scope.storageLink =
			'/tapeLibrary/mediaDetails?libraryId=' +
			$scope.libraryId +
			'&libraryName=' +
			encodeURIComponent($scope.libraryName) +
			'&model=' +
			$scope.model;

		$scope.stateName = $state.current.name;

		var breadCrumbs = [
			{
				title: cvLoc('label.nav.tape'),
				link: '#storage/tape'
			},
			{
				title: $scope.libraryName,
				link: '#' + $scope.storageLink
			}
		];

		if ($scope.stateName === 'vaultTrackerPolicyActions' || $scope.stateName === 'vaultTrackerPolicyActionDetails') {
			breadCrumbs.push({
				title: $scope.vaultName,
				link:
					'#/vaultTracker?vaultId=' +
					$scope.vaultId +
					'&vaultName=' +
					$scope.vaultName +
					'&libraryId=' +
					$scope.libraryId +
					'&libraryName=' +
					$scope.libraryName +
					'&model=' +
					$scope.model
			});
			if ($scope.stateName === 'vaultTrackerPolicyActionDetails') {
				breadCrumbs.push({
					title: cvLoc('label.vaultTrackerActions'),
					link:
						'#/vaultTrackerPolicyActions?input.LibraryId=' +
						$scope.libraryId +
						'&input.PolicyId=' +
						$scope.vaultId +
						'&input.model=' +
						$scope.model +
						'&vaultId=' +
						$scope.vaultId +
						'&vaultName=' +
						$scope.vaultName +
						'&libraryId=' +
						$scope.libraryId +
						'&libraryName=' +
						encodeURIComponent($scope.libraryName) +
						'&model=' +
						$scope.model
				});
			}
		}
		cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);

		// dom methods
		$scope.deleteVault = () => {
			var callBackFunctions = {
				noFunction: function() {},
				yesFunction: function() {
					const body = {
						trackingPolicy: {
							trackingPolicyId: $scope.vaultId
						}
					};
					VaultTrackerService.deleteVaultTracker($scope.vaultId, body, true)
						.success(function(response) {
							$log.debug('Delete VaulTracker success');
							$location.url($scope.storageLink);
						})
						.error(function(e) {
							$dialogs.error(cvLoc('label.error'), e.errorMessage);
							$log.error('Deletion of VaulTracker failed');
						});
				}
			};
			$dialogs.confirm(
				cvLoc('label.confirmDelete'),
				cvLoc('label.confirmationStoragePool', '<b>' + $scope.vaultName + '</b>'),
				callBackFunctions
			);
		};

		$scope.returnScheduleObject = function(pattern, subTaskId) {
			pattern.subTaskType = 1;
			pattern.operationType = 'VT'; // 4010;
			delete pattern.planSubType;
			delete pattern.backupLevel;
			return {
				subTask: {
					subTaskName: pattern.name,
					subTaskType: 1,
					subTaskId: subTaskId,
					operationType: pattern.operationType
				},
				pattern: {
					...pattern
				},
				options: {
					adminOpts: {
						runvtPolicyOption: {
							vTPolicy: {
								trackingPolicyName: $scope.forms.general.values.policyName,
								_type_: 21
							},
							sourceLibrary: {
								libraryId: Number($scope.libraryId)
							}
						}
					}
				}
			};
		};

		$scope.addSchedule = function() {
			$scope.oneTime = false;
			scheduleUIFactory.addNewSchedule(null, 'vaultTracker');
		};

		const scheduleAddedListener = $rootScope.$on('scheduleAdded', function(evt, addedSchedule) {
			$scope.scheduleObject = {
				associations: [
					{
						trackingPolicyId: Number($scope.vaultId),
						trackingPolicyName: $scope.vaultName,
						_type_: 21
					}
				],
				task: {
					ownerId: 1,
					taskType: 2,
					ownerName: 'admin',
					sequenceNumber: 0,
					initiatedFrom: 1,
					policyType: 1,
					taskFlags: {
						isEdgeDrive: false,
						isEZOperation: false,
						disabled: false
					}
				},
				subTasks: []
			};

			//this event will be called twice when plan has secondary schedule, for secondary schedule, don't do anything
			if (!$scope.oneTime) {
				$scope.scheduleObject.subTasks.push(addedSchedule);
				$scope.oneTime = true;
			}
			$scope.populateTask();

			VaultTrackerService.runNowVaultTracker(0, JSON.stringify({ taskInfo: $scope.scheduleObject }))
				.success(function(response) {
					getAllSchedule(); //Needed as we need the auto generated TaskId from DB
				})
				.error(function(e) {
					$dialogs.error(cvLoc('label.error'), e.errorMessage);
				});
		});

		const scheduleEditedListener = $rootScope.$on('scheduleEdited', function(evt, addedSchedule) {
			var subTaskId = addedSchedule.id;
			var taskIndex = $scope.scheduleObjectTaskInfoList
				.map(function(x) {
					return x.subTasks[0].subTask.subTaskId;
				})
				.indexOf(subTaskId);

			if (taskIndex >= 0) {
				$scope.scheduleObjectTaskInfoList[taskIndex].subTasks[0] = $scope.returnScheduleObject(
					addedSchedule,
					subTaskId
				);
				addedSchedule.planSubType = VaultTrackerConstants.DEFAULT_PLAN_SUB_TYPE;
				addedSchedule.operationType = VaultTrackerConstants.DEFAULT_OPERATION_TYPE;
				addedSchedule.subTaskType = VaultTrackerConstants.DEFAULT_SUB_TASK_TYPE;

				scheduleService
					.modifySchedule(
						$scope.scheduleObjectTaskInfoList[taskIndex].task.taskId,
						subTaskId,
						addedSchedule,
						undefined,
						true
					)
					.success(function(response) {
						$log.debug('Successfully updated VaultTracker schedule');
					})
					.error(function(error) {
						$log.error('Failed to update VaultTracker schedule');
					});
			}
		});

		const scheduleDeletedListener = $rootScope.$on('scheduleDeleted', function(evt, addedSchedule) {
			var subTaskId = addedSchedule.id;
			var taskIndex = $scope.scheduleObjectTaskInfoList
				.map(function(x) {
					return x.subTasks[0].subTask.subTaskId;
				})
				.indexOf(subTaskId);
			const taskId = $scope.scheduleObjectTaskInfoList[taskIndex].task.taskId;
			$scope.scheduleObjectTaskInfoList.splice(taskIndex, 1);
			scheduleService.deleteSchedule(taskId, subTaskId);
		});

		$scope.$on('$destroy', scheduleAddedListener, scheduleEditedListener, scheduleDeletedListener);

		$scope.populateTask = function() {
			if ($scope.scheduleObject.subTasks.length > 0) {
				$scope.scheduleObject.associations[0].trackingPolicyName = $scope.vaultName;

				$scope.scheduleObject.subTasks = $scope.scheduleObject.subTasks.map(item => {
					let scheduleItem = scheduleUIFactory.convertScheduleToSubTaskInfo(item);
					delete scheduleItem.options;
					scheduleItem.subTask = {
						subTaskName: scheduleItem.pattern.name,
						subTaskType: 1,
						operationType: 4010
					};
					scheduleItem.options = {
						backupOpts: {
							backupLevel: 2,
							dataOpt: {
								dataOpt: {
									autoCopy: false
								}
							}
						},
						adminOpts: {
							runvtPolicyOption: {
								vTPolicy: {
									trackingPolicyId: Number($scope.vaultId),
									trackingPolicyName: $scope.vaultName,
									_type_: 21
								},
								sourceLibrary: {
									libraryId: Number($scope.libraryId)
								}
							}
						}
					};

					switch (scheduleItem.pattern.freq_type) {
						case 'Weekly':
							scheduleItem.pattern.freq_type = 8;
							scheduleItem.pattern.active_end_occurence = 0;
							scheduleItem.pattern.active_end_time = 0;
							scheduleItem.pattern.active_start_date = 1541376000; // need to change ?
							scheduleItem.pattern.calendar = { calendarId: 1, calendarName: 'Standard' };
							scheduleItem.pattern.calendarId = 1;
							scheduleItem.pattern.description = 'Every week on Friday at 8:00 AM starting November 5, 2018 '; // need to change ?
							scheduleItem.pattern.freq_recurrence_factor = 1;
							scheduleItem.pattern.freq_relative_interval = 0;
							scheduleItem.pattern.freq_type = 8;
							scheduleItem.pattern.skipDayNumber = 0;
							scheduleItem.pattern.skipOccurence = 0;
							scheduleItem.pattern.timeZone = VaultTrackerConstants.DEFAULT_CS_TIME_ZONE;
							delete scheduleItem.pattern.daysToRun.Saturday;
							break;
						case 'One_Time':
							scheduleItem.pattern.freq_type = 1;
							scheduleItem.pattern.active_start_time = item.activeStartTime;
							scheduleItem.pattern.freq_recurrence_factor = 1;
							scheduleItem.pattern.freq_subday_interval = 0;
							scheduleItem.pattern.timeZone = VaultTrackerConstants.DEFAULT_CS_TIME_ZONE;
							break;
						case 'Daily':
							scheduleItem.pattern.timeZone = VaultTrackerConstants.DEFAULT_CS_TIME_ZONE;
							scheduleItem.pattern.freq_type = 4;
							scheduleItem.pattern.active_end_occurence = 0;
							scheduleItem.pattern.active_end_time = 0;
							scheduleItem.pattern.active_start_date = 1541376000; // need to change ?
							scheduleItem.pattern.description = 'Every day at 8:00 AM starting November 14, 2018 '; // need to change ?
							scheduleItem.pattern.freq_recurrence_factor = 1;
							delete scheduleItem.pattern.daysToRun;
							break;
						case 'Monthly':
							scheduleItem.pattern.freq_type = 16;
							scheduleItem.pattern.timeZone = VaultTrackerConstants.DEFAULT_CS_TIME_ZONE;
							scheduleItem.pattern.freq_recurrence_factor = 1;
							scheduleItem.pattern.active_start_date = 1542326400; // need to change ?
							scheduleItem.pattern.active_start_time = item.activeStartTime;
							scheduleItem.pattern.active_end_occurence = 0;
							scheduleItem.pattern.active_end_time = 0;
							scheduleItem.pattern.calendar = { calendarId: 1, calendarName: 'Standard' };
							scheduleItem.pattern.calendarId = 1;
							scheduleItem.pattern.description = 'Every month on day 10  at 9:00 AM starting November 16, 2018 '; // need to change ?
							break;
						case 'Monthly_Relative':
							scheduleItem.pattern.freq_type = 32;
							scheduleItem.pattern.timeZone = VaultTrackerConstants.DEFAULT_CS_TIME_ZONE;
							scheduleItem.pattern.freq_recurrence_factor = 1;
							scheduleItem.pattern.active_end_occurence = 0;
							scheduleItem.pattern.active_end_time = 0;
							scheduleItem.pattern.calendar = { calendarId: 1, calendarName: 'Standard' };
							scheduleItem.pattern.calendarId = 1;
							break;
						default:
							break;
					}
					return scheduleItem;
				});
			}
		};

		$scope.editSchedule = function(obj) {
			var showEdit = true;
			obj.context = 'SCHEDULE_POLICY';

			const payload = {
				subtaskId: obj.subTasks[0].subTask.subTaskId,
				taskId: obj.task.taskId
			};

			VaultTrackerService.getVTScheduleDetails(payload)
				.success(function(response) {
					const scheduleParsed = response;
					scheduleParsed.planSubType = 'vaultTracker';
					scheduleParsed.backupLevel = 'vaultTracker';
					let time = 0;
					if (scheduleParsed.activeStartTime || scheduleParsed.activeStartTime == 0) {
						time = scheduleParsed.activeStartTime;
						scheduleParsed.scheduleTime = cvUtil.convertCvTimeToDate(time);
						scheduleParsed.dailyBackupHours = scheduleParsed.scheduleTime.getHours();
						scheduleParsed.dailyBackupMinutes = scheduleParsed.scheduleTime.getMinutes();
					}

					scheduleParsed.id = payload.subtaskId;
					scheduleUIFactory.addSchedule(
						{
							source: 'createProfile',
							model: { ...scheduleParsed }
						},
						showEdit,
						$scope.planSubType,
						false,
						'',
						'',
						'',
						undefined,
						undefined,
						undefined,
						true
					);
				})
				.error(function(error) {
					console.log('Error', error);
				});
		};

		$scope.oldType;
		$scope.onEdit = type => {
			if (!$scope.oldType) {
				$scope.oldType = type;
			}
			$scope.forms[type].editing = !$scope.forms[type].editing;

			if ($scope.isOtherEditing(type)) {
				var callBackFunctions = {
					noFunction: () => {
						$scope.forms[type].editing = !$scope.forms[type].editing;
						$scope.forms.destination.editing = false;
						$scope.forms.media.editing = false;
						$scope.forms.general.editing = false;
						$scope.forms[$scope.oldType].editing = true;
					},
					yesFunction: () => {
						$state.forceReload();
					}
				};
				$dialogs.confirm(cvLoc('label.caution'), cvLoc('label.changeEdit'), callBackFunctions);
			}
		};

		$scope.changeSelective = type => {
			switch (type) {
				case 'full_tape':
					if ($scope.forms.media.editing) {
						$scope.forms.media.values.fullTape = !$scope.forms.media.values.fullTape;
						$scope.forms.media.isDirty = true;
					}
					break;
				case 'include_tape':
					if ($scope.forms.media.editing) {
						$scope.forms.media.values.includeTape = !$scope.forms.media.values.includeTape;
						$scope.forms.media.isDirty = true;
					}
					break;
				case 'exclude_media':
					if ($scope.forms.media.editing) {
						$scope.forms.media.values.excludeMedia = !$scope.forms.media.values.excludeMedia;
						$scope.forms.media.isDirty = true;
					}
					break;
				case 'autoAcknowledge':
					if ($scope.forms.general.editing) {
						$scope.forms.general.values.autoAcknowledge = !$scope.forms.general.values.autoAcknowledge;
						$scope.forms.general.isDirty = true;
					}
					break;
				case 'general_enable':
					if ($scope.forms.general.editing) {
						$scope.forms.general.values.enable = !$scope.forms.general.values.enable;
						$scope.forms.general.isDirty = true;
					}
					break;
				default:
					break;
			}
		};

		$scope.isOtherEditing = type => {
			if ($scope.forms.media.editing && $scope.forms.destination.editing) {
				if ($scope.forms.media.editing && type !== 'media') {
					return true;
				} else if ($scope.forms.destination.editing && type !== 'destination') {
					return true;
				}
			} else {
				return false;
			}
		};

		// On saves
		$scope.onMediaSave = () => {
			if (!$scope.forms.media.values.limitMedia.hasError && !$scope.forms.media.values.lastTape.hasError) {
				if ($scope.forms.media.isDirty) {
					$scope.onSave('media');
				} else {
					$scope.forms.media.editing = false;
					$scope.forms.media.isDirty = false;
				}
			}
		};

		$scope.destinationTouched = function() {
			$scope.forms.destination.isDirty = true;
		};

		$scope.onDestinationSave = () => {
			if ($scope.forms.destination.isDirty) {
				$scope.onSave('destination');
			} else {
				$scope.forms.destination.isDirty = false;
				$scope.forms.destination.editing = false;
			}
		};

		$scope.onGeneralSave = () => {
			if ($scope.forms.general.isDirty) {
				$scope.onSave('general');
			} else {
				$scope.forms.general.isDirty = false;
				$scope.forms.general.editing = false;
			}
		};

		$scope.onSave = value => {
			var callBackFunctions = {
				noFunction: () => {
					$scope.forms[value].isDirty = false;
					$state.forceReload();
				},
				yesFunction: () => {
					// save form determination
					switch (value) {
						case 'media':
							$scope.mediaSave();
							break;
						case 'destination':
							$scope.destinationSave();
							break;
						case 'general':
							$scope.generalSave();
							break;
					}
				}
			};
			$dialogs.confirm(cvLoc('title.confirmStoragePolicy'), cvLoc('label.confirmStoragePolicyEdit'), callBackFunctions);
		};

		// actual saves
		$scope.mediaSave = () => {
			let payload = {
				trackingPolicy: {
					vaultTrackerPolicyType: 1,
					sourceLocation: {
						exportCriteria: {
							limitMediaCountForExport: {},
							mediaGroups: {
								all: true
							},
							mediaStatus: {}
						},
						libraryList: [
							{
								libraryId: Number($scope.libraryId)
							}
						]
					},
					trackingPolicy: {
						trackingPolicyId: Number($scope.vaultId)
					}
				}
			};

			const exportCriteria = payload.trackingPolicy.sourceLocation.exportCriteria;

			exportCriteria.tapeWrittenToLastDay = $scope.forms.media.values.lastTape.value;
			exportCriteria.excludeMediaNotCopied = $scope.forms.media.values.excludeMedia;
			exportCriteria.limitMediaCountForExport.value = $scope.forms.media.values.limitMedia.value; // $scope.forms.media.values.lastTape;
			exportCriteria.limitMediaCountForExport.limitMediaCount = 1; // $scope.forms.media.values.limitMedia;
			exportCriteria.mediaStatus.activeAssignedMedia = $scope.forms.media.values.includeTape; // $scope.forms.media.values.excludeMedia;
			exportCriteria.mediaStatus.appendableAssignedMedia = $scope.forms.media.values.includeTape;
			exportCriteria.mediaStatus.fullAssignedMedia = $scope.forms.media.values.fullTape;
			VaultTrackerService.putVaultTrackerDetails(JSON.stringify(payload), $scope.vaultId)
				.success(function(response) {
					// $state.forceReload();
				})
				.error(function(e) {
					$dialogs.error(cvLoc('label.error'), e.errorMessage);
					$log.error('Deletion of VaulTracker failed');
					// $state.forceReload();
				});
			$scope.forms.media.editing = false;
			$scope.forms.media.isDirty = false;
		};

		$scope.destinationSave = () => {
			let destination = $scope.forms.destination.values.destination;
			let transit = $scope.forms.destination.values.trackTransit;
			let payload = {
				trackingPolicy: {
					vaultTrackerPolicyType: 1,
					trackingPolicy: {
						trackingPolicyId: Number($scope.vaultId)
					}
				}
			};

			let reloadLocations = false;

			if (destination.length > 0) {
				if (destination[0].locationId === -1) {
					delete destination[0].locationId;
					reloadLocations = true;
				}
				delete destination[0].ticked;
				if (destination[0].locationName !== $scope.getDestinationName()) {
					payload.trackingPolicy.destinationLocation = {
						destinationType: 2,
						location: destination[0]
					};
				}
			}

			if (transit.length > 0) {
				if (transit[0].locationId === -1) {
					delete transit[0].locationId;
					reloadLocations = true;
				}
				delete transit[0].ticked;
				if (
					!$scope.vaultDetails.trasitLocation ||
					$scope.vaultDetails.trasitLocation.locationName !== transit[0].locationName
				) {
					payload.trackingPolicy.trasitLocation = transit[0];
				}
			}

			VaultTrackerService.putVaultTrackerDetails(JSON.stringify(payload), $scope.vaultId)
				.success(function(response) {
					$scope.vaultDetails.destinationLocation = { location: destination[0] };
					$scope.vaultDetails.trasitLocation = transit[0];

					reloadLocations && $scope.initializeDestinationTile();
				})
				.error(function(e) {
					$dialogs.error(cvLoc('label.error'), e.errorMessage);
					$log.error('Deletion of VaulTracker failed');
					// $state.forceReload();
				});

			$scope.forms.destination.editing = false;
			$scope.forms.destination.isDirty = false;
		};

		$scope.generalSave = () => {
			let payload = {
				trackingPolicy: {
					vaultTrackerPolicyType: 1,
					autoAcknowledge: $scope.forms.general.values.autoAcknowledge,
					enable: $scope.forms.general.values.enable,
					description: $scope.forms.general.values.description,
					trackingPolicy: {
						trackingPolicyId: Number($scope.vaultId),
						trackingPolicyName: $scope.forms.general.values.policyName
					}
				}
			};

			VaultTrackerService.putVaultTrackerDetails(JSON.stringify(payload), $scope.vaultId)
				.success(function(response) {
					$scope.vaultName = $scope.forms.general.values.policyName;
					// $state.forceReload();
				})
				.error(function(e) {
					$dialogs.error(cvLoc('label.error'), e.errorMessage);
					$log.error('Deletion of VaulTracker failed');
					// $state.forceReload();
				});

			$scope.forms.general.editing = false;
			$scope.forms.general.isDirty = false;
		};

		/**
		 *
		 * @param {*} form param to get dirty
		 * @param {*} type Vaiable's name
		 * @param {*} value The value to modify
		 */
		$scope.changeValue = (form, type, value) => {
			$scope.validateField(type);
			if (form && type && (value || value === '')) {
				$scope[type] = value;
				$scope.forms[form].isDirty = true;
			} else {
				console.log('ERROR');
			}
		};

		$scope.validateField = type => {
			switch (type) {
				case 'lastTape':
					if ($scope.forms.media.values.lastTape.value > 0 && $scope.forms.media.values.lastTape.value <= 9999) {
						$scope.forms.media.values.lastTape.hasError = false;
					} else {
						$scope.forms.media.values.lastTape.hasError = true;
					}
					break;
				case 'limitMedia':
					if ($scope.forms.media.values.limitMedia.value > 0 && $scope.forms.media.values.limitMedia.value <= 1000) {
						$scope.forms.media.values.limitMedia.hasError = false;
					} else {
						$scope.forms.media.values.limitMedia.hasError = true;
					}
					break;
			}
		};

		$scope.runNowVaultTracker = () => {
			const body = {
				taskInfo: {
					associations: [
						{
							_type_: '21',
							trackingPolicyId: Number($scope.vaultId),
							trackingPolicyName: $scope.vaultName
						}
					],
					task: {
						taskFlags: {
							disabled: false
						},
						initiatedFrom: 1,
						ownerId: 1,
						ownerName: 'admin',
						sequenceNumber: 0,
						taskType: 1
					},
					subTasks: [
						{
							subTask: {
								operationType: VaultTrackerConstants.DEFAULT_OPERATION_TYPE,
								subTaskType: 1
							},
							options: {
								adminOpts: {
									runvtPolicyOption: {
										vTPolicy: {
											_type_: 21,
											trackingPolicyId: Number($scope.vaultId),
											trackingPolicyName: $scope.vaultName
										}
									}
								}
							}
						}
					]
				}
			};
			VaultTrackerService.runNowVaultTracker($scope.vaultId, JSON.stringify(body))
				.success(function(response) {
					const actionLink =
						'#/vaultTrackerPolicyActions?input.LibraryId=' +
						$scope.libraryId +
						'&input.PolicyId=' +
						$scope.vaultId +
						'&input.model=' +
						$scope.model +
						'&vaultId=' +
						$scope.vaultId +
						'&vaultName=' +
						$scope.vaultName +
						'&libraryId=' +
						$scope.libraryId +
						'&libraryName=' +
						encodeURIComponent($scope.libraryName) +
						'&model=' +
						$scope.model;
					const message =
						cvLoc('popup.successExportMedia') + '. <a href="' + actionLink + '">' + cvLoc('popup.viewActions') + '</a>';
					cvToaster.showSuccessMessage({
						ttl: '5000',
						message: message
					});
				})
				.error(function(e) {
					cvToaster.showErrorMessage({
						ttl: '10000',
						message: e.errorMessage ? e.errorMessage : cvLoc('generic_error')
					});
				});
		};
	}
];

storageMod.controller(vaultTrackerController);

export default storageMod;
