import 'adminConsole/js/directives/cv-detect-tape-library.js';
import 'storage/js/services/storage.svc.js';
import 'webScale/js/controllers/storagePool.ctrl.js';
import 'adminConsole/js/controllers/cloudLibConstants.js';
import 'modules/storage/js/constants/storage.constants.js';
import 'modules/storage/js/factories/sharedData.factory.js';
//service
import 'modules/storage/js/services/vaultTracker.svc.js';
import { acAppStorageModule } from 'common/js/modules';

var storageMod = acAppStorageModule;

class TapeLibraryMediaDetailsController {
	constructor(
		$q,
		$log,
		$scope,
		$state,
		$dialogs,
		$stateParams,
		cvLoc,
		tabService,
		storageService,
		cvTableOptions,
		sharedData,
		cvBreadcrumbsTabsFactory,
		tapeVaulTrackerColumnsTemplateService,
		VaultTrackerService,
		cvToaster,
		ENTITY_TYPES,
		$compile,
		TapeConstants,
		ReportConstants,
		storageFactory
	) {
		this.$q = $q;
		this.$log = $log;
		this.$scope = $scope;
		this.$state = $state;
		this.$dialogs = $dialogs;
		this.$stateParams = $stateParams;
		this.cvLoc = cvLoc;
		this.tabService = tabService;
		this.storageService = storageService;
		this.cvTableOptions = cvTableOptions;
		this.sharedData = sharedData;
		this.cvBreadcrumbsTabsFactory = cvBreadcrumbsTabsFactory;
		this.tapeVaulTrackerColumnsTemplateService = tapeVaulTrackerColumnsTemplateService;
		this.VaultTrackerService = VaultTrackerService;
		this.cvToaster = cvToaster;
		this.ENTITY_TYPES = ENTITY_TYPES;
		this.$compile = $compile;
		this.TapeConstants = TapeConstants;
		this.ReportConstants = ReportConstants;
		this.storageFactory = storageFactory;

		this.initializer();
	}

	initializer() {
		/// initialize default values
		this.$scope.libraryId = this.$stateParams['libraryId'];
		this.$scope.libraryName = decodeURIComponent(this.$stateParams['libraryName']);
		this.$scope.model = this.$stateParams['model'];
		this.$scope.libraryType = this.$stateParams['libraryType'];
		this.$scope.stateName = this.$state.current.name;

		this.$scope.bShowVaultTrackerChanges = !(
			(cv &&
				cv.additionalSettings &&
				cv.additionalSettings.AdminConsole &&
				cv.additionalSettings.AdminConsole.bHideVaultTrackerChanges) ||
			false
		);
		this.$scope.gridVaultTracker = {};
		/// initialize default values
		var breadCrumbs = [
			{
				title: this.cvLoc('label.nav.tape'),
				link: '#storage/tape'
			}
		];

		this.cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);

		this.$scope.exportLibraryCriteria = libId => this.storageFactory.exportLibraryCriteria(libId);
		this.$scope.exportLibraryList = (libId, libName, model) => this.storageFactory.exportLibrary(libId, libName, model);
		this.$scope.updateTapeLibrayName = (err, name) => this.updateTapeLibrayName(err, name);
		/// initialize controller
		this._initializeTabs();
		this._runSetupVaulTrackerKendoGrid();

		this.$scope.filtermediaInLibrary = this.ReportConstants.MEDIA_IN_LIBRARY_REPORT_FILTER;
		this.$scope.filterAssignedMedia = this.ReportConstants.ASSIGNED_MEDIA_REPORT_FILTER;
		this.$scope.filtercleaningMedia = this.ReportConstants.CLEANING_MEDIA_REPORT_FILTER;
		this.$scope.filteragedMedia = this.ReportConstants.AGED_MEDIA_REPORT_FILTER;
		this.$scope.filterDefaultScratch = this.ReportConstants.DEFAULT_SCRATCH_REPORT_FILTER;
	}

	_initializeTabs() {
		const tabs = [
			{
				title: this.cvLoc('label.overview'),
				state: 'tapeLibraryDetails',
				stateParams: this.$stateParams
			},
			{
				title: this.cvLoc('title.mediaDetails'),
				state: 'tapeLibraryMediaDetails',
				stateParams: this.$stateParams
			}
		];

		this.tabService.init({ tabs, hasParent: true });
	}

	_fetchApi() {
		// fetch data
		const deferred = this.$q.defer();
		if (this.sharedData.data.libId !== 0) {
			this.sharedData.data = {
				libId: this.$scope.libraryId,
				libName: this.$scope.libraryName,
				model: this.$scope.model,
				libraryVendorId: 0
			};
		}
		if (this.sharedData.data.vaultTrackerPolicies && this.sharedData.data.libDetails) {
			this.$scope.vaultTrackerPolicies = this.sharedData.data.vaultTrackerPolicies;
			this.$scope.libDetails = this.sharedData.data.libDetails;
			deferred.resolve({ data: this.$scope.vaultTrackerPolicies });
		} else {
			this.storageService
				._getLibraryDetails(this.$scope.libraryId)
				.success(libDetails => {
					libDetails = libDetails.libraryInfo;
					this.$scope.libDetails = libDetails;
					this.$scope.vaultTrackerPolicies = libDetails.vaultTrackerPolicies || [];
					this.$scope.mountPathMessage = {
						message: ' ', // space is needed
						type: 'ok'
					};
					this.$scope.libraryName = libDetails.library.libraryName;
					this.$scope.changeNameObj = {
						id: this.$scope.libraryId,
						name: this.$scope.libraryName
					};
					deferred.resolve({ data: this.$scope.vaultTrackerPolicies });
				})
				.error(e => {
					this.$scope.mountPathMessage = {
						message: e,
						type: 'error'
					};
					deferred.reject({ error: e });
				});
		}

		return deferred.promise;
		// fetch data
	}

	_runSetupVaulTrackerKendoGrid() {
		//var selft = this;
		this.$scope.gridVaultTracker.options = {};
		this.$scope.gridVaultTracker.options.url = options => {
			var vaulTrackerList = [];
			this._fetchApi()
				.then(response => {
					vaulTrackerList = this._setupVaultTrackerPoliciesList(response.data);
					options.success(vaulTrackerList);
				})
				.catch(e => {
					options.error(e.error);
				});
		};

		this.$scope.gridVaultTracker.options.columns = this.tapeVaulTrackerColumnsTemplateService.getColumns();
		this.$scope.gridVaultTracker.options.gridTitle = this.cvLoc('title.vaultTrackerPolicies');
		this.$scope.gridVaultTracker.options.tableName = 'vaultTrackingPolicyList';
		this.$scope.gridVaultTracker.options.idField = 'vault.trackingPolicy.trackingPolicyName';
		this.$scope.gridVaultTracker.options.hasViews = true;
		this.$scope.gridVaultTracker.options.pageSize = 10;
		this.$scope.gridVaultTracker.options.sortDirection = {
			field: 'vault.trackingPolicy.trackingPolicyName',
			dir: 'asc'
		};

		this.$scope.gridVaultTracker.options.onGridDataBound = this._onGridDataBound.bind(this);
	}

	_onGridDataBound(dataItem, row) {
		const permittedOptions = dataItem.permittedOptions;
		const id = permittedOptions.entityId;
		const template = `<cv-permitted-actions cv-permitted-options="permittedOptions${id}"></cv-permitted-actions>`;
		this.$scope[`permittedOptions${id}`] = permittedOptions;
		row.find('.permittedActions').append(this.$compile(template)(this.$scope));
	}

	_setupVaultTrackerPoliciesList(list = []) {
		var configuredList = [];
		var selft = this;
		list.forEach(vault => {
			const obj = {
				vault,
				link: {
					libraryId: selft.$scope.libraryId,
					libraryName: encodeURIComponent(selft.$scope.libraryName),
					model: selft.$scope.model,
					stateName: selft.$scope.stateName
				}
			};

			obj.vault.getDestinationName = () => {
				const destinationLocation = obj.vault.destinationLocation;
				return (
					destinationLocation.location.locationName ||
					destinationLocation.library.libraryName ||
					destinationLocation.shelf.shelfName ||
					''
				);
			};

			obj.permittedOptions = {
				entity: angular.copy(obj),
				entityId: obj.vault.trackingPolicy.trackingPolicyId,
				entityName: obj.vault.trackingPolicy.trackingPolicyName,
				appendToBody: true,
				permittedActionList: [
					{
						show: true,
						label: selft.cvLoc('action.runNow'),
						onClick: selft._runNowVaultTracker.bind(selft, obj.vault)
					},
					{
						show: true,
						label: selft.cvLoc('action.listMedia'),
						onClick: selft._goToVaultTrackerPolicyListMedia.bind(selft, obj.vault)
					},
					{
						show: true,
						label: selft.cvLoc('action.delete'),
						onClick: selft._deleteVaultTracker.bind(selft, obj.vault)
					}
				]
			};

			configuredList.push(obj);
		});

		return configuredList;
	}

	_runNowVaultTracker(vault) {
		const body = {
			taskInfo: {
				associations: [
					{
						_type_: '21',
						trackingPolicyId: vault.trackingPolicy.trackingPolicyId,
						trackingPolicyName: vault.trackingPolicy.trackingPolicyName
					}
				],
				task: {
					taskFlags: {
						disabled: false
					},
					initiatedFrom: 1,
					ownerId: 1,
					ownerName: 'admin',
					sequenceNumber: 0,
					taskType: 1
				},
				subTasks: [
					{
						subTask: {
							operationType: this.TapeConstants.DEFAULT_OPERATION_TYPE,
							subTaskType: 1
						},
						options: {
							adminOpts: {
								runvtPolicyOption: {
									vTPolicy: {
										_type_: 21,
										trackingPolicyId: vault.trackingPolicy.trackingPolicyId,
										trackingPolicyName: vault.trackingPolicy.trackingPolicyName
									},
									sourceLibrary: {
										libraryId: Number(this.$scope.libraryId)
									}
								}
							}
						}
					}
				]
			}
		};
		this.VaultTrackerService.runNowVaultTracker(vault.trackingPolicy.trackingPolicyId, JSON.stringify(body))
			.success(() => {
				const actionLink =
					'#/vaultTrackerPolicyActions?input.LibraryId=' +
					this.$scope.libraryId +
					'&input.PolicyId=' +
					vault.trackingPolicy.trackingPolicyId +
					'&input.model=' +
					this.$scope.model +
					'&vaultId=' +
					vault.trackingPolicy.trackingPolicyId +
					'&vaultName=' +
					vault.trackingPolicy.trackingPolicyName +
					'&libraryId=' +
					this.$scope.libraryId +
					'&libraryName=' +
					encodeURIComponent(this.$scope.libraryName) +
					'&model=' +
					this.$scope.model;
				const message =
					this.cvLoc('popup.successExportMedia') +
					'. <a href="' +
					actionLink +
					'">' +
					this.cvLoc('popup.viewActions') +
					'</a>';
				this.cvToaster.showSuccessMessage({
					ttl: '5000',
					message: message
				});
			})
			.error(function(e) {
				this.cvToaster.showErrorMessage({
					ttl: '10000',
					message: e.errorMessage ? e.errorMessage : this.cvLoc('generic_error')
				});
			});
	}

	_goToVaultTrackerPolicyListMedia(vault) {
		this.$state.go('vaultTrackerPolicyListMedia', {
			'input.PolicyId': vault.trackingPolicy.trackingPolicyId,
			'input.LibraryId': this.$scope.libraryId,
			libraryId: this.$scope.libraryId,
			vaultId: vault.trackingPolicy.trackingPolicyId,
			vaultName: vault.trackingPolicy.trackingPolicyName,
			libraryName: encodeURIComponent(this.$scope.libraryName),
			model: this.$scope.model
		});
	}

	_deleteVaultTracker(vault) {
		var callBackFunctions = {
			noFunction: () => {},
			yesFunction: () => {
				const body = {
					trackingPolicy: {
						trackingPolicyId: vault.trackingPolicy.trackingPolicyId
					}
				};
				this.VaultTrackerService.deleteVaultTracker(vault.trackingPolicy.trackingPolicyId, body, true)
					.success(() => {
						this.$log.debug('Delete VaulTracker success');
						this.sharedData.data.libId = 0; // set 0 to libId in order to reset values to default
						this.$state.forceReload();
					})
					.error(e => {
						this.$dialogs.error(this.cvLoc('label.error'), e.errorMessage);
						this.$log.error('Deletion of VaulTracker failed');
					});
			}
		};
		this.$dialogs.confirm(
			this.cvLoc('label.confirmDelete'),
			this.cvLoc('label.confirmationStoragePool', '<b>' + vault.trackingPolicy.trackingPolicyName + '</b>'),
			callBackFunctions
		);
	}

	updateTapeLibrayName(err = null, name) {
		this.$state.go(this.$state.current.name, { ...this.$stateParams, storagePoolName: name });
	}
}

TapeLibraryMediaDetailsController.$inject = [
	'$q',
	'$log',
	'$scope',
	'$state',
	'$dialogs',
	'$stateParams',
	'cvLoc',
	'tabService',
	'storageService',
	'cvTableOptions',
	'sharedData',
	'cvBreadcrumbsTabsFactory',
	'tapeVaulTrackerColumnsTemplateService',
	'VaultTrackerService',
	'cvToaster',
	'ENTITY_TYPES',
	'$compile',
	'TapeConstants',
	'ReportConstants',
	'storageFactory'
];

storageMod.controller('tapeLibraryMediaDetailsController', TapeLibraryMediaDetailsController);

export default storageMod;
