import 'adminConsole/js/directives/cv-detect-tape-library.js';
import 'browse/js/controllers/browse.ctrl.js';

import 'machineBrowse/js/controllers/machineBrowse.ctrl.js';
import 'machineBrowse/js/services/machineBrowse.svc.js';
import 'storage/js/services/storage.svc.js';
import 'webScale/js/controllers/storagePool.ctrl.js';
import 'adminConsole/js/controllers/cloudLibConstants.js';
import 'dlo/js/controllers/profile.ctrl.js';
import 'adminConsole/js/factories/rpstore.factory.js';
import 'adminConsole/js/controllers/rpstore.ctrl.js';
import 'modules/schedule/js/factory/schedule.factory.js';
import 'modules/storage/js/filters/storage.filters';
import 'modules/storage/js/constants/storage.constants.js';
import 'modules/storage/js/factories/sharedData.factory.js';
import 'modules/storage/js/factories/tapeColumnsTemplate.factory.js';
import 'modules/storage/js/directives/cvEncryptionComponent.directive.js';
import 'modules/storage/js/directives/storage-index-cache-tile.directive.js';
//service
import 'modules/storage/js/services/vaultTracker.svc.js';
import { acAppStorageModule } from 'common/js/modules';
import * as listStorageColumnTemplates from 'webScale/js/listStorage.column.template';
import * as associatedEntitiesColumnTemplates from 'modules/storage/js/storagePoolAssociatedEntities.column.template';
var storageMod = acAppStorageModule;
const storageControllers = {};

storageControllers.tapeLibraryDetailsController = [
	'$q',
	'$filter',
	'$compile',
	'tapeDriveColumnsTemplateService',
	'sharedData',
	'$scope',
	'storageService',
	'cvToaster',
	'$rootScope',
	'$uibModal',
	'cvBreadcrumbsTabsFactory',
	'$stateParams',
	'cvLoc',
	'$state',
	'$dialogs',
	'LibraryConstants',
	'DriveConstants',
	'ReportConstants',
	'rpStoreFactory',
	'storageFactory',
	'$log',
	'tabService',
	'TAPE_STORAGEPOOL_TYPE',
	function(
		$q,
		$filter,
		$compile,
		tapeColumnsTemplateService,
		sharedData,
		$scope,
		storageService,
		cvToaster,
		$rootScope,
		$modal,
		cvBreadcrumbsTabsFactory,
		$stateParams,
		cvLoc,
		$state,
		$dialogs,
		LibraryConstants,
		DriveConstants,
		ReportConstants,
		rpStoreFactory,
		storageFactory,
		$log,
		tabService,
		TAPE_STORAGEPOOL_TYPE
	) {
		/// initialize params
		var vm = $scope;
		var fetchStoragePoolList = (poolList = null) => {
			const deferred = $q.defer();
			if (poolList !== null) {
				deferred.resolve(poolList);
			} else {
				deferred.reject(cvLoc('label.errorNoTapeStoragePool'));
			}
			return () => deferred.promise;
		};
		var fetchedTapeStoragePool = null;

		vm.libraryId = $stateParams['libraryId'];
		vm.libraryName = decodeURIComponent($stateParams['libraryName']);
		vm.model = $stateParams['model'];
		vm.libraryType = $stateParams['libraryType'];
		/// initialize params

		/// initialize default values
		vm.gridDrive = {};
		vm.storagePoolGrid = {};
		vm.isRPStore = vm.libraryType && vm.libraryType == 10;
		vm.stateName = $state.current.name;
		vm.maintenanceMode = 'enabled-activity';
		vm.status = 'enabled-activity';
		vm.storageFactory = storageFactory;
		vm.deconfiguredLibrary = false;
		vm.bShowVaultTrackerChanges = !(
			(cv &&
				cv.additionalSettings &&
				cv.additionalSettings.AdminConsole &&
				cv.additionalSettings.AdminConsole.bHideVaultTrackerChanges) ||
			false
		);

		vm.fecthedStoragPoolList = false;
		vm.isEditingKeyManagement = false;

		vm.$filter = $filter;
		vm.$state = $state;
		vm.sharedData = sharedData;
		vm.LibraryConstants = LibraryConstants;
		vm.DriveConstants = DriveConstants;
		vm.ReportConstants = ReportConstants;
		vm.storageService = storageService;
		vm.$modal = $modal;
		vm.cvToaster = cvToaster;
		vm.cvLoc = cvLoc;
		vm.$dialogs = $dialogs;
		vm.$log = $log;
		vm.$q = $q;
		/// initialize default values

		/// initialize tabs
		function initTabs() {
			const tabs = [
				{
					title: cvLoc('label.overview'),
					state: 'tapeLibraryDetails',
					stateParams: $stateParams
				},
				{
					title: cvLoc('title.mediaDetails'),
					state: 'tapeLibraryMediaDetails',
					stateParams: $stateParams
				}
			];

			tabService.init({ tabs, hasParent: true });
		}
		initTabs();
		//// initialze tabs

		vm.editRPStore = function() {
			var rpStoreModal = rpStoreFactory.showAddRPStoreModal(
				vm.libraryId,
				vm.libraryName,
				vm.libDetails.magLibSummary.associatedMediaAgents,
				vm.libDetails.rpStoreLibraryInfo.minSpacePerRPStoreGB,
				vm.libDetails.rpStoreLibraryInfo.maxSpacePerRPStoreGB
			);
			rpStoreModal.result.then(
				function() {
					$state.forceReload();
				},
				function() {}
			);
		};

		let breadCrumbs = [
			{
				title: cvLoc('label.nav.tape'),
				link: '#storage/tape'
			}
		];

		if (vm.stateName === 'tapeLibraryDetails') {
			if (vm.isRPStore) {
				cvBreadcrumbsTabsFactory.addBreadCrumbs([
					{
						title: cvLoc('label.nav.storageTargets.rpStores'),
						link: '#rpStores'
					}
				]);
			} else {
				cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);
			}

			vm.sharedData.data = {
				libId: vm.libraryId,
				libName: vm.libraryName,
				model: vm.model,
				libraryVendorId: 0
			};
			vm.typeOfStorage = {
				type: 'localStorage'
			};
			vm.notApplicableLabel = cvLoc('label.N_SLASH_A');
			vm.localPathPattern = /^([a-zA-Z]:){1}(\\[^<>:"/\\|?*]+)*\\?$/;
			vm.networkPathPattern = /^\\(\\[^<>:"/\\|?*]+)+\\?$/;
			vm.pathPattern = {
				pattern: vm.localPathPattern
			};

			vm.$on('unloadDrive', function(evt) {
				$state.forceReload();
			});

			vm.$on('resetDrive', function(evt) {
				$state.forceReload();
			});

			vm.$on('replaceDrive', function(evt) {
				$state.forceReload();
			});

			initializeDriveKendoGrid(tapeTargetFetchData); // RUN DRIVE KENDO GRID AND FETCH DATA FOR VIEW
			initializeStoragePoolGrid();
		} else if (
			vm.stateName === 'slotView' ||
			vm.stateName === 'IEPortView' ||
			vm.stateName === 'LibraryController' ||
			vm.stateName === 'tapeDriveUsage' ||
			vm.stateName === 'tapeMediaUsage' ||
			vm.stateName === 'MediaInLibrary' ||
			vm.stateName === 'vaultTrackerActions'
		) {
			const tapeLibraryPath =
				$state.previous.route.name === 'tapeLibraryMediaDetails' ? '/tapeLibrary/mediaDetails' : '/tapeLibrary';

			breadCrumbs.push({
				title: vm.libraryName,
				link:
					'#' +
					tapeLibraryPath +
					'?libraryId=' +
					vm.libraryId +
					'&libraryName=' +
					encodeURIComponent(vm.libraryName) +
					'&model=' +
					vm.model
			});

			cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);
		} else if (vm.stateName === 'vaultTrackerActionDetails') {
			breadCrumbs.push(
				{
					title: vm.libraryName,
					link:
						'#/tapeLibrary/mediaDetails?libraryId=' +
						vm.libraryId +
						'&libraryName=' +
						encodeURIComponent(vm.libraryName) +
						'&model=' +
						vm.model
				},
				{
					title: cvLoc('label.vaultTrackerActions'),
					link:
						'#/vaultTrackerActions?input.LibraryId=' +
						vm.libraryId +
						'&input.model=' +
						vm.model +
						'&libraryId=' +
						vm.libraryId +
						'&libraryName=' +
						encodeURIComponent(vm.libraryName) +
						'&model=' +
						vm.model
				}
			);
			cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);
		}

		vm.getCount = function(count) {
			return count == undefined ? 0 : count;
		};

		vm.openWizard = function(libId, libName) {
			vm.maEntity = {
				libraryEntity: {
					libraryName: libName,
					libraryId: libId
				},
				loginName: '',
				serverType: {
					id: 0,
					name: ''
				},
				serverHost: ''
			};
			var template = 'adminConsole/partials/shareDrives.jsp';
			$modal.open({
				templateUrl: appUtil.appRoot + template,
				windowClass: 'addServerModal',
				backdrop: 'static',
				controller: [
					'$scope',
					'$log',
					'$uibModalInstance',
					'$state',
					'cvLoc',
					'maEntity',
					function($scope, $log, $modalInstance, $state, cvLoc, maEntity) {
						$scope.maEntity = maEntity;
						$scope.action = 'shareDrive';
						$scope.cvLoc = cvLoc;
						$rootScope.$on('sharedDrive', function() {
							$log.debug('sharedDrive....');
							$modalInstance.dismiss();
							$state.forceReload();
						});
						$rootScope.$on('shareDriveCancelled', function() {
							$log.debug('shareDriveCancelled....');
							$modalInstance.dismiss();
						});
					}
				],
				resolve: {
					maEntity: function() {
						return $scope.maEntity;
					}
				}
			});
		};

		/* setup function declaration  - Actually here we are fetching data from api in order to populate view */
		/* State: tapeLibraryDetails */
		function tapeTargetFetchData() {
			const deferred = vm.$q.defer();
			var drives = [];
			//targetPromise
			vm.storageService
				._getLibraryDetails(vm.libraryId)
				.success(function(libDetails) {
					libDetails = libDetails.libraryInfo;
					vm.libDetails = libDetails;
					// setup drives
					drives = configDriveList(libDetails.DriveList);
					// setup drives
					// must save into sharedData Service in order to avoid make calling to backend for lib details
					vm.sharedData.data.libDetails = vm.libDetails;
					vm.sharedData.data.vaultTrackerPolicies = (libDetails.vaultTrackerPolicies || []).filter(a => a !== 2);
					//
					vm.maintenanceMode =
						(libDetails.tapeLibSummary.attribute & vm.LibraryConstants.MMS2_LIBRARY_EXT_MARKED_FOR_MAINTENANCE) != 0
							? 'enabled-activity'
							: 'disabled-activity';
					vm.status = libDetails.tapeLibSummary.isEnabled == 1 ? 'enabled-activity' : 'disabled-activity';

					// TODO: needs to come from API
					// vm.libDetails.TapeProps = {
					//   enableTapeAfterDelay: false,
					//   enableTapeAtDateTime: null,
					//   markTapeOfflineForMaintenance: vm.maintenanceMode === 'enabled-activity'
					// }

					vm.mountPathMessage = {
						message: ' ', // space is needed
						type: 'ok'
					};
					vm.libraryType = libDetails.libraryType;

					vm.filtermediaInLibrary = vm.ReportConstants.MEDIA_IN_LIBRARY_REPORT_FILTER;
					vm.filterAssignedMedia = vm.ReportConstants.ASSIGNED_MEDIA_REPORT_FILTER;
					vm.filtercleaningMedia = vm.ReportConstants.CLEANING_MEDIA_REPORT_FILTER;
					vm.filteragedMedia = vm.ReportConstants.AGED_MEDIA_REPORT_FILTER;
					vm.filterDefaultScratch = vm.ReportConstants.DEFAULT_SCRATCH_REPORT_FILTER;
					vm.deconfiguredLibrary = libDetails.libraryType === vm.LibraryConstants.CV_LIB_DECONFIGURED; // ? true : false;

					if (vm.isRPStore) {
						vm.libraryName = libDetails.library.libraryName;
						vm.libDetails.rpStoreLibraryInfo = {};
						if (
							libDetails.MountPathList &&
							libDetails.MountPathList.length > 0 &&
							libDetails.MountPathList[0].rpStoreLibraryInfo
						) {
							vm.libDetails.rpStoreLibraryInfo = libDetails.MountPathList[0].rpStoreLibraryInfo;
							vm.libDetails.rpStoreLibraryInfo.mountPathName = libDetails.MountPathList[0].mountPathName;
						}
					}
					vm.libraryName = libDetails.library.libraryName;
					vm.changeNameObj = {
						id: vm.libraryId,
						name: vm.libraryName
					};

					fetchedTapeStoragePool = fetchStoragePoolList(libDetails.storagePoolList || []);
					vm.fecthedStoragPoolList = !!libDetails.storagePoolList;
					deferred.resolve(drives);
				})
				.error(function(e) {
					vm.mountPathMessage = {
						message: e,
						type: 'error'
					};
					fetchedTapeStoragePool = fetchStoragePoolList();
					deferred.reject(e);
				});

			return deferred.promise;
		}

		function onGridDataBound(dataItem, row) {
			const permittedOptions = dataItem.permittedOptions;
			const id = permittedOptions.entityId;
			const template = `<cv-permitted-actions cv-permitted-options="permittedOptions${id}"></cv-permitted-actions>`;
			vm[`permittedOptions${id}`] = permittedOptions;
			row.find('.permittedActions').append($compile(template)(vm));
		}

		function initializeDriveKendoGrid(FetchDataApiCallback) {
			vm.gridDrive.options = {};

			vm.gridDrive.options.url = function(options) {
				FetchDataApiCallback()
					.then(drives => {
						options.success(drives);
					})
					.catch(error => options.error(error));
			};

			vm.gridDrive.options.columns = tapeColumnsTemplateService.getColumns();
			vm.gridDrive.options.gridTitle = cvLoc('title.drives');
			vm.gridDrive.options.tableName = 'Drivelist';
			vm.gridDrive.options.idField = 'drive.driveId';
			vm.gridDrive.options.hasViews = true;
			vm.gridDrive.options.pageSize = 10;
			vm.gridDrive.options.searchable = true;
			vm.gridDrive.options.sortDirection = {
				field: 'drive.driveId',
				dir: 'asc'
			};

			vm.gridDrive.options.onGridDataBound = onGridDataBound;
		}

		function initializeStoragePoolGrid() {
			vm.storagePoolGrid.options = {};
			vm.storagePoolGrid.options.url = function(options) {
				fetchedTapeStoragePool()
					.then(listPool => {
						options.success(configStoragePoolList(listPool));
					})
					.catch(error => options.error(error));
			};

			vm.storagePoolGrid.options.columns = listStorageColumnTemplates.getTapeStoragePoolColumnTemplate({
				cvLoc: vm.cvLoc
			});
			vm.storagePoolGrid.options.gridTitle = cvLoc('label.storage');
			vm.storagePoolGrid.options.tableName = 'TapeStoragePool';
			vm.storagePoolGrid.options.idField = 'storagePool.storagePoolName';
			vm.storagePoolGrid.options.hasViews = true;
			vm.storagePoolGrid.options.pageSize = 10;
			vm.storagePoolGrid.options.searchable = true;
			vm.storagePoolGrid.options.sortDirection = {
				field: 'storagePool.storagePoolName',
				dir: 'asc'
			};

			// TODO: PENDING SOME DATA FROM BACKEND
			// vm.storagePoolGrid.options.gridToolbarMenu = [{
			//   id: 'AddStorage',
			//   disableOnDeselect: false,
			//   label: vm.cvLoc("action.add"),
			//   onSelect: () => {
			//     addTapeStoragePool();
			//   }
			// }];

			vm.storagePoolGrid.options.onGridDataBound = onGridDataBound;
		}

		function configDriveList(driveList = []) {
			const drives = [];
			var link = setupLink();
			driveList.forEach(item => {
				const obj = {
					drive: item,
					link
				};
				obj.permittedOptions = {
					entity: angular.copy(obj),
					entityId: 'drive_' + obj.drive.driveId,
					entityName: obj.drive.driveName,
					appendToBody: true
				};

				obj.permittedOptions.permittedActionList = computePermittedDriveActions(obj);
				drives.push(obj);
			});

			function setupLink() {
				const result = {
					libraryId: vm.libraryId,
					libraryName: encodeURIComponent(vm.libraryName),
					model: vm.model,
					stateName: vm.stateName
				};

				if (vm.stateName === 'tapeStoragePoolDetails') {
					result.storagePoolId = vm.storagePoolId;
					result.storagePoolName = encodeURIComponent(vm.storagePoolName);
					result.storagePoolType = vm.storagePoolType;
				}
				return result;
			}

			function computePermittedDriveActions(entity) {
				const { drive } = entity;
				const permittedActions = [
					{
						show: vm.isValidateDriveApplicable(drive.driveId, drive.driveAttributes),
						label: cvLoc('action.validate'),
						onClick: () => vm.validateDrive(entity)
					},
					{
						show: vm.isCleanDriveApplicable(drive.driveId, drive.driveAttributes),
						label: cvLoc('action.clean'),
						onClick: () => vm.cleanDrive(entity)
					},
					{
						show: vm.isUnloadDriveApplicable(drive.driveId, drive.driveAttributes),
						label: cvLoc('action.unload'),
						onClick: () => vm.unloadDrive(entity)
					},
					{
						show: vm.isResetReplaceDriveApplicable(drive.driveId, drive.driveAttributes),
						label: cvLoc('action.resetDrive'),
						onClick: () => vm.resetDrive(entity)
					},
					{
						show: vm.isResetReplaceDriveApplicable(drive.driveId, drive.driveAttributes),
						label: cvLoc('action.markDriveReplaced'),
						onClick: () => vm.replaceDrive(entity)
					}
				];
				return permittedActions;
			}

			return drives;
		}

		function configStoragePoolList(list = []) {
			const config = [];
			list.forEach(item => {
				const obj = {
					...item,
					storagePool: {
						...item.storagePool,
						formattedStoragePoolName: vm.$filter('encodeParam')(item.storagePool.storagePoolName)
					},
					formattedStoragePoolType: cvLoc(TAPE_STORAGEPOOL_TYPE[item.storagePoolType])
				};

				obj.permittedOptions = {
					entity: angular.copy(obj),
					entityId: 'tapePool_' + item.storagePool.storagePoolId,
					entityName: item.storagePool.storagePoolName,
					appendToBody: true,
					permittedActionList: [
						{
							show: true,
							label: vm.cvLoc('action.delete'),
							onClick: () => deleteStoragePool(item.storagePool.storagePoolId, item.storagePool.storagePoolName)
						}
					]
				};

				config.push(obj);
			});

			return config;
		}

		// StoragePool Grid Actions
		function deleteStoragePool(id, name) {
			var callBackFunctions = {
				noFunction: function() {},
				yesFunction: function() {
					storageService
						.deleteStoragePool(id)
						.success(function() {
							vm.$log.debug('Delete Storage Pool success');
							vm.$state.forceReload();
						})
						.error(function(data) {
							vm.$dialogs.error(vm.cvLoc('label.error'), vm.cvUtil.errMsg(data).message);
							vm.$log.error('Deletion of Storage Pool failed');
						});
				}
			};
			vm.$dialogs.confirm(
				vm.cvLoc('label.confirmDelete'),
				vm.cvLoc('label.confirmationStoragePool', '<b>' + name + '</b>'),
				callBackFunctions
			);
		}

		// TODO: Pending data from backend
		// function addTapeStoragePool() {
		//   vm.$modal.open({
		//     templateUrl: appUtil.appRoot + "webScale/partials/createTapeStoragePool.jsp",
		//     backdrop: 'static',
		//     controller: ['$scope','$uibModalInstance', '$controller', function ($scope, $modalInstance, $controller) {
		//       $scope.closeModal = function (isSuccess) {
		//         $modalInstance.dismiss(isSuccess);
		//       };
		//       $scope.tapeLibrary = {
		//         'id': vm.libraryId,
		//         'name': vm.libraryName
		//       }
		//       angular.extend(this, $controller('createTapeStoragePoolController', {$scope: $scope}));
		//     }]
		//   }).result.then(function () {}, (isSuccess) => {
		//     if(isSuccess && isSuccess !== 'close') {
		//       vm.$state.forceReload();
		//     }
		//   });
		// }
		/* Criteria for drive actions */
		vm.isCleanDriveApplicable = function(driveTypeId, driveAttribute) {
			if (vm.libDetails.libraryType != vm.LibraryConstants.CV_LIB_MAGNETIC) {
				if (vm.isPNPLibrary() || vm.isRemovableMagDisk(driveTypeId)) {
					return false;
				} else if (vm.isStandAloneLibrary()) {
					return false;
				} else if (vm.isDriveCleanable(driveAttribute)) {
					return true;
				} else if (vm.isOpticalLibrary()) {
					return false;
				}
				return false; // Not applicable by default.
			}
			return false;
		};

		vm.isValidateDriveApplicable = function(driveTypeId, driveAttributes) {
			if (vm.libDetails.libraryType != vm.LibraryConstants.CV_LIB_MAGNETIC) {
				if (vm.isPNPLibrary() || vm.isRemovableMagDisk(driveTypeId)) {
					return false;
				} else if (vm.isStandAloneLibrary()) {
					return true;
				} else if (vm.isDriveCleanable(driveAttributes)) {
					return true;
				} else if (vm.isOpticalLibrary()) {
					return false;
				}
				return true; // applicable by default.
			}
			return false;
		};

		vm.isUnloadDriveApplicable = function(driveTypeId, driveAttributes) {
			if (vm.libDetails.libraryType != vm.LibraryConstants.CV_LIB_MAGNETIC) {
				if (vm.isPNPLibrary() || vm.isRemovableMagDisk(driveTypeId)) {
					return false;
				} else if (vm.isStandAloneLibrary()) {
					return false;
				} else if (vm.isDriveCleanable(driveAttributes)) {
					return true;
				} else if (vm.isOpticalLibrary()) {
					return true;
				}
				return true; //  applicable by default.
			}
			return false;
		};

		vm.isResetReplaceDriveApplicable = function(driveTypeId, driveAttributes) {
			if (vm.libDetails.libraryType != vm.LibraryConstants.CV_LIB_MAGNETIC) {
				if (vm.isPNPLibrary() || vm.isRemovableMagDisk(driveTypeId)) {
					return true;
				} else if (vm.isStandAloneLibrary()) {
					return true;
				} else if (vm.isDriveCleanable(driveAttributes)) {
					return true;
				} else if (vm.isOpticalLibrary()) {
					return true;
				}
				return true; //  applicable by default.
			}
			return false;
		};
		/* Library type */
		vm.isStandAloneLibrary = function() {
			if (
				vm.libDetails.libraryType == vm.LibraryConstants.CV_LIB_STANDALONE_TAPE ||
				vm.libDetails.libraryType == vm.LibraryConstants.CV_LIB_STANDALONE_OPTICAL
			) {
				return true;
			}

			return false;
		};

		/*
		 * Plug-n-Play library means that its library type is standalone and * the PNP extended attribute is set.
		 */
		vm.isPNPLibrary = function() {
			let isLibStandAloneTape = vm.libDetails.libraryType == vm.LibraryConstants.CV_LIB_STANDALONE_TAPE;
			let isLibStandAloneOptical = vm.libDetails.libraryType == vm.LibraryConstants.CV_LIB_STANDALONE_OPTICAL;
			if (isLibStandAloneTape || isLibStandAloneOptical) {
				return vm.libDetails.extendedAttributes & vm.LibraryConstants.MMS2_LIBRARY_EXT_PNP_DISK_BASED;
			}

			return false;
		};

		vm.isOpticalLibrary = function() {
			let isLibOptical = vm.libDetails.libraryType == vm.LibraryConstants.CV_LIB_OPTICAL;
			let isStandAloneOptical = vm.libDetails.libraryType == vm.LibraryConstants.CV_LIB_STANDALONE_OPTICAL;
			return isLibOptical || isStandAloneOptical;
		};

		vm.isRemovableMagDisk = function(driveTypeId) {
			return driveTypeId > 10000 && driveTypeId < 20000;
		};

		vm.isDriveCleanable = function(driveAttributeFlag) {
			return driveAttributeFlag & vm.DriveConstants.DRIVE_CLEANBLE; // true if driveAttributeFlag is set, false if driveAttributeFlag is not set
		};

		/*
		 * Operation Validate Drive Input: driveId
		 */
		vm.validateDrive = function(entity) {
			var template = 'adminConsole/partials/ValidateDrive.jsp';
			vm.$modal.open({
				templateUrl: appUtil.appRoot + template,
				backdrop: 'static',
				controller: [
					'$scope',
					'cvLoc',
					'cvUtil',
					function($scope, cvLoc, cvUtil) {
						$scope.driveId = entity.drive.driveId;
						$scope.libraryId = entity.link.libraryId;
						$scope.libraryName = entity.link.libraryName;
						$scope.voulmeBlockSizeList = [
							{
								value: '32'
							},
							{
								value: '64'
							},
							{
								value: '128'
							},
							{
								value: '256'
							},
							{
								value: '512'
							},
							{
								value: '1024'
							},
							{
								value: '2048'
							}
						];
						$scope.selectedVolumeBSize = $scope.voulmeBlockSizeList[1];
						$scope.numberOfChunks = 2;
						$scope.chunkSize = 2;
						$scope.fileMarkerToStart = 1;
						$scope.chunksTillEnd = false;
						vm.storageService
							.getValidateDriveInfo($scope.driveId)
							.success(function(getInfoForValidateDriveResponse) {
								var mediaInfoList = [];
								var drivePoolInfoList = [];
								var mediatoMediaSideList = [];

								var mediaAgenttoDrivePoolList = [];
								mediaInfoList = getInfoForValidateDriveResponse.mediaInfo;
								drivePoolInfoList = getInfoForValidateDriveResponse.drivePoolInfo;
								if (mediaInfoList) {
									for (var i = 0; i < mediaInfoList.length; i++) {
										var mediatoMediaSide;
										var mediaSideList = [];

										mediaSideList.push(mediaInfoList[i].mediaSide);
										mediatoMediaSide = {
											media: mediaInfoList[i].media,
											MediaSideList: mediaSideList
										};
										mediatoMediaSideList.push(mediatoMediaSide);
									}
									$scope.mediatoMediaSideModel = mediatoMediaSideList;
								}
								if (drivePoolInfoList) {
									for (var i = 0; i < drivePoolInfoList.length; i++) {
										var mediaAgenttoDrivePool;
										var drivePoolList = [];

										drivePoolList.push(drivePoolInfoList[i].drivePool);
										mediaAgenttoDrivePool = {
											mediaAgent: drivePoolInfoList[i].mediaAgent,
											DrivePoolList: drivePoolList
										};
										mediaAgenttoDrivePoolList.push(mediaAgenttoDrivePool);
									}
									//$scope.selectedmediatoMediaSideModel = mediatoMediaSideList[0];
									$scope.mediaAgenttoDrivePoolModel = mediaAgenttoDrivePoolList;
									$scope.selectedmediaAgenttoDrivePoolModel = mediaAgenttoDrivePoolList[0];
								}

								if ($scope.selectedmediaAgenttoDrivePoolModel) {
									$scope.changeMediaAgent($scope.selectedmediaAgenttoDrivePoolModel);
								}
								if ($scope.selectedmediatoMediaSideModel) {
									$scope.changeMedia($scope.selectedmediatoMediaSideModel);
								}
							})
							.error(function(e) {
								cvToaster.showErrorMessage({
									ttl: '10000',
									message: e ? e : cvLoc('popup.failedValidateDrive')
								});
							});

						$scope.changeMedia = function(selectedmediatoMediaSideModel) {
							if (selectedmediatoMediaSideModel) {
								$scope.mediaSideList = selectedmediatoMediaSideModel.MediaSideList;
								$scope.selectedMediaSide = selectedmediatoMediaSideModel.MediaSideList[0];
							}
						};

						$scope.changeMediaAgent = function(selectedmediaAgenttoDrivePoolModel) {
							$scope.drivePoolList = selectedmediaAgenttoDrivePoolModel.DrivePoolList;
							$scope.selectedDrivePool = selectedmediaAgenttoDrivePoolModel.DrivePoolList[0];
						};
						$scope.save = function() {
							$scope.generalSetupMessage = cvUtil.emptyMsg();
							if (!$scope.selectedmediaAgenttoDrivePoolModel) {
								$scope.generalSetupMessage = {
									message: cvLoc('error.noMediaAgentName'),
									type: 'error'
								};
								return;
							}

							if (!$scope.selectedDrivePool) {
								$scope.generalSetupMessage = {
									message: cvLoc('error.noDrivePoolName'),
									type: 'error'
								};
								return;
							}

							if (!$scope.mediatoMediaSideModel) {
								$scope.generalSetupMessage = {
									message: cvLoc('error.noSpareMedia'),
									type: 'error'
								};
								return;
							}

							vm.storageService
								.ValidateDriveRequest(
									$scope.selectedmediaAgenttoDrivePoolModel.mediaAgent.mediaAgentId,
									$scope.selectedmediaAgenttoDrivePoolModel.mediaAgent.mediaAgentName,
									$scope.selectedDrivePool.drivePoolId,
									!$scope.selectedmediatoMediaSideModel ? 0 : $scope.selectedmediatoMediaSideModel.media.mediaId,
									!$scope.selectedMediaSide ? 0 : $scope.selectedMediaSide.mediaSideId,
									$scope.selectedVolumeBSize.value,
									$scope.driveId,
									$scope.numberOfChunks,
									$scope.chunkSize,
									$scope.fileMarkerToStart,
									$scope.chunksTillEnd,
									$scope.libraryId,
									$scope.libraryName
								)
								.success(function(data) {
									if (data != 0) {
										cvToaster.showSuccessMessage({
											ttl: '10000',
											message:
												cvLoc('popup.jobStartedValdateDrive') +
												'<br/>' +
												' <a href="#/jobs/' +
												data +
												'">' +
												cvLoc('notification.jobDetails') +
												'</a>'
										});
									}
								})
								.error(function(e) {
									cvToaster.showErrorMessage({
										ttl: '10000',
										message: e ? e : cvLoc('popup.failedValidateDrive')
									});
								});
							$scope.$close();
						};

						$scope.cancel = function() {
							$scope.$close();
						};
					}
				]
			});
		};

		/*
		 * Operation Unload Drive Input LibraryID, MediaAgentId, DrPoolID,LDriveID
		 */
		vm.unloadDrive = function(entity) {
			var callBackFunctions = {
				noFunction: function() {},
				yesFunction: function() {
					vm.storageService
						.unloadDrive(entity.drive.driveId)
						.success(function(data) {
							if ((data.errorMessage != '') & (data.errorCode != 0)) {
								vm.cvToaster.showErrorMessage({
									ttl: '10000',
									message: data.errorMessage
								});
							} else {
								vm.cvToaster.showSuccessMessage({
									ttl: '10000',
									message: vm.cvLoc('popup.successUnloadDrive')
								});
							}

							vm.$emit('unloadDrive');
						})
						.error(function(data) {
							vm.cvToaster.showErrorMessage({
								ttl: '10000',
								message: data ? data.errorMessage : vm.cvLoc('popup.failedUnloadDrive')
							});
							vm.$log.error('Unload Drive failed');
						});
				}
			};

			vm.$dialogs.confirm(
				vm.cvLoc('title.confirmUnloadDrive'),
				vm.cvLoc('label.confirmUnloadDrive'),
				callBackFunctions
			);
		};
		/*
		 * Operation Reset Drive Input LDriveID
		 */
		vm.resetDrive = function(entity) {
			var callBackFunctions = {
				noFunction: function() {},
				yesFunction: function() {
					vm.storageService
						.resetDrive(entity.drive.driveId)
						.success(function(data) {
							if ((data.errorMessage != '') & (data.errorCode != 0)) {
								vm.cvToaster.showErrorMessage({
									ttl: '10000',
									message: data.errorMessage
								});
							} else {
								vm.cvToaster.showSuccessMessage({
									ttl: '10000',
									message: cvLoc('popup.successDriveReset')
								});
							}

							vm.$emit('resetDrive');
						})
						.error(function(data) {
							vm.cvToaster.showErrorMessage({
								ttl: '10000',
								message: data ? data : vm.cvLoc('popup.failedResetDrive')
							});
							vm.$log.error('Reset Drive failed');
						});
				}
			};

			vm.$dialogs.confirm(cvLoc('title.confirmResetDrive'), vm.cvLoc('label.confirmResetDrive'), callBackFunctions);
		};

		/*
		 * Operation Replace Drive Input LDriveID
		 */
		vm.replaceDrive = function(entity) {
			var callBackFunctions = {
				noFunction: function() {},
				yesFunction: function() {
					vm.storageService
						.replaceDrive(entity.drive.driveId)
						.success(function(data) {
							if ((data.errorMessage != '') & (data.errorCode != 0)) {
								vm.cvToaster.showErrorMessage({
									ttl: '10000',
									message: data.errorMessage
								});
							} else {
								vm.cvToaster.showSuccessMessage({
									ttl: '10000',
									message: cvLoc('popup.successDriveReplace')
								});
							}

							vm.$emit('replaceDrive');
						})
						.error(function(data) {
							vm.cvToaster.showErrorMessage({
								ttl: '10000',
								message: data ? data : cvLoc('popup.failedReplaceDrive')
							});
							vm.$log.error('Mark drive replaced failed');
						});
				}
			};
			vm.$dialogs.confirm(
				vm.cvLoc('title.confirmReplaceDrive'),
				vm.cvLoc('label.confirmReplaceDrive', '<b>' + entity.drive.driveName + '</b>'),
				callBackFunctions
			);
		};

		/*
		 * Operation Clean Drive Input LDriveID
		 */
		vm.cleanDrive = function(entity) {
			var callBackFunctions = {
				noFunction: function() {},
				yesFunction: function() {
					vm.storageService
						.cleanDrive(entity.drive.driveId, entity.link.libraryId, entity.link.libraryName)
						.success(function(data) {
							vm.cvToaster.showSuccessMessage({
								ttl: '10000',
								message:
									vm.cvLoc('popup.successCleanDrive') +
									'<br/>' +
									' <a href="#/jobs/' +
									data +
									'">' +
									vm.cvLoc('notification.jobDetails') +
									'</a>'
							});
						})
						.error(function(data) {
							vm.cvToaster.showErrorMessage({
								ttl: '10000',
								message: data ? data : vm.cvLoc('popup.failedCleanDrive')
							});
							vm.$log.error('Clean Drive failed');
						});
				}
			};

			vm.$dialogs.confirm(vm.cvLoc('title.confirmCleanDrive'), vm.cvLoc('label.cleanDrive'), callBackFunctions);
		};

		/*
		 * Operation : update Tape Library Status (Input: libraryID)
		 */
		vm.updateTapeLibraryStatus = function() {
			var statusInt = vm.status == 'enabled-activity' ? 0 : 1;
			vm.storageService
				.updateTapeLibraryStatus(vm.libraryId, statusInt)
				.success(function(data) {
					if (data.errorCode == 0) {
						vm.status = vm.status == 'enabled-activity' ? 'disabled-activity' : 'enabled-activity';
					} else {
						vm.cvToaster.showErrorMessage({
							ttl: '5000', //5 sec
							message: data.errorMessage
						});
						vm.$log.error('update status option failed');
					}
				})
				.error(function(error) {
					vm.cvToaster.showErrorMessage({
						ttl: '10000',
						message: error ? error : cvLoc('generic_error')
					});
				});
		};

		/*
		 * Operation : update Tape Library Maintenance mode (Input: libraryID)
		 */
		vm.updateMaintenanceMode = function(maintenanceModeInt) {
			maintenanceModeInt =
				vm.maintenanceMode == 'enabled-activity'
					? maintenanceModeInt ^ LibraryConstants.MMS2_LIBRARY_EXT_MARKED_FOR_MAINTENANCE
					: maintenanceModeInt | LibraryConstants.MMS2_LIBRARY_EXT_MARKED_FOR_MAINTENANCE;

			vm.storageService
				.updateMaintenanceMode(vm.libraryId, maintenanceModeInt)
				.success(function(data) {
					if (data.errorCode == 0) {
						vm.maintenanceMode = vm.maintenanceMode == 'enabled-activity' ? 'disabled-activity' : 'enabled-activity';
					} else {
						cvToaster.showErrorMessage({
							ttl: '5000', //5 sec
							message: data.errorMessage
						});
						$log.error('update Maintenance mode option failed');
					}
				})
				.error(function(error) {
					vm.cvToaster.showErrorMessage({
						ttl: '10000',
						message: error ? error : cvLoc('generic_error')
					});
				});
		};

		vm.updateTapeLibrayName = (err = null, name) => {
			vm.$state.go($state.current.name, { ...$stateParams, storagePoolName: name });
		};
	}
];

storageControllers.listMediaController = [
	'$scope',
	'$stateParams',
	'VaultTrackerService',
	'$log',
	'$dialogs',
	'TapeConstants',
	'cvBreadcrumbsTabsFactory',
	'cvLoc',
	'cvToaster',
	'$location',
	function(
		$scope,
		$stateParams,
		VaultTrackerService,
		$log,
		$dialogs,
		TapeConstants,
		cvBreadcrumbsTabsFactory,
		cvLoc,
		cvToaster,
		$location
	) {
		$scope.vaultId = $stateParams['vaultId'];
		$scope.vaultName = $stateParams['vaultName'];
		$scope.libraryId = $stateParams['libraryId'];
		$scope.libraryName = $stateParams['libraryName'];
		$scope.model = $stateParams['model'];

		var breadCrumbs = [
			{
				title: cvLoc('label.nav.tape'),
				link: '#storage/tape'
			},
			{
				title: decodeURIComponent($scope.libraryName),
				link:
					'#/tapeLibrary/mediaDetails?' +
					'libraryId=' +
					$scope.libraryId +
					'&libraryName=' +
					encodeURIComponent($scope.libraryName) +
					'&model=' +
					$scope.model
			},
			{
				title: $scope.vaultName,
				link:
					'#/vaultTracker?vaultId=' +
					$scope.vaultId +
					'&vaultName=' +
					$scope.vaultName +
					'&libraryId=' +
					$scope.libraryId +
					'&libraryName=' +
					$scope.libraryName +
					'&model=' +
					$scope.model
			}
		];

		cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);

		$scope.runNowVaultTrackerListMedia = function() {
			const vaultId = parseInt($scope.vaultId);
			const vaultName = $scope.vaultName;

			const body = {
				taskInfo: {
					associations: [
						{
							_type_: '21',
							trackingPolicyId: vaultId,
							trackingPolicyName: vaultName
						}
					],
					task: {
						taskFlags: {
							disabled: false
						},
						initiatedFrom: 1,
						ownerId: 1,
						ownerName: 'admin',
						sequenceNumber: 0,
						taskType: 1
					},
					subTasks: [
						{
							subTask: {
								operationType: TapeConstants.DEFAULT_OPERATION_TYPE,
								subTaskType: 1
							},
							options: {
								adminOpts: {
									runvtPolicyOption: {
										vTPolicy: {
											_type_: 21,
											trackingPolicyId: vaultId,
											trackingPolicyName: vaultName
										},
										sourceLibrary: {
											libraryId: Number($scope.libraryId)
										}
									}
								}
							}
						}
					]
				}
			};

			VaultTrackerService.runNowVaultTracker(vaultId, JSON.stringify(body))
				.success(function(response) {
					const actionLink =
						'#/vaultTrackerPolicyActions?input.LibraryId=' +
						$scope.libraryId +
						'&input.PolicyId=' +
						vaultId +
						'&input.model=' +
						$scope.model +
						'&vaultId=' +
						vaultId +
						'&vaultName=' +
						vaultName +
						'&libraryId=' +
						$scope.libraryId +
						'&libraryName=' +
						encodeURIComponent($scope.libraryName) +
						'&model=' +
						$scope.model;
					const message =
						cvLoc('popup.successExportMedia') + '. <a href="' + actionLink + '">' + cvLoc('popup.viewActions') + '</a>';
					cvToaster.showSuccessMessage({
						ttl: '5000',
						message: message
					});
				})
				.error(function(e) {
					cvToaster.showErrorMessage({
						ttl: '10000',
						message: e.errorMessage ? e.errorMessage : cvLoc('generic_error')
					});
				});
		};
	}
];

storageControllers.tapeStoragePoolDetailsController = [
	'$q',
	'$filter',
	'sharedData',
	'$scope',
	'storageService',
	'cvBreadcrumbsTabsFactory',
	'$stateParams',
	'cvLoc',
	'$state',
	'$dialogs',
	'ReportConstants',
	'rpStoreFactory',
	'securityFactory',
	'TAPE_STORAGEPOOL_TYPE',
	function(
		$q,
		$filter,
		sharedData,
		$scope,
		storageService,
		cvBreadcrumbsTabsFactory,
		$stateParams,
		cvLoc,
		$state,
		$dialogs,
		ReportConstants,
		rpStoreFactory,
		securityFactory,
		TAPE_STORAGEPOOL_TYPE
	) {
		/// initialize params
		var vm = $scope;
		vm.storagePoolId = $stateParams['storagePoolId'];
		vm.storagePoolName = $stateParams['storagePoolName'];
		vm.storagePoolType = $stateParams['storagePoolType'];
		vm.storagePoolTypeStringify = cvLoc(TAPE_STORAGEPOOL_TYPE[vm.storagePoolType]);

		/// initialize default values
		vm.isRPStore = vm.libraryType && vm.libraryType == 10;
		vm.stateName = $state.current.name;
		vm.maintenanceMode = 'enabled-activity';
		vm.status = 'enabled-activity';
		vm.deconfiguredLibrary = false;

		vm.$filter = $filter;
		vm.$state = $state;
		vm.sharedData = sharedData;
		vm.ReportConstants = ReportConstants;
		vm.storageService = storageService;
		vm.cvLoc = cvLoc;
		vm.$dialogs = $dialogs;
		vm.$q = $q;

		// Security tile
		vm.entityType = 'STORAGE_POLICY_ENTITY';
		vm.genericEntity = {
			storagePolicyId: parseInt(vm.storagePoolId)
		};
		vm.formattedSecurityAssociations = securityFactory.createSecurityAssociationsObject();
		vm.associationsLoaded = false;

		const DISK_LIBRARY = 3;

		if (vm.storagePoolId) {
			securityFactory.getSecurityAssociation(vm.entityType, parseInt(vm.storagePoolId)).success(function(data) {
				vm.formattedSecurityAssociations = securityFactory.formatSecurityAssociationsObject(data.securityAssociations);
				vm.associationsLoaded = true;
			});
		}
		// Security tile

		vm.editRPStore = function() {
			var rpStoreModal = rpStoreFactory.showAddRPStoreModal(
				vm.libraryId,
				vm.libraryName,
				vm.libDetails.magLibSummary.associatedMediaAgents,
				vm.libDetails.rpStoreLibraryInfo.minSpacePerRPStoreGB,
				vm.libDetails.rpStoreLibraryInfo.maxSpacePerRPStoreGB
			);
			rpStoreModal.result.then(
				function() {
					$state.forceReload();
				},
				function() {}
			);
		};

		/* setup function declaration  - Actually here we are fetching data from api in order to populate view */
		/* State: tapeStoragePoolDetails */
		function tapeStoragePoolFetchData(options) {
			const deferred = vm.$q.defer();
			vm.storageService
				.getStoragePoolDetails(vm.storagePoolId)
				.success(function(poolDetails) {
					vm.storagePoolDetails = poolDetails;
					vm.libDetails = poolDetails.libraryList;
					let libraryModel;
					_.forEach(poolDetails.libraryList, library => {
						if (library.libraryType === DISK_LIBRARY)
							vm.storageIndexLibrary = _.get(cv, 'sessionContext.IBMiVTLStorageExists', false) && library;
						else if (!libraryModel) {
							libraryModel = library;
						}
					});

					vm.libraryType = libraryModel.libraryType;
					vm.isRPStore = vm.libraryType && vm.libraryType == 10;
					const planList = poolDetails.planList || [];
					const copyInfo = poolDetails.copyInfo;
					const dataEncryp = copyInfo.dataEncryption;

					configEncryptionType({ copyInfo, dataEncryp });
					buildBreadcrumb(libraryModel.library.libraryId, libraryModel.library.libraryName, libraryModel.model);
					vm.storagePoolMessage = {
						message: ' ', // space is needed
						type: 'ok'
					};

					if (planList.length > 0) {
						planList.forEach(plan => {
							plan.associationLevel = 'Plans';
						});
					}
					options.success(planList);
					deferred.resolve();
				})
				.error(function(e) {
					vm.storagePoolMessage = {
						message: e,
						type: 'error'
					};
					options.error(e);
					deferred.reject(e);
				});
			return deferred.promise;
		}

		function configEncryptionType({ copyInfo, dataEncryp }) {
			vm.encryption = {
				encrypt: copyInfo.copyFlags.auxCopyReencryptData === 'SET_TRUE',
				cipher: {
					keyName: dataEncryp.encryptionType,
					keyLength: dataEncryp.encryptionKeyLength
				},
				storeOnMedia: copyInfo.copyFlags.storeKeyOnMedia === 'SET_TRUE',
				managementServer: dataEncryp.keyProvider.keyProviderName,
				extendedFlags: {
					encryptOnDependentPrimary: copyInfo.extendedFlags.encryptOnDependentPrimary === 'SET_TRUE'
				}
			};
		}

		function buildBreadcrumb(libId, libName, model) {
			// BreadCrumb
			let breadCrumbs = [
				{
					title: cvLoc('label.nav.tape'),
					link: '#storage/tape'
				},
				{
					title: libName,
					link:
						'#/tapeLibrary?' + 'libraryId=' + libId + '&libraryName=' + encodeURIComponent(libName) + '&model=' + model
				}
			];

			cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);
			// BreadCrumb
		}

		const setupGridOptions = function() {
			let gridOptions = {};
			gridOptions.enableResizing = true;
			gridOptions.columns = initColumnDefs();
			gridOptions.gridTitle = cvLoc('label.associatedPlans');
			gridOptions.tableName = 'associatedPlans';
			gridOptions.enableCheckBoxColumn = false;
			gridOptions.url = options => {
				$q.all([
					tapeStoragePoolFetchData(options), // RUN FETCH DATA FOR VIEW
					storageService.getAllKeyManagementServers(null)
				]).then(([first = null, keyManagementServers]) => {
					// here first returns undefined because we handle all the data inside of tapeStoragePoolFetchData
					vm.keyProviders = (keyManagementServers.data && keyManagementServers.data.keyProviders) || [];
				});
			};
			gridOptions.hasViews = false;
			$scope.gridOptions = gridOptions;
			//$scope.gridOptionsKendo = gridOptions;
		};

		const initColumnDefs = function() {
			const storagePool = {
				name: $scope.storagePoolName,
				id: $scope.storagePoolId,
				type: $scope.storagePoolType
			};
			return associatedEntitiesColumnTemplates.getAssociatedEntitiesColumnTemplate({
				cvLoc: cvLoc,
				isRPStore: $scope.isRPStore,
				stateName: $scope.stateName,
				storagePool
			});
		};

		setupGridOptions();
	}
];

storageMod.controller(storageControllers);

export default storageMod;
