import 'adminConsole/js/directives/cv-detect-tape-library.js';
import 'browse/js/controllers/browse.ctrl.js';
import 'machineBrowse/js/controllers/machineBrowse.ctrl.js';
import 'machineBrowse/js/services/machineBrowse.svc.js';
import 'storage/js/services/storage.svc.js';
import 'webScale/js/controllers/storagePool.ctrl.js';
import 'adminConsole/js/controllers/cloudLibConstants.js';
import 'dlo/js/controllers/profile.ctrl.js';
import 'adminConsole/js/factories/rpstore.factory.js';
import 'adminConsole/js/controllers/kendoRpstore.ctrl.js';
import 'modules/policies/storagePolicy/js/services/storagePolicy.svc';
//refactor
import 'modules/storage/js/constants/storage.constants.js';
import 'modules/storage/js/factories/storage.factory.js';
import 'modules/storage/js/filters/storage.filters.js';
// Controllers
import 'modules/storage/js/controllers/addStorage.ctrl.js';
import 'modules/storage/js/controllers/wizard.ctrl.js';
// Directives
import 'modules/storage/js/directives/storage.directive.js';
import { acAppStorageModule } from 'common/js/modules';

var storageMod = acAppStorageModule;

const storageControllers = {};

storageControllers.storageController = [
	'$scope',
	'$http',
	'storageService',
	'$rootScope',
	'$uibModal',
	'$stateParams',
	'cvTableOptions',
	'cvLoc',
	'$dialogs',
	'$log',
	'$state',
	'cvUtil',
	'cvToaster',
	'LibraryConstants',
	'rpStoreFactory',
	'storageFactory',
	'cvBreadcrumbsTabsFactory',
	function(
		$scope,
		$http,
		storageService,
		$rootScope,
		$modal,
		$stateParams,
		cvTableOptions,
		cvLoc,
		$dialogs,
		$log,
		$state,
		cvUtil,
		cvToaster,
		LibraryConstants,
		rpStoreFactory,
		storageFactory,
		cvBreadcrumbsTabsFactory
	) {
		$scope.cvLoc = cvLoc;
		let _setupBreadCrumbs = () => {
			let breadCrumbs = [];

			breadCrumbs.push({
				title: cvLoc('label.nav.storage'),
				link: '#nav/mstoragePool'
			});

			cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);
		};

		//_setupBreadCrumbs();

		$scope.libraryMessage = cvUtil.infoMsgLoc('Loading');

		var bShowVaultTrackerChanges = !(
			(cv &&
				cv.additionalSettings &&
				cv.additionalSettings.AdminConsole &&
				cv.additionalSettings.AdminConsole.bHideVaultTrackerChanges) ||
			false
		);

		storageService
			.getAllLibraries('All')
			.success(function(data) {
				$scope.libraryMessage = cvUtil.emptyMsg();
				if (data.length) {
					$scope.libs = data;
				} else {
					$scope.libs = [];
				}
			})
			.error(function(e) {
				$scope.libraryMessage = cvUtil.errMsg(e);
			});

		var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);
		const actionsCellTemplate = bShowVaultTrackerChanges
			? '<div class="btn-group" uib-dropdown> <a href class= "uib-dropdown-toggle" uib-dropdown-toggle data-ng-disabled="disabled"> <span class="grid-action-icon"></span> </a> <ul uib-dropdown-menu class="dropdown-menu" role="menu">' +
			  ' <li data-ng-if="row.entity.libraryType != 3 && row.entity.libraryType == 9"> <a class="crop"  data-ng-click="grid.appScope.deleteLibrary(row.entity.library.libraryId, row.entity.library.libraryName, row.entity.libraryType);">' +
			  cvLoc('action.delete') +
			  '</a> </li>' +
			  ' <li data-ng-if="row.entity.libraryType == 3"> <a class="crop" data-ng-click="grid.appScope.deleteLibrary(row.entity.library.libraryId, row.entity.library.libraryName, row.entity.libraryType);">' +
			  cvLoc('action.delete') +
			  '</a> </li>' +
			  ' <li data-ng-if="row.entity.libraryType != 3 && row.entity.libraryType != 9' +
			  '&& !grid.appScope.isStandAloneLibrary(row.entity.libraryType)"> <a class="crop"' +
			  'data-ng-click="grid.appScope.resetLibrary(row.entity.library.libraryId);">' +
			  cvLoc('action.resetLibrary') +
			  '</a> </li>' +
			  ' <li> <a class= "crop" data-ng-if="row.entity.libraryType != 3 && row.entity.libraryType != 9" class= "crop" data-ng-click="grid.appScope.deleteLibrary(row.entity.library.libraryId, row.entity.library.libraryName, row.entity.libraryType);"> ' +
			  cvLoc('action.deconfigure') +
			  '</a> </li> ' +
			  ' <li data-ng-if="row.entity.libraryType != 3 && row.entity.libraryType != 9' +
			  '&& !grid.appScope.isStandAloneLibrary(row.entity.libraryType)" class= "dropdown-submenu dropdown-submenu-left"> <a class="crop" >' +
			  cvLoc('title.exportMedia') +
			  '</a> <ul class="dropdown-menu"> <li data-ng-if="row.entity.libraryType != 3 && row.entity.libraryType != 9' +
			  '&& !grid.appScope.isStandAloneLibrary(row.entity.libraryType)"> <a data-ng-click="grid.appScope.exportLibrary(row.entity.library.libraryId, row.entity.library.libraryName, row.entity.model);">' +
			  cvLoc('label.listBased') +
			  '</a> </li>' +
			  ' <li data-ng-if="row.entity.libraryType != 3 && row.entity.libraryType != 9' +
			  '&& !grid.appScope.isStandAloneLibrary(row.entity.libraryType)"> <a ' +
			  'data-ng-click="grid.appScope.exportLibraryCriteria(row.entity.library.libraryId);">' +
			  cvLoc('title.exportMediaCriteria') +
			  '</a> </li>' +
			  ' </ul> </li> </ul> </div>'
			: '<div class="btn-group" uib-dropdown><a href class= "uib-dropdown-toggle" uib-dropdown-toggle data-ng-disabled="disabled"><span class="grid-action-icon"/></a><ul uib-dropdown-menu class="dropdown-menu" role="menu">' +
			  ' <li data-ng-if="row.entity.libraryType != 3 && row.entity.libraryType == 9"><a class="crop"  data-ng-click="grid.appScope.deleteLibrary(row.entity.library.libraryId, row.entity.library.libraryName, row.entity.libraryType);">' +
			  cvLoc('action.delete') +
			  '</a></li>' +
			  ' <li data-ng-if="row.entity.libraryType == 3"><a class="crop" data-ng-click="grid.appScope.deleteLibrary(row.entity.library.libraryId, row.entity.library.libraryName, row.entity.libraryType);">' +
			  cvLoc('action.delete') +
			  '</a></li>' +
			  ' <li data-ng-if="row.entity.libraryType != 3 && row.entity.libraryType != 9' +
			  '&& !grid.appScope.isStandAloneLibrary(row.entity.libraryType)"><a class="crop"' +
			  'data-ng-click="grid.appScope.resetLibrary(row.entity.library.libraryId);">' +
			  cvLoc('action.resetLibrary') +
			  '</a></li>' +
			  ' <li><a class= "crop" data-ng-if="row.entity.libraryType != 3 && row.entity.libraryType != 9" class= "crop" data-ng-click="grid.appScope.deleteLibrary(row.entity.library.libraryId, row.entity.library.libraryName, row.entity.libraryType);"> ' +
			  cvLoc('action.deconfigure') +
			  '</a></li> ' +
			  ' <li data-ng-if="row.entity.libraryType != 3 && row.entity.libraryType != 9' +
			  '&& !grid.appScope.isStandAloneLibrary(row.entity.libraryType)"><a class="crop" data-ng-click="grid.appScope.exportLibrary(row.entity.library.libraryId, row.entity.library.libraryName, row.entity.model);">' +
			  cvLoc('title.exportMedia') +
			  '</a></li></ul></div>';

		$scope.exportLibrary = storageFactory.exportLibrary;
		$scope.exportLibraryCriteria = storageFactory.exportLibraryCriteria;
		angular.extend(globalGridOptions, {
			data: 'libs',
			columnDefs: [
				{
					field: 'library.libraryName',
					displayName: cvLoc('Name'),
					enableHiding: false,
					cellClass: 'crop',
					cellTemplate:
						'<a data-ng-if="row.entity.libraryType == 3" href="#diskLibrary?libraryId={{row.entity.library.libraryId}}&libraryName={{row.entity.library.libraryName | encodeParam}}&model={{row.entity.model}}">{{row.entity.library.libraryName}}</a>' +
						'<a data-ng-if="row.entity.libraryType != 3" href="#tapeLibrary?libraryId={{row.entity.library.libraryId}}&libraryName={{row.entity.library.libraryName | encodeParam}}&model={{row.entity.model}}">{{row.entity.library.libraryName}}</a>'
				},
				{
					field: 'status',
					displayName: cvLoc('label.status'),
					cvUserPref: 'status'
				},
				{
					field: 'manufacturer',
					displayName: cvLoc('label.manufacturer'),
					cvUserPref: 'manufacturer'
				},
				{
					field: 'libraryVendorId',
					displayName: cvLoc('label.model'),
					cellTemplate:
						'<span class="crop" data-ng-if="row.entity.model == \'Cloud\'"> {{row.entity.libraryVendorId | cloudVendorNames}} </span>' +
						'<span class="crop" data-ng-if="row.entity.model != \'Cloud\'"> {{row.entity.model}} </span>',
					cvUserPref: 'model'
				},
				{
					field: 'libraryId',
					name: 'action',
					cellTooltip: true,
					displayName: cvLoc('Actions'),
					enableFiltering: false,
					enableSorting: false,
					enableHiding: false,
					//cellTemplate: '<cv-cell-actions row="row" is-stand-alone-library="grid.appScope.isStandAloneLibrary" delete-library="grid.appScope.deleteLibrary" reset-libraryis-stand-alone-library="grid.appScope.resetLibrary" export-library-criteria="grid.appScope.exportLibraryCriteria" export-library="grid.appScope.exportLibrary"></cv-cell-actions>',
					cellTemplate: actionsCellTemplate,
					width: '10%'
				}
			]
		});

		$scope.addDiskLibrary = function() {
			storageFactory.addOrEditStorage(
				$scope,
				$http,
				storageService,
				$rootScope,
				$modal,
				$stateParams,
				cvTableOptions,
				cvLoc,
				'newDiskLib',
				$state
			);
		};

		$scope.addCloudLibrary = function() {
			storageFactory.addOrEditStorage(
				$scope,
				$http,
				storageService,
				$rootScope,
				$modal,
				$stateParams,
				cvTableOptions,
				cvLoc,
				'newCloudLib',
				$state
			);
		};

		$scope.addTapeLibrary = function() {
			storageFactory.addOrEditStorage(
				$scope,
				$http,
				storageService,
				$rootScope,
				$modal,
				$stateParams,
				cvTableOptions,
				cvLoc,
				'newTapeLib',
				$state
			);
		};

		$scope.addRPStore = function() {
			var rpStoreModal = rpStoreFactory.showAddRPStoreModal();
			rpStoreModal.result.then(
				function() {
					$state.forceReload();
				},
				function() {}
			);
		};

		$scope.aDifferentStorageTargetTypes = [
			{
				label: cvLoc('label.disk'),
				onclick: $scope.addDiskLibrary
			},
			{
				label: cvLoc('label.cloud'),
				onclick: $scope.addCloudLibrary
			},
			{
				label: cvLoc('label.tape'),
				onclick: $scope.addTapeLibrary
			}
		];

		$scope.aStorageTargetPageLinks = [
			{
				label: cvLoc('title.addLibrary'),
				subLinks: $scope.aDifferentStorageTargetTypes
			}
		];

		if (
			cv.isTenantAdmin &&
			cvUtil.objectContainsNestedProperty('cv.sessionContext.infrastructureType', cv) &&
			cv.sessionContext.infrastructureType === 'RENTED' &&
			cv.sessionContext.bTenantCanViewStoragePool
		) {
			$scope.aStorageTargetPageLinks = [];
			$scope.aDifferentStorageTargetTypes = [];
		}

		$scope.storageListGridOptions = {
			cvPageLinks: $scope.aStorageTargetPageLinks,
			cvGridTitle: cvLoc('Storage'),
			cvTableName: 'storageTable',
			cvServerMessage: 'libraryMessage',
			cvSearchFields: ['library.libraryName', 'status', 'manufacturer', 'model'],
			cvOnGridEmpty: {
				message: cvLoc('label.noStorage'),
				links: $scope.aDifferentStorageTargetTypes
			},
			gridOptions: globalGridOptions
		};

		$scope.editDiskLibrary = function(entity) {
			storageFactory.addOrEditStorage(
				$scope,
				$http,
				storageService,
				$rootScope,
				$modal,
				$stateParams,
				cvTableOptions,
				cvLoc,
				'editLib',
				$state,
				entity
			);
		};

		$scope.editCloudLibrary = function(entity) {
			storageFactory.addOrEditStorage(
				$scope,
				$http,
				storageService,
				$rootScope,
				$modal,
				$stateParams,
				cvTableOptions,
				cvLoc,
				'editCloudLib',
				$state,
				entity
			);
		};

		$scope.editMountPath = function(entity) {
			storageFactory.addOrEditStorage(
				$scope,
				$http,
				storageService,
				$rootScope,
				$modal,
				$stateParams,
				cvTableOptions,
				cvLoc,
				'editMP',
				$state,
				entity
			);
		};

		$scope.deleteLibrary = function(libraryId, libraryName, libraryType) {
			var LibraryInfo = {
				libraryEntity: {
					libraryId: libraryId,
					libraryName: libraryName,
					libraryType: libraryType
				}
			};
			var callBackFunctions = {
				noFunction: function() {},
				yesFunction: function() {
					storageService
						.delLibrary(LibraryInfo)
						.success(function(data) {
							$log.debug('Delete Library success');
							$state.forceReload();
						})
						.error(function(data) {
							$dialogs.error(cvLoc('label.error'), cvUtil.errMsg(data).message);
							$log.error('Delete Library failed');
						});
				}
			};
			if (libraryType == 3) {
				$dialogs.confirm(
					cvLoc('label.confirmDelete'),
					cvLoc('label.confirmDeleteDiskCloudLibrary') +
						'<br/>' +
						cvLoc('label.generalDeleteLibarry', '<b>' + libraryName + '</b>'),
					callBackFunctions
				);
			} else {
				$dialogs.confirm(
					cvLoc('label.confirmDelete'),
					cvLoc('label.confirmDeleteTapeLibrary') +
						'<br/>' +
						cvLoc('label.generalDeleteLibarry', '<b>' + libraryName + '</b>'),
					callBackFunctions
				);
			}
		};

		$scope.resetLibrary = function(libraryId) {
			var callBackFunctions = {
				noFunction: function() {},
				yesFunction: function() {
					storageService
						.resetLibrary(libraryId)
						.success(function(data) {
							if ((data.errorMessage != '') & (data.errorCode != 0)) {
								cvToaster.showErrorMessage({
									ttl: '10000',
									message: data.errorMessage
								});
							} else {
								cvToaster.showSuccessMessage({
									ttl: '10000',
									message: cvLoc('popup.succesResetLibrary')
								});
							}
							$log.debug('Reset Library success');
							$state.forceReload();
						})
						.error(function(data) {
							cvToaster.showErrorMessage({
								ttl: '10000',
								message: e ? e : cvLoc('popup.failedResetLibrary')
							});
							$log.error('Reset Library failed');
						});
				}
			};

			$dialogs.confirm(cvLoc('title.confirmResetLibrary'), cvLoc('confirm.resetLibrary'), callBackFunctions);
		};
		/* Library type */
		$scope.isStandAloneLibrary = function(libraryType) {
			if (
				libraryType == LibraryConstants.CV_LIB_STANDALONE_TAPE ||
				libraryType == LibraryConstants.CV_LIB_STANDALONE_OPTICAL
			) {
				return true;
			}

			return false;
		};
	}
];

storageMod.controller(storageControllers);

export default storageMod;
