import 'adminConsole/js/directives/cv-detect-tape-library.js';
import 'browse/js/controllers/browse.ctrl.js';
import 'modules/storage/js/filters/storage.filters.js';
import 'machineBrowse/js/controllers/machineBrowse.ctrl.js';
import 'machineBrowse/js/services/machineBrowse.svc.js';
import 'webScale/js/controllers/storagePool.ctrl.js';
import 'adminConsole/js/controllers/cloudLibConstants.js';
import 'dlo/js/controllers/profile.ctrl.js';
import 'adminConsole/js/factories/rpstore.factory.js';
import 'adminConsole/js/controllers/rpstore.ctrl.js';
import 'modules/schedule/js/factory/schedule.factory.js';
import 'storage/js/services/storage.svc.js';
import 'modules/settings/js/factories/cvPermissions.factory.js';

import * as mountPathColumnTemplates from '../storagePoolDetails.column.template';
import * as ddbDiskInformationColumnTemplates from '../storagePoolDDBDiskInformation.column.template';

import { acAppStorageModule } from 'common/js/modules';

var storageMod = acAppStorageModule;

const storageControllers = {};

storageControllers.diskLibraryDetailsController = [
	'CLOUD_TYPE_LABELS',
	'storagePoolTypesConstants',
	'sharedData',
	'$scope',
	'$http',
	'storageService',
	'cvToaster',
	'$rootScope',
	'$uibModal',
	'cvBreadcrumbsTabsFactory',
	'$stateParams',
	'cvTableOptions',
	'cvLoc',
	'$dialogs',
	'$log',
	'$state',
	'cvUtil',
	'rpStoreFactory',
	'storageFactory',
	'securityFactory',
	'tabService',
	'$q',
	'$compile',
	'CLOUD_TYPE_LIST',
	'dialogFactory',
	function(
		CLOUD_TYPE_LABELS,
		storagePoolTypesConstants,
		sharedData,
		$scope,
		$http,
		storageService,
		cvToaster,
		$rootScope,
		$modal,
		cvBreadcrumbsTabsFactory,
		$stateParams,
		cvTableOptions,
		cvLoc,
		$dialogs,
		$log,
		$state,
		cvUtil,
		rpStoreFactory,
		storageFactory,
		securityFactory,
		tabService,
		$q,
		$compile,
		CLOUD_TYPE_LIST,
		dialogFactory
	) {
		$scope.storagePoolId = $stateParams['storagePoolId'];
		$scope.storagePoolName = $stateParams['storagePoolName'];
		$scope.storagePoolType = parseInt($stateParams['storagePoolType']);

		$scope.libraryId = $stateParams['libraryId'];
		$scope.libraryName = $stateParams['libraryName'];
		$scope.libraryType = $stateParams['libraryType'];
		$scope.isRPStore = $scope.libraryType && $scope.libraryType == 10;

		$scope.stateName = $state.current.name;
		$scope.storageFactory = storageFactory;
		sharedData.stateName = $scope.stateName;
		$scope.showAddOption = $scope.storagePoolType != 'SCALE_OUT';

		$scope.entityType = 'STORAGE_POLICY_ENTITY';
		$scope.grid = {};

		$scope.HPE_CATALYST_STORAGE = 59; // serverId for HPE Catalyst Storage
		var MP_DELETE_FORCE_DELETE_NOT_SUPPORTED = 16;
		$scope.genericEntity = {
			storagePolicyId: parseInt($scope.storagePoolId)
		};

		const setupGridOptions = function(err = null, mountPaths) {
			let gridOptions = {};
			gridOptions.url = function(options) {
				if (err === null) {
					options.success(mountPaths);
				} else {
					options.error(err);
				}
			}.bind(this);

			gridOptions.enableResizing = true;
			gridOptions.columns = initColumnDefs();
			// gridOptions.gridTitle = $scope.fromStoragePool ? cvLoc("label.storage") : cvLoc("label.mountPaths");
			gridOptions.gridTitle =
				$scope.model && $scope.model.toUpperCase() === 'cloud'.toUpperCase()
					? cvLoc(getCloudLabelFromVendorType())
					: cvLoc('label.backupLocations');
			gridOptions.tableName = $scope.isRPStore ? 'rpStoreDetailTable' : 'diskLibraryDetailsTable';
			gridOptions.enableCheckBoxColumn = false;
			gridOptions.hasViews = true;

			gridOptions.onGridDataBound = _onGridDataBound.bind(this);

			// add button will not appear when the cloud is hpe catalyst storage vendor type
			if (!$scope.isRPStore && $scope.libraryVendorId !== $scope.HPE_CATALYST_STORAGE) {
				gridOptions.gridToolbarMenu = [
					{
						id: 'AddStorage',
						disableOnDeselect: false,
						label: cvLoc('label.add'),
						onSelect: () => {
							$scope.addMountPath(
								$scope.libraryId,
								$scope.libraryName,
								$scope.model,
								$scope.libraryVendorId,
								$scope.distributedStorage
							);
						}
					}
				];
			}

			$scope.grid.gridOptionsKendo = gridOptions;
			$scope.gridOptionsKendo = gridOptions;
		};

		const initColumnDefs = function() {
			const storagePool = {
				name: $scope.storagePoolName,
				id: $scope.storagePoolId,
				type: $scope.storagePoolType,
				libraryVendorId: $scope.libraryVendorId
			};
			return mountPathColumnTemplates.getMountPathColumnTemplate({
				cvLoc: cvLoc,
				isRPStore: $scope.isRPStore,
				stateName: $scope.stateName,
				storagePool
			});
		};

		const _onGridDataBound = (dataItem, row) => {
			const permittedOptions = dataItem.permittedOptions;
			const id = permittedOptions.entityId;
			const template = `<cv-permitted-actions cv-permitted-options="permittedOptions${id}"></cv-permitted-actions>`;
			$scope[`permittedOptions${id}`] = permittedOptions;
			row.find('.permittedActions').append($compile(template)($scope));

			const roleDetailLink = row.find('.k-grid-roleDetail');

			roleDetailLink.click(function() {
				self.showAddRoleDialog(dataItem);
			});
		};

		const _computePermittedActionsForMountPath = function(entity) {
			let arrayOfActionsToMountPath = [
				{
					show: true,
					label: cvLoc('pageHeader.addMediaAgent'),
					onClick: () =>
						$scope.openWizard(entity.mountPathId, entity.mountPathName, entity.deviceInfo.id, entity.dataServerType),
					value: 'ADDMEDIAAGENT'
				},
				{
					show: !$scope.isRPStore,
					value: 'DELETE',
					label: cvLoc('action.delete'),
					onClick: () =>
						$scope.deleteMountPathonConfig(
							entity.mountPathId,
							entity.mountPathName,
							entity.mountPathSummary.libraryId,
							entity.mountPathSummary.libraryName
						)
				}
			];
			return arrayOfActionsToMountPath;
		};
		const fetchStorageDetails = function() {
			const deferred = $q.defer();
			storageService
				.getStoragePoolDetails($scope.storagePoolId)
				.success(function(poolDetails) {
					let mountPaths = [];
					let libModelMap = [];
					$scope.storagePoolMessage = cvUtil.emptyMsg();

					$scope.storagePoolNode = poolDetails.storagePoolNodeDetailsList;
					$scope.storagePoolDetails = poolDetails;
					$scope.storagePoolDDBDetails = poolDetails.dedupDBDetails;
					$scope.storeId = poolDetails.dedupDBDetails.storeId;
					$scope.storagePoolName = poolDetails.copyInfo.StoragePolicyCopy.storagePolicyName;
					$scope.changeNameObj = {
						id: $scope.storagePoolId,
						name: $scope.storagePoolName
					};
					let libDetails = poolDetails.libraryList;
					for (var i = 0; i < libDetails.length; i++) {
						libModelMap[libDetails[i].library.libraryId] = libDetails[i].model;
						for (var j = 0; j < libDetails[i].MountPathList.length; j++) {
							libDetails[i].MountPathList[j].model = libDetails[i].model;
							libDetails[i].MountPathList[j].permittedOptions = {
								entity: angular.copy(libDetails[i].MountPathList[j]),
								entityId: libDetails[i].MountPathList[j].mountPathId,
								entityName: libDetails[i].MountPathList[j].mountPathName,
								appendToBody: true,
								permittedActionList: _computePermittedActionsForMountPath(libDetails[i].MountPathList[j])
							};
							mountPaths.push(libDetails[i].MountPathList[j]);
						}
					}

					$scope.libraryId = poolDetails.libraryList[0].library.libraryId;
					$scope.libraryName = poolDetails.libraryList[0].library.libraryName;
					$scope.libraryVendorId = poolDetails.libraryList[0].libraryVendorId;
					$scope.model = poolDetails.libraryList[0].model;
					$scope.distributedStorage = poolDetails.distributedStorage;
					//mock data start
					//if($scope.distributedStorage.distributedStorageId)
					//	$scope.distributedStorage.distributedStorageName = 'test-diststorage-1';
					//mock data end
					// here we need in order to work with other views details
					sharedData.data = {
						libId: $scope.libraryId,
						libName: $scope.libraryName,
						model: $scope.model,
						libraryVendorId: 0
					};
					let breadCrumbs = [];
					if ($scope.stateName.includes('disk')) {
						breadCrumbs.push({
							title: cvLoc('label.disk'),
							link: '#storage/disk'
						});
					} else {
						breadCrumbs.push({
							title: cvLoc('label.cloud'),
							link: '#storage/cloud'
						});
					}

					cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);

					$scope.storagePoolDetailsPageLoaded = true;
					$scope.storagePoolDDBDetails.isDeduplicationType =
						$scope.storagePoolType === storagePoolTypesConstants.DEDUPLICATION;
					sharedData.data.libraryVendorId =
						poolDetails.libraryList && poolDetails.libraryList[0] ? poolDetails.libraryList[0].libraryVendorId : 0;
					getVendorType();
					deferred.resolve(mountPaths);
				})
				.error(function(e) {
					$scope.storagePoolMessage = {
						message: e,
						type: 'error'
					};
					deferred.reject(e);
				});
			return deferred.promise;
		};

		var getVendorType = () => {
			if ($scope.libraryVendorId) {
				$scope.serverType = CLOUD_TYPE_LIST.CloudType.find(cloudType => cloudType.id === $scope.libraryVendorId);
			}

			if (!$scope.serverType || $scope.serverType.name === '') {
				$scope.serverType = CLOUD_TYPE_LIST.CloudType[0];
			}
		};

		var getCloudLabelFromVendorType = () => {
			return CLOUD_TYPE_LABELS.CloudLabel[$scope.serverType.id]['label_Bucket'];
		};

		var getAddTitleFromVendorType = () => {
			switch (getCloudLabelFromVendorType()) {
				case 'label.container':
					return cvLoc('label.addContainer');
				case 'label.rootFolder':
					return cvLoc('label.addRootFolder');
				case 'label.namespace':
					return cvLoc('label.addNamespace');
				case 'label.Store':
					return cvLoc('label.addStore');
			}
			return cvLoc('label.addBucket');
		};

		$scope.updateStorage = (id, name) => {
			$scope.serverMessage = null;
			const copyInfo = $scope.storagePoolDetails.copyInfo;
			let data = {
				StoragePolicy: copyInfo.StoragePolicyCopy,
				storagePolicyCopyInfo: {
					StoragePolicyCopy: copyInfo.StoragePolicyCopy
				}
			};
			if (name) {
				data.newStoragePolicyName = name;
				data.storagePolicyCopyInfo.newStoragePolicyName = name;
			}

			storageService
				.updateStoragePool(copyInfo.StoragePolicyCopy, name)
				.success(function(data) {
					if (data.errorCode === 0) {
						$log.debug(cvLoc('log.succesUpdatePolicy'));
						$state.go($state.current.name, { ...$stateParams, storagePoolName: name });
					} else {
						$log.error(cvLoc('log.errorUpdatePolicy'));
						cvToaster.showErrorMessage({
							ttl: '10000',
							message: data.error.errorMessage ? data.error.errorMessage : cvLoc('popup.errorFetchingMedia')
						});
					}
				})
				.error(function(e) {
					$log.error(cvLoc('log.errorUpdatePolicy'));
					cvToaster.showErrorMessage({
						ttl: '10000',
						message: e
					});
				});
		};
		$scope.editRPStore = function() {
			var params = {};
			params.libraryId = $scope.libraryId;
			params.libraryName = $scope.libraryName;
			params.associatedMedia = $scope.libDetails.magLibSummary.associatedMediaAgents;
			params.minGB = $scope.libDetails.rpStoreLibraryInfo.minSpacePerRPStoreGB;
			params.maxGB = $scope.libDetails.rpStoreLibraryInfo.maxSpacePerRPStoreGB;
			params.intervalWindow = $scope.libDetails.rpStoreLibraryInfo.intervalWindow;
			//call the factory method to show RPstore modal
			var rpStoreModal = rpStoreFactory.showAddRPStoreModal(params);
			rpStoreModal.result.then(
				function() {
					$state.forceReload();
				},
				function() {}
			);
		};
		// this controller is used in two jsps and the url has different parameters

		if ($scope.stateName === 'diskLibraryDetails' || $scope.stateName === 'rpDiskLibraryDetails') {
			if ($scope.isRPStore) {
				$scope.model = 'Disk';
				$state.current.pageTitle = 'label.nav.storageTargets.rpStores';
				cvBreadcrumbsTabsFactory.addBreadCrumbs([
					{
						title: cvLoc('label.nav.rpStores'),
						link: '#rpStores'
					}
				]);
			} else {
				cvBreadcrumbsTabsFactory.addBreadCrumbs([
					{
						title: cvLoc('label.nav.storageTargets'),
						link: '#storage/tape'
					}
				]);
			}
			$scope.fromStoragePool = false;

			sharedData.data = {
				libId: $scope.libraryId,
				libName: $scope.libraryName,
				model: $scope.model,
				libraryVendorId: 0
			};
			$scope.cvLoc = cvLoc;
			$scope.typeOfStorage = {
				type: 'localStorage'
			};
			$scope.localPathPattern = /^([a-zA-Z]:){1}(\\[^<>:"/\\|?*]+)*\\?$/;
			$scope.networkPathPattern = /^\\(\\[^<>:"/\\|?*]+)+\\?$/;
			$scope.pathPattern = {
				pattern: $scope.localPathPattern
			};

			storageService
				.getLibraryDetails($scope.libraryId)
				.success(function(libDetails) {
					$scope.mountPaths = libDetails.MountPathList;
					$scope.libDetails = libDetails;
					$scope.storagePoolType = $scope.libDetails.storagePoolType;
					$scope.showAddOption = $scope.libDetails.storagePoolType != 'SCALE_OUT' && !$scope.isRPStore;
					if ($scope.isRPStore) {
						$scope.libDetails.rpStoreLibraryInfo = {};
						if (
							libDetails.MountPathList &&
							libDetails.MountPathList.length > 0 &&
							libDetails.MountPathList[0].rpStoreLibraryInfo
						) {
							libDetails.MountPathList[0].permittedOptions = {
								entity: angular.copy(libDetails.MountPathList[0]),
								entityId: libDetails.MountPathList[0].mountPathId,
								entityName: libDetails.MountPathList[0].mountPathName,
								appendToBody: true,
								permittedActionList: _computePermittedActionsForMountPath(libDetails.MountPathList[0])
							};
							var mountPaths = libDetails.MountPathList;
							setupGridOptions(null, mountPaths);
							$scope.gridSetupDone = true;

							$scope.libDetails.rpStoreLibraryInfo = libDetails.MountPathList[0].rpStoreLibraryInfo;
							$scope.libDetails.rpStoreLibraryInfo.mountPathName = libDetails.MountPathList[0].mountPathName;
							//if interval window not set for any reason, set it to empty object to show 'not enabled'
							if (!$scope.libDetails.rpStoreLibraryInfo.intervalWindow) {
								$scope.libDetails.rpStoreLibraryInfo.intervalWindow = rpStoreFactory.getEmptyIntervalObject();
							}
							$scope.libDetails.rpStoreLibraryInfo.intervalWindow.isRPStore = true;
						}
					}

					$scope.libDetails.rpStoreLoaded = true;
					if ($scope.libDetails.storagePoolType === 'SCALE_OUT') {
						// mountpathGridOptions.columnDefs.pop();
					}

					$scope.mountPathMessage = {
						message: ' ', // space is needed
						type: 'ok'
					};
				})
				.error(function(e) {
					$scope.mountPathMessage = {
						message: e,
						type: 'error'
					};
				});
		} else if ($scope.stateName === 'diskStoragePoolDetails' || $scope.stateName === 'cloudStoragePoolDetails') {
			$scope.fromStoragePool = true;
			$scope.cvLoc = cvLoc;

			fetchStorageDetails()
				.then(mountPaths => {
					setupGridOptions(null, mountPaths);
				})
				.catch(err => {
					setupGridOptions(err, null);
				});
		} else if ($scope.stateName === 'diskStoragePoolDetailsChart') {
			cvBreadcrumbsTabsFactory.addBreadCrumbs([
				{
					title: cvLoc('label.nav.storagePool'),
					link: '#storagePool'
				},
				{
					title: $scope.storagePoolName,
					link:
						'#/diskStoragePoolInfo?storagePoolName=' +
						encodeURIComponent($scope.storagePoolName) +
						'&storagePoolId=' +
						$scope.storagePoolId +
						'&storagePoolType=' +
						$scope.storagePoolType
				}
			]);
		} else if ($scope.stateName === 'diskLibraryDetailsChart') {
			cvBreadcrumbsTabsFactory.addBreadCrumbs([
				{
					title: cvLoc('label.nav.storageTargets'),
					link: '#storage'
				},
				{
					title: $scope.libraryName,
					link:
						'#/diskLibrary?libraryId=' +
						$scope.libraryId +
						'&libraryName=' +
						encodeURIComponent($scope.libraryName) +
						'&model=' +
						$scope.model
				}
			]);
		}

		if ($scope.stateName === 'diskStoragePoolDetails') {
			$scope.title = cvLoc('title.addLibrary');
		} else if ($scope.model === 'Cloud') {
			$scope.title = cvLoc('title.addCloudMountPath');
		} else {
			$scope.title = cvLoc('title.addMountPath');
		}

		$scope.addMountPath = function() {
			$scope.addMountPath(
				$scope.libraryId,
				$scope.libraryName,
				$scope.model,
				$scope.libraryVendorId,
				$scope.distributedStorage
			);
		};

		$scope.getCount = function(count) {
			return count == undefined ? 0 : count;
		};
		$scope.addMountPath = function(libraryId, libraryName, model, libraryVendorId, distributedStorage) {
			let action = '';
			var LibraryItem = {
				libraryEntity: {
					libraryName: libraryName,
					libraryId: libraryId
				},
				loginName: '',
				serverType: {
					id: 0,
					name: ''
				},
				libraryVendorId: libraryVendorId,
				serverHost: ''
			};

			if (distributedStorage && distributedStorage.distributedStorageId) {
				LibraryItem.distributedStorage = distributedStorage;
			}

			if ($scope.model === 'Cloud') {
				$scope.title = getAddTitleFromVendorType();
				action = 'addCloudMP';
			} else {
				action = 'addMP';
				$scope.title = cvLoc('Add_Path');
			}

			storageFactory.addOrEditStorage(
				$scope,
				$http,
				storageService,
				$rootScope,
				$modal,
				$stateParams,
				cvTableOptions,
				cvLoc,
				action,
				$scope.title,
				$state,
				LibraryItem
			);
		};

		$scope.openWizard = function(mpId, mpName, deviceId, dataServerType) {
			$scope.maEntity = {
				controller: {
					mediaAgentId: 0,
					mediaAgentName: '',
					displayName: '',
					mountPathId: 0,
					path: '',
					userName: '',
					accessType: '',
					protocolType: 0,
					numWriters: '',
					deviceControllerId: 0,
					deviceId: deviceId,
					accessTypeValue: 0,
					accessible: true,
					dataServerType: dataServerType
				},
				libraryEntity: {
					libraryName: $scope.libraryName,
					libraryId: $scope.libraryId
				},
				mountPath: {
					id: mpId,
					name: mpName
				},
				writersNumber: {
					maxWriters: -1,
					allowedWritersNumber: 5
				},
				loginName: '',
				serverType: {
					id: 0,
					name: ''
				},
				serverHost: '',
				preferred: false,
				enabled: true,
				libraryVendorId: 0,
				selectedCredential: {
					credentialId: 0,
					credentialName: ''
				}
			};

			const gethelpTextForMaShareWizardModal = () => {
				switch ($scope.model) {
					case 'Cloud': {
						return sharedData.data.libraryVendorId === $scope.HPE_CATALYST_STORAGE
							? cvLoc('label.addMediaAgentHelpTextForHPECatalystStorage')
							: cvLoc('label.addMediaAgentHelpTextForCloud');
					}
					default: {
						return cvLoc('label.addMediaAgentHelpTextForDisk');
					}
				}
			};

			$modal.open({
				templateUrl: appUtil.appRoot + 'adminConsole/partials/maShareWizard.jsp',
				windowClass: 'addServerModal',
				backdrop: 'static',
				controller: [
					'$scope',
					'$log',
					'$uibModalInstance',
					'$state',
					'cvLoc',
					'maEntity',
					function($scope, $log, $modalInstance, $state, cvLoc, maEntity) {
						$scope.addMediaAgentHelpText = gethelpTextForMaShareWizardModal();
						$scope.maEntity = maEntity;
						$scope.action = 'shareDisk';
						$scope.cvLoc = cvLoc;
						$rootScope.$on('storageShared', function() {
							$log.debug('storageShared....');
							$modalInstance.dismiss();
							$state.forceReload();
						});
						$rootScope.$on('shareMountPathCancelled', function() {
							$log.debug('shareMountPathCancelled....');
							$modalInstance.dismiss();
						});
					}
				],
				resolve: {
					maEntity: function() {
						return $scope.maEntity;
					}
				}
			});
		};
		$scope.updateMPStatus = function(mountPathId, mountPathName, enabledMP, libraryName) {
			$scope.libraryInfo = {
				libraryName: libraryName,
				mountPath: {
					id: mountPathId,
					name: mountPathName
				},
				mediaAgent: $scope.storagePoolDetails.mediaAgents[0].mediaAgent.mediaAgentName,
				enabledMP: enabledMP ? 0 : 1
			};
			return storageService
				.updateStatus($scope.libraryInfo)
				.success(function(data) {
					$scope.$emit('mountPathEdited');
					$log.debug('mountPathEdited');
					$state.forceReload();
				})
				.error(function(e) {
					$log.error('Editing mountPath failed');
					$scope.serverMessage = cvUtil.errMsg(e);
				});
		};
		$scope.deleteMountPathonConfig = function(mountPathId, mountPathName, libraryId, libraryName) {
			if (!cvConfig.disallowForceDeleteMountPath || cvConfig.disallowForceDeleteMountPath === false) {
				$scope.deleteMountPathForced(mountPathId, mountPathName, libraryId, libraryName);
			} else {
				$scope.deleteMountPath(mountPathId, mountPathName, libraryId, libraryName);
			}
		};
		$scope.deleteMountPath = function(mountPathId, mountPathName, libraryId, libraryName) {
			var LibraryInfo = {
				libraryEntity: {
					libraryId: libraryId,
					libraryName: libraryName
				},
				mountPath: {
					id: mountPathId,
					name: mountPathName
				}
			};

			var callBackFunctions = {
				noFunction: function() {},
				yesFunction: function() {
					storageService
						.delMountPath(LibraryInfo)
						.success(function(data) {
							$log.debug('Delete MountPath success');
							$state.forceReload();
						})
						.error(function(data) {
							$dialogs.error(cvLoc('label.error'), cvUtil.errMsg(data).message);
							$log.error('Deletion of MountPath failed');
						});
				}
			};
			$dialogs.confirm(
				cvLoc('label.confirmDelete'),
				cvLoc('label.confirmationDeleteMountpath', '<b>' + mountPathName + '</b>'),
				callBackFunctions
			);
		};

		$scope.deleteMountPathForced = function(mountPathId, mountPathName, libraryId, libraryName) {
			var LibraryInfo = {
				libraryEntity: {
					libraryId: libraryId,
					libraryName: libraryName
				},
				mountPath: {
					id: mountPathId,
					name: mountPathName
				},
				forced: 0
			};
			storageService
				.isDeleteMountPathAllowed(mountPathId)
				.success(function(data) {
					$log.debug('Check if mountpath can be deleted');
					if (data.errorCode > 0) {
						var callBackFunctions = {
							noFunction: function() {},
							yesFunction: function() {
								LibraryInfo.forced = 1;
								storageService
									.delForceMountPath(LibraryInfo)
									.success(function(data) {
										$log.debug('Force Deletion of MountPath success');
										$state.forceReload();
									})
									.error(function(data) {
										$dialogs.error(cvLoc('label.error'), cvUtil.errMsg(data).message);
										$log.error('Force Deletion of MountPath failed');
									});
							}
						};
						if ((data.errorCode && MP_DELETE_FORCE_DELETE_NOT_SUPPORTED) == 0) {
							$dialogs.error(cvLoc('label.confirmDelete'), data.errorMessage);
						} else {
							dialogFactory
								.deleteConfirmDialog(
									cvLoc('label.confirmDelete'),
									'<b>' + data.errorMessage + '<b>',
									cvLoc('label.forceDeleteWithDataLoss')
								)
								.result.then(callBackFunctions.yesFunction, callBackFunctions.noFunction);
						}
					} else {
						var callBackFunctions = {
							noFunction: function() {},
							yesFunction: function() {
								storageService
									.delForceMountPath(LibraryInfo)
									.success(function(data) {
										$log.debug('Non force Deletion of MountPath success');
										$state.forceReload();
									})
									.error(function(data) {
										$dialogs.error(cvLoc('label.error'), cvUtil.errMsg(data).message);
										$log.error('Non force Deletion of MountPath failed');
									});
							}
						};
						$dialogs.confirm(
							cvLoc('label.confirmDelete'),
							cvLoc('label.confirmationDeleteMountpath', '<b>' + mountPathName + '</b>'),
							callBackFunctions
						);
					}
				})
				.error(function(data) {
					$dialogs.error(cvLoc('label.error'), cvUtil.errMsg(data).message);
					$log.error('Deletion of MountPath failed');
				});
		};

		function initTabs() {
			if (!$scope.isRPStore) {
				let tabs = [];
				const type = $scope.stateName.includes('disk') ? 'disk' : 'cloud';
				tabs.push({
					title: cvLoc('label.overview'),
					state: type + 'StoragePoolDetails',
					stateParams: $stateParams
				});

				tabs.push({
					title: cvLoc('label.configuration'),
					state: type + 'StoragePoolConfiguration',
					stateParams: $stateParams
				});

				tabs.push({
					title: cvLoc('label.associatedPlans'),
					state: type + 'StoragePoolAssociatedEntities',
					stateParams: $stateParams
				});

				tabService.init({ tabs: tabs, hasParent: true });
			}
		}
		initTabs();

		// DDB disk information Grid - TBD: API CONFIGURATION
		const initSCGridDDBDisk = function() {
			setupGridOptionsDDBDisk();
		};

		const setupGridOptionsDDBDisk = function() {
			let gridOptions = {};
			gridOptions.enableResizing = true;
			gridOptions.columns = initColumnDefsDDBDisk();
			// gridOptions.gridTitle = $scope.fromStoragePool ? cvLoc("label.storage") : cvLoc("label.mountPaths");
			gridOptions.gridTitle = cvLoc('label.ddbDiskInformation');
			gridOptions.tableName = 'ddbDiskInformation'; // $scope.isRPStore ? "rpStoreDetailTable":"diskLibraryDetailsTable";
			gridOptions.enableCheckBoxColumn = false;
			gridOptions.enableServerLoading = true;
			gridOptions.url = options => options.success([]);
			$scope.grid.gridOptionsDDBDisk = gridOptions;
		};

		const initColumnDefsDDBDisk = function() {
			// const storagePool = {
			//   name: $scope.storagePoolName,
			//   id: $scope.storagePoolId,
			//   type: $scope.storagePoolType
			// }
			return ddbDiskInformationColumnTemplates.getDDBDiskInformationColumnTemplate({ cvLoc });
			// return associatedEntitiesColumnTemplates.getAssociatedEntitiesColumnTemplate({cvLoc: cvLoc, isRPStore: $scope.isRPStore, stateName: $scope.stateName, storagePool});
		};

		const _onGridDataBoundDDBDisk = (dataItem, row) => {
			const permittedOptions = dataItem.permittedOptions;
			const id = permittedOptions.entityId;
			const template = `<cv-permitted-actions cv-permitted-options="permittedOptions${id}"></cv-permitted-actions>`;
			$scope[`permittedOptions${id}`] = permittedOptions;
			row.find('.permittedActions').append($compile(template)($scope));

			// const nameTemplate = `<cv-fancy-tooltip cv-objects="contactsMap${id}" class="fancy-tooltip-no-break"></cv-fancy-tooltip>`;
			// $scope[`contactsMap${id}`] = dataItem.contactsMap;
			// row.find('.fancy-tooltip').append($compile(nameTemplate)($scope));

			const roleDetailLink = row.find('.k-grid-roleDetail');

			roleDetailLink.click(function() {
				self.showAddRoleDialog(dataItem);
			});
		};
		initSCGridDDBDisk();
	}
];

storageMod.controller(storageControllers);

export default storageMod;
