import 'adminConsole/js/directives/cv-detect-tape-library.js';
import 'browse/js/controllers/browse.ctrl.js';
import 'modules/storage/js/filters/storage.filters.js';
import 'machineBrowse/js/controllers/machineBrowse.ctrl.js';
import 'machineBrowse/js/services/machineBrowse.svc.js';
import 'webScale/js/controllers/storagePool.ctrl.js';
import 'adminConsole/js/controllers/cloudLibConstants.js';
import 'dlo/js/controllers/profile.ctrl.js';
import 'adminConsole/js/factories/rpstore.factory.js';
import 'adminConsole/js/controllers/rpstore.ctrl.js';
import 'modules/schedule/js/factory/schedule.factory.js';
import 'storage/js/services/storage.svc.js';

import { acAppStorageModule } from 'common/js/modules';

var storageMod = acAppStorageModule;

const storageControllers = {};

storageControllers.diskLibraryConfigurationController = [
	'$q',
	'sharedData',
	'$scope',
	'storageService',
	'cvToaster',
	'cvBreadcrumbsTabsFactory',
	'$stateParams',
	'cvLoc',
	'$log',
	'$state',
	'securityFactory',
	'tabService',
	function(
		$q,
		sharedData,
		$scope,
		storageService,
		cvToaster,
		cvBreadcrumbsTabsFactory,
		$stateParams,
		cvLoc,
		$log,
		$state,
		securityFactory,
		tabService
	) {
		$scope.storagePoolId = $stateParams['storagePoolId'];
		$scope.storagePoolName = $stateParams['storagePoolName'];
		$scope.storagePoolType = $stateParams['storagePoolType'];

		$scope.libraryId = $stateParams['libraryId'];
		$scope.libraryName = $stateParams['libraryName'];
		$scope.model = $stateParams['model'];
		$scope.libraryType = $stateParams['libraryType'];
		$scope.isRPStore = $scope.libraryType && $scope.libraryType == 10;

		$scope.stateName = $state.current.name;
		sharedData.stateName = $scope.stateName;
		$scope.showAddOption = $scope.storagePoolType != 'SCALE_OUT';
		$scope.isNotHPECatalystStorage = true;

		$scope.entityType = 'STORAGE_POLICY_ENTITY';
		$scope.genericEntity = {
			storagePolicyId: parseInt($scope.storagePoolId)
		};

		function initTabs() {
			let tabs = [];
			const type = $scope.stateName.includes('disk') ? 'disk' : 'cloud';
			tabs.push({
				title: cvLoc('label.overview'),
				state: type + 'StoragePoolDetails',
				stateParams: $stateParams
			});

			tabs.push({
				title: cvLoc('label.configuration'),
				state: type + 'StoragePoolConfiguration',
				stateParams: $stateParams
			});

			tabs.push({
				title: cvLoc('label.associatedPlans'),
				state: type + 'StoragePoolAssociatedEntities',
				stateParams: $stateParams
			});

			tabService.init({ tabs: tabs, hasParent: true });
		}
		let breadCrumbs = [];

		if ($scope.stateName.includes('disk')) {
			breadCrumbs.push({
				title: cvLoc('label.disk'),
				link: '#storage/disk'
			});
		} else {
			breadCrumbs.push({
				title: cvLoc('label.cloud'),
				link: '#storage/cloud'
			});
		}

		cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);

		initTabs();
		$scope.formattedSecurityAssociations = securityFactory.createSecurityAssociationsObject();
		$scope.associationsLoaded = false;

		if ($scope.storagePoolId) {
			securityFactory.getSecurityAssociation($scope.entityType, parseInt($scope.storagePoolId)).success(function(data) {
				$scope.formattedSecurityAssociations = securityFactory.formatSecurityAssociationsObject(
					data.securityAssociations
				);
				$scope.associationsLoaded = true;
			});
		}

		$q.all([
			storageService.getStoragePoolDetails($scope.storagePoolId),
			storageService.getAllKeyManagementServers(null)
		]).then(([storagePoolDetails, keyManagementServers]) => {
			handleStoragePoolDetails(storagePoolDetails.data);
			$scope.keyProviders = (keyManagementServers.data && keyManagementServers.data.keyProviders) || [];
		});

		function handleStoragePoolDetails(poolDetails) {
			const copyInfo = poolDetails.copyInfo;
			const dataEncryp = copyInfo.dataEncryption;
			$scope.storagePoolDetails = poolDetails;
			$scope.isNotHPECatalystStorage = poolDetails.libraryList[0].libraryVendorId !== 59;
			$scope.storagePoolName = copyInfo.StoragePolicyCopy.storagePolicyName;
			$scope.changeNameObj = {
				id: $scope.storagePoolId,
				name: $scope.storagePoolName
			};
			$scope.encryption = {
				encrypt: copyInfo.copyFlags.auxCopyReencryptData === 'SET_TRUE',
				cipher: {
					keyName: dataEncryp.encryptionType,
					keyLength: dataEncryp.encryptionKeyLength
				},
				storeOnMedia: copyInfo.copyFlags.storeKeyOnMedia === 'SET_TRUE',
				managementServer: dataEncryp.keyProvider.keyProviderName,
				extendedFlags: {
					encryptOnDependentPrimary: copyInfo.extendedFlags.encryptOnDependentPrimary === 'SET_TRUE'
				}
			};
			$scope.model = poolDetails.libraryList[0].model;
			$scope.storagePoolDetailsPageLoaded = true;
		}

		$scope.updateStorage = (id, name) => {
			$scope.serverMessage = null;
			const copyInfo = $scope.storagePoolDetails.copyInfo;

			storageService
				.updateStoragePool(copyInfo.StoragePolicyCopy, name)
				.success(function(data) {
					if (data.errorCode === 0) {
						$log.debug(cvLoc('log.succesUpdatePolicy'));
						$state.go($state.current.name, { ...$stateParams, storagePoolName: name });
					} else {
						$log.error(cvLoc('log.errorUpdatePolicy'));
						cvToaster.showErrorMessage({
							ttl: '10000',
							message: data.error.errorMessage ? data.error.errorMessage : cvLoc('popup.errorFetchingMedia')
						});
					}
				})
				.error(function(e) {
					$log.error(cvLoc('log.errorUpdatePolicy'));
					cvToaster.showErrorMessage({
						ttl: '10000',
						message: e
					});
				});
		};
	}
];

storageMod.controller(storageControllers);

export default storageMod;
