export const getColumns = function(angularLibs) {
	const columnList = [
		getNameColumn(angularLibs.cvLoc),
		getStatusColumn(angularLibs.cvLoc),
		//getTypeColumn(angularLibs.cvLoc),
		getNodesCountColumn(angularLibs.cvLoc),
		getCapacityColumn(angularLibs.cvLoc),
		getFreeSpaceColumn(angularLibs.cvLoc),
		getActionColumn(angularLibs.cvLoc)
	];
	const columns = {};
	columnList.forEach(column => {
		const field = Object.keys(column)[0];
		columns[field] = column[field];
	});
	return columns;
};

export const getNameColumn = function(cvLoc) {
	return {
		'storagePoolEntity.storagePoolName': {
			title: cvLoc('Name'),
			type: 'string',
			enableHiding: false,
			cellClass: 'crop',
			template: `#if(storagePoolNameLink) {#
					<a title="#:storagePoolEntity.storagePoolName#" href="#=storagePoolNameLink#">
						#:storagePoolEntity.storagePoolName#
					</a>
				#}else{#
					#:storagePoolEntity.storagePoolName#
				#}#`,
			disableViewFiltering: false
		}
	};
};

export const getStatusColumn = function(cvLoc) {
	return {
		status: {
			title: cvLoc('label.status'),
			type: 'string',
			template: `<div class="ellipsis-parent"><span class="ellipsis-content" uib-tooltip="#=status#" tooltip-append-to-body="true" tooltip-placement="left" >#=status#</span></div>`,
			disableViewFiltering: false
		}
	};
};
export const getTypeColumn = function(cvLoc) {
	return {
		storagePoolType: {
			title: cvLoc('label.Type'),
			type: 'string',
			template: `<span class="crop" title="#=formattedStoragePoolType#">#=formattedStoragePoolType#</span>`,
			disableViewFiltering: false
		}
	};
};
export const getNodesCountColumn = function(cvLoc) {
	return {
		numberOfNodes: {
			title: cvLoc('label.numberOfNodes'),
			type: 'number',
			disableViewFiltering: false
		}
	};
};
export const getCapacityColumn = function(cvLoc) {
	return {
		totalCapacity: {
			title: cvLoc('label.capacity'),
			type: 'number',
			sortField: 'totalCapacity',
			template: `<span class="crop" title="#=formattedTotalCapacity#">#=formattedTotalCapacity#</span>`,
			disableViewFiltering: false
		}
	};
};
export const getFreeSpaceColumn = function(cvLoc) {
	return {
		totalFreeSpace: {
			title: cvLoc('label.freeSpace'),
			type: 'number',
			sortField: 'totalFreeSpace',
			template: `<span class="crop" title="#=formattedTotalFreeSpace#">#=formattedTotalFreeSpace#</span>`,
			disableViewFiltering: false
		}
	};
};
export const getActionColumn = function(cvLoc) {
	return {
		action: {
			title: cvLoc('Actions'),
			//type: 'string',
			sortable: false,
			disableColumnFilter: true,
			width: '7%',
			template: `<div class="permittedActions"></div>`,
			attributes: {
				class: 'permitted-actions'
			},
			disableViewFiltering: false
		}
	};
};
