export const getColumns = function(angularLibs) {
	const columnList = [
		getNodeNameColumn(angularLibs.cvLoc),
		getApplianceNameColumn(angularLibs.cvLoc),
		getNodeStatusColumn(angularLibs.cvLoc)
	];
	const columns = {};
	columnList.forEach(column => {
		const field = Object.keys(column)[0];
		columns[field] = column[field];
	});
	return columns;
};

export const getNodeNameColumn = function(cvLoc) {
	return {
		'node.mediaAgentName': {
			title: cvLoc('label.node'),
			type: 'string',
			template: `<a href="\\#storagePoolScaleOutStorageDiskDetails?storagePoolName=#=storagePool.storagePoolName#&storagePoolId=#=storagePool.storagePoolId#&storagePoolType=SCALE_OUT&mediaAgentId=#=node.mediaAgentId#&mediaAgentName=#=node.mediaAgentName#&nav=appliances">#=node.mediaAgentName#</a>`,
			disableViewFiltering: false,
			width: '40%'
		}
	};
};
export const getApplianceNameColumn = function(cvLoc) {
	return {
		'storagePool.storagePoolName': {
			title: cvLoc('label.appliance'),
			type: 'string',
			template: `<a href="\\#storagePoolInfo?storagePoolName=#=storagePool.storagePoolName#&storagePoolId=#=storagePool.storagePoolId#&storagePoolType=SCALE_OUT&nav=appliances">#=storagePool.storagePoolName#</a>`,
			disableViewFiltering: false,
			width: '40%'
		}
	};
};
export const getNodeStatusColumn = function(cvLoc) {
	return {
		status: {
			title: cvLoc('label.status'),
			type: 'string',
			cellTooltip: true,
			template: `<div class="nodeStatusIconSelector" cv-toggle-html-content="#:statusTooltip#" cv-toggle="tooltip" titlle="#:statusTooltip#"><img src="#:statusIcon#"class="status-icon" /><span>#:status#</span></div>`,
			disableViewFiltering: false,
			width: '20%'
		}
	};
};
