import 'adminConsole/js/directives/cv-detect-tape-library.js';
import 'browse/js/controllers/browse.ctrl.js';
import 'machineBrowse/js/controllers/machineBrowse.ctrl.js';
import 'machineBrowse/js/services/machineBrowse.svc.js';
import 'storage/js/services/storage.svc.js';
import 'webScale/js/controllers/storagePool.ctrl.js';
import 'adminConsole/js/controllers/cloudLibConstants.js';
import 'dlo/js/controllers/profile.ctrl.js';
import 'adminConsole/js/factories/rpstore.factory.js';
import 'adminConsole/js/controllers/rpstore.ctrl.js';
import 'modules/policies/storagePolicy/js/services/storagePolicy.svc';
import 'credentialManager/js/constants/credentialManager.constant.js';
import { acAppStorageModule } from 'common/js/modules';

var storageMod = acAppStorageModule;

const storageControllers = {};

storageControllers.addStorageController = [
	'sharedData',
	'$scope',
	'$uibModal',
	'$log',
	'storageService',
	'$location',
	'cvUtil',
	'cvTableOptions',
	'cvLoc',
	'$filter',
	'StorageConstants',
	'mbService',
	'$dialogs',
	'$state',
	'CLOUD_TYPE_LIST',
	'CLOUD_TYPE_LABELS',
	'CREDENTIAL_TYPE',
	'storageFactory',
	'pushInstallSoftwareFactory',
	'StorageClassConstants',
	'AuthenticationTypeConstant',
	'$timeout',
	'MetallicStorageClass',
	'MetallicReplication',
	'MetallicLicense',
	'$stateParams',
	'cvBreadcrumbsTabsFactory',
	'cvToaster',
	function(
		sharedData,
		$scope,
		$modal,
		$log,
		storageService,
		$location,
		cvUtil,
		cvTableOptions,
		cvLoc,
		$filter,
		StorageConstants,
		mbService,
		$dialogs,
		$state,
		CLOUD_TYPE_LIST,
		CLOUD_TYPE_LABELS,
		CREDENTIAL_TYPE,
		storageFactory,
		pushInstallSoftwareFactory,
		StorageClassConstants,
		AuthenticationTypeConstant,
		$timeout,
		MetallicStorageClass,
		MetallicReplication,
		MetallicLicense,
		$stateParams,
		cvBreadcrumbsTabsFactory,
		cvToaster
	) {
		$scope.isTenantAdmin = cv.isTenantAdmin;
		$scope.isTenantOperator = cv.isTenantOperator;
		$scope.isShowStorageSelection = cv.isShowStorageSelection;
		$scope.agentList = [];
		const azureAppRoleAccount = 4;

		$scope.saveButtonClick = () => {
			$scope.isSaveButtonClicked = true;
		};
		$scope.showSwitchToCM = true;
		$scope.showCredentialDropDown = true;
		$scope.mediaAgentError = false;
		$scope.isDiskStorageForMultipleDDBs = $state.current.name === 'storagePoolDisk';
		$scope.typeOfStorage = {
			type: 'localStorage'
		};
		$scope.isStateAddCloudOther = false;
		$scope.selectedMediaAgent = null;
		$scope.cloud = {
			cloudType: null
		};

		/**
		 * @method matchCloudTypeList
		 * method responsible of iterate in cloud type list
		 * and set the selected field in true if a match occurs
		 * so the cloud type list will show it as a selected
		 * @param {number} idToMatch
		 */
		const matchCloudTypeList = idToMatch => {
			$scope.cloudTypeList.forEach(vendor => {
				vendor.selected = vendor.id === idToMatch ? true : false;
			});
		};

		if ($state.current.name === 'addCloudOther') {
			$scope.action = 'addCloudLib';
			$scope.libraryInfo = {
				libraryEntity: {
					libraryName: ''
				},
				mountPath: {
					id: '',
					name: ''
				},
				loginName: '',
				serverType: {
					id: 0,
					name: ''
				},
				serverHost: '',
				selectedCredential: null
			};
			$scope.fromStoragePool = true;
			$scope.isStateAddCloudOther = true;
			$scope.showDDBInput = true;
			$scope.inputRequired = {
				name: false,
				DDB: false
			};
			$scope.numDDBLimit = 4;

			cvBreadcrumbsTabsFactory.addBreadCrumbs([
				{
					title: cvLoc('label.nav.storage'),
					link: '#nav/mstoragePool'
				},
				{
					title: cvLoc('label.cloud'),
					link: '#storage/cloud'
				},
				{
					title: cvLoc('label.nav.cloudType'),
					link: '#storage/cloud/addCloud'
				}
			]);
		}

		$scope.setStorageClass = function() {
			const serverType = $scope.libraryInfo.serverType.id;
			$scope.storageClassList = StorageClassConstants[serverType];
			$scope.libraryInfo.storageClass = null;

			$scope.storageClassList =
				$scope.storageClassList &&
				$scope.storageClassList.map(storageClass => {
					if (
						storageClass.id === 0 &&
						($scope.action !== 'editMP' ||
							($scope.action === 'editMP' && !$scope.libraryInfo.controller.storageClassId))
					) {
						$scope.libraryInfo.storageClass = storageClass;
					} else if (
						$scope.libraryInfo.controller &&
						$scope.libraryInfo.controller.storageClassId === storageClass.id
					) {
						$scope.libraryInfo.storageClass = storageClass;
					}

					return storageClass;
				});

			$scope.showStorageClass = !!$scope.storageClassList;
		};
		$scope.configureAuthCloud = $scope.configureAuthCloud || {
			accountName: null,
			arnRole: null,
			storageAuthenticationType: {
				id: 0,
				displayName: ''
			}
		};
		$scope.MICROSOFT_AZURE_CLOUD = 3;
		$scope.IAMVMID = 2;
		$scope.ACCESSANDSECRET = 0;
		$scope.IAMADCMID = 3;
		$scope.AMAZON_S3 = 2;
		$scope.selectedAuthTypeIndex = 0;
		$scope.setStorageAuthenticationType = function() {
			const serverType = $scope.libraryInfo.serverType.id;
			$scope.storageAuthenticationTypeList = AuthenticationTypeConstant[serverType];
			$scope.configureAuthCloud.showIAMVMLabels = false;
			$scope.configureAuthCloud.showIAMADCMLabels = false;

			if ($scope.storageAuthenticationTypeList) {
				$scope.configureAuthCloud.storageAuthenticationType =
					$scope.storageAuthenticationTypeList[$scope.selectedAuthTypeIndex];
				$scope.showAuthenticationType = true;
			} else {
				$scope.showAuthenticationType = false;
				$scope.configureAuthCloud.storageAuthenticationType = {
					id: 0,
					displayName: '',
					showCredential: storageService.getCloudCredentialsSupport($scope.libraryInfo.libraryVendorId)
				};
			}
		};

		const setUserName = (loginName, serverTypeId) => {
			if (!loginName) {
				return;
			}
			let userName = '';
			switch (serverTypeId) {
				case 2:
					userName = loginName.split('|-|');
					if (userName.length === 2 && userName[1].includes('IAM')) {
						$scope.selectedAuthTypeIndex = 3;
						$scope.configureAuthCloud.arnRole = userName[0];
					} else if (userName.length === 2) {
						$scope.selectedAuthTypeIndex = 2;
						$scope.configureAuthCloud.arnRole = userName[0];
					} else if (
						!$scope.libraryInfo.selectedCredential ||
						$scope.libraryInfo.selectedCredential.credentialId == 0
					) {
						if (userName[0].includes('IAM')) {
							$scope.selectedAuthTypeIndex = 1;
						}
					}
					break;
				case $scope.MICROSOFT_AZURE_CLOUD:
					userName = loginName.split('|-|');
					if (userName.length == 2) {
						if (userName[1] == 'IAM') {
							$scope.selectedAuthTypeIndex = 1;
							$scope.configureAuthCloud.accountName = userName[0];
						} else if ($scope.libraryInfo.selectedCredential.credentialId > 0) {
							$scope.selectedAuthTypeIndex = 2;
							$scope.configureAuthCloud.accountName = userName[0];
						}
					}
					break;
			}
		};

		$scope.refreshCredentials = function() {
			$scope.savedCredentials = [];
			let acctType = $scope.configureAuthCloud.showIAMADCMLabels ? 4 : $scope.libraryInfo.serverType.id + 100;
			storageService.getCredentials(acctType).then(function(credentialsList) {
				$scope.savedCredentials = credentialsList.list;
				if ($scope.action === 'editMP') {
					let i = 0;
					for (i = 0; i < $scope.savedCredentials.length; i++) {
						if ($scope.libraryInfo.selectedCredential.credentialId === $scope.savedCredentials[i].credentialId) {
							$scope.savedCredentials[i].selected = true;
							break;
						}
					}
				}
			});
		};

		$scope.authenticationChanged = function(editMode) {
			if ($scope.libraryInfo.serverType.id === $scope.MICROSOFT_AZURE_CLOUD) {
				$scope.configureAuthCloud.showIAMVMLabels =
					$scope.configureAuthCloud.storageAuthenticationType.id == $scope.IAMVMID;
				$scope.configureAuthCloud.showIAMADCMLabels =
					$scope.configureAuthCloud.storageAuthenticationType.id == $scope.IAMADCMID;

				if (!$scope.configureAuthCloud.showIAMADCMLabels && !$scope.configureAuthCloud.showIAMVMLabels) {
					$scope.configureAuthCloud.accountName = '';
				}

				$scope.showCredentialDropDown = $scope.configureAuthCloud.showIAMVMLabels ? false : true;
			} else {
				$scope.showCredentialDropDown = $scope.configureAuthCloud.storageAuthenticationType.showCredential;
				if (!editMode) {
					$scope.configureAuthCloud.arnRole = null;
				}
			}
			$scope.showSwitchToCM = $scope.showCredentialDropDown;

			if ($scope.showCredentialDropDown) {
				if (
					$scope.libraryInfo.serverType.id === $scope.MICROSOFT_AZURE_CLOUD ||
					$scope.libraryInfo.serverType.id === $scope.AMAZON_S3 ||
					editMode
				) {
					$scope.refreshCredentials();
				}
			} else {
				// if credentials are not supported, reset values
				if ($scope.libraryInfo.selectedCredential && $scope.libraryInfo.serverType.id !== $scope.METALLIC_STORAGE) {
					$scope.libraryInfo.selectedCredential = null;
				}
			}
			$scope.credentialNotSelectedError = false;
		};

		var DEFAULT_PASSWORD = '9876543210';

		// edit a grid item from multiple ddb grid - feature: support mutiple ddb location when create a cloud
		if ($scope.mode && $scope.mode.editMode) {
			$scope.showCredentialDropDown = $scope.libraryInfo.selectedCredential !== null;
			$scope.switchToCM = $scope.showCredentialDropDown ? 'enabled-activity' : 'disabled-activity';
			onInitAlreadyExistingAuthenticationType($scope.libraryInfo.loginName);
		}
		// isModalFromMultipleDDBGrid => this is a hack when you come for the first time, this scope model is not defined
		// so with double !! you can set as false or true.
		// At the same time when this controller is trigger from storageFactory.configMultipleDDBsGrid,
		// this model is set as TRUE in order to keep this opcion with the rigth value
		$scope.isModalFromMultipleDDBGrid = !!$scope.isModalFromMultipleDDBGrid;
		$scope.isCloudStorageForMultipleDDBs = $state.current.name === 'storagePoolCloud';

		//If the state is coreSetup or configuration of Storage pool for Tenant Admins/Tenantoperators  we set the action name as newCloudLib
		if ($state.current.name == 'coreSetup' || $state.current.name == 'coreSetupTenantOS') {
			$scope.isSetup = true;
			//check config property based on that set this action
			$scope.action = 'addCloudLib';
			$scope.libraryInfo = {};
		}
		if ($state.current.name == 'replicationGroup.recoveryOptions') {
			$scope.isCloudStorageForMultipleDDBs = true;
			$scope.repGrpPage = true;
			$scope.repGrp = !$scope.isModalFromMultipleDDBGrid;
			$scope.action = 'addCloudLib';
			$scope.libraryInfo = $scope.libraryInfo || {};
			if (!_.get($scope, 'libraryInfo.libraryEntity.libraryName')) {
				$scope.libraryInfo.libraryEntity = { libraryName: 'Cloud Storage' };
			}
		}
		$scope.configureCloudLibrary = {
			TenancyOCID: '',
			UserOCID: '',
			KeysFingerprint: '',
			CompartmentName: '',
			PemKeyFilename: ''
		};
		$scope.ORACLE_CLOUD_INFRASTRUCTURE_OBJECT_STORAGE = 26;
		$scope.ORACLE_CLOUD_INFRASTRUCTURE_ARCHIVE_STORAGE = 28;
		$scope.ORACLE_STORAGE_CLOUD_SERVICE = 21; // Oracle Cloud Infrastructure Object Storage Classic
		$scope.ORACLE_STORAGE_CLOUD_ARCHIVE_SERVICE = 22; // Oracle Cloud Infrastructure Archive Storage Classic
		$scope.HPE_CATALYST_STORAGE = 59; // HPE Catalyst Storage
		$scope.METALLIC_STORAGE = 400;

		$scope.localPathPattern = /^([a-zA-Z]:){1}(\\[^<>:"/\\|?*]+)*\\?$/;
		$scope.linuxPathPattern = /^(\/[^<>:"/\\|?*]+)+\/?$/;
		$scope.networkPathPattern = /^\\(\\[^<>:"/\\|?*]+)+\\?$/;
		$scope.pathPattern = {
			pattern: $scope.localPathPattern
		};
		$scope.cvLoc = cvLoc;

		// initialize iif not initialized
		if ($scope.savedCredentials === undefined) {
			$scope.savedCredentials = [];
		}

		$scope.openCreateCredentialModal = () => {
			const accountType = getAccountType();

			storageFactory.openCreateCredentialModal(accountType).then(credentialsList => {
				if (credentialsList) {
					$scope.savedCredentials = credentialsList.list || $scope.savedCredentials;
					$scope.libraryInfo.selectedCredential = $scope.savedCredentials.find(function(credential) {
						return credential.credentialName === credentialsList.name;
					});
				}
			});
		};

		$scope.openCreateMediaAgentModal = function() {
			$scope.libraryInfo.controller = $scope.libraryInfo.controller || {};
			var pushInstallParams = {
				useAgent: 'MA',
				dialogTitle: cvLoc('placeholder.createMediaAgent'),
				dialogTitleHelpText: cvLoc('label.createMediaAgentHelpText'),
				disableInteractiveInstall: true,
				hideJobDetails: $scope.isSetup
			};
			var modalInstance = pushInstallSoftwareFactory.openPushInstallDialog(pushInstallParams);
			modalInstance.result.then(
				function() {
					// on success
					$scope.generalSetupMessage = cvUtil.infoMsgLoc('info.installingMA');
					$scope.libraryInfo.controller.mediaAgent = '';
				},
				function() {
					// on error
					$scope.libraryInfo.controller.mediaAgent = '';
				}
			);
		};

		const getAccountType = () => {
			if (
				$scope.action == 'addCloudMP' ||
				$scope.action == 'newCloudLib' ||
				$scope.action == 'addCloudLib' ||
				(sharedData.data && sharedData.data.isEditingCloud)
			) {
				if ($scope.libraryInfo && $scope.libraryInfo.serverType) {
					if (
						$scope.libraryInfo.serverType.id === $scope.ORACLE_CLOUD_INFRASTRUCTURE_OBJECT_STORAGE ||
						$scope.libraryInfo.serverType.id === $scope.ORACLE_CLOUD_INFRASTRUCTURE_ARCHIVE_STORAGE ||
						$scope.libraryInfo.serverType.id === $scope.HPE_CATALYST_STORAGE
					) {
						return 0;
					} else if (
						$scope.libraryInfo.serverType.id === $scope.MICROSOFT_AZURE_CLOUD &&
						$scope.configureAuthCloud.storageAuthenticationType.id === $scope.IAMADCMID
					) {
						return azureAppRoleAccount;
					} else {
						return $scope.libraryInfo.serverType.id + 100;
					}
				}
			}
			return CREDENTIAL_TYPE.WINDOWSACCOUNT;
		};

		const isDisableForWrite = () => {
			return $scope.libraryInfo.controller.numWriters == 0 ? true : false;
		};

		$scope.showDDBLocation = true;
		$scope.storagePoolType = 'DEDUPLICATION';
		if ($scope.isModalFromMultipleDDBGrid) {
			$scope.showDDBLocation = $scope.shouldShowDDBLocationInputField;
		}

		$scope.onToggleUseDDB = function() {
			$scope.showDDBLocation = !$scope.showDDBLocation;
			$scope.libraryInfo.ddbPartitionPath = null;
			$scope.storagePoolType = $scope.showDDBLocation ? 'DEDUPLICATION' : 'NON-DEDUPLICATION';
		};

		$scope.onToggleUseDDBOtherCloud = function() {
			$scope.showDDBInput = !$scope.showDDBInput;
			$scope.libraryInfo.ddbPartitionPath = null;
			$scope.storagePoolType = $scope.showDDBInput ? 'DEDUPLICATION' : 'NON-DEDUPLICATION';
		};

		if ($scope.action === 'addCloudMP') {
			$scope.showCredentialDropDown = storageService.getCloudCredentialsSupport($scope.libraryInfo.libraryVendorId);
			$scope.showDDBLocation = $scope.HPE_CATALYST_STORAGE !== $scope.libraryInfo.libraryVendorId;

			if ($scope.libraryInfo.libraryVendorId === $scope.METALLIC_STORAGE) {
				$scope.licenseTypeList = [];
				$scope.regionList = [];
				$scope.storageClassList = [];
				$scope.replicationList = [];
				$scope.metallicStorageInfo = {
					region: [],
					storageClass: [],
					replication: [],
					licenseType: []
				};
				$scope.licenseTypeToData = {};
				$scope.showStorageClass = false;
				$scope.showReplication = false;
				$scope.inputRequired = {
					name: false,
					license: false,
					region: false,
					storageClass: false,
					replication: false,
					DDB: false
				};

				$scope.showMetallicInputs = {
					storageClass: false,
					replication: false
				};

				$scope.setMetallicLicenseType = function(data) {
					storageFactory.setMetallicLicenseType(data, {
						metallicStorageInfo: $scope.metallicStorageInfo,
						licenseTypeToData: $scope.licenseTypeToData,
						regionList: $scope.regionList,
						storageClassList: $scope.storageClassList,
						replicationList: $scope.replicationList,
						inputRequired: $scope.inputRequired
					});
				};

				$scope.setMetallicRegion = function(data) {
					storageFactory.setMetallicRegion(data, {
						metallicStorageInfo: $scope.metallicStorageInfo,
						inputRequired: $scope.inputRequired
					});
				};

				$scope.setMetallicStorageClass = function(data) {
					$scope.setMetallicStorageClass(data, {
						metallicStorageInfo: $scope.metallicStorageInfo,
						inputRequired: $scope.inputRequired
					});
				};

				$scope.setMetallicReplication = function(data) {
					$scope.setMetallicReplication(data, {
						metallicStorageInfo: $scope.metallicStorageInfo,
						inputRequired: $scope.inputRequired
					});
				};

				storageService
					.getMetallicStorageInfo($scope.libraryInfo.libraryEntity.libraryId)
					.success(function(data) {
						if (data.errorCode === 0) {
							storageFactory.processGetMetallicStorageInfo(data, {
								licenseTypeList: $scope.licenseTypeList,
								regionList: $scope.regionList,
								storageClassList: $scope.storageClassList,
								replicationList: $scope.replicationList,
								licenseTypeToData: $scope.licenseTypeToData,
								metallicStorageInfo: $scope.metallicStorageInfo,
								showMetallicInputs: $scope.showMetallicInputs,
								inputRequired: $scope.inputRequired
							});
							if ($scope.regionList.length > 0) {
								$log.error('Finished loading');
							}
						} else {
							cvToaster.showErrorMessage({
								ttl: '10000',
								message: data.errorMessage
							});
						}
					})
					.error(function(data, status, headers, config) {
						$scope.serverMessage = cvUtil.errMsg(data);
						return false;
					});
			}
		}

		$scope.showDDBLocationHandler = () => {
			if ($scope.isModalFromMultipleDDBGrid) {
				return $scope.showDDBLocation || !$scope.showInputs;
			}

			return $scope.showDDBLocation;
		};

		var requiredAccountType = getAccountType();

		// flag to show error message for credential, when left selected
		// on submit
		$scope.credentialNotSelectedError = false;

		// adding it if the page is accessed from setup screen
		$scope.action = $scope.action ? $scope.action : 'newDiskLib';
		$scope.accessTypes = [
			{
				text: cvLoc('label.readWrite'),
				value: StorageConstants.READWRITE_DEVICEACCESS
			},
			{
				text: cvLoc('label.read'),
				value: StorageConstants.READ_DEVICEACCESS
			}
		];
		$scope.shareTypes = [
			{
				text: cvLoc('label.Regular'),
				value: 0
			},
			{
				text: cvLoc('label.dataServerIP'),
				value: StorageConstants.DATASERVER_IP_DEVICEACCESS
			},
			{
				text: cvLoc('label.dataServerFC'),
				value: StorageConstants.DATASERVER_FC_DEVICEACCESS
			},
			{
				text: cvLoc('label.dataServeriSCSI'),
				value: StorageConstants.DATASERVER_iSCSI_DEVICEACCESS
			}
		];

		$scope.setInitDefaultAccessType = function(entity) {
			// if entity type is equal to cloud - defaultIndex = 0;
			let defaultIndex =
				!($scope.$state.current.name === 'diskStoragePoolDetails') || sharedData.data.model === 'Cloud' ? 0 : 1; // 0: read/write v 1: read only

			return $scope.accessTypes[defaultIndex].value;
		};

		if ($scope.action == 'shareDisk' || $scope.action == 'shareDrive' || $scope.action == 'editMP') {
			$scope.libraryInfo = $scope.maEntity;
			$scope.showCredentialDropDown =
				$scope.libraryInfo.selectedCredential && $scope.libraryInfo.selectedCredential.credentialId !== 0;
		}

		if ($scope.action == 'editMP') {
			$scope.metallicStorageInfo = {
				licenseType: '',
				region: '',
				storageClass: '',
				replication: ''
			};

			$scope.metallicStorageInfo.licenseType =
				MetallicLicense[$scope.libraryInfo.metallicStorageInfo.licenseType].label;
			$scope.metallicStorageInfo.region = $scope.libraryInfo.metallicStorageInfo.region
				? $scope.libraryInfo.metallicStorageInfo.region.displayName
				: '(US) East US';
			$scope.metallicStorageInfo.storageClass =
				$scope.libraryInfo.metallicStorageInfo.storageClass !== 0
					? MetallicStorageClass[$scope.libraryInfo.metallicStorageInfo.storageClass].label
					: 'Hot';
			$scope.metallicStorageInfo.replication =
				$scope.libraryInfo.metallicStorageInfo.replication !== 0
					? MetallicReplication[$scope.libraryInfo.metallicStorageInfo.replication].label
					: 'Locally-redundant storage (LRS)';

			// here we are initializing the controller
			$scope.shouldOpenconfirmEditMPPopUp = false;
			//      $scope.libraryInfo.disableForWrite = isDisableForWrite();
			var oldMPName = $scope.libraryInfo.mountPath.name;
			$scope.agentList = [
				{
					mediaAgentId: $scope.libraryInfo.controller.mediaAgentId,
					mediaAgentName: $scope.libraryInfo.controller.mediaAgentName,
					displayName: $scope.libraryInfo.controller.displayName
				}
			];

			$scope.libraryInfo.controller.mediaAgentId = $scope.agentList[0].mediaAgentId;
			if ($scope.libraryInfo.mountPath.name.indexOf('\\\\') == 0) {
				$scope.typeOfStorage.type = 'networkStorage';
				$scope.pathPattern.pattern = $scope.networkPathPattern;
				$scope.libraryInfo.loginName = $scope.libraryInfo.controller.userName;
				$scope.libraryInfo.password = DEFAULT_PASSWORD;
			} else if ($scope.libraryInfo.mountPath.name.indexOf('/') == 0) {
				$scope.isUnixMA = true;
				$scope.pathPattern.pattern = $scope.linuxPathPattern;
			} else {
				$scope.pathPattern.pattern = $scope.localPathPattern;
			}
			if (sharedData.data.model == cvLoc('label.cloud')) {
				$scope.showCredentialDropDown = $scope.libraryInfo.serverType.id !== 400;
				$scope.cloudTypeList = CLOUD_TYPE_LIST.CloudType;
				$scope.cloudTypeLables = CLOUD_TYPE_LABELS.CloudLabel;
				if ($scope.libraryInfo.controller.userName.length > 1) {
					var serviceHost = $scope.libraryInfo.controller.userName;
					var accessKey = '';
					var sProxyUserInfo;
					var proxyServer = '';
					var proxyServerInfo;
					var sProxyInfo;
					var loginName;
					sProxyInfo = serviceHost.split('!!', -1);
					serviceHost = sProxyInfo[0].substring(0, sProxyInfo[0].lastIndexOf('//'));
					loginName = sProxyInfo[0].substring(sProxyInfo[0].lastIndexOf('//') + 2);
					//							for (var i = 0; i < $scope.cloudTypeList.length; i++) {
					//								if ($scope.cloudTypeLables[CLOUD_TYPE_LIST.CloudType[i].name].label_Host == serviceHost[0]) {
					if (sProxyInfo.length > 1) {
						sProxyUserInfo = sProxyInfo[sProxyInfo.length - 1].split('@', -1);
						proxyServer = sProxyUserInfo[0];
						proxyServerInfo = proxyServer.split(':', -1);
						if (proxyServerInfo.length > 1) {
							$scope.libraryInfo.proxyAddress = proxyServer.substring(
								0,
								proxyServer.length - proxyServerInfo[proxyServerInfo.length - 1].length - 1
							);
							const proxyValue = proxyServerInfo[proxyServerInfo.length - 1];
							const proxyNumber = parseInt(proxyValue, 10); // for proxy input type number
							$scope.libraryInfo.proxyPort = proxyNumber;
						} else {
							$scope.libraryInfo.proxyAddress = proxyServerInfo[0];
						}
						if (sProxyUserInfo.length > 1) {
							$scope.libraryInfo.proxyUsername = sProxyUserInfo[1].split(':', -1)[0];
							$scope.libraryInfo.proxyPassword = DEFAULT_PASSWORD;
						}
					}

					for (var i = 0; i < $scope.cloudTypeList.length; i++) {
						if ($scope.cloudTypeList[i].id === $scope.libraryInfo.libraryVendorId) {
							matchCloudTypeList($scope.libraryInfo.libraryVendorId);
							$scope.libraryInfo.serverType = $scope.cloudTypeList[i];
						}
					}
					//									$scope.libraryInfo.serverType = CLOUD_TYPE_LIST.CloudType[$scope.libraryInfo.libraryVendorId];
					$scope.libraryInfo.loginName = loginName;
					$scope.libraryInfo.password = DEFAULT_PASSWORD;
					$scope.libraryInfo.serviceHost = serviceHost; //$scope.cloudTypeLables[CLOUD_TYPE_LIST.CloudType[i].name].label_Host;
					$scope.setStorageClass();
					onInitAlreadyExistingAuthenticationType(loginName);
					if (
						$scope.libraryInfo.serverType.id === $scope.ORACLE_CLOUD_INFRASTRUCTURE_OBJECT_STORAGE ||
						$scope.libraryInfo.serverType.id === $scope.ORACLE_CLOUD_INFRASTRUCTURE_ARCHIVE_STORAGE
					) {
						sProxyInfo = loginName.split('|-|');
						if (sProxyInfo.length === 5) {
							$scope.configureCloudLibrary.CompartmentName = sProxyInfo[0];
							$scope.configureCloudLibrary.TenancyOCID = sProxyInfo[1];
							$scope.configureCloudLibrary.UserOCID = sProxyInfo[2];
							$scope.configureCloudLibrary.KeysFingerprint = sProxyInfo[3];
							$scope.configureCloudLibrary.PemKeyFilename = sProxyInfo[4];
						}
					}
				}
			}
			$scope.$watch('libraryInfo.mountPath.name', newName => {
				$scope.shouldOpenconfirmEditMPPopUp = newName !== oldMPName;
			});
		}

		//load media agents for new library
		if (
			$scope.action == 'newDiskLib' ||
			$scope.action == 'newTapeLib' ||
			$scope.action == 'addCloudLib' ||
			$scope.action == 'newCloudLib' ||
			$scope.action == 'addCloudMP'
		) {
			if ($scope.action == 'newCloudLib' || $scope.action == 'addCloudLib' || $scope.action == 'addCloudMP') {
				if ($scope.action == 'newCloudLib' || $scope.action == 'addCloudLib') {
					$scope.cloudTypeList = CLOUD_TYPE_LIST.CloudType.filter(
						cloudType => cloudType.id !== $scope.METALLIC_STORAGE
					);
				} else {
					$scope.cloudTypeList = CLOUD_TYPE_LIST.CloudType;
				}

				$scope.cloudTypeLables = CLOUD_TYPE_LABELS.CloudLabel;

				if ($scope.libraryInfo.libraryVendorId) {
					for (var i = 0; i < $scope.cloudTypeList.length; i++) {
						if ($scope.cloudTypeList[i].id === $scope.libraryInfo.libraryVendorId) {
							matchCloudTypeList($scope.libraryInfo.libraryVendorId);
							$scope.libraryInfo.serverType = $scope.cloudTypeList[i];
						}
					}
				}
				if (!$scope.libraryInfo.serverType || $scope.libraryInfo.serverType.name === '') {
					matchCloudTypeList($scope.cloudTypeList[1].id);
					$scope.libraryInfo.serverType = $scope.cloudTypeList[1];
				}
				if (!($scope.mode && $scope.mode.editMode) && $scope.libraryInfo.serverType.id !== $scope.METALLIC_STORAGE) {
					$scope.libraryInfo.serviceHost = $scope.cloudTypeLables[$scope.libraryInfo.serverType.id].label_Host;
					$scope.setStorageAuthenticationType();
				}

				$scope.setStorageClass();
			}
			if (
				$scope.isModalFromMultipleDDBGrid ||
				$scope.isSetup ||
				$scope.action == 'addCloudMP' ||
				$scope.isStateAddCloudOther
			) {
				storageService
					.getMediaAgentList('NONE')
					.success(function(data) {
						$scope.agentList = cvUtil.sortAscending(data, 'displayName');
						let selectedMediaAgent = null;
						if ($scope.agentList.length === 1) {
							$scope.agentList[0].selected = true;
							selectedMediaAgent = $scope.agentList[0];
						} else if ($scope.libraryInfo) {
							selectedMediaAgent = $scope.agentList.find(
								mediaAgent => mediaAgent.mediaAgentId === $scope.libraryInfo.controller.mediaAgentId
							);
						}
						$scope.setClientType(selectedMediaAgent);
						if (!$scope.libraryInfo) {
							$scope.libraryInfo = { serverType: {} };
						}
					})
					.error(function(data, status, headers, config) {
						$scope.serverMessage = cvUtil.errMsg(data);
						return false;
					});
			}
		}

		/**
		 * Feature: support create cloud with multiple ddb locations
		 *
		 * This method runs when we create a new storage cloud from storage/cloud path Here we try to handle
		 * create a new disk with multiple MediaAgents
		 */
		if ($scope.action === 'addCloudLib' && !$scope.isModalFromMultipleDDBGrid && !$scope.isStateAddCloudOther) {
			$scope.libraryInfo.libraryEntity = { libraryName: 'Cloud Storage' };
			$scope.storageGridForDiskCloudMultipleDDB = storageFactory.configMultipleDDBsGrid($scope); // here you get the kendo grid
		}

		if ($scope.action === 'addCloudLib' && $scope.isStateAddCloudOther) {
			$scope.addCloudDDBGridOptions = storageFactory.addCloudDDBGridOptions($scope);
		}

		if ($scope.distributedStorage && $scope.distributedStorage.distributedStorageId) {
			if (!_.get($scope, 'libraryInfo.mountPath.name', undefined)) {
				_.set($scope, 'libraryInfo.mountPath.name', '/ws/hedvig/');
			}
			$scope.isUnixMA = true;
		}

		// get the media agent detail for this library in order to add path to the same media agent
		if ($scope.action == 'addMP') {
			// For disk mount path we don't need to check reg key for credential manager support
			$scope.showCredentialDropDown = false;
			$scope.showDDBLocation = false;
			if ($scope.distributedStorage && $scope.distributedStorage.distributedStorageId) {
				storageService
					.getLinuxMediaAgents()
					.success(function(data) {
						$scope.agentList = cvUtil.sortAscending(data, 'displayName');
						if ($scope.agentList.length === 1) {
							$scope.agentList[0].selected = true;
							$scope.setClientType($scope.agentList[0]);
						}
					})
					.error(function(data, status, headers, config) {
						$scope.serverMessage = cvUtil.errMsgLoc(data);
						return false;
					});
			} else {
				storageService
					.getMediaAgentList('NONE')
					.success(function(data) {
						$scope.agentList = cvUtil.sortAscending(data, 'displayName');
						if ($scope.agentList.length === 1) {
							$scope.agentList[0].selected = true;
							$scope.setClientType($scope.agentList[0]);
						}
					})
					.error(function(data, status, headers, config) {
						$scope.serverMessage = cvUtil.errMsgLoc(data);
						return false;
					});
			}
		}
		// get the media agent detail for this library in order to share path to the same media agent
		if ($scope.action == 'shareDrive') {
			storageService
				.getMAListForLibrary($scope.libraryInfo.libraryEntity.libraryId)
				.success(function(data) {
					$scope.agentList = [];
					for (var i = 0; i < data.length; i++) {
						$scope.agentList.push({
							mediaAgentId: data[i].mediaAgent.mediaAgentId,
							mediaAgentName: data[i].mediaAgent.mediaAgentName,
							displayName: data[i].mediaAgent.displayName
						});
					}
				})
				.error(function(data, status, headers, config) {
					$scope.serverMessage = cvUtil.errMsg(data);
					return false;
				});

			// initialize if not initialized
			if ($scope.savedCredentials === undefined) {
				$scope.savedCredentials = [];
			}
		}

		// If credentials are required, load them
		requiredAccountType = getAccountType();
		if (requiredAccountType != 0 && $scope.action !== 'shareDisk' && shouldCallCredentialApi()) {
			storageService.getCredentials(requiredAccountType).then(function(credentialsList) {
				$scope.savedCredentials = credentialsList.list;
				if ($scope.action === 'editMP') {
					let i = 0;
					for (i = 0; i < $scope.savedCredentials.length; i++) {
						if ($scope.savedCredentials[i].credentialId === $scope.libraryInfo.selectedCredential.credentialId) {
							$scope.savedCredentials[i].selected = true;
							break;
						}
					}
				}
			});
		}

		$scope.addEditShareLibrary = () => {
			$scope.onSubmit = true;
			$scope.serverMessage = {
				message: '',
				type: ''
			};

			var libraryInfo = angular.extend({}, $scope.libraryInfo);

			if ($scope.action === 'addCloudMP' || $scope.action === 'editMP' || $scope.action === 'addMP') {
				if (
					(sharedData.data.model === 'Cloud' && $scope.libraryInfo.serverType.id !== $scope.METALLIC_STORAGE) ||
					(sharedData.data.model === 'Disk' && $scope.typeOfStorage.type === 'networkStorage')
				) {
					if ($scope.showCredentialDropDown) {
						libraryInfo.loginName = '';
						libraryInfo.password = '';
						libraryInfo.selectedCredential = {
							credentialName: libraryInfo.credentialToSave[0].credentialName,
							credentialId: libraryInfo.credentialToSave[0].credentialId
						};
					} else {
						libraryInfo.selectedCredential = {
							credentialName: '',
							credentialId: 0
						};
					}
				}
			}

			if (
				(sharedData.data.model === 'Disk' && $scope.typeOfStorage.type === 'networkStorage') ||
				sharedData.data.model === 'Cloud'
			) {
				if (!$scope.isCloudStorageForMultipleDDBs && $scope.showCredentialDropDown) {
					// make sure that a credential was selected
					$scope.onChangeCredential(libraryInfo.selectedCredential);
					if ($scope.credentialNotSelectedError) {
						return;
					}
				}
			}

			if ($scope.action == 'editMP') {
				var submitEditionMP = function() {
					var shareType = $filter('TransportType')(libraryInfo.controller.accessType);
					libraryInfo.controller.protocolType = shareType;

					//          if (isDisableForWrite() !== libraryInfo.disableForWrite) {
					//            libraryInfo.controller.numWriters = libraryInfo.disableForWrite ? 0 : -1;
					//          }

					if (libraryInfo.controller.accessTypeValue == StorageConstants.READWRITE_DEVICEACCESS) {
						libraryInfo.controller.accessType = StorageConstants.READWRITE_DEVICEACCESS;
					} else if (libraryInfo.controller.accessTypeValue == StorageConstants.READ_DEVICEACCESS) {
						libraryInfo.controller.accessType = StorageConstants.READ_DEVICEACCESS;
					}
					libraryInfo.controller.accessType |= shareType;
					if (libraryInfo.preferred) {
						libraryInfo.controller.accessType |= StorageConstants.PREFERRED_DEVICEACCESS;
					}

					if (libraryInfo.enabled) {
						libraryInfo.controller.enabled = 1;
					} else {
						libraryInfo.controller.enabled = 0;
					}

					if (libraryInfo.accessible) {
						libraryInfo.controller.accessible = 1;
					} else {
						libraryInfo.controller.accessible = 0;
					}

					if (!$scope.libraryInfo.proxyPort) {
						libraryInfo.proxyPort = 0;
					}

					libraryInfo.loginName = $scope.getLoginName(libraryInfo);
					libraryInfo.password = $scope.getPassword(libraryInfo);
					if (
						$scope.libraryInfo.serverType.id === $scope.ORACLE_CLOUD_INFRASTRUCTURE_OBJECT_STORAGE ||
						$scope.libraryInfo.serverType.id === $scope.ORACLE_CLOUD_INFRASTRUCTURE_ARCHIVE_STORAGE
					) {
						if (libraryInfo.password === DEFAULT_PASSWORD) {
							libraryInfo.password = '';
						}
					}
					libraryInfo.authType = $scope.configureAuthCloud.storageAuthenticationType.id;
					libraryInfo.serverHost = libraryInfo.storageClass
						? `${libraryInfo.serviceHost}@${libraryInfo.storageClass.id}`
						: libraryInfo.serviceHost;
					storageService
						.editDiskOrCloudMountPath(libraryInfo, $scope.typeOfStorage.type, $scope.action)
						.success(() => isReadyForAPICall('editMountPath', 'Edit mount path'))
						.error(function(e) {
							if (!$scope.isAPICall) {
								$log.error('Editing mountPath failed');
								$scope.serverMessage = cvUtil.errMsg(e);
							}
						});
				};

				var callBackFunctions = {
					noFunction: () => {},
					yesFunction: () => {
						submitEditionMP();
					}
				};

				if ($scope.shouldOpenconfirmEditMPPopUp && !$scope.isAPICall) {
					$dialogs.confirm(cvLoc('title.confirmStoragePolicy'), cvLoc('label.mountPathEditText'), callBackFunctions);
				} else {
					submitEditionMP();
				}
			} else if ($scope.action == 'addCloudLib') {
				//add a new cloud lib
				if ($scope.repGrp) {
					// The $scope.libararyInfo is not shared between the grid and the modal.
					// Hence, saving the value in the factory when values are being added to the grid and reading it back during save
					storageFactory.libraryInfo.libraryEntity = libraryInfo.libraryEntity;
					libraryInfo = storageFactory.libraryInfo;
				}

				if ($scope.isSetup && !libraryInfo.selectedCredential) {
					libraryInfo.selectedCredential = libraryInfo.credentialToSave;
				}

				const storagePoolInfo = {
					createNew: true,
					library: {},
					mediaAgent: libraryInfo.controller,
					mountPath: libraryInfo.mountPath.name,
					credential:
						libraryInfo.selectedCredential && libraryInfo.selectedCredential.length > 0
							? {
									credentialId: libraryInfo.selectedCredential[0].credentialId,
									credentialName: libraryInfo.selectedCredential[0].credentialName
							  }
							: { credentialId: 0, credentialName: '' },
					name: libraryInfo.libraryEntity.libraryName,
					...(libraryInfo.ddbPartitionPath
						? {
								partitionInfo: [
									{
										mediaAgentName: libraryInfo.controller.mediaAgentName,
										mediaAgentId: libraryInfo.controller.mediaAgentId,
										path: libraryInfo.ddbPartitionPath, //"c:\\testddb_rahul",
										displayName: `${libraryInfo.controller.mediaAgentName} and ${libraryInfo.ddbPartitionPath}` //"ABC and c:\\testddb_rahul"
									}
								]
						  }
						: {}),
					clientGroup: {
						id: 0,
						name: null
					},
					cloudLibInfo: {
						serverType: libraryInfo.serverType.id,
						authType: $scope.configureAuthCloud.storageAuthenticationType.id,

						loginName: $scope.getLoginName(libraryInfo),
						password: $scope.getPassword(libraryInfo), // undefined
						serverName: libraryInfo.serviceHost,
						serverHost: libraryInfo.storageClass
							? `${libraryInfo.serviceHost}@${libraryInfo.storageClass.id}`
							: libraryInfo.serviceHost,
						metallicStorageInfo: {
							region: {
								regionId: 0,
								regionName: '',
								displayName: ''
							},
							storageClass: 0,
							replication: 0
						}
					},
					distributedStorage: {
						distributedStorageId: 0,
						distributedStorageName: ''
					}
				};
				if (
					$scope.showCredentialDropDown &&
					(libraryInfo.selectedCredential.length === 0 || libraryInfo.selectedCredential[0].credentialId === 0)
				) {
					$scope.credentialNotSelectedError = true;
					return;
				} else {
					if ($scope.credentialNotSelectedError) {
						$scope.credentialNotSelectedError = false;
					}
				}

				// Feature - support multiple ddb locations
				if ($scope.isModalFromMultipleDDBGrid && ($scope.mode.editMode || $scope.mode.initialMode)) {
					libraryInfo.isDeduplication = $scope.showDDBLocation;
					// here you are saving into GRID
					$scope.addCloudToGrid(libraryInfo, $scope.configureCloudLibrary); // configureCloudLibrary is only for ORACLE server type
					if ($scope.repGrpPage) {
						// The $scope.libararyInfo is not shared between the grid and the modal.
						// Hence, saving the value in the factory when values are being added to the grid and reading it back during save
						storageFactory.libraryInfo = angular.copy($scope.libraryInfo);
					}
				} else if ($scope.isCloudStorageForMultipleDDBs && !$scope.isSetup && !$scope.isStateAddCloudOther) {
					// Feature create new disk / cloud with multiple ddb locations
					const [primary] = $scope.multipleDDBsListForNewDiskOrCloud;

					storagePoolInfo.mediaAgent = {
						mediaAgentId: primary.storageInfo.mediaAgent.mediaAgentId,
						mediaAgentName: primary.storageInfo.mediaAgent.mediaAgentName,
						displayName: primary.storageInfo.mediaAgent.displayName
					};
					storagePoolInfo.mountPath = primary.storageInfo.mountPath;
					storagePoolInfo.credential =
						primary.storageInfo.selectedCredential === null
							? { credentialId: 0, credentialName: '' }
							: primary.storageInfo.selectedCredential;
					storagePoolInfo.partitionInfo = [...$scope.partitionList];
					storagePoolInfo.cloudLibInfo = {
						...storagePoolInfo.cloudLibInfo,
						...primary.storageInfo.cloudLibInfo
					};

					createStorage(storagePoolInfo, $scope.partitionList.length > 0); // HERE you are sending to backend
				}
				if ($scope.isStateAddCloudOther) {
					$scope.isSaveButtonClicked = true;
					if ($scope.libraryInfo.libraryEntity.libraryName === '') {
						$scope.inputRequired.name = true;
					} else {
						$scope.inputRequired.name = false;
					}

					if ($scope.libraryInfo.serverType.id !== $scope.HPE_CATALYST_STORAGE) {
						if ($scope.showDDBInput && $scope.partitionList.length === 0) {
							$scope.inputRequired.DDB = true;
						} else {
							$scope.inputRequired.DDB = false;
						}
					}

					if ($scope.inputRequired.name || $scope.inputRequired.DDB) {
						return;
					}

					storagePoolInfo.partitionInfo = [...$scope.partitionList];
					createStorage(storagePoolInfo, $scope.partitionList.length > 0);
				} else if ($scope.isSetup || !$scope.isCloudStorageForMultipleDDBs) {
					createStorage(storagePoolInfo, $scope.showDDBLocation);
				}
			} else {
				libraryInfo.loginName = $scope.getLoginName(libraryInfo);
				libraryInfo.password = $scope.getPassword(libraryInfo);
				libraryInfo.authType = $scope.configureAuthCloud.storageAuthenticationType.id;
				libraryInfo.metallicStorageInfo = {};
				libraryInfo.metallicStorageInfo.license =
					$scope.libraryInfo.serverType.id === $scope.METALLIC_STORAGE
						? $scope.metallicStorageInfo.licenseType[0].value
						: 0;
				libraryInfo.metallicStorageInfo.storageClass =
					$scope.libraryInfo.serverType.id === $scope.METALLIC_STORAGE
						? $scope.metallicStorageInfo.storageClass[0].value
						: 0;
				libraryInfo.metallicStorageInfo.replication =
					$scope.libraryInfo.serverType.id === $scope.METALLIC_STORAGE
						? $scope.metallicStorageInfo.replication[0].value
						: 0;
				libraryInfo.metallicStorageInfo.region = {};
				libraryInfo.metallicStorageInfo.region.regionName =
					$scope.libraryInfo.serverType.id === $scope.METALLIC_STORAGE ? $scope.metallicStorageInfo.region[0].name : '';
				libraryInfo.metallicStorageInfo.region.displayName =
					$scope.libraryInfo.serverType.id === $scope.METALLIC_STORAGE
						? $scope.metallicStorageInfo.region[0].label
						: '';

				if ($scope.libraryInfo.serverType.id === $scope.METALLIC_STORAGE) {
					if (
						storageFactory.isInputRequired(
							{
								licenseType: $scope.metallicStorageInfo.licenseType,
								storageClass: $scope.metallicStorageInfo.storageClass,
								region: $scope.metallicStorageInfo.region,
								replication: $scope.metallicStorageInfo.replication
							},
							{
								inputRequired: $scope.inputRequired
							},
							false,
							false
						)
					) {
						return;
					}
				}

				if ($scope.action == 'addMP') {
					$scope.libraryInfo.selectedCredential = libraryInfo.selectedCredential;
				}

				(libraryInfo.serverHost = libraryInfo.storageClass
					? `${libraryInfo.serviceHost}@${libraryInfo.storageClass.id}`
					: libraryInfo.serviceHost),
					storageService
						.addDiskOrCloudLibrary(libraryInfo, $scope.action, libraryInfo.ddbPartitionPath)
						.success(() => isReadyForAPICall('storageAdded', 'Add storage'))
						.error(function(e) {
							if (!$scope.isAPICall) {
								$log.error('Adding a storage failed');
								$scope.serverMessage = cvUtil.errMsg(e);
							}
						});
			}
		};

		function createStorage(storagePoolInfo, flag) {
			const createNewStorage = flag
				? storageService.createDedupeStoragePool
				: storageService.createNonDedupeStoragePool;
			createNewStorage(storagePoolInfo)
				.success(data => isReadyForAPICall('storageAdded', 'Add storage', data))
				.error(function(e) {
					if (!$scope.isAPICall) {
						$log.error('Adding a storage failed');
						$scope.serverMessage = cvUtil.errMsg(e);
						if ($scope.isStateAddCloudOther) {
							cvToaster.showErrorMessage({
								ttl: '30000',
								message: e
							});
						}
					}
				});
		}

		$scope.disableSaveButton = () => {
			if (!$scope.isModalFromMultipleDDBGrid && $scope.mode && $scope.mode.submitMode) {
				const [primary] = $scope.multipleDDBsListForNewDiskOrCloud;
				return (
					!$scope.libraryInfo.libraryEntity.libraryName || !(primary && primary.storageInfo.mediaAgent.mediaAgentId)
				);
			}

			return !$scope.libraryInfo.controller?.mediaAgentId;
		};

		$scope.onChangeCredential = credential => {
			if (credential && credential.credentialId !== 0) {
				$scope.credentialNotSelectedError = false;
				return;
			}
			$scope.credentialNotSelectedError = true;
		};

		$scope.renameLibrary = function() {
			storageService
				.renameLibrary($scope.libraryInfo, $scope.libraryInfo.label)
				.success(function(data) {
					$scope.$emit('editLibrary');
					$log.debug('Edit Library');
				})
				.error(function(e) {
					$log.error('editing Library failed');
					$scope.serverMessage = cvUtil.errMsg(e);
				});
		};
		$scope.cancel = function() {
			if ($scope.action == 'editMP') {
				$log.log('Edit MountPath Cancelled...');
				$scope.$emit('editMountPathCancelled');
			} else if ($scope.isStateAddCloudOther) {
				$state.go('addCloudLanding');
			} else if ($scope.isModalFromMultipleDDBGrid) {
				$scope.mode.editMode = false;
				$scope.mode.initialMode = false;
				$scope.mode.submitMode = true;
				$scope.cancelAdd();
			} else {
				$log.log('storage addition cancelled...');
				$scope.$emit('storageAddCancelled');
			}
		};
		$scope.browse = function(browseParamFlags) {
			if (!$scope.libraryInfo.controller || !$scope.libraryInfo.controller.mediaAgentId) {
				$scope.mediaAgentError = true;
				return;
			} else {
				$scope.mediaAgentError = false;
			}

			var modalInstance = $modal.open({
				templateUrl: appUtil.appRoot + 'machineBrowse/partials/machineBrowse.jsp',
				controller: 'mbController',
				resolve: {
					browseParams: function() {
						return {
							foldersOnly: true,
							clientId: $scope.libraryInfo.controller.mediaAgentId,
							isBackupLocation: angular.isDefined(browseParamFlags) ? !browseParamFlags.isDDBLocation : false,
							isDDBackupLocation: angular.isDefined(browseParamFlags) ? browseParamFlags.isDDBLocation : false
						};
					}
				}
			});
			modalInstance.result.then(
				function(result) {
					$scope.libraryInfo.mountPath = $scope.libraryInfo.mountPath || {};
					$scope.libraryInfo.mountPath.name = result.path;
					if (
						!$scope.libraryInfo.libraryEntity.libraryName ||
						$scope.libraryInfo.libraryEntity.libraryName.length === 0
					) {
						if (result.path.indexOf('\\') !== -1 || result.path.indexOf('/') !== -1) {
							$scope.libraryInfo.libraryEntity.libraryName = result.item.label;
						}
					}
				},
				function() {
					$log.info('Cancel clicked: ');
				}
			);
		};

		$scope.browseForPartitionPath = function(browseParamFlags) {
			if (!$scope.libraryInfo.controller || !$scope.libraryInfo.controller.mediaAgentId) {
				$scope.mediaAgentError = true;
				return;
			} else {
				$scope.mediaAgentError = false;
			}

			var modalInstance = $modal.open({
				templateUrl: appUtil.appRoot + 'machineBrowse/partials/machineBrowse.jsp',
				controller: 'mbController',
				resolve: {
					browseParams: function() {
						return {
							foldersOnly: true,
							clientId: $scope.libraryInfo.controller.mediaAgentId,
							isBackupLocation: angular.isDefined(browseParamFlags) ? !browseParamFlags.isDDBLocation : false,
							isDDBackupLocation: angular.isDefined(browseParamFlags) ? browseParamFlags.isDDBLocation : false
						};
					}
				}
			});
			modalInstance.result.then(
				function(result) {
					$scope.libraryInfo.ddbPartitionPath = result.path;
				},
				function() {
					$log.info('Cancel clicked: ');
				}
			);
		};

		$scope.setClientType = function(setClientTypeParam) {
			if (!setClientTypeParam) return;
			$scope.libraryInfo.controller = {
				mediaAgentId: setClientTypeParam.mediaAgentId,
				mediaAgentName: setClientTypeParam.mediaAgentName,
				displayName: setClientTypeParam.displayName
			};
			$scope.mediaAgentError = false;
			$scope.selectedMediaAgent = [setClientTypeParam];
			mbService.getOSType(setClientTypeParam.mediaAgentId).then(function successCallBack(response) {
				$scope.separator = response.data.toLowerCase() == 'unix' ? '/' : '\\';
				$scope.isUnixMA = response.data.toLowerCase() == 'unix';
				$scope.typeOfStorage.type = $scope.isUnixMA ? 'localStorage' : $scope.typeOfStorage.type;
				if ($scope.typeOfStorage.type == 'localStorage') {
					$scope.pathPattern.pattern = $scope.isUnixMA ? $scope.linuxPathPattern : $scope.localPathPattern;
				} else {
					$scope.pathPattern.pattern = $scope.networkPathPattern;
				}
			});
		};

		$scope.changeStorageType = function() {
			$scope.pathPattern.pattern = $scope.isUnixMA
				? $scope.linuxPathPattern
				: $scope.typeOfStorage.type == 'localStorage'
				? $scope.localPathPattern
				: $scope.networkPathPattern;
			$scope.typeOfStorage.type = $scope.isUnixMA ? 'localStorage' : $scope.typeOfStorage.type;
			$scope.showCredentialDropDown = $scope.typeOfStorage.type === 'networkStorage';
			$scope.switchToCM = $scope.showCredentialDropDown ? 'enabled-activity' : 'disabled-activity';
		};

		$scope.changeTransportType = function() {
			if ($scope.libraryInfo.controller.protocolType != 0) {
				$scope.isDataServer = true;
			} else {
				$scope.isDataServer = false;
			}
		};

		$scope.setCloudHost = function() {
			if (!$scope.libraryInfo.serverType) {
				$scope.libraryInfo.serverType = {};
				$scope.libraryInfo.serverType.id = 0;
			}
			$scope.libraryInfo.serviceHost = $scope.cloudTypeLables[$scope.libraryInfo.serverType.id].label_Host;
		};

		$scope.refreshCloudInputs = function() {
			if ($scope.cloud.cloudType[0]?.id !== $scope.libraryInfo.serverType.id) {
				$scope.libraryInfo.serverType = $scope.cloud.cloudType[0];
				$scope.setCloudHost();
				$scope.setStorageClass();
				$scope.selectedAuthTypeIndex = 0;
				$scope.setStorageAuthenticationType();
				$scope.showDDBLocation = $scope.HPE_CATALYST_STORAGE !== $scope.libraryInfo.serverType.id;
				$scope.showCredentialDropDown = storageService.getCloudCredentialsSupport($scope.libraryInfo.serverType.id);
				$scope.showSwitchToCM = $scope.showCredentialDropDown;
				// When the cloud vendor type is changed in the drop down
				// check for credential manager support for the selected
				// vendor type and refresh credentials to load the corresponding
				// list of credentials for the selected vendor type
				// For eg. when going from Amazon s3 to Google we need to reload
				// the list of credentials so that it will only show Google credentials
				if ($scope.showCredentialDropDown) {
					$scope.refreshCredentials();
				} else {
					// if credentials are not supported, reset values
					if ($scope.libraryInfo.selectedCredential) {
						$scope.libraryInfo.selectedCredential = null;
					}
					$scope.credentialNotSelectedError = false;
				}
				if ($scope.HPE_CATALYST_STORAGE === $scope.libraryInfo.serverType.id) {
					$scope.libraryInfo.ddbPartitionPath = '';
				} else {
					if ($scope.isSetup) {
						$scope.showInputs = true;
					}
				}
			}
		};

		$scope.toggleCredentialType = function() {
			$scope.switchToCM = $scope.switchToCM == 'disabled-activity' ? 'enabled-activity' : 'disabled-activity';
			if ($scope.switchToCM == 'enabled-activity') {
				$scope.showCredentialDropDown = true;
				$scope.libraryInfo.loginName = '';
				$scope.libraryInfo.password = '';
			} else {
				$scope.showCredentialDropDown = false;
				$scope.libraryInfo.selectedCredential = {
					credentialName: '',
					credentialId: 0
				};
			}
			$scope.credentialNotSelectedError = false;
		};

		$scope.getPassword = function(libraryInfo) {
			const { storageAuthenticationType } = $scope.configureAuthCloud;
			if (
				(libraryInfo.serverType.id === $scope.MICROSOFT_AZURE_CLOUD &&
					storageAuthenticationType.id == $scope.IAMVMID) ||
				(libraryInfo.serverType.id === 2 && !storageAuthenticationType.showCredential)
			) {
				return DEFAULT_PASSWORD;
			} else if (libraryInfo.selectedCredential && libraryInfo.selectedCredential.credentialId !== 0) {
				return '';
			}
			return libraryInfo.password;
		};

		const buildLoginNameForAmazon = function() {
			if (!$scope.configureAuthCloud.storageAuthenticationType) {
				return '';
			}
			switch ($scope.configureAuthCloud.storageAuthenticationType.id) {
				case 0: // accessAndSecretKeys
					// Old style credential
					return $scope.libraryInfo.selectedCredential && $scope.libraryInfo.selectedCredential.credentialId !== 0
						? ''
						: $scope.libraryInfo.loginName;
				case 1:
					return `IAM`;
				case 2:
					return `${$scope.configureAuthCloud.arnRole}|-|`;
				case 3:
					return `${$scope.configureAuthCloud.arnRole}|-|IAM`;
			}
			return '';
		};
		$scope.getLoginName = function(libraryInfo) {
			if (
				libraryInfo.serverType.id === $scope.ORACLE_CLOUD_INFRASTRUCTURE_OBJECT_STORAGE ||
				libraryInfo.serverType.id === $scope.ORACLE_CLOUD_INFRASTRUCTURE_ARCHIVE_STORAGE
			) {
				return $scope.buildLoginNameForOracle();
			} else if (libraryInfo.serverType.id === $scope.MICROSOFT_AZURE_CLOUD) {
				if ($scope.configureAuthCloud.storageAuthenticationType.id == $scope.IAMVMID)
					return $scope.buildLoginNameForAzureIAMVMID();
				else if ($scope.configureAuthCloud.storageAuthenticationType.id == $scope.IAMADCMID)
					return `${$scope.configureAuthCloud.accountName}|-|`;
				else if (
					$scope.configureAuthCloud.storageAuthenticationType.id == $scope.ACCESSANDSECRET &&
					libraryInfo.selectedCredential !== null &&
					libraryInfo.selectedCredential.credentialId === 0
				)
					// Old style credential
					return libraryInfo.loginName;
				else return '';
			} else if (libraryInfo.serverType.id === 2) {
				return buildLoginNameForAmazon();
			}
			return libraryInfo.loginName;
		};

		$scope.buildLoginNameForOracle = function() {
			var loginName = [
				$scope.configureCloudLibrary.CompartmentName,
				$scope.configureCloudLibrary.TenancyOCID,
				$scope.configureCloudLibrary.UserOCID,
				$scope.configureCloudLibrary.KeysFingerprint,
				$scope.configureCloudLibrary.PemKeyFilename
			].join('|-|');
			return loginName;
		};

		function shouldCallCredentialApi() {
			if (
				$scope.isCloudStorageForMultipleDDBs &&
				$scope.action == 'addCloudLib' &&
				!$scope.isSetup &&
				!$scope.isModalFromMultipleDDBGrid &&
				!$scope.isStateAddCloudOther
			) {
				return false;
			}

			// perform edit
			if ($scope.isModalFromMultipleDDBGrid && !$scope.showInputs) {
				return false;
			}

			if ($scope.action === 'editMP' && sharedData.data.model === 'Cloud') {
				return false;
			}

			// Don't call credential api for added hedvig storages
			if ($scope.distributedStorage && $scope.distributedStorage.distributedStorageId) {
				return false;
			}

			return true; // when it is not the add MA modal for new Cloud always is TRUE;
		}

		$scope.openEditCredentialModal = function(credentialEntity) {
			storageFactory.openEditCredentialModal(credentialEntity).then(editedCredentialName => {
				if (editedCredentialName) {
					$scope.libraryInfo.selectedCredential[0].credentialName = editedCredentialName;
					$scope.savedCredentials.forEach(function(credential, index) {
						if (credential.credentialId === $scope.libraryInfo.selectedCredential[0].credentialId) {
							credential.credentialName = editedCredentialName;
						}
					});
				}
			});
		};

		$scope.buildLoginNameForAzureIAMVMID = function() {
			var loginName = [$scope.configureAuthCloud.accountName, 'IAM'].join('|-|');
			return loginName;
		};

		function onInitAlreadyExistingAuthenticationType(loginName) {
			setUserName(loginName, $scope.libraryInfo.serverType.id);
			$scope.setStorageAuthenticationType();
			$scope.authenticationChanged(true);
			$scope.showCredentialDropDown =
				$scope.libraryInfo.selectedCredential !== null && $scope.libraryInfo.selectedCredential.credentialId !== 0;
		}

		const isReadyForAPICall = (eventName, debugMessage, data) => {
			if (!$scope.isSaveButtonClicked) {
				return;
			} else {
				$scope.$emit(eventName, data);
				$log.debug(debugMessage);
				if ($scope.isStateAddCloudOther) {
					$state.transitionTo('storagePoolCloud', $stateParams, {
						reload: true,
						inherit: false,
						notify: true
					});
				}
			}
		};
	}
];

storageControllers.addCloudTypesController = [
	'$scope',
	'$state',
	'cvBreadcrumbsTabsFactory',
	'cvLoc',
	function($scope, $state, cvBreadcrumbsTabsFactory, cvLoc) {
		cvBreadcrumbsTabsFactory.addBreadCrumbs([
			{
				title: cvLoc('label.nav.storage'),
				link: '#nav/mstoragePool'
			},
			{
				title: cvLoc('label.cloud'),
				link: '#storage/cloud'
			}
		]);

		$scope.launchMetallic = function() {
			$state.go('addCloudMetallicCommon');
		};

		$scope.launchOther = function() {
			$state.go('addCloudOther');
		};

		let learnMoreLink =
			'<a href="https://www.commvault.com/metallic-cloud-storage" target="_blank">' +
			cvLoc('tooltip.learnMore') +
			'</a>';

		$scope.metallicInfoText = cvLoc('tooltip.metallicStorage', learnMoreLink);
	}
];

storageControllers.addMetallicCloudController = [
	'sharedData',
	'$scope',
	'$log',
	'storageService',
	'cvUtil',
	'cvLoc',
	'StorageConstants',
	'$state',
	'storageFactory',
	'pushInstallSoftwareFactory',
	'cvBreadcrumbsTabsFactory',
	'MetallicStorageClass',
	'MetallicReplication',
	'MetallicLicense',
	'cvToaster',
	'$stateParams',
	'$uibModal',
	'mbService',
	'coreSetup',
	function(
		sharedData,
		$scope,
		$log,
		storageService,
		cvUtil,
		cvLoc,
		StorageConstants,
		$state,
		storageFactory,
		pushInstallSoftwareFactory,
		cvBreadcrumbsTabsFactory,
		MetallicStorageClass,
		MetallicReplication,
		MetallicLicense,
		cvToaster,
		$stateParams,
		$modal,
		mbService,
		coreSetup
	) {
		$scope.isTenantAdmin = cv.isTenantAdmin;
		$scope.isTenantOperator = cv.isTenantOperator;
		$scope.isShowStorageSelection = cv.isShowStorageSelection;
		$scope.licenseTypeList = [];
		$scope.regionList = [];
		$scope.storageClassList = [];
		$scope.replicationList = [];
		$scope.metallicStorageInfo = {
			region: [],
			storageClass: [],
			replication: [],
			licenseType: []
		};
		$scope.selectedMediaAgent = null;
		$scope.licenseTypeToData = {};
		$scope.showStorageClass = false;
		$scope.showReplication = false;
		$scope.showDDBInput = true;
		$scope.libraryInfo = {
			libraryEntity: {
				libraryName: ''
			},
			mountPath: {
				id: '',
				name: ''
			},
			loginName: '',
			serverType: {
				id: 400,
				name: ''
			},
			serverHost: '',
			selectedCredential: null,
			mediaAgent: {
				mediaAgentId: 0,
				mediaAgentName: ''
			}
		};
		$scope.numDDBLimit = 4;
		$scope.inputRequired = {
			name: false,
			license: false,
			region: false,
			storageClass: false,
			replication: false,
			DDB: false,
			mediaAgent: false
		};

		$scope.showMetallicInputs = {
			storageClass: false,
			replication: false
		};

		if ($state.current.name === 'addCloudMetallic') {
			cvBreadcrumbsTabsFactory.addBreadCrumbs([
				{
					title: cvLoc('label.nav.storage'),
					link: '#nav/mstoragePool'
				},
				{
					title: cvLoc('label.Metallic'),
					link: '#storage/metallic'
				}
			]);
		} else {
			cvBreadcrumbsTabsFactory.addBreadCrumbs([
				{
					title: cvLoc('label.nav.storage'),
					link: '#nav/mstoragePool'
				},
				{
					title: cvLoc('label.cloud'),
					link: '#storage/cloud'
				},
				{
					title: cvLoc('label.nav.cloudType'),
					link: '#storage/cloud/addCloud'
				}
			]);
		}

		storageService
			.getMediaAgentList('NONE')
			.success(function(data) {
				$scope.agentList = cvUtil.sortAscending(data, 'displayName');
				if (!$scope.libraryInfo) {
					$scope.libraryInfo = {};
					$scope.libraryInfo.serverType = {};
				}
				if ($scope.agentList.length === 1) {
					$scope.libraryInfo.mediaAgent.mediaAgentId = $scope.agentList[0].mediaAgentId;
					$scope.libraryInfo.mediaAgent.mediaAgentName = $scope.agentList[0].mediaAgentName;
				}
			})
			.error(function(data, status, headers, config) {
				$scope.serverMessage = cvUtil.errMsg(data);
				return false;
			});

		$scope.addMetallicDDBGridOptions = storageFactory.addCloudDDBGridOptions($scope);

		storageService
			.getMetallicStorageInfo()
			.success(function(data) {
				if (data.errorCode === 0) {
					storageFactory.processGetMetallicStorageInfo(data, {
						licenseTypeList: $scope.licenseTypeList,
						regionList: $scope.regionList,
						storageClassList: $scope.storageClassList,
						replicationList: $scope.replicationList,
						licenseTypeToData: $scope.licenseTypeToData,
						metallicStorageInfo: $scope.metallicStorageInfo,
						showMetallicInputs: $scope.showMetallicInputs,
						inputRequired: $scope.inputRequired
					});
				} else {
					cvToaster.showErrorMessage({
						ttl: '10000',
						message: data.errorMessage
					});
				}
			})
			.error(function(data, status, headers, config) {
				$scope.serverMessage = cvUtil.errMsg(data);
				return false;
			});

		$scope.setMetallicLicenseType = function(data) {
			storageFactory.setMetallicLicenseType(data, {
				metallicStorageInfo: $scope.metallicStorageInfo,
				licenseTypeToData: $scope.licenseTypeToData,
				regionList: $scope.regionList,
				storageClassList: $scope.storageClassList,
				replicationList: $scope.replicationList,
				inputRequired: $scope.inputRequired
			});
		};

		$scope.setMetallicRegion = function(data) {
			storageFactory.setMetallicRegion(data, {
				metallicStorageInfo: $scope.metallicStorageInfo,
				inputRequired: $scope.inputRequired
			});
		};

		$scope.setMetallicStorageClass = function(data) {
			storageFactory.setMetallicStorageClass(data, {
				metallicStorageInfo: $scope.metallicStorageInfo,
				inputRequired: $scope.inputRequired
			});
		};

		$scope.setMetallicReplication = function(data) {
			storageFacory.setMetallicStorageClass(data, {
				metallicStorageInfo: $scope.metallicStorageInfo,
				inputRequired: $scope.inputRequired
			});
		};

		$scope.onToggleUseDDBMetallic = function() {
			$scope.showDDBInput = !$scope.showDDBInput;
			$scope.libraryInfo.ddbPartitionPath = null;
			$scope.storagePoolType = $scope.showDDBInput ? 'DEDUPLICATION' : 'NON-DEDUPLICATION';
		};

		$scope.openCreateMediaAgentModal = function() {
			$scope.libraryInfo.controller = $scope.libraryInfo.controller || {};
			var pushInstallParams = {
				useAgent: 'MA',
				dialogTitle: cvLoc('placeholder.createMediaAgent'),
				dialogTitleHelpText: cvLoc('label.createMediaAgentHelpText'),
				disableInteractiveInstall: true,
				hideJobDetails: $scope.isSetup
			};
			var modalInstance = pushInstallSoftwareFactory.openPushInstallDialog(pushInstallParams);
			modalInstance.result.then(
				function() {
					// on success
					$scope.generalSetupMessage = cvUtil.infoMsgLoc('info.installingMA');
					$scope.libraryInfo.mediaAgent = '';
				},
				function() {
					// on error
					$scope.libraryInfo.mediaAgent = '';
				}
			);
		};

		$scope.localDDBPathPattern = /^([a-zA-Z]:){1}(\\[^<>:"/\\|?*]+)*\\?$/;
		$scope.linuxDDBPathPattern = /^(\/[^<>:"/\\|?*]+)+\/?$/;
		$scope.pathPattern = {
			pattern: ''
		};

		$scope.addMetallicSP = function() {
			if ($state.current.name === 'coreSetup' && $scope.showDDBInput) {
				$scope.partitionList.splice(0, $scope.partitionList.length);
				$scope.partitionList.push({
					mediaAgentName: $scope.libraryInfo.mediaAgent.mediaAgentName,
					mediaAgentId: $scope.libraryInfo.mediaAgent.mediaAgentId,
					path: $scope.libraryInfo.ddbPartitionPath,
					displayName: $scope.libraryInfo.mediaAgent.displayName
				});
			}

			if (
				storageFactory.isInputRequired(
					{
						libraryName: $scope.libraryInfo.libraryEntity.libraryName,
						licenseType: $scope.metallicStorageInfo.licenseType,
						storageClass: $scope.metallicStorageInfo.storageClass,
						region: $scope.metallicStorageInfo.region,
						replication: $scope.metallicStorageInfo.replication,
						partitionList: $scope.partitionList,
						mediaAgent: $scope.libraryInfo.mediaAgent
					},
					{
						inputRequired: $scope.inputRequired
					},
					true,
					$scope.showDDBInput
				)
			) {
				return;
			}

			const storagePoolInfo = {
				createNew: true,
				library: {},
				mediaAgent: {
					mediaAgentId: $scope.libraryInfo.mediaAgent.mediaAgentId,
					mediaAgentName: $scope.libraryInfo.mediaAgent.mediaAgentName
				},
				mountPath: '',
				credential: { credentialId: 0, credentialName: '' },
				name: $scope.libraryInfo.libraryEntity.libraryName,
				clientGroup: {
					id: 0,
					name: null
				},
				cloudLibInfo: {
					serverType: 400,
					authType: 0,
					loginName: '',
					password: '',
					serverName: '',
					serverHost: '',
					metallicStorageInfo: {
						region: {
							regionId: $scope.metallicStorageInfo.region[0].value,
							regionName: $scope.metallicStorageInfo.region[0].name,
							displayName: $scope.metallicStorageInfo.region[0].label
						},
						storageClass: $scope.metallicStorageInfo.storageClass[0].value,
						replication: $scope.metallicStorageInfo.replication[0].value,
						licenseType: $scope.metallicStorageInfo.licenseType[0].value
					}
				}
			};

			storagePoolInfo.partitionInfo = [...$scope.partitionList];

			const createNewStorage =
				$scope.partitionList.length > 0
					? storageService.createDedupeStoragePool
					: storageService.createNonDedupeStoragePool;
			createNewStorage(storagePoolInfo).then(
				function(data) {
					if ($state.current.name === 'coreSetup') {
						coreSetup.handleNext();
					} else {
						cvToaster.showSuccessMessage({
							message: cvLoc('label.createdStoragePool', $scope.libraryInfo.libraryEntity.libraryName)
						});
						$state.transitionTo('storagePoolMetallic', $stateParams, {
							reload: true,
							inherit: false,
							notify: true
						});
					}
				},
				function(e) {
					$log.error('Adding a storage failed');
					cvToaster.showErrorMessage({
						ttl: '30000',
						message: 'Create storage pool failed: ' + e.data
					});
				}
			);
		};
		$scope.cancel = function() {
			$state.go($state.previous.route.name);
		};

		$scope.browseForPartitionPath = function(browseParamFlags) {
			if (!$scope.libraryInfo.mediaAgent || !$scope.libraryInfo.mediaAgent.mediaAgentId) {
				$scope.inputRequired.mediaAgent = true;
				return;
			} else {
				$scope.inputRequired.mediaAgent = false;
			}

			var modalInstance = $modal.open({
				templateUrl: appUtil.appRoot + 'machineBrowse/partials/machineBrowse.jsp',
				controller: 'mbController',
				resolve: {
					browseParams: function() {
						return {
							foldersOnly: true,
							clientId: $scope.libraryInfo.mediaAgent.mediaAgentId,
							isBackupLocation: angular.isDefined(browseParamFlags) ? !browseParamFlags.isDDBLocation : false,
							isDDBackupLocation: angular.isDefined(browseParamFlags) ? browseParamFlags.isDDBLocation : false
						};
					}
				}
			});
			modalInstance.result.then(
				function(result) {
					$scope.libraryInfo.ddbPartitionPath = result.path;
				},
				function() {
					$log.info('Cancel clicked: ');
				}
			);
		};

		$scope.setMediaAgent = function(mediaAgent) {
			$scope.libraryInfo.mediaAgent = mediaAgent;
			if ($state.current.name === 'coreSetup') {
				$scope.mediaAgentError = false;
				mbService.getOSType(mediaAgent.mediaAgentId).then(function successCallBack(response) {
					$scope.separator = response.data.toLowerCase() == 'unix' ? '/' : '\\';
					$scope.pathPattern.pattern =
						response.data.toLowerCase() === 'unix' ? $scope.linuxDDBPathPattern : $scope.localDDBPathPattern;
				});
			} else {
				$scope.inputRequired.mediaAgent = false;
			}
		};
	}
];
storageMod.controller(storageControllers);

export default storageMod;
