import { acAppStorageModule } from 'common/js/modules';

import '../directives/storage.directive.js';

import * as scaleOutStorageLibraryListDetailsTemplate from './ScaleOutStorageLibraryDetails.template';

var storageMod = acAppStorageModule;

export class ScaleOutStorageLibraryDetailsListController {
	constructor(
		$scope,
		$http,
		storageService,
		cvToaster,
		$modal,
		$stateParams,
		cvLoc,
		$state,
		$dialogs,
		cvUtil,
		$log,
		$filter,
		$compile,
		cvBreadcrumbsTabsFactory
	) {
		this.$scope = $scope;
		this.$http = $http;
		this.storageService = storageService;
		this.cvToaster = cvToaster;
		this.$modal = $modal;
		this.$stateParams = $stateParams;
		this.cvLoc = cvLoc;
		this.$state = $state;
		this.$dialogs = $dialogs;
		this.cvUtil = cvUtil;
		this.$log = $log;
		this.$filter = $filter;
		this.cvBreadcrumbsTabsFactory = cvBreadcrumbsTabsFactory;
		this.$compile = $compile;

		this.initializeController();
		this._setupGridOptions();
		this._initBreadCrumbs();
	}

	initializeController() {
		this.$scope.scaleOutStorageDiskInfoList = [];
		this.$scope.model = this.$stateParams['model'];
		this.$scope.storagePoolId = this.$stateParams['storagePoolId'];
		this.$scope.storagePoolName = this.$stateParams['storagePoolName'];
		this.$scope.storagePoolType = this.$stateParams['storagePoolType'];
		this.$scope.mediaAgentId = this.$stateParams['mediaAgentId'];
		this.$scope.mediaAgentName = this.$stateParams['mediaAgentName'];
		this.$scope.stateName = this.$state.current.name;
		this.$scope.cvLoc = this.cvLoc;
		this.$scope.scaleOutStorageStatus = {
			status: '',
			statusInt: 0,
			diskStatus: '',
			diskStatusInt: 0
		};

		this.$scope.bEnableScaleoutPerformanceCharts =
			cv &&
			cv.additionalSettings &&
			cv.additionalSettings.AdminConsole &&
			cv.additionalSettings.AdminConsole.bEnableScaleoutPerformanceCharts;
	}

	_initColumnsDef() {
		return scaleOutStorageLibraryListDetailsTemplate.getColumnTemplate({
			cvLoc: this.cvLoc
		});
	}

	_initBreadCrumbs() {
		let fromAppliance = false;
		let fromAppliancesPool = false;
		let applianceNav = '';
		let nav = this.$stateParams['nav'];
		if (nav && nav == 'appliances') {
			fromAppliance = true;
			applianceNav = '&nav=appliances';
		} else if (nav && nav == 'appliancesPool') {
			fromAppliancesPool = true;
			applianceNav = '&nav=appliances';
		}
		let breadCrumbs = [];
		breadCrumbs.push(
			{
				title: this.cvLoc('label.nav.storage'),
				link: '#nav/mstoragePool'
			},
			{
				title:
					fromAppliancesPool || fromAppliance ? this.cvLoc('title.appliances') : this.cvLoc('label.nav.hyperscale'),
				link: fromAppliancesPool || fromAppliance ? '#appliances' : '#storage/hyperscale'
			}
		);
		if (!fromAppliance || fromAppliancesPool) {
			breadCrumbs.push({
				title: this.$scope.storagePoolName,
				link:
					'#/storage/hyperscale/overview?storagePoolName=' +
					encodeURIComponent(this.$scope.storagePoolName) +
					'&storagePoolId=' +
					this.$scope.storagePoolId +
					'&storagePoolType=' +
					this.$scope.storagePoolType +
					'&input.storagePoolName=' +
					encodeURIComponent(this.$scope.storagePoolName) +
					'&input.storagePoolId=' +
					this.$scope.storagePoolId +
					applianceNav
			});
		}
		this.cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);
	}

	_fetchData(data) {
		let self = this;
		this.storageService
			.getStoragePoolDiskInfo(this.$scope.storagePoolId, this.$scope.mediaAgentId)
			.success(scaleOutStoragePoolResp => {
				self.$scope.scaleOutStoragePoolResp = scaleOutStoragePoolResp;

				let concatString = '';
				self.$scope.successStatus =
					self.$scope.scaleOutStoragePoolResp.overallHostStatusInt == 1 &&
					self.$scope.scaleOutStoragePoolResp.overallBrickStatusInt == 1
						? 1
						: 0;
				if (
					self.$scope.scaleOutStoragePoolResp.overallHostStatus &&
					self.$scope.scaleOutStoragePoolResp.overallBrickStatus
				) {
					concatString = '/';
				}
				self.$scope.statusString =
					self.$scope.scaleOutStoragePoolResp.overallHostStatus +
					concatString +
					self.$scope.scaleOutStoragePoolResp.overallBrickStatus;
				self.$scope.hwInfo = scaleOutStoragePoolResp.hwInfo;
				self.$scope.isHwCollectionSupported = scaleOutStoragePoolResp.isHwCollectionSupported;
				self.$scope.scaleOutStorageDiskInfoList = scaleOutStoragePoolResp.scaleOutStorageDiskInfo
					? self._setupList(scaleOutStoragePoolResp.scaleOutStorageDiskInfo)
					: [];

				if (self.isHedvig) {
					self.grid.hideColumn('Actions');
				}

				//Adding details links for hardware components
				if (scaleOutStoragePoolResp.isHwCollectionSupported) {
					var reportCompMap = {
						disk: { table: 'Table1538692662762', filter: 'EntityStatusStr=Offline' }, //Disks
						flashDrive: { table: 'Table1538692743393', filter: 'EntityStatusStr=Offline' }, //Cache
						fan: { table: 'Table1538692884743', filter: 'EntityStatusStr=Off' }, //Cooling Devices/Fans
						power: { table: 'Table1538693005924', filter: 'EntityStatusStr=Disconnected' }, //Power supply
						nic: { table: 'Table1538693098987', filter: 'EntityStatusStr=Disconnected' } //NICs
					};
					var baseReportLink =
						appUtil.appRoot +
						'#/reportDetails?reportId=Hardware%20Details&app=ADMIN_CONSOLE&input.storagePoolId=' +
						this.$scope.storagePoolId +
						'&input.mediaAgentId=' +
						this.$scope.mediaAgentId;
					self.$scope.hwInfo.detailsLink = baseReportLink;
					if (self.$scope.hwInfo.flashDriveStatus == 0) {
						self.$scope.hwInfo.flashStatusLink =
							baseReportLink +
							'&showComponents=' +
							reportCompMap.flashDrive.table +
							'&' +
							reportCompMap.flashDrive.table +
							'.filter.' +
							reportCompMap.flashDrive.filter;
					}
					if (self.$scope.hwInfo.fanStatus == 0) {
						self.$scope.hwInfo.fanStatusLink =
							baseReportLink +
							'&showComponents=' +
							reportCompMap.fan.table +
							'&' +
							reportCompMap.fan.table +
							'.filter.' +
							reportCompMap.fan.filter;
					}
					if (self.$scope.hwInfo.powerStatus == 0) {
						self.$scope.hwInfo.powerStatusLink =
							baseReportLink +
							'&showComponents=' +
							reportCompMap.power.table +
							'&' +
							reportCompMap.power.table +
							'.filter.' +
							reportCompMap.power.filter;
					}
					if (self.$scope.hwInfo.nicStatus == 0) {
						self.$scope.hwInfo.nicStatusLink =
							baseReportLink +
							'&showComponents=' +
							reportCompMap.nic.table +
							'&' +
							reportCompMap.nic.table +
							'.filter.' +
							reportCompMap.nic.filter;
					}
				}
				let cpu = self.$scope.scaleOutStoragePoolResp.CPUUsage;
				let memory = self.$scope.scaleOutStoragePoolResp.MemoryUsage;

				//formatting cpu/memory
				var imageMap = {
					normal: appUtil.appRoot + 'common/img/good.svg',
					warning: appUtil.appRoot + 'common/img/warning.svg',
					critical: appUtil.appRoot + 'common/img/critical.svg'
				};

				if (!memory || (!memory.currentCount && !memory.severityLevel)) {
					memory = memory || {};
					memory.usageStr = this.cvLoc('label.noDataAvailable');
				} else {
					memory.usedMemory = memory.threshold * (memory.currentCount / 100);
					memory.usageStr =
						self.$filter('dataSizeString')(memory.usedMemory * 1024 || 0) +
						'/' +
						self.$filter('dataSizeString')(memory.threshold * 1024 || 0);
					memory.statusIcon = imageMap[memory.severityLevel.toLowerCase()];
				}
				if (!cpu || (!cpu.currentCount && !cpu.severityLevel)) {
					cpu = cpu || {};
					cpu.usageStr = this.cvLoc('label.noDataAvailable');
				} else {
					cpu.usageStr = self.$filter('number')(cpu.currentCount, 1) + '%';
					cpu.statusIcon = imageMap[cpu.severityLevel.toLowerCase()];
				}

				self.$scope.cpuUsage = cpu;
				self.$scope.memoryUsage = memory;

				self.$scope.storagePoolMessage = {
					message: ' ', // space is needed
					type: 'ok'
				};
				data.success(self.$scope.scaleOutStorageDiskInfoList);
			})
			.error(e => {
				self.$scope.storagePoolMessage = {
					message: e,
					type: 'error'
				};
			});
	}

	_setupList(scaleOutStorageDiskInfoList) {
		const self = this;
		const firstDiskInfo = scaleOutStorageDiskInfoList[0] || {};
		self.isHedvig = firstDiskInfo.deviceOSPath && firstDiskInfo.deviceOSPath.startsWith('/hedvig');
		return scaleOutStorageDiskInfoList.map(element => {
			element.capacity = this.$filter('capacity')(element.capacity * 1024 * 1024);
			element.permittedOptions = {
				entityName: element.deviceOSPath,
				entityId: element.diskId,
				appendToBody: true,
				permittedActionList: !self.isHedvig
					? [
							{
								show: true, //(element.overallDiskStatus === 2), //broken state
								label: this.cvLoc('action.replace'),
								onClick: self.replaceDiskForScaleoutStoragePool.bind(
									this,
									this.$scope.mediaAgentId,
									this.$scope.mediaAgentName,
									element.diskId,
									element.deviceOSPath
								)
							},
							{
								show: self.$scope.isHwCollectionSupported,
								label: this.cvLoc('action.locate'),
								onClick: self.blinkDiskForScaleoutStoragePool.bind(
									this,
									this.$scope.mediaAgentId,
									this.$scope.mediaAgentName,
									element.diskId,
									element.deviceOSPath
								)
							}
					  ]
					: []
			};
			element.physicalId = '\n' + element.physicalId;
			return element;
		});
	}

	replaceDiskForScaleoutStoragePool(mediaAgentId, mediaAgentName, diskId, deviceOSPath) {
		let callBackFunctions = {
			noFunction: () => {},
			yesFunction: () => {
				this.storageService
					.replaceDisk(mediaAgentId, this.$scope.storagePoolId, this.$scope.storagePoolName, mediaAgentName, diskId)
					.success(data => {
						this.$log.debug('Replaced disk {0} successfully', deviceOSPath);
						this.$state.forceReload();
					})
					.error(data => {
						this.$dialogs.error(this.cvLoc('label.error'), this.cvUtil.errMsg(data).message);
						this.$log.error('Replace disk failed');
					});
			}
		};
		this.$dialogs.confirm(
			this.cvLoc('label.confirmReplace'),
			this.cvLoc(
				'label.confirmReplaceDisk',
				'<b>' + deviceOSPath + '</b>',
				'<b>' + deviceOSPath + '</b>',
				'<b>' + deviceOSPath + '</b>'
			),
			callBackFunctions
		);
	}

	blinkDiskForScaleoutStoragePool(mediaAgentId, mediaAgentName, diskId, deviceOSPath) {
		this.storageService
			.blinkDisk(mediaAgentId, this.$scope.storagePoolId, this.$scope.storagePoolName, mediaAgentName, diskId)
			.success(data => {
				this.$log.debug('Blink disk ' + deviceOSPath + ' successful');
				this.$state.forceReload();
			})
			.error(data => {
				this.$dialogs.error(this.cvLoc('label.error'), this.cvUtil.errMsg(data).message);
				this.$log.error('Blink disk failed');
			});
	}

	_onGridDataBound(dataItem, row) {
		const permittedOptions = dataItem.permittedOptions;
		const id = permittedOptions.entityId;
		const template = `<cv-permitted-actions cv-permitted-options="permittedOptions${id}"></cv-permitted-actions>`;
		this.$scope[`permittedOptions${id}`] = permittedOptions;
		row.find('.permittedActions').append(this.$compile(template)(this.$scope));
	}

	_setupGridOptions() {
		const self = this;
		this.kendoGridOptions = {};
		this.$scope.kendoGridOptions = this.kendoGridOptions;
		this.kendoGridOptions.gridTitle = this.cvLoc('label.disks');
		this.kendoGridOptions.tableName = 'storagePoolDiskListTable';
		this.kendoGridOptions.url = this._fetchData.bind(this);
		this.kendoGridOptions.columns = this._initColumnsDef();
		this.kendoGridOptions.onGridDataBound = this._onGridDataBound.bind(this);
		this.kendoGridOptions.hideToolbar = false;
		this.kendoGridOptions.enableFiltering = false;
		this.kendoGridOptions.enableColumnMenu = false;
		this.kendoGridOptions.hasViews = true;
		this.kendoGridOptions.gridEmptySvg = `<svg class="add-new-placeholder" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 160 200" xml:space="preserve"><path d="M121,167a5,5,0,0,0,5-5V38a5,5,0,0,0-5-5H39a5,5,0,0,0-5,5V162a5,5,0,0,0,5,5h82ZM44.8,53.3h70.4v3H44.8v-3Zm0,12h70.4v3H44.8v-3Zm0,12h70.4v3H44.8v-3Zm0,12h70.4v3H44.8v-3ZM72,134.8a8,8,0,1,1,8,8A8,8,0,0,1,72,134.8Z"/></svg>`;

		this.kendoGridOptions.beforeGridInitialize = ({ grid }) => {
			self.grid = grid;
		};
	}
}

ScaleOutStorageLibraryDetailsListController.$inject = [
	'$scope',
	'$http',
	'storageService',
	'cvToaster',
	'$uibModal',
	'$stateParams',
	'cvLoc',
	'$state',
	'$dialogs',
	'cvUtil',
	'$log',
	'$filter',
	'$compile',
	'cvBreadcrumbsTabsFactory'
];

storageMod.controller('scaleOutStorageLibraryDetailsListController', ScaleOutStorageLibraryDetailsListController);

export default storageMod;
