<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.settings"></cv:cvMessages>
	<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.usersJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.saphana"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.setup"></cv:cvMessages>
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.archiving"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sharepoint"></cv:cvMessages>
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.activeDirectory"></cv:cvMessages>
	<cv:cvMessages bundle="localization.bigData"></cv:cvMessages>
	<cv:cvMessages bundle="localization.notesDatabase"></cv:cvMessages>
	<cv:cvMessages bundle="localization.office365"></cv:cvMessages>
	<cv:cvMessages bundle="localization.gsuite"></cv:cvMessages>
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
	<cv:cvMessages bundle="localization.kubernetes"></cv:cvMessages>
	<cv:cvMessages bundle="localization.cloudStorageApp"></cv:cvMessages>
</script>
<div class="center-container setup-container" data-ng-if="setupSteps" data-ng-class="{'metallic-setup' : customizeForMetallic }" >  <!-- setup-steps-wrapper -->
	<div class="row">
		<div class="setup-banner setup-banner-shrink">
			<div class="col-xs-12 col-md-6 col-lg-12 setup-banner-text" data-ng-if="!customizeForMetallic">
				<div class="setup-banner-header">
					<a href="#gettingStarted" class="go-back"><i
						class="ion-ios-undo"></i></a>
						<!--to Show header in setup steps page based on the setup state-->
						<span data-ng-switch="$state.current.name">
							<span data-ng-switch-when="coreSetup">{{'label.coreSetup' | cvLoc}}</span>
							<span data-ng-switch-when="coreSetupTenantOS">{{'label.storageConfiguration' | cvLoc}}</span>
							<span data-ng-switch-when="acSetup">{{'label.serversSetup' | cvLoc}}</span>
							<span data-ng-switch-when="vsaSetup">{{'label.virtualizationSetup' | cvLoc}}</span>
							<span data-ng-switch-when="dloSetup">{{'label.endpointSetup' | cvLoc}}</span>
							<span data-ng-switch-when="dbsSetup">{{'label.databasesSetup' | cvLoc}}</span>
							<span data-ng-switch-when="ebsSetup">{{'label.ebsSetup' | cvLoc}}</span>
							<span data-ng-switch-when="cappsSetup">{{'label.cloudappsSetup' | cvLoc}}</span>
							<span data-ng-switch-when="cappsGDriveSetup">{{'label.gsuiteSetup' | cvLoc}}</span>
							<span data-ng-switch-when="cappsGMailSetup">{{'label.gsuiteSetup' | cvLoc}}</span>
							<span data-ng-switch-when="cappsOneDriveSetup">{{'label.cloudappsOneDriveSetup' | cvLoc}}</span>
							<span data-ng-switch-when="cappsSalesforceSetup">{{'label.cloudappsSalesforceSetup' | cvLoc}}</span>
							<span data-ng-switch-when="cappsAmazonSQLSetup">{{'label.cloudappsAmazonSQLSetup' | cvLoc}}</span>
							<span data-ng-switch-when="cappsAzureSQLSetup">{{'label.cloudappsAzureSQLSetup' | cvLoc}}</span>
							<span data-ng-switch-when="exchangeSetup">{{'label.exchangeSetup' | cvLoc}}</span>
							<span data-ng-switch-when="exchangeDagSetup">{{'label.exchangeDagSetup' | cvLoc}}</span>
							<span data-ng-switch-when="exchangeMailboxSetup">{{'label.exchangeMailboxSetup' | cvLoc}}</span>
							<span data-ng-switch-when="archivingSetup">{{'label.archivngSetup' | cvLoc}}</span>
							<span data-ng-switch-when="archiveSetup">{{'label.archivngSetup' | cvLoc}}</span>
							<span data-ng-switch-when="sharepointSetup">{{'label.sharepointSetup' | cvLoc}}</span>
							<span data-ng-switch-when="activateSetup">{{'label.activateSetup' | cvLoc}} - {{activateApp}}</span>
							<span data-ng-switch-when="activeDirectorySetup">{{'label.activeDirectorySetup' | cvLoc}}</span>
							<span data-ng-switch-when="cassandraSetup">{{'heading.cassandraSetup' | cvLoc}}</span>
							<span data-ng-switch-when="hadoopSetup">{{'header.hadoopSetup' | cvLoc}}</span>
							<span data-ng-switch-when="exchangeOnlineSetup">{{'label.office365Setup' | cvLoc}}</span>
							<span data-ng-switch-when="sharepointOnlineSetup">{{'label.sharepointOnlineSetup' | cvLoc}}</span>
							<span data-ng-switch-when="configureAzureApp">{{'label.AzureAppOffice365Setup' | cvLoc}}</span>
							<span data-ng-switch-when="OneDriveForBusinessSetup">{{'label.oneDriveForBusinessSetup' | cvLoc}}</span>
							<span data-ng-switch-when="notesDatabaseSetup">{{'label.notesDatabaseSetup' | cvLoc}}</span>
							<span data-ng-switch-when="office365Setup">{{'label.office365Setup' | cvLoc}}</span>
							<span data-ng-switch-when="bigDataAppsSetup">{{'label.bigDataAppsSetup' | cvLoc}}</span>
							<span data-ng-switch-when="kubernetesSetup">{{'pageTitle.kubernetesSetup' | cvLoc}}</span>
							<span data-ng-switch-when="objectStorageSetup">{{'pageTitle.objectStorageSetup' | cvLoc}}</span>
							<span data-ng-switch-when="epicSetup">{{'label.epicSetup' | cvLoc}}</span>
							<span data-ng-switch-when="dynamics365Setup">{{'label.dynamics365Setup' | cvLoc}}</span>
						</span>
				</div>
			</div>
			<div class="setup-banner-image visible-lg">
				<div class="banner-image">
					<svg xmlns="http://www.w3.org/2000/svg" viewbox="0 0 950 600"
						width="1700" height="750">
						<defs></defs>
						<path
							d="M681.5,317.5V281.5l44-16.7a208,208,0,0,0-35.6-86.7l-43.2,19.4L621.2,172l19.5-43.3a208,208,0,0,0-86.6-35.9l-16.9,44.4H501.1L484.3,92.8a208,208,0,0,0-86.6,35.9L417.2,172l-25.5,25.5-43.2-19.4a208,208,0,0,0-35.6,86.7l44,16.7v36.1L313,334.2q1.5,8.7,3.7,17.1H440a97.3,97.3,0,1,1,158.4,0H721.7q2.2-8.4,3.7-17.2Z"
							transform="translate(-312.8 4)" />
						<path
							d="M654.6,71.3l16.5-43.5h36.1l16.5,43.5a208,208,0,0,0,86.6-35.7L792.5-4H585.8L568,35.6A208,208,0,0,0,654.6,71.3Z"
							transform="translate(-312.8 4)" />
						<path
							d="M1090.5,149.1a147.3,147.3,0,0,0-25.2-61.4l-30.6,13.8-18.1-18.1,13.8-30.7A147.3,147.3,0,0,0,969,27.3L957.1,58.8H931.6L919.6,27.3a147.3,147.3,0,0,0-61.3,25.4l13.8,30.7L854,101.5,823.4,87.7a147.3,147.3,0,0,0-25.2,61.4L829.4,161v25.5l-31.1,11.8a147.3,147.3,0,0,0,25.5,61.3L854,246l18.1,18.1-13.6,30.2a147.4,147.4,0,0,0,61.4,25.3l11.7-30.8h25.5l11.7,30.8a147.3,147.3,0,0,0,61.4-25.3l-13.6-30.2,18.1-18.1,30.2,13.6a147.3,147.3,0,0,0,25.5-61.3l-31.1-11.8V161ZM944.3,239.4a68.9,68.9,0,1,1,68.9-68.9A68.9,68.9,0,0,1,944.3,239.4Z"
							transform="translate(-312.8 4)" />
						<path
							d="M1173.9-4a208.6,208.6,0,0,0-16.1,52.7l44,16.7v36.1L1158,118.2a208,208,0,0,0,36,86.5l42.7-19.2,25.5,25.5L1243,253.6a208,208,0,0,0,23,14.2V-4Z"
							transform="translate(-312.8 4)" /></svg>
				</div>
			</div>
		</div>
		<ul data-ng-if="!customizeForMetallic" class="steps group" data-setup-steps="{{data.steps.length}}">
			<li data-ng-repeat="step in data.steps" title="{{step.name}}"
				data-ng-class="{'current': getCurrentStep() == $index, 'done': (overrides[$index] === undefined && (setupComplete || setupSteps[$index])) || overrides[$index], 'warn': !setupComplete && showWarning($index), 'clickable': canGoToStep($index) }"
				data-ng-click="goToStep($index)"><span
				data-ng-if="setupComplete || showWarning($index) || setupSteps[$index]"> <a
					href="">{{step.name}}</a>
			</span> <span data-ng-if="!setupComplete && !(showWarning($index) || setupSteps[$index])">{{step.name}} </span></li>
		</ul>

		<ul data-ng-if="customizeForMetallic" class="wizard-step-tracker" data-setup-steps="{{data.steps.length}}">
			<li class= "wizard-step" data-ng-repeat="step in data.steps" data-ng-class="{'wizard-step active': getCurrentStep() == $index, 'wizard-step completed': (setupComplete || setupSteps[$index]) }">
				<div class="wizard-step-circle">
                	<span data-ng-if="setupComplete || setupSteps[$index]" class="k-icon k-i-check"></span>
                	<span data-ng-if="!(setupComplete || setupSteps[$index])">{{$index+1}}</span>
                </div>
                <div class="wizard-step-bar"></div>
                <div class="wizard-step-text">{{step.name}}</div>
			</li>
		</ul>

		<div data-ng-class="{'back-strip no-background' : $state.current.name !== 'activateSetup', 'wizard-body' : customizeForMetallic }">
			<div class="set-up-page"
				data-ng-class="{'done': setupSteps[setupStep]}">
				<ng-include src="data.steps[setupStep].template"></ng-include>
			</div>
		</div>
		<div class="bottom-setup-actions" data-ng-if="!customizeForMetallic">
			<a class="quit-setup" target="_self" data-ng-click="skipSetup()">
				<span data-ng-if="!coreSetupEnabled">
					<span data-ng-if="setupComplete">
						<fmt:message key="setup.setupCompleted" />
					</span>
					<span data-ng-if="!setupComplete">
						<fmt:message key="setup.finishLater" />
					</span>
				</span>
				<span data-ng-if="coreSetupEnabled">
					<cv:msg key="label.coreSetupBack" bundle="setup" />
				</span>
			</a>
			<div data-ng-if="stateName === 'acSetup' && showDownloadLink " class="serverMessage"><cv:msg key="info.interactiveInstallation" bundle="serversJs" /><a href="{{downloadLink}}" target="_blank"> <cv:msg key="label.here" bundle="messagesJs" /></a>.</div>
			<div data-ng-if="!setupComplete && canMarkAsComplete">
				<div class="or"><span>or</span></div>
				<div class="mark-as-complete"><a href="" data-ng-click="markAsComplete()"><cv:msg key="label.markAsComplete" bundle="setup" /></a></div>
			</div>
		</div>
	</div>
</div>
