<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.navJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.setup"></cv:cvMessages>
	<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvEnum name="Api.SupportedSolutionsBitValue"></cv:cvEnum>
</script>
<div class="getting-started" data-resize-on-state-change>
	<div class="center-container setup-container">
		<div class="row">
			<div class="core-setup-block setup-banner"
				data-ng-class="{'setup-banner-shrink': coreSetupCompleted}">
				<div class="col-xs-12 core-setup-items setup-banner-text">
					<div class="setup-banner-header smaller-header">
						<cv:msg key="label.welcome" bundle="setup" />
						${loginContext.userEntity.userName}
					</div>
					<div class="setup-banner-sub-header">
						<span data-ng-if="!coreSetupCompleted" data-ng-bind="coreSetupSubHeader"></span><span class="italize smaller-font" data-ng-if="!coreSetupCompleted && showSkipInitialSetup"><cv:msg key="label.or" bundle="setup"></cv:msg> <a data-ng-click="skipInitialSetup()" ><cv:msg key="label.skipIt" bundle="setup"></cv:msg></a></span>
						<div data-ng-if="coreSetupCompleted">
							<span data-ng-bind="coreSetupSubHeaderCompleted"><a data-ng-href="#/license?openRegistration=true" data-ng-if="showRegisterProduct && !isTenantAdmin"><cv:msg key="label.registerProductLabel" bundle="setup"></cv:msg></a></span>
						</div>
					</div>
					<div data-ng-if="!coreSetupCompleted">
						<table data-ng-if="showQuickTasks" class="core-setup-list">
							<tbody>
								<tr>
									<td><a data-ng-href="#/{{setupName}}?forceStep=0"><i data-ng-class="setupSteps[0] ? 'ion-android-checkbox-outline' : 'ion-android-checkbox-outline-blank'"></i></a></td>
									<td><a data-ng-href="#/{{setupName}}?forceStep=0"><span data-ng-bind="storageTitle"></span></a></td>
								</tr>
								<tr data-ng-if="!isZealBrand">
									<td><a data-ng-href="#/{{setupName}}?forceStep=1"><i data-ng-class="setupSteps[1] ? 'ion-android-checkbox-outline' : 'ion-android-checkbox-outline-blank'"></i></a></td>
									<td><a data-ng-href="#/{{setupName}}?forceStep=1"><cv:msg key="label.createServerBackupPlan" bundle="setup" /></a></td>
								</tr>
							</tbody>
						</table>

						<div class="core-setup-getStarted smaller-getStarted">
								<span data-ng-if="coreSetupStarted && showQuickTasks">{{'label.finishSetupText' | cvLoc}}</span>
						</div>
						<div data-ng-if="showLetsGetStarted" class="core-setup-getStarted" ng-class="{'tenant-os' : isTenantAdmin}">
							<span data-ng-if="coreSetupStarted">
								<a data-ng-href="#/{{setupName}}?forceStep={{coreSetupStartStep}}" class="btn btn-lg">{{'label.finishSetupCTA' | cvLoc}}&nbsp;<i class="ion-ios-arrow-forward"></i></a>
							</span>
							<span data-ng-if="!coreSetupStarted">
								<a  data-ng-href="#/{{setupName}}?forceStep={{coreSetupStartStep}}" class="btn btn-lg">{{'label.letsGetStarted' | cvLoc}}&nbsp;<i class="ion-ios-arrow-forward"></i></a>
							</span>
						</div>
						<div data-ng-if="skipCoreSetup" class="core-setup-getStarted smaller-getStarted"
							style="padding-top: 10px">
							<a data-ng-href="{{dashboardPath}}" class="btn btn-lg"><cv:msg key="label.finishLaterCTA" bundle="setup" />
								&nbsp;<i class="ion-ios-arrow-forward"></i>
							</a>
						</div>

						<div class="core-setup-getStarted smaller-getStarted underline">
								<a data-ng-href="{{helpLink}}" target="_blank"><cv:msg
									key="label.needHelp" bundle="setup" /></a>
						</div>

					</div>
				</div>
				<div class="setup-banner-image visible-lg">
					<div class="banner-image">
						<svg xmlns="http://www.w3.org/2000/svg" viewbox="0 0 950 600"
							width="1700" height="750">
						<path
								d="M681.5,317.5V281.5l44-16.7a208,208,0,0,0-35.6-86.7l-43.2,19.4L621.2,172l19.5-43.3a208,208,0,0,0-86.6-35.9l-16.9,44.4H501.1L484.3,92.8a208,208,0,0,0-86.6,35.9L417.2,172l-25.5,25.5-43.2-19.4a208,208,0,0,0-35.6,86.7l44,16.7v36.1L313,334.2q1.5,8.7,3.7,17.1H440a97.3,97.3,0,1,1,158.4,0H721.7q2.2-8.4,3.7-17.2Z"
								transform="translate(-312.8 4)" />
						<path
								d="M654.6,71.3l16.5-43.5h36.1l16.5,43.5a208,208,0,0,0,86.6-35.7L792.5-4H585.8L568,35.6A208,208,0,0,0,654.6,71.3Z"
								transform="translate(-312.8 4)" />
						<path
								d="M1090.5,149.1a147.3,147.3,0,0,0-25.2-61.4l-30.6,13.8-18.1-18.1,13.8-30.7A147.3,147.3,0,0,0,969,27.3L957.1,58.8H931.6L919.6,27.3a147.3,147.3,0,0,0-61.3,25.4l13.8,30.7L854,101.5,823.4,87.7a147.3,147.3,0,0,0-25.2,61.4L829.4,161v25.5l-31.1,11.8a147.3,147.3,0,0,0,25.5,61.3L854,246l18.1,18.1-13.6,30.2a147.4,147.4,0,0,0,61.4,25.3l11.7-30.8h25.5l11.7,30.8a147.3,147.3,0,0,0,61.4-25.3l-13.6-30.2,18.1-18.1,30.2,13.6a147.3,147.3,0,0,0,25.5-61.3l-31.1-11.8V161ZM944.3,239.4a68.9,68.9,0,1,1,68.9-68.9A68.9,68.9,0,0,1,944.3,239.4Z"
								transform="translate(-312.8 4)" />
						<path
								d="M1173.9-4a208.6,208.6,0,0,0-16.1,52.7l44,16.7v36.1L1158,118.2a208,208,0,0,0,36,86.5l42.7-19.2,25.5,25.5L1243,253.6a208,208,0,0,0,23,14.2V-4Z"
								transform="translate(-312.8 4)" /></svg>
					</div>
				</div>
			</div>
			<div class="col-xs-12">
				<div class="extend-setup-block">
					<div class="row">
						<div class="col-md-12 core-setup-extend">
							<div class="padding-left-0"
								data-ng-class="{'col-xs-8': showQuickTasks, 'col-md-8': showQuickTasks, 'col-xs-12': !showQuickTasks, 'col-md-12': !showQuickTasks}">

								<span class="angular-tab-wrapper">
									<uib-tabset active="activeTab">
											 <uib-tab class="gettingStarted_Tab_protect"  heading="<cv:msg key="label.protect" bundle="setup" />" select="onTabSelected(TABS_ENUM.protect)" index="1">
											 	<fieldset >
											 	<div  data-ng-disabled="!coreSetupCompleted" class="row">
														<div class="app-tiles">
															<div class="padding-left-0 col-xs-12 col-md-12">
															<div  data-ng-repeat="(appType, app) in apps track by $index"
																class="app more-solutions" data-ng-class="{'hidden' : (showQuickTasks && $index > 5) || (!showQuickTasks && $index > 3)}">
																<div class="col-xs-12 app-setup-container" data-ng-class="{'col-md-6': showQuickTasks, 'col-lg-4': showQuickTasks, 'col-md-4': !showQuickTasks, 'col-lg-3': !showQuickTasks}"
																	data-ng-if="!app.isSubApp"
																	id="appsProtect_{{app.appSetupState}}">
																	<div class="panel panel-default clickable"
																		data-ng-click="handleClick(app)"
																		data-ng-class="{'setup-more': app.showMore}">
																		<div data-ng-if="!app.showMore">
																			<div class="panel-body" data-ng-class="{'app-no-scroll' : !app.appSubApps}">
																				<div class="row">
																					<div class="col-md-12 padding-left-20 padding-top-10">
																						<div class="col-md-8 padding-left-0" data-app-icon="{{app.appType}}"></div>
																						<div class="col-md-4" data-ng-if="app.appSetupCompleted"><i class="ion-android-done float-right"></i></div>
																					</div>
																					<div class="col-md-12 padding-left-20"><h3>{{app.appName}}</h3></div>
																					<ul>
																						<!-- <li
																							data-ng-repeat="feature in app.appFeatures track by $index">{{feature}}</li> -->
																							<li data-ng-if="app.appFeatures" class="feature-font">{{app.appFeatures[0]}}</li>

																						<li data-ng-if="app.appHelpLink"><a
																							data-ng-href="{{app.appHelpLink}}" target="_blank"
																							data-ng-click="$event.stopPropagation()">{{'label.needMoreInformation'
																								| cvLoc}}</a></li>
																					</ul>
																				</div>
																			</div>
																		</div>
																	</div>
																</div>
															</div>
															</div>
														</div>
														<div class="padding-right-30 col-xs-12 col-md-12 col-lg-12"><a class="float-right" data-ng-click="showMoreSolutions()" data-ng-if="showMoreSolutionsButton"><cv:msg bundle="setup" key="label.moreSolutions" /></a></div>
												</div>
											 	</fieldset>
											 </uib-tab>
											 <uib-tab class="gettingStarted_Tab_activate" heading="<cv:msg key="label.activate" bundle="navJs" />" data-ng-if="activateApps.length > 0" select="onTabSelected(TABS_ENUM.activate)" index="2">
											 	<fieldset >
											 	<div class="row">
														<div class="app-tiles">
															<div class="padding-left-0 col-xs-12 col-md-12">
															<div data-ng-repeat="(appType, app) in activateApps track by $index"
																class="app more-solutions" data-ng-class="{'hidden' : (showQuickTasks && $index > 5) || (!showQuickTasks && $index > 3)}">
																<div class="col-xs-12 col-md-6 col-lg-4 app-setup-container"
																	data-ng-if="!app.isSubApp"
																	id="appsActivate_{{app.appSetupState}}">
																	<div class="panel panel-default clickable"
																		data-ng-click="handleClick(app)"
																		data-ng-class="{'setup-more': app.showMore}">
																		<div data-ng-if="!app.showMore">
																			<div class="panel-body" data-ng-class="{'app-no-scroll' : !app.appSubApps}">
																				<div class="row">
																					<div class="col-md-12 padding-left-20 padding-top-10">
																						<div class="col-md-8 padding-left-0" data-app-icon="{{app.appType}}"></div>
																						<div class="col-md-4" data-ng-if="app.appSetupCompleted"><i class="ion-android-done float-right"></i></div>
																					</div>
																					<div class="col-md-12 padding-left-20"><h3>{{app.appName}}</h3></div>
																					<ul>
																						<!-- <li
																							data-ng-repeat="feature in app.appFeatures track by $index">{{feature}}</li> -->
																							<li data-ng-if="app.appFeatures" class="feature-font">{{app.appFeatures[0]}}</li>

																						<li data-ng-if="app.appHelpLink"><a
																							data-ng-href="{{app.appHelpLink}}" target="_blank"
																							data-ng-click="$event.stopPropagation()">{{'label.needMoreInformation'
																								| cvLoc}}</a></li>
																					</ul>
																				</div>
																			</div>
																		</div>
																	</div>
																</div>
															</div>
															</div>
														</div>
												</div>
											 	</fieldset>
											 </uib-tab>
											 <uib-tab class="gettingStarted_Tab_orchestrate"  heading="<cv:msg key="label.nav.disasterRecovery" bundle="navJs" />" data-ng-if="orchestrateApps.length > 0" select="onTabSelected(TABS_ENUM.disasterRecovery)" index="3">
											 	<fieldset >
											 	<div data-ng-disabled="!coreSetupCompleted" class="row">
														<div class="app-tiles">
															<div class="padding-left-0 col-xs-12 col-md-12">
															<div   data-ng-repeat="(appType, app) in orchestrateApps track by $index"
																class="app more-solutions" data-ng-class="{'hidden' : (showQuickTasks && $index > 5) || (!showQuickTasks && $index > 3)}">
																<div class="col-xs-12 col-md-6 col-lg-4  app-setup-container"
																	data-ng-if="!app.isSubApp"
																	id="appsOrchestrate_{{app.appSetupState}}">
																	<div class="panel panel-default clickable"
																		data-ng-click="handleClick(app)"
																		data-ng-class="{'setup-more': app.showMore}">
																		<div data-ng-if="!app.showMore">
																			<div class="panel-body" data-ng-class="{'app-no-scroll' : !app.appSubApps}">
																				<div class="row">
																					<div class="col-md-12 padding-left-20 padding-top-10">
																						<div class="col-md-8 padding-left-0" data-app-icon="{{app.appType}}"></div>
																						<div class="col-md-4" data-ng-if="app.appSetupCompleted"><i class="ion-android-done float-right"></i></div>
																					</div>
																					<div class="col-md-12 padding-left-20"><h3>{{app.appName}}</h3></div>
																					<ul>
																						<!-- <li
																							data-ng-repeat="feature in app.appFeatures track by $index">{{feature}}</li> -->
																							<li data-ng-if="app.appFeatures" class="feature-font">{{app.appFeatures[0]}}</li>

																						<li data-ng-if="app.appHelpLink"><a
																							data-ng-href="{{app.appHelpLink}}" target="_blank"
																							data-ng-click="$event.stopPropagation()">{{'label.needMoreInformation'
																								| cvLoc}}</a></li>
																					</ul>
																				</div>
																			</div>
																		</div>
																	</div>
																</div>
															</div>
															</div>
														</div>
												</div>
											 	</fieldset>
											 </uib-tab>
											 <uib-tab class="gettingStarted_Tab_services"  heading="<cv:msg key="label.nav.services" bundle="navJs" />" data-ng-if="cloudServicesEnabled && cloudServices.length > 0" select="onTabSelected(TABS_ENUM.services)" index="4">
											 	<fieldset >
											 	<div data-ng-disabled="!coreSetupCompleted" class="row">
														<div class="app-tiles">
															<div class="padding-left-0 col-xs-12 col-md-12">
															<div  data-ng-repeat="(appType, app) in cloudServices track by $index"
																class="app more-solutions" data-ng-class="{'hidden' : (showQuickTasks && $index > 5) || (!showQuickTasks && $index > 3)}">
																<div class="col-xs-12 col-md-6 col-lg-4  app-setup-container"
																	data-ng-if="!app.isSubApp"
																	id="appsCloud_{{app.appSetupState}}">
																	<div class="panel panel-default clickable"
																		data-ng-click="handleClick(app)"
																		data-ng-class="{'setup-more': app.showMore}">
																		<div data-ng-if="!app.showMore">
																			<div class="panel-body" data-ng-class="{'app-no-scroll' : !app.appSubApps}">
																				<div class="row">
																					<div class="col-md-12 padding-left-20 padding-top-10">
																						<div class="col-md-8 padding-left-0" data-app-icon="{{app.appType}}"></div>
																						<div class="col-md-4" data-ng-if="app.appSetupCompleted"><i class="ion-android-done float-right"></i></div>
																					</div>
																					<div class="col-md-12 padding-left-20"><h3>{{app.appName}}</h3></div>
																					<ul>
																						<!-- <li
																							data-ng-repeat="feature in app.appFeatures track by $index">{{feature}}</li> -->
																							<li data-ng-if="app.appFeatures" class="feature-font">{{app.appFeatures[0]}}</li>

																						<li data-ng-if="app.appHelpLink"><a
																							data-ng-href="{{app.appHelpLink}}" target="_blank"
																							data-ng-click="$event.stopPropagation()">{{'label.needMoreInformation'
																								| cvLoc}}</a></li>
																					</ul>
																				</div>
																			</div>
																		</div>
																	</div>
																</div>
															</div>
															</div>
														</div>
												</div>
											 	</fieldset>
											 </uib-tab>
									</uib-tabset>
								</span>
							</div>
							<div data-ng-if="showQuickTasks"  class="row core-setup-extend">
								<div class="col-xs-4 col-md-4 app-tiles">
									<div class="col-xs-12 col-md-12 col-lg-12 padding-bottom-28 core-setup-extendLabel"><cv:msg key="label.quickTasks" bundle="setup" /></div>
									<div class="col-xs-12 col-md-12 col-lg-12">
										<div data-ng-disabled="!coreSetupCompleted" class="quick-tasks">
											<div class="app-setup-container">
												<div class="panel panel-default" >
													<div class="panel-body">
														<div class="row task taskInfo-items" data-ng-repeat="task in quickTasks track by $index" data-ng-click="handleQuickTasksClick(task)" data-ng-if="task.show">
															<div class="col-xs-2 col-md-2 col-lg-2 padding-top-10 icon" data-app-icon="{{task.value}}"></div>
															<div class="col-xs-10 col-md-10 col-lg-10"><h3>{{task.label}}</h3></div>
															<div class="col-xs-12 col-md-12 col-lg-12 feature-font" title="{{task.helpText}}">{{task.helpText}}</div>
														</div>

														<!-- handle download software separately for now, becasue everything was wrapped in one controller and refactory code may cause regression -->
														<div class="row task" data-ng-controller="loadDefaultSoftwareController" data-ng-click="openDownloadSoftwareDialog(0, '', false)" data-ng-if="isMSPAdmin" data-ng-init="loadData()">
															<div class="col-xs-2 col-md-2 col-lg-2 padding-top-10 icon" ng-bind-html="downloadSoftwareSvg"></div>
															<div class="col-xs-10 col-md-10 col-lg-10"><h3><cv:msg key="label.task.downloadSoftware" bundle="setup" /></h3></div>
															<div class="col-xs-12 col-md-12 col-lg-12 feature-font" title="<cv:msg key="info.help.downloadSoftware" bundle="setup" />"><cv:msg key="info.help.downloadSoftware" bundle="setup" /></div>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>