import { commonSetupModule } from 'common/js/modules';

/**
 * A directive for generating a dashboard with app icons
 */
commonSetupModule.directive('appIconDashboard', [
	function() {
		return {
			scope: {
				appIconOptions: '=',
				parentClose: '&',
				enableIconFilter: '='
			},
			templateUrl: appUtil.appRoot + 'modules/setup/partials/appIconDashboard.jsp',
			controller: [
				'$uibModal',
				'$scope',
				function($modal, $scope) {
					$scope.filteredAppIconOptions = $scope.appIconOptions;
					$scope.filterText = '';
					$scope.filterOptions = function() {
						let searchStr = $scope.filterText;
						if (searchStr) {
							$scope.filteredAppIconOptions = _.filter($scope.appIconOptions, function(item) {
								return item.label.toLowerCase().includes(searchStr.toLowerCase());
							});
						} else {
							$scope.filteredAppIconOptions = $scope.appIconOptions;
						}
					};
					$scope.onSelect = option => {
						if ($scope.parentClose) {
							$scope.parentClose();
						}
						//cancel modal
						//call the action defined for server
						if (option && option.onSelect) {
							option.onSelect(option.id);
						}
					};
				}
			]
		};
	}
]);

export default commonSetupModule;
