import 'modules/setup/js/directives/app-icon.js';
import 'modules/servers/js/services/servers.svc.js';
import 'modules/commcellRegistration/js/factory/serviceCommcell.constant.js';
import 'modules/setup/js/services/setup.svc.js';
import 'vsa/js/factories/replicationGroups.factory.js';
import { commonSetupModule } from 'common/js/modules';
import { ServiceTypes } from 'ediscovery/common/js/constants.js';

var mod = commonSetupModule;
mod.controller('gettingStartedController', [
	'$scope',
	'$state',
	'$window',
	'cvUtil',
	'cvLoc',
	'userPrefService',
	'serverService',
	'settingsService',
	'$uibModal',
	'$location',
	'subscriptionsUIFactory',
	'cvToaster',
	'MAINTANENCE_ICONS',
	'serviceCommcellConstants',
	'setupService',
	'replicationGroupFactory',
	'cvNavigationFactory',
	'commcellRole',
	'subscriptionService',
	function(
		$scope,
		$state,
		$window,
		cvUtil,
		cvLoc,
		userPrefService,
		serverService,
		settingsService,
		$modal,
		$location,
		subscriptionsUIFactory,
		cvToaster,
		MAINTANENCE_ICONS,
		serviceCommcellConstants,
		setupService,
		replicationGroupFactory,
		cvNavigationFactory,
		commcellRole,
		subscriptionService
	) {
		$scope.TABS_ENUM = Object.freeze({ protect: 1, activate: 2, disasterRecovery: 3, services: 4 });
		$scope.activeTab = 1;
		$scope.onTabSelected = function(tabValue) {
			let tabName = tabValue
				? Object.keys($scope.TABS_ENUM).find(tabName => $scope.TABS_ENUM[tabName] === tabValue)
				: 'protect';
			tabName = $scope.allApps[tabName].length ? tabName : 'protect';
			$location.search('tab', tabName);
			$scope.activeTab = $scope.TABS_ENUM[tabName];
		};

		$scope.dashboardPath = '#' + cvUtil.getAppDashboard();
		$scope.isMSPAdmin = cv.isMspAdmin;
		$scope.isTenantAdmin = cv.isTenantAdmin;
		$scope.isReseller = cv.isReseller;
		$scope.activateEnabled = cvConfig.enableEdiscovery;
		let isCurrentCommCellACloudService = (cvApp.commcellInfo.commcellRole & commcellRole.CLOUDSERVICE) > 0;
		//Show services tab only to msp admin and tenant admin who is not operator. Revisit this in sp25 and make appropriate user role.
		let showCloudServices = cv.isUserOnlyTenantAdmin || cv.isMspAdmin;
		let cloudServicesEnabled = cvConfig.enableCloudServices && showCloudServices && !isCurrentCommCellACloudService;
		if (cloudServicesEnabled) {
			if (!cvConfig.enableCompanyLinkingToMetallic) {
				subscriptionService.getSubscriptions().success(data => {
					if (data.length > 0) {
						if (!cv.sessionContext.completedSetups['METALLIC']) {
							$scope.cloudServicesEnabled = false;
						} else {
							$scope.cloudServicesEnabled = cloudServicesEnabled;
						}
					} else {
						$scope.cloudServicesEnabled = cloudServicesEnabled;
					}
				});
			} else {
				$scope.cloudServicesEnabled = cloudServicesEnabled;
			}
		}
		$scope.showQuickTasks = $scope.isMSPAdmin || $scope.isReseller;
		$scope.setupName = 'coreSetup';
		$scope.infrastructureType = '';
		$scope.showLetsGetStarted = cv.isAdminOnCommcellLevel;
		$scope.coreSetupSubHeaderCompleted = cvLoc('label.coreSetupSubHeaderCompleted');
		$scope.step1Name = cvLoc('label.configureEmailLabel');
		$scope.setupStepsLength = cvUtil.objectContainsNestedProperty('cv.sessionContext.setupStepsMap.CORE_SETUP', cv)
			? cv.sessionContext.setupStepsMap.CORE_SETUP.length
			: 2;
		$scope.coreSetupSubHeader = cvLoc('label.coreSetupSubHeader', $scope.setupStepsLength);
		if (cv.isTenantAdmin || cv.isTenantOperator) {
			$scope.coreSetupSubHeaderCompleted = '';
			$scope.infrastructureType = cvUtil.objectContainsNestedProperty('cv.sessionContext.infrastructureType', cv)
				? cv.sessionContext.infrastructureType
				: '';
			if ($scope.infrastructureType === 'OWN_STORAGE') {
				$scope.setupName = 'tenantOSSetup';
				$scope.showLetsGetStarted = true;
			}
			$scope.step1Name =
				$scope.infrastructureType &&
				($scope.infrastructureType === 'OWN_STORAGE' || $scope.infrastructureType === 'HYBRID')
					? cvLoc('label.addStorageServer')
					: '';
			$scope.coreSetupSubHeader = cvLoc('label.bringYourOwnStorage');
		}
		$scope.downloadSoftwareSvg = MAINTANENCE_ICONS.COPY_SOFTWARE;
		$scope.isZealBrand = cvApp.oemId === 118;
		$scope.storageTitle = $scope.isZealBrand ? cvLoc('title.addLibrary') : cvLoc('label.addStoragePoolLabel');
		// update this list if the solution does not require a guided set up\
		$scope.noGuidedSetUp = ['gitAppsAccountsSetup'];

		const isOrchestrate = app => {
			switch (app.appName) {
				case cvUtil.lookupEnumConstant('REPLICATION'):
					return true;
			}
			return false;
		};

		const isActivate = app => {
			switch (app.appName) {
				case cvLoc('label.gdpr'):
				case cvLoc('label.analytics'):
				case cvLoc('label.userPermissions'):
				case cvLoc('label.casemanager'):
				case cvLoc('label.complianceSearch'):
					return true;
			}
			return false;
		};

		const isCloud = app => {
			switch (app.appName) {
				case cvLoc('label.nav.Metallic'):
					return true;
			}
			return false;
		};

		$scope.appSteps = cvNavigationFactory.getAppSteps();

		if (!(cv.isTenantAdmin || cv.isTenantOperator)) {
			settingsService.getCloudSettings(
				function(email) {
					if (!angular.isString(email) || email.length <= 0) {
						$scope.showRegisterProduct = true;
					}
				},
				function() {
					$scope.showRegisterProduct = true;
				}
			);
		}

		$scope.coreSetupCompleted = true;
		$scope.setupSteps = cv.sessionContext.setupStepsMap.CORE_SETUP;
		if (
			(cv.isTenantAdmin || cv.isTenantOperator) &&
			cv.sessionContext.infrastructureType === 'OWN_STORAGE' &&
			cvUtil.objectContainsNestedProperty('cv.sessionContext.setupStepsMap.CORE_SETUP_TENANT_OS', cv)
		) {
			$scope.setupSteps = cv.sessionContext.setupStepsMap.CORE_SETUP_TENANT_OS;
		}
		// Find the step that the user has left off on.
		for (var i in $scope.setupSteps) {
			if ($scope.setupSteps[i]) {
				$scope.coreSetupStarted = true;
			} else {
				$scope.coreSetupCompleted = false;
				if (!angular.isDefined($scope.coreSetupStartStep)) {
					$scope.coreSetupStartStep = i;
				}
			}
		}

		// We want to give the option to the user to make his/her CommServe an MSP if the following conditions are met.
		//
		// 1. The user is an admin on the CommCell level.
		// 2. The core setup is completed.
		// 3. The CommServe is not already an MSP
		// 4. The user didn't specify to never ask him/her again about making the CommServe an MSP.
		// 5. The user didn't specify to remind him/her later.
		$scope.mspDocumentationLink = cvConfig.helpLink + '?p=87419.htm';
		$scope.showMspAction =
			cv.isAdminOnCommcellLevel &&
			$scope.coreSetupCompleted &&
			!cvApp.showMSP &&
			cvApp.globalParams.dontAskAboutMSP !== '1' &&
			cv.userPref.askAboutMspLater !== '1';

		$scope.apps = [];
		$scope.activateApps = [];
		$scope.orchestrateApps = [];
		$scope.cloudServices = [];
		/*
		 * Loop through each setup to determine whether or not it has been completed.
		 */
		angular.forEach($scope.appSteps, function(step, key) {
			if (!step.isSubApp) {
				if (angular.isDefined(step.show) && step.show === true) {
					if ($scope.activateEnabled && isActivate(step)) {
						$scope.activateApps.push(step);
					} else if (isOrchestrate(step)) {
						$scope.orchestrateApps.push(step);
					} else if (isCloud(step)) {
						if (cloudServicesEnabled) {
							$scope.cloudServices.push(step);
						}
					} else {
						$scope.apps.push(step);
					}
				}
			}
			step.appType = key;

			//This is just a temporary fix from the UI. In the next SP we will take it

			step.appSetupCompleted = $scope.coreSetupCompleted && !step.appSubApps && cv.sessionContext.completedSetups[key];
		});

		$scope.allApps = {
			protect: $scope.apps,
			activate: $scope.activateApps,
			disasterRecovery: $scope.orchestrateApps,
			services: $scope.cloudServices
		};

		let tabValue = $location.search().tab ? $scope.TABS_ENUM[$location.search().tab] : $scope.TABS_ENUM.protect;
		/*
		 * For zeal brand customers, Disaster recovery should be the default tab
		 */
		if ($scope.isZealBrand && $scope.orchestrateApps.length > 0) {
			tabValue = $scope.TABS_ENUM.disasterRecovery;
		}
		$scope.onTabSelected(tabValue);

		//populating subApps setup status.
		//For this, look for the corresponding app in apps list and get its status.
		angular.forEach($scope.appSteps, function(app, key) {
			if (app.appSubApps && app.appSubApps.length > 0) {
				angular.forEach(app.appSubApps, function(subApp, subAppKey) {
					//found the app which is the matching subapp to get setup status
					var appForSubApp = {};
					for (var key in $scope.appSteps) {
						if ($scope.appSteps[key].appName === subApp.subAppName) {
							appForSubApp = $scope.appSteps[key];
							break;
						}
					}
					subApp.setupCompleted = appForSubApp.appSetupCompleted;
				});
			}
		});

		//If an app has subapps, update its appSetupCompleted property to true if at least one subapp is completed; else false
		angular.forEach($scope.appSteps, function(app, key) {
			var appActualstatus = false;
			if (app.appSubApps && app.appSubApps.length > 0) {
				for (var i = 0, len = app.appSubApps.length; i < len; i++) {
					if (app.appSubApps[i].setupCompleted === true) {
						appActualstatus = true;
						break;
					}
				}
				app.appSetupCompleted = appActualstatus;
			}
		});

		/*
		 * Sort all of the apps based on the order given.
		 */
		$scope.apps.sort(function(a, b) {
			/*
			 * Based on the OEM installed, we want to show the corresponding setup first in the list of apps.
			 */
			switch (cvApp.oemId) {
				case 106: // VSA
				case 114:
					// VSA
					if (a === $scope.appSteps.VSA) {
						return -1;
					} else if (b === $scope.appSteps.VSA) {
						return 1;
					}
					break;
				case 113:
					// ENDPOINT
					if (a === $scope.appSteps.ENDPOINT) {
						return -1;
					} else if (b === $scope.appSteps.ENDPOINT) {
						return 1;
					}
					break;
				case 1: // Admin Console
				case 16: // Admin Console
				default:
					if (a === $scope.appSteps.ADMIN_CONSOLE) {
						return -1;
					} else if (b === $scope.appSteps.ADMIN_CONSOLE) {
						return 1;
					}
					break;
			}

			/*
			 * We then order by the "order" attribute attached to each app setup.
			 */
			if (angular.isUndefined(b.order) && angular.isUndefined(a.order)) {
				return 0;
			} else if (angular.isUndefined(b.order)) {
				return -1;
			} else if (angular.isUndefined(a.order)) {
				return 1;
			} else {
				return a.order - b.order;
			}
		});

		$scope.helpLink = cvConfig.helpLink;
		$scope.skipCoreSetup =
			angular.isUndefined(cvApp.globalParams.skipInitialSetup) ||
			cvApp.globalParams.skipInitialSetup === 'true' ||
			cvConfig.skipCoreSetup;
		$scope.showSkipInitialSetup =
			angular.isUndefined(cvApp.globalParams.skipInitialSetup) || cvApp.globalParams.skipInitialSetup === 'false';

		/**
		 * Specify that the user should be asked about setting his/her enviornment as MSP the next time he/she
		 * logs in.
		 */
		$scope.askMeLater = function() {
			userPrefService.setBooleanUserPref('askAboutMspLater', true);
			$scope.showMspAction = false;
		};

		/**
		 * Handle a user clicking on a tile.
		 */
		$scope.handleClick = function(app) {
			/*
			 * If the setup is complete, go to the app's dashboard page. Otherwise, go to the app's setup
			 * page.
			 */
			app.loading = true;
			if (app.appSetupCompleted) {
				if (app.appDashboardState) {
					$state.go(app.appDashboardState);
				} else if (app.redirectLink) {
					$location.url(app.redirectLink);
				}
			} else if (app.appSetupState) {
				if (isOrchestrate(app) && $scope.isZealBrand) {
					replicationGroupFactory.configureVSAReplicationGroup();
				} else if ($scope.noGuidedSetUp.indexOf(app.appSetupState) !== -1) {
					$state.go(app.appSetupState, { isGuidedSetup: true });
				} else {
					$state.go(app.appSetupState);
				}
			} else if (app.redirectLink) {
				$location.url(app.redirectLink);
			}
			app.loading = false;
		};

		$scope.handleSubAppClick = function(app, subApp) {
			app.loading = true;
			if (subApp.setupCompleted) {
				$state.go(subApp.subAppDashboardState);
			} else {
				$state.go(subApp.subAppSetupState);
			}
			app.loading = false;
		};

		/**
		 * Specify that the environment should not be a managed service provider.
		 */
		$scope.dontMakeMsp = function() {
			serverService.dontAskAboutMSP();
			//cvApp.globalParams object will never be null, but adding this check to avoid future changes failover if any.
			if (cvApp.globalParams) {
				cvApp.globalParams['dontAskAboutMSP'] = '1';
			}
			$scope.showMspAction = false;
		};

		/**
		 * Make the current environment a managed service provider.
		 */
		$scope.makeMsp = function() {
			serverService.setIsMSPCommcell(true).success(function() {
				userPrefService.setBooleanUserPref('mspConfigured', true);
				$window.location.reload();
			});
		};

		$scope.quickTasks = [
			{
				value: 'EMAIL_CONFIGURATION',
				label: cvLoc('label.task.configureEmail'),
				onClick: openConfigureEmailModal.bind(this),
				helpText: cvLoc('info.help.configureEmail'),
				show: $scope.isMSPAdmin
			},
			{
				value: 'BRANDING',
				label: cvLoc('label.task.CustomizeTheme'),
				link: '/customizeTheme',
				helpText: cvLoc('info.help.CustomizeTheme'),
				show: $scope.isMSPAdmin || $scope.isReseller
			},
			{
				value: 'PLAN',
				label: cvLoc('label.task.createPlan'),
				onClick: createServerPlan.bind(this),
				helpText: cvLoc('info.help.createPlan'),
				show: $scope.isMSPAdmin || $scope.isReseller
			},
			{
				value: 'COMPANY',
				label: cvLoc('label.task.createCompany'),
				onClick: addSubscriptionWindow.bind(this),
				helpText: cvLoc('info.help.createCompany'),
				show:
					($scope.isMSPAdmin || $scope.isReseller) &&
					!(
						_.get(cvApp, 'commcellInfo.commcellType', '') === serviceCommcellConstants.SERVICECOMMCELL &&
						_.get(cvApp, 'commcellInfo.globalIdpCommcellName', '') !== ''
					)
			}
		];
		$scope.showMoreSolutionsButton =
			($scope.showQuickTasks && $scope.apps.length > 6) || (!$scope.showQuickTasks && $scope.apps.length > 4);
		$scope.showMoreSolutions = function() {
			var ele = $('.extend-setup-block').find('.more-solutions');
			ele.removeClass('hidden');
			$scope.showMoreSolutionsButton = false;
		};

		$scope.handleQuickTasksClick = function(task) {
			if (task.link) {
				$location.url(task.link);
			} else if (task.onClick) {
				task.onClick.call();
			}
		};

		function addSubscriptionWindow() {
			subscriptionsUIFactory.addSubscriptionWindow();
		}

		function createServerPlan() {
			const modalInstance = $modal.open({
				templateUrl: appUtil.appRoot + 'dlo/partials/addServerPlan.jsp',
				backdrop: 'static',
				controller: [
					'$scope',
					'$uibModalInstance',
					'cvLoc',
					'$location',
					function($scope, $modalInstance, cvLoc, $location) {
						$scope.cancel = function() {
							$modalInstance.dismiss();
						};
						$scope.planSubType = 'Server';
						$scope.$on('planAdded', function(evt, data) {
							$location.path('/profileDetails/' + data.profile.summary.plan.planId);
							$modalInstance.dismiss();
						});
					}
				]
			});
		}
		$scope.skipInitialSetup = function() {
			settingsService
				.skipInitialSetup()
				.success(function(data) {
					//set the global params variable
					cvApp.globalParams.skipInitialSetup = 'true';
					//redirect to the dashboard
					$location.path(cvUtil.getAppDashboard());
				})
				.error(function(e) {
					cvToaster.showErrorMessage({
						ttl: '10000', //10 sec
						message: e ? e : cvLoc('generic_error')
					});
				});
		};
		function openConfigureEmailModal() {
			const modalInstance = $modal.open({
				templateUrl: appUtil.appRoot + 'modules/settings/partials/configureEmail.jsp',
				backdrop: 'static',
				controller: [
					'$scope',
					'$uibModalInstance',
					'settingsService',
					function($scope, $modalInstance, settingsService) {
						settingsService.getEmail(
							function(data) {
								let port = 25;
								// need check this deep as some cases have data of sendername or address
								if (
									data &&
									data.emailSettings &&
									data.emailSettings.smtpInfo &&
									data.emailSettings.smtpInfo.smtpServer
								) {
									$scope.configureEmailMessage = cvUtil.infoMsgLoc('info.emailConfigured');
								}
								if (data.emailSettings.smtpInfo.smtpPort != undefined) {
									port = data.emailSettings.smtpInfo.smtpPort;
								}
								$scope.emailSettings = {
									smtpServer: data.emailSettings.smtpInfo.smtpServer,
									smtpPort: port,
									senderEmail: data.emailSettings.smtpInfo.senderInfo.senderAddress,
									senderName: data.emailSettings.smtpInfo.senderInfo.senderName
								};
								if ($scope.emailSettings.senderEmail == '' && cvApp.acApp == 'ADMIN_CONSOLE' && cvApp.oemId == 16) {
									$scope.emailSettings.senderEmail = 'one@commvault.com';
								}
								if ($scope.emailSettings.senderName == '' && cvApp.acApp == 'ADMIN_CONSOLE' && cvApp.oemId == 16) {
									$scope.emailSettings.senderName = 'Commvault One';
								}
							},
							function(e) {
								$scope.emailSettings = {
									smtpServer: '',
									smtpPort: 25,
									senderEmail: '',
									senderName: ''
								};
							}
						);
						$scope.dismissModal = function() {
							$modalInstance.dismiss();
						};
						$scope.$on('emailAdded', function(event, emailSettings) {
							$modalInstance.close();
						});
					}
				]
			});
		}
	}
]);

export default mod;
