import { commonSetupModule } from 'common/js/modules';
import 'adminConsole/js/controllers/activityControl.ctrl.js';
import 'adminConsole/js/services/backup.svc.js';
var pushMod = commonSetupModule;
var controllers = {};
controllers.fileServerSetupCompleteCtrl = [
	'$scope',
	'$state',
	'backupEntityService',
	'cvToaster',
	'cvLoc',
	'$stateParams',
	'ENTITY_TYPES',
	function($scope, $state, backupEntityService, cvToaster, cvLoc, $stateParams, ENTITY_TYPES) {
		var fileServerBackupConfig = {
			entityType: ENTITY_TYPES.CLIENT_ENTITY,
			backupType: 'FULL'
		};

		if ($state.includes('acSetup')) {
			//getting server plan mapping from coreSetup factory
			$scope.serverPlanList = $scope.getServerPlanMapping();
		}

		//start full backup on clients selected in previous step[Add file server]
		$scope.backupNow = function() {
			var genericEntities = [];
			$scope.serverPlanList.forEach(clientPlan => {
				genericEntities.push({ clientId: clientPlan.clientId, applicationId: 33 });
			});
			backupEntityService
				.backupClients(
					fileServerBackupConfig.entityType,
					angular.toJson(genericEntities),
					fileServerBackupConfig.backupType
				)
				.success(function(data) {
					cvToaster.showInfoMessage({
						ttl: '10000', //10 sec
						message: cvLoc('notification.backupStarted')
					});

					$state.transitionTo('activeJobs', $stateParams, {
						reload: true,
						inherit: false,
						notify: true
					});
				})
				.error(function(e) {
					cvToaster.showErrorMessage({
						ttl: '10000', //10 sec
						message: e ? e : cvLoc('generic_error')
					});
					$scope.skip();
				});
		};
	}
];

pushMod.controller(controllers);
export default pushMod;
