(function() {
	'use strict';

	/**
	 * A controller for handling the functionality on the completedSetups.jsp page.
	 */
	angular.module('common.setup').controller('completedSetupsController', [
		'$scope',
		'setupService',
		function($scope, setupService) {
			$scope.completedSetups = cv.sessionContext.completedSetups;

			/**
			 * Marks a setup with the given name as complete.
			 */
			$scope.markSetupAsComplete = function(setupName) {
				setupService.markSetupAsComplete(setupName).success(function() {
					$scope.completedSetups[setupName] = true;
					$scope.setupName = '';
					$scope.adding = false;
				});
			};

			/**
			 * Marks a setup with the given name as incomplete.
			 */
			$scope.markSetupAsIncomplete = function(setupName) {
				setupService.markSetupAsIncomplete(setupName).success(function() {
					delete $scope.completedSetups[setupName];
				});
			};
		}
	]);
})();
