<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
</script>
<div class="col-lg-8 col-lg-offset-2 col-xs-12 margin-top-20">
	<div class="panel panel-default">
		<div class="panel-body">
			<h1 class="text-center"><cv-help-text help-label="label.syslogServer" help-text="info.syslogServer"/></h1>
			<div class="{{sysCtrl.syslogMessage.type}} serverMessage text-center" ng-bind="sysCtrl.syslogMessage.message"></div>
			<div class="row">
				<div class="col-lg-8 col-lg-offset-2 col-md-10 col-md-offset-1">
					<form class="bootstrap-wrapper padding-0" name="serverStatusForm" data-cv-submit="sysCtrl.setSyslogServerStatus()" novalidate>
						<div class="form-group" >
							<label class="col-md-4 col-xs-12" for="hostname"><cv:msg key="label.hostname" bundle="restore" /></label>
							<div class="col-md-8 col-xs-12">
								<input type="text" name="hostname" id="hostname" ng-model="sysCtrl.hostname" placeholder="<cv:msg key='label.hostname' bundle='restore' />" ng-change="sysCtrl.updateChange()" required>
								<span class="cv-help-block" data-ng-show="serverStatusForm.hostname.$error.required && cv.serverStatusForm.needsAttention(serverStatusForm.hostname)"><cv:msg key="error.hostName" bundle="restore" />
							</div>
						</div>
						<div class="form-group">
							<label class="col-md-4 col-xs-12" for="port"><cv:msg key="label.port" bundle="storage" /></label>
							<div class="col-md-8 col-xs-12">
								<div>
									<input type="number" name="port" id="port" ng-model="sysCtrl.port" placeholder="port" ng-change="sysCtrl.updateChange(true)" required>
								</div>
								<span class="cv-help-block" data-ng-show="(serverStatusForm.port.$error.required && cv.serverStatusForm.needsAttention(serverStatusForm.port)) || sysCtrl.showPortErrorMessage"><cv:msg key="error.port" bundle="storage" />
							</div>
						</div>
						<div class="form-group">
							<div class="col-xs-12 margin-top-20">
								<cv-toggle data-ng-if="sysCtrl.isSecureEnabled !== null" toggle-label="<cv:msg bundle='storage' key='label.enableSecureMessaging'/>" help-text="'info.enableSecureMessaging'" class="margin-top-10" toggleName="enableSecure" value="sysCtrl.isSecureEnabled" on-click="sysCtrl.toggleSecureChange(data)"></cv-toggle>
							</div>
						</div>
						<div class="form-group" data-ng-if="sysCtrl.isSecureEnabled">
							<label  class="col-md-4 col-xs-12" 
								for="browsePath">
								<cv-help-text help-label="label.certificateAuthority" help-text="info.certificateAuthority"/>
							</label>
							<div class="col-sm-8">
								<div class="input-group">
									<input class="hidden"
										type="file"
										id="browse"
										name="browse"
										maxlength="100"/>
										<input placeholder="{{sysCtrl.caFileName}}"
										type="url"
										readonly
										required
										id="browsePath"
										name="browsePath"
										maxlength="100" disabled/>
									<span class="input-group-btn">
										<button type="button" id="outputbrowse" 
											class="btn btn-default" 
											data-ng-click="sysCtrl.browseLocalPath('browse', 'browsePath', true);">
											<cv:msg key="action.browse" bundle="collections"/>
										</button>
									</span>
								</div>
							</div>
						</div>
						<div class="form-group">
							<div class="col-xs-12 margin-top-20">
								<cv-toggle data-ng-if="sysCtrl.isEnabled !== null" toggle-label="<cv:msg bundle="storage" key="label.enable"/>" class="margin-top-10" toggleName="enableSyslogs" value="sysCtrl.isEnabled" on-click="sysCtrl.toggleChange(data)"></cv-toggle>
							</div>
						</div>
						<div class="form-group">
							<label class="col-md-4 col-xs-12"><cv:msg key="label.forwardLogs" bundle="storage" /></label>
							<div class="col-md-8 col-xs-12" ng-if="sysCtrl.checkboxOptions">
								<cv-checkbox-group on-click-checkbox="sysCtrl.checkboxChange(data)" is-disabled="!sysCtrl.isEnabled" class="cv-main-bar-flex" is-vertical="" check-obj="sysCtrl.checkboxOptions" output-model="sysCtrl.selectedLogTypes"></cv-checkbox-group>
								<span class="cv-help-block" data-ng-show="sysCtrl.showLogtypeErrorMessage && sysCtrl.checkboxDirty"><cv:msg key="error.logType" bundle="storage" />
							</div>
						</div>						
						<div class="button-container">
							<button id="syslogServer_button_#0535" ng-disabled="!sysCtrl.isSubmitButtonEnabled" class="btn btn-primary" type="submit"><cv:msg key="action.submit" bundle="restore" /></button>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
</div>