	<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
	<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
	<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
	<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
	</script>
	<fmt:bundle basename="localization.settings">
	<div ng-class="{'settings-page':!$state.includes('license')}">
		<div ng-class="{'back-strip center-horizontal':!$state.includes('license')}">
				<div ng-class="{'set-up-page':!$state.includes('license')}" data-ng-controller="registerWithCloudController">
					<div class="setup-title">
						<h1><fmt:message key="pageHeader.registerCloudHeading" /><cv-help-component help-text="<cv:msg key="label.registerProductHelpText" bundle="settings"/>"></cv-help-component></h1>
					</div>
					<div class="setup-content">
						<span class="{{registerCloudMessage.type}} serverMessage">{{registerCloudMessage.message}}</span>
						<div>
							<h4 data-ng-if="!hideForm"><fmt:message key="pageHeader.registerCloud" /></h4>
							<form name="registerCloudForm" novalidate data-cv-submit="registerCloud()" autocomplete="off">
								<div data-ng-if="!hideForm">
									<!-- fake fields are a workaround for chrome autofill getting the wrong fields and filling it with login credentials for add Server-->
									<input style="display:none" type="text" name="fakeusernameremembered"/>
									<input style="display:none" type="password" name="fakepasswordremembered"/>
									<label for="cloudEmail"><fmt:message key="label.cloudEmail" />
										<input type="text" name="cloudEmail" id="cloudEmail" data-ng-model="model.cloudEmail" autocomplete="never" data-ng-pattern="emailRegex" required />
										<span class="help-block" data-ng-show="cv.registerCloudForm.needsAttention(registerCloudForm.cloudEmail) || showError"><fmt:message key="error.cloudEmail" /></span>
									</label>
									<label for="cloudPassword"><fmt:message key="label.password" />
										<input type="password" name="cloudPassword" id="cloudPassword" data-ng-model="model.cloudPassword" autocomplete="never" required/>
										<span class="help-block" data-ng-show="cv.registerCloudForm.needsAttention(registerCloudForm.cloudPassword) || showError"><fmt:message key="error.password" /></span>
									</label>
									<label for="activationCode" data-ng-if="isActivationCodeSupported"><cv:msg key="label.activationCode" bundle="setup" /></span>
										<input type="text" name="activationCode" id="activationCode" data-ng-model="model.activationCode" required />
										<span class="help-block" data-ng-show="cv.registerCloudForm.needsAttention(registerCloudForm.activationCode) || showError"><cv:msg key="error.activationCode" bundle="setup" /></span>
									</label>
								</div>
								<div data-ng-if="!hideForm">
									<div class="button-container">
										<fmt:bundle basename="localization.messages">
											<button id="registerCloud_button_#2921" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-hide="hideCancelBtn" data-ng-click="cancel()"> 
												<cv:msg key="Cancel" bundle="messages"/>
											</button>
											<button id="registerCloud_button_#9463" type="submit" class="btn btn-primary cvBusyOnAjax"><fmt:message key="Save" /></button> 
										</fmt:bundle>
									</div>
								</div>
								<div data-ng-if="hideForm">
									<div class="button-container centered skip-btn--hidden">
										<fmt:bundle basename="localization.messages">
										<button id="registerCloud_button_#2700" type="button" class="btn btn-default" data-ng-click="skip()"><fmt:message key="Continue" /></button> 
										</fmt:bundle>
									</div>
								</div>
							</form>
						</div>
					</div>
				</div>
		</div>
	</div>
	</fmt:bundle>
