<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
<cv:cvMessages bundle="localization.settings"></cv:cvMessages>
</script>
<div >
	<div class="setup-title">
		<h3 >Edit web domains list</h3>
	</div>
	<div class="bootstrap-wrapper" >
		<p class="serverMessage {{domainListCtrl.serverMessage.type}}">{{domainListCtrl.serverMessage.message}}</p>
		<div class="error-text-padding" >
			<p><cv:msg key="info.domainWhitelistInfo" bundle="settings" /></p>
			<p><cv:msg key="info.tomcatMsg" bundle="settings" /></p>
		</div>
		<form name="editWebDomainsForm" data-cv-submit="" novalidate autocomplete="off" >
			<div class="form-group">
				<div class="col-xs-10"><input data-ng-model="domainListCtrl.domainName" ng-keypress="domainListCtrl.add(domainListCtrl.domainName, $event)" type="text" placeholder="https://domain.com:port" ></div>
				<button id="editWebDomainsListModal_button_#9638" type="button" class="btn btn-primary" ng-click="domainListCtrl.add(domainListCtrl.domainName)" ><cv:msg key="Add" bundle="messages"/></button> 
			</div>
			<ul class="error-text-padding list-style__row group plan-invite-user-modal">
				<li data-ng-if="domainListCtrl.domainList.length == 0" class="info-place-holder"><cv:msg key="info.noDomains" bundle="settings"/></li>
				<li class="users-list__user " data-ng-repeat="domain in domainListCtrl.domainList" >
					<span >
						<label title="{{domain}}" ><span>{{domain}}</span></label>
						<span title="Remove" class="delete-row" ng-click="domainListCtrl.deleteDomain(domain)">&times;</span>
					 </span>
				</li>
			</ul>
			<div class="button-container">
				<!-- <div class="error-text-padding" >Tomcat service needs to be restarted in order to read the new domains added here.</div> -->
				<button id="editWebDomainsListModal_button_#4027" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="domainListCtrl.cancel()"><cv:msg key="action.cancel" bundle="settings" /></button> 
				<button id="editWebDomainsListModal_button_#0651" type="button" data-ng-click="domainListCtrl.save()" data-ng-disabled="loadingSendLogsMetadata" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.save"  bundle="settings"/></button> 
			</div>
		</form>
	</div>
</div>
