<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
</script>
<span class="center-container settings-page">
	<div class="center-container__center-el">
		<div class="back-strip center-horizontal">
			<div class="set-up-page">
				<div class="setup-title">
					<h1>
						<cv:msg key="label.defaultPlan" bundle="profiles" />
						<cv-help-component help-text="<cv:msg key="label.infoDefaultPlan" bundle="profiles"/>"></cv-help-component>
					</h1>
				</div>
				<div class="setup-content">
					<span class="{{defaultPlanMessage.type}} serverMessage">{{defaultPlanMessage.message}}</span>
					<form name="defaultPlanForm" novalidate data-cv-submit="saveDefaultPlan()" autocomplete="off">
						<div class="addServerModal">
							<label for="serverDefault" class="select-label" data-ng-if="showServerDefault && serverPlans.length>0"><cv:msg key="label.serverPlan" bundle="profiles" />
								<select name="serverDefault" data-ng-options="plan.planSummary.plan.planId as plan.planSummary.plan.planName for plan in serverPlans | orderBy: 'planSummary.plan.planName'" data-ng-model="model.defaultServer" required>
									<option value=""><cv:msg key="label.serverDefaultPlan" bundle="profiles" /></option>
								</select>
								<span class="help-block" data-ng-show="cv.defaultPlanForm.needsAttention(defaultPlanForm.serverDefault)"><cv:msg key="error.serverDefaultPlan" bundle="profiles" /></span>
							</label>
							
							<label for="laptopDefault" class="select-label" data-ng-if="showLaptopDefault && laptopPlans.length>0"><cv:msg key="label.laptopPlan" bundle="profiles" />
								<select name="laptopDefault" data-ng-options="plan.planSummary.plan.planId as plan.planSummary.plan.planName for plan in laptopPlans | orderBy: 'planSummary.plan.planName'" data-ng-model="model.defaultLaptop" required>
									<option value=""><cv:msg key="label.laptopDefaultPlan" bundle="profiles" /></option>
								</select>
								<span class="help-block" data-ng-show="cv.defaultPlanForm.needsAttention(defaultPlanForm.laptopDefault)"><cv:msg key="error.laptopDefaultPlan" bundle="profiles" /></span>
							</label>
							
							<label for="fsDefault" class="select-label" data-ng-if="showFsServerDefault && fsServerPlans.length>0"><cv:msg key="label.fsPlan" bundle="profiles" />
								<select name="fsDefault" data-ng-options="plan.planSummary.plan.planId as plan.planSummary.plan.planName for plan in fsServerPlans | orderBy: 'planSummary.plan.planName'" data-ng-model="model.defaultFsServer" required>
									<option value=""><cv:msg key="label.fsDefaultPlan" bundle="profiles" /></option>
								</select>
								<span class="help-block" data-ng-show="cv.defaultPlanForm.needsAttention(defaultPlanForm.fsDefault)"><cv:msg key="error.fsDefaultPlan" bundle="profiles" /></span>
							</label>
							
							<label for="dbDefault" class="select-label" data-ng-if="showDatabaseDefault && dbPlans.length>0"><cv:msg key="label.dbPlan" bundle="profiles" />
								<select name="dbDefault" data-ng-options="plan.planSummary.plan.planId as plan.planSummary.plan.planName for plan in dbPlans | orderBy: 'planSummary.plan.planName'" data-ng-model="model.defaultDb" required>
									<option value=""><cv:msg key="label.dbDefaultPlan" bundle="profiles" /></option>
								</select>
								<span class="help-block" data-ng-show="cv.defaultPlanForm.needsAttention(defaultPlanForm.dbDefault)"><cv:msg key="error.dbDefaultPlan" bundle="profiles" /></span>
							</label>
						</div>
						
						<div class="button-container" data-ng-if="laptopPlans.length>0 || serverPlans.length>0 || fsServerPlans.length>0">
							<button id="defaultPlan_button_#0303" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="Save" bundle="messages"/></button> 									
						</div>
					</form>
				</div>
				
			</div>
		</div>
	</div>
</span>
