<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="header.configureDataInterfacePairs" bundle="settingsJs" /></h1>
</div>
<form name="configureDataInterfacePairs" data-ng-submit="saveConfiguration()" novalidate autocomplete="off">
	<div class="bootstrap-wrapper">
	<div class="text-center {{uiModel.serverMessage.type}} col-sm-12" data-ng-if="uiModel.serverMessage" data-ng-bind="uiModel.serverMessage.message"></div><br>
		<div class="reduced-padding-top">
			<uib-accordion class="overflow-visible" close-others="true">
				<div uib-accordion-group is-open="uiModel.accordionStatus.selectComputersTab" data-scroll-to-when-open>
					<uib-accordion-heading><cv:msg key="label.selectComputers" bundle="settingsJs" /><i class="pull-right glyphicon" 
						data-ng-class="{'glyphicon-chevron-down': uiModel.accordionStatus.selectComputersTab, 'glyphicon-chevron-right': !uiModel.accordionStatus.selectComputersTab}"></i>
					</uib-accordion-heading>					
					
					<div class="form-group row">
						<label class="col-sm-5">
							<cv:msg key="label.selectFirstComputer" bundle="settingsJs" />
						</label>
						<div class="col-sm-7">
							<isteven-multi-select
								input-model="uiModel.computers.firstComputer"
								output-model="uiModel.firstComputer"
								item-label="entityName"
								button-label="entityName"
								tick-property="selected"
								class="isteven-multi-select user-group-select"
								id="firstComputer"
								name="firstComputer"
								helper-elements="filter"
								selection-mode="single"
								group-property="group"
								on-item-click="updateAvailableInterfaces()"
								translation="uiModel.translation">
							</isteven-multi-select>
						</div>
					</div>
					
					<div class="form-group row">
						<label class="col-sm-5">
							<cv:msg key="label.selectSecondComputer" bundle="settingsJs" />
						</label>
						<div class="col-sm-7">
							<isteven-multi-select
								input-model="uiModel.computers.secondComputer"
								output-model="uiModel.secondComputer"
								item-label="entityName"
								button-label="entityName"
								tick-property="selected"
								class="isteven-multi-select user-group-select"
								id="secondComputer"
								name="secondComputer"
								helper-elements="filter"
								selection-mode="single"
								group-property="group"
								on-item-click="updateAvailableInterfaces()"
								translation="uiModel.translation">
							</isteven-multi-select>
						</div>
					</div>
				</div>
				
				<div uib-accordion-group is-open="uiModel.accordionStatus.selectInterfacesTab" data-scroll-to-when-open data-ng-disabled="!validateSelectedComputers()">
					<uib-accordion-heading><cv:msg key="label.selectInterfaces" bundle="settingsJs" /><i class="pull-right glyphicon" 
						data-ng-class="{'glyphicon-chevron-down': uiModel.accordionStatus.selectInterfacesTab, 'glyphicon-chevron-right': !uiModel.accordionStatus.selectInterfacesTab}"></i>
					</uib-accordion-heading>
					<div data-ng-if="uiModel.gridOptions">
						<cv-grid cv-grid-options="uiModel.gridOptions"></cv-grid>
					</div>
				</div>
				<div class="margin-bottom-10">&nbsp;</div>
			</uib-accordion>
		</div>
		<div class="modal-footer">
			<button id="configureDataInterfacePairs_button_#3105" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="close()"><cv:msg key="Cancel" bundle="messages" /></button> 
			<button id="configureDataInterfacePairs_button_#5646" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-disabled="configureDataInterfacePairs.$invalid"><cv:msg key="Save" bundle="messages" /></button> 
		</div>
	</div>
</form>