<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.subscriptions"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
	<cv:cvMessages bundle="localization.security"></cv:cvMessages>
	<cv:cvMessages bundle="localization.settings"></cv:cvMessages>
	<cv:cvMessages bundle="localization.commcell"></cv:cvMessages>
</script>
<div class="row">
	<div class="col-xs-12">
	<h1 class="float-left" data-ng-bind="commcellName"></h1>
		<%-- <span class="page-action-item">
			<a href data-ng-click="openConfigureEmailModal()"><cv:msg key="header.label.configureEmail" bundle="settingsJs" /></a>
		</span>
		<span class="page-action-item">
			<a href data-ng-click="openRegisterCloudModal()"><cv:msg key="header.label.registerCloud" bundle="settingsJs" /></a>
		</span> --%>
		<span ng-if="hasSendLogPermission" class="page-action-item">
			<a href data-ng-href="#/sendLogs/commCell/{{genericEntity.commCellId}}?sourceName={{commcellName}}"><cv:msg key="action.sendLogs" bundle="servers" /></a>
		</span>
		<span class="page-action-item">
			<a href data-ng-click="viewLogs()"><cv:msg key="action.viewLogs" bundle="settings" /></a>
		</span>
		<span class="page-action-item" data-ng-if="commcellConsoleLink && showCommcellLink">
			<a href="{{commcellConsoleLink}}" target="_blank"><cv:msg key="action.commcellConsoleLink" bundle="settings" /></a>
		</span>
		<%--<span class="page-action-item"> Shifted under Maintenance
		   <a data-ng-click="openDownloadSoftwareDialog(0, '')"><cv:msg key="label.downloadSoftware" bundle="navJs" /></a>
		</span>--%>
	</div>
</div>
<div class="group row" data-ng-if="hasActivityManagement">
	<div class="col-xs-12 col-md-6">
		<cv-tile-component data-ac-id="label_about-settingsJs" data-loader="versionDetails" data-title='<cv:msg key="label.about" bundle="clients"/>'>
			<fmt:bundle basename="localization.clients">
				<ul class="list-style-secondary">
					<li class="group">
						<span class="pageDetailColumn"><fmt:message key="label.commserver" /></span>
						<span class="pageDetailColumn" ng-bind="versionDetails.hostName"></span>
					</li>
					<li class="group">
						<span class="pageDetailColumn"><fmt:message key="header.Version" /></span>
						<span class="pageDetailColumn" ng-bind="versionDetails.csVersionInfo | getVersionString"></span>
					</li>
				</ul>
			</fmt:bundle>
		</cv-tile-component>
		<cv-activity-control-component data-ac-params="acParams">
		</cv-activity-control-component>
		<cv-tile-component data-ac-id="header_label_emailSettings-settingsJs" data-loader="emailSettings" data-title='<cv:msg key="header.label.emailSettings" bundle="settingsJs"/>'>
			<div class="page-details-box-links">
				<a href="" data-ng-click="openConfigureEmailModal()"><cv:msg key="action.edit" bundle="settingsJs" /></a>
			</div>
			<fmt:bundle basename="localization.settings">
			<ul class="list-style-secondary">
				<li class="group">
					<span class="pageDetailColumn"><fmt:message key="label.smtpServer" /></span>
					<span class="pageDetailColumn">{{emailSettings.smtpServer}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><fmt:message key="label.smtpPort" /></span>
					<span class="pageDetailColumn">{{emailSettings.smtpPort}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><fmt:message key="label.senderEmail" /></span>
					<span class="pageDetailColumn">{{emailSettings.senderEmail}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><fmt:message key="label.senderName" /></span>
					<span class="pageDetailColumn">{{emailSettings.senderName}}</span>
				</li>
			</ul>
			</fmt:bundle>
		</cv-tile-component>
		<cv-tile-component data-ac-id="label_general-subscriptions" loader="subscriptionData.id !== undefined" data-title='<cv:msg key="label.general" bundle="subscriptions"/>'>
			<ul class="list-style-secondary">
				<li class="group" data-ng-if="subscriptionData.id !== undefined" ><cv-generate-auth-code subscription-id="0" serverMessage="serverMessage" subscription-data="subscriptionData"></cv-generate-auth-code></li>
	  			<div data-ng-if="showUserCentric">
		  			<li class = "group" data-ng-if = "isAdmin || isTenantAdmin">
						<span class="pageDetailColumn"><cv:msg key="label.enableUserCentric" bundle="subscriptions" /> </span>
						<span class="pageDetailColumn pull-right">
							<toggle-control class="{{userCentric}}" status="userCentric" data-ng-click="enableDisableUserCentricOption()" title="Enable/Disable <cv:msg key='label.enableUserCentric' bundle='subscriptions' />"></toggle-control>
						</span>
					</li>
				</div>
	  			<li class = "group" data-ng-if = "isAdmin || isTenantAdmin">
					<span class="pageDetailColumn"><cv:msg key="label.useUpn" bundle="subscriptions" /> </span>
					<span class="pageDetailColumn pull-right">
						<toggle-control class="{{useUPN}}" status="useUPN" data-ng-click="enableDisableUPNOption()" title="Enable/Disable <cv:msg key='label.useUpn' bundle='subscriptions' />"></toggle-control>
					</span>
				<!-- TFA -->
				<li class="group" data-ng-if = "showTFA && commcellFieldsLoaded">
					<cv-tfa-directive data-cv-id="commcellTFADirective" source-page="commcellDetails" subscription-data="subscriptionData"></cv-tfa-directive>
				</li>
				<li class="group" data-ng-if="showAlwaysActivateLaptop">
					<span class="pageDetailColumn">
						<cv-help-text help-label="label.alwaysActivateDefaultPlan" help-text="label.alwaysActivateDefaultPlan.helpText"/>
					</span>
                   <span class="pageDetailColumn pull-right">
                       <toggle-control class="alwaysActivateWithDefaultPlanToggle" status="alwaysActivateWithDefaultPlanToggle" data-ng-click="showHideActivateWithDefaultPlan()"></toggle-control>
                   </span>
                </li>
			</ul>
			<span data-ng-if="!subscriptionData && subscriptionsLoadedError">
				<p class="info-place-holder"><cv:msg key="error.getSubscription" bundle="subscriptions"/></p>
			</span>
		</cv-tile-component>

		<cv-tile-component data-ac-id="title_globalCommandCenter" data-title='<cv:msg key="title.globalCommandCenter" bundle="commcell"/>' data-ng-if="${cvConfig.isMCCDynamicAppEnabled()}">
                <div data-ng-show="globalCCListSupported && globalCCListSupported.length > 0"><cv-kendo-grid cv-grid-options="globalCCTblGridOptions" /></div>
                <div data-ng-hide="globalCCListSupported && globalCCListSupported.length > 0">
					<p class="info-place-holder"><cv:msg key="label.noGlobalCommandCenters" bundle="commcell"/></p>
				</div>
                <div class="page-details-box-links">
					<a href="" data-ng-click="openConfigureGlobalCCModal()"><cv:msg key="action.edit" bundle="settingsJs" /></a>
				</div>
        </cv-tile-component>

	</div>
	<div class="col-xs-12 col-md-6">
        <div data-ng-if="subscriptionData">
            <cv-security-component entity-type='entityType' generic-entity = 'genericEntity' associations='formattedSecurityAssociations' associations-loaded='associationsLoaded'>
            </cv-security-component>
            <div data-ng-if="subscriptionData.privacy">
            	<cv-privacy-setting-component subscription-data="subscriptionData" generic-entity='genericEntity' source-page = "commcell"></cv-privacy-setting-component>
            </div>
            <cv-passkey-setting-component data-ng-if="commcellFieldsLoaded" subscription-data="subscriptionData" generic-entity='genericEntity' source-page = "commcell"></cv-privacy-setting-component>
		</div>

		<cv-sla-days data-entity-data="" data-entity-type="entityType" data-entity-id="2"></cv-sla-days>

		<cv-tile-component data-ac-id="title_passwordEncryption-security" data-loader="keyManagementServer" data-title='<cv:msg key="title.passwordEncryption" bundle="security"/>'>
			<div class="page-details-box-links">
				<a href="" data-ng-click="openConfigurePasswordEncryptionModal()"><cv:msg key="action.edit" bundle="settingsJs" /></a>
			</div>
			<ul class="list-style-secondary">
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.kms" bundle="security"/></span>
					<span class="pageDetailColumn">{{keyManagementServer}}</span>
				</li>
			</ul>
		</cv-tile-component>
		<cv-tile-component data-ac-id="label_defaultPlans-profiles" data-title='<cv:msg key="label.defaultPlans" bundle="profiles"/>' min-height="true" loader="organizationInfo.defaultPlans">
			<ul class="list-style__row group" data-ng-repeat="plan in organizationInfo.defaultPlans track by $index">
				<li><a href="#profileDetails/{{plan.plan.planId}}">{{plan.plan.planName}}<span class='parenthetical-text no-margin '> -  {{plan.type}}</span></a></li>
			</ul>
			<span data-ng-if="organizationInfo.defaultPlans.length==0">
				<p class="info-place-holder"><cv:msg key="info.noDefaultPlans" bundle="profiles"/></p>
			</span>
			<div class="page-details-box-links" data-ng-if="showEdit">
				<a href="" data-ng-click="editDefaultPlanModal()"><cv:msg key="action.edit" bundle="profiles" />
				</a>
			</div>
		</cv-tile-component>
		<div data-ng-if="subscriptionData.id !== undefined">
			<cv-encrytion-setting-component generic-entity='genericEntity' subscription-data="subscriptionData"></cv-encrytion-setting-component>
		</div>
		<div data-ng-if="showManageIdleClient && commcellFieldsLoaded">
			<cv-manage-idle-clients  auto-retire-devices="autoRetireDevices" level="COMMCELL" entity-id="commcellId" entity-name="commcellName"></cv-manage-idle-clients>
		</div>
		<!--
			<cv-tile-component data-ac-id="header_label_preference-settingsJs" data-title='<cv:msg key="header.label.preference" bundle="settingsJs" />'>
			<ul class="list-style-secondary">
				<li class="group"><span class="pageDetailColumn"><cv:msg
							key="label.isMSP" bundle="settingsJs" /> <a
						ng-href="{{mspDocumentationLink}}"
						target="_blank"
						title='<cv:msg key="label.whatDoesThisMean" bundle="setup" />'><i
							class="ion-help-circled"></i></a></span><span class="pageDetailColumn"><toggle-control
							data-ng-class="showMSP ? 'enabled-activity disabled' : 'disabled-activity'"
							status="showMSP ? 'enabled-activity' : 'disabled-activity'"
							data-ng-click="!mspToggleClicked && makeMsp()"
							data-ng-attr-title="{{!showMSP ? ('label.enableDisable' | cvLoc) + ' MSP' : ('label.mspConfigured' | cvLoc)}}"></toggle-control></span></li>
			</ul>
			</cv-tile-component>
		-->
	</div>
</div>
