
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
</script>
<script src="${pageContext.request.contextPath}/common/js/encoder.js"></script>
<span data-ng-controller="configurePasswordController">
<!-- Adding the following hardcoded breadcrumb to show when the user is an admin on the commcell level, but hasn't completed the core setup yet. -->
<!-- This allows the user to go back to the getting started page since there will be no nav -->
<!-- !! This is planned to be fixed in SP7 !! -->
<div class="nav-breadcrumbs group ng-scope getting-started-breadcrumbs" data-ng-if="showBreadcrumbs">
	<div>
		<span class="group">
			<ul class="nav-breadcrumbs__list ng-scope">
				<li><a data-ng-href="#gettingStarted">{{'label.gettingStarted' | cvLoc}}</a></li>
			</ul>
		</span>
	</div>
</div>
<fmt:bundle basename="localization.settings">
	<span class="center-container settings-page">
		<div class="center-container__center-el">
			<div class="back-strip center-horizontal" id="changePasswordBG">
				<div class="set-up-page">
					<div class="setup-title">
						<h1>
							<fmt:message key="pageHeader.configurePassword" />
						</h1>
					</div>
					<div class="setup-content">
						<span class="{{configurePasswordMessage.type}} serverMessage">{{configurePasswordMessage.message}}</span>
						<form name="configurePasswordForm" novalidate
							data-cv-submit="configurePassword()" autocomplete="off">
							<div>
								<!-- fake fields are a workaround for chrome autofill getting the wrong fields and filling it with login credentials for add Server-->
								<input style="display: none" type="text"
									name="fakeusernameremembered" /> <input style="display: none"
									type="password" name="fakepasswordremembered" /> <label
									for="oldPassword"><fmt:message key="label.oldPassword" />
									<input type="password" name="oldPassword" id="oldPassword"
									data-ng-model="model.oldPassword" autocomplete="off"
									data-ng-disabled="!isPasswordChangeAllowed" /> </label> <label for="newPassword"><fmt:message
										key="label.newPassword" /> <input type="password"
									name="newPassword" id="newPassword"
									data-ng-model="model.newPassword" autocomplete="off" required
									data-ng-disabled="!isPasswordChangeAllowed" /> <span
									class="help-block"
									data-ng-show="cv.configurePasswordForm.needsAttention(configurePasswordForm.newPassword)"><fmt:message
											key="error.newPassword" /></span> </label> <label for="confirmPassword"><fmt:message
										key="label.confirmPassword" /> <input type="password"
									name="confirmPassword" id="confirmPassword"
									data-ng-model="model.confirmPassword"
									data-cv-equals="{{model.newPassword}}" autocomplete="off"
									required data-ng-disabled="!isPasswordChangeAllowed" /> <span
									class="help-block"
									data-ng-show="!configurePasswordForm.confirmPassword.$error.required && configurePasswordForm.confirmPassword.$error.cvEquals && cv.configurePasswordForm.needsAttention(configurePasswordForm.confirmPassword)"><fmt:message
											key="error.confirmPassword" /></span> </label>
							</div>
							<div class="button-container"
								data-ng-if="isPasswordChangeAllowed">
								<fmt:bundle basename="localization.messages">
									<button id="changePassword_button_#0035" type="submit" class="btn btn-primary cvBusyOnAjax"> 
										<fmt:message key="Save" />
									</button>
								</fmt:bundle>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</span>
</fmt:bundle>
</span>